<?php
/**
 * Main WOO_VPF_Admin_Menu Class
 *
 * @class WOO_VPF_Admin_Menu
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WOO_VPF_Admin_Menu {

	/**
	 * @var: vpf_menu
	 */
	public $vpf_menu;
	
	/**
	 * Constructor
	 *
	 * @access public
	 */
	public function __construct() {
		// Admin Main Menu: VPF
		add_action( 'admin_menu', array( $this, 'terms_main_menu' ), 5 );
	}

	/**
	 * Admin Main Menu: VPF
	 */
	public function terms_main_menu() {
		add_menu_page( __( 'VPF', WOO_VPF_TEXT_DOMAIN ), __( 'VPF', WOO_VPF_TEXT_DOMAIN ), 'manage_woocommerce', 'vpf_menu', array( $this, 'vpf_menu' ), '', 58 );
		
		$this->vpf_menu = add_submenu_page( 'vpf_menu', __( 'Terms', WOO_VPF_TEXT_DOMAIN ), __( 'Terms', WOO_VPF_TEXT_DOMAIN ), 'manage_woocommerce', 'vpf_menu', array( $this, 'vpf_menu' ) );
		
		add_action( 'admin_menu', array( $this, 'vpf_direct_menus' )  );
	}
	
	/**
	 * Admin Sub Menu: Makes
	 */
	public function vpf_menu() {
		return;
	}
	
	/**
	 * Admin Sub Menu: Direct Menus ( Export AND Settings )
	 */
	public function vpf_direct_menus() {
		global $submenu;
		
		if( ! isset( $submenu['vpf_menu'] ) ) {
			return;
		}
		
		unset( $submenu['vpf_menu'][0] );
		
		$submenu['vpf_menu'][] = array( __( 'Terms', WOO_VPF_TEXT_DOMAIN ), 'manage_woocommerce', 'edit-tags.php?taxonomy=product_make&post_type=product' );
		
		$submenu['vpf_menu'][] = array( __( 'Import CSV', WOO_VPF_TEXT_DOMAIN ), 'manage_woocommerce', 'admin.php?import=woo_product_makes_importer' );
		
		$submenu['vpf_menu'][] = array( __( 'Settings', WOO_VPF_TEXT_DOMAIN ), 'manage_woocommerce', 'admin.php?page=wc-settings&tab=woo_vpf' );
	}
}

new WOO_VPF_Admin_Menu();
