<?php
/**
 * Main WOO_VPF_Admin_Actions Class
 *
 * @class WOO_VPF_Admin_Actions
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WOO_VPF_Admin_Actions {

	/**
	 * Constructor
	 *
	 * @access public
	 */
	public function __construct() {
		// Save Terms
		add_action( 'admin_init', array( $this, 'save_terms' ) );
		
		// Delete All Terms
		add_action( 'admin_init', array( $this, 'delete_terms' ) );
		
		// Global Notices
		add_action( 'admin_notices', array( $this, 'term_notices' ) );
	}

	/**
	 * Save Terms
	 */
	public function save_terms() {
		if( isset( $_POST['action'] ) && $_POST['action'] == 'woo_vpf_manage_term' ) {
		
			if( ! isset( $_POST['term_name'] ) || empty( $_POST['term_name'] ) ) {
				return;
			}
				
			if( ! isset( $_POST['woo_vpf_noncename'] ) || ! wp_verify_nonce( $_POST['woo_vpf_noncename'], 'woo_vpf' ) ) {
				return;
			}
		
			$term_id = 0;
			if( isset( $_POST['term_id'] ) ) {
				$term_id = $_POST['term_id'];
			}
			
			$parent_id = 0;
			if( isset( $_REQUEST['parent_term_id'] ) ) {
				$_REQUEST['parent_term_id'] = array_filter( $_REQUEST['parent_term_id'] );
				$parent_id = end( $_REQUEST['parent_term_id'] );
			}
		
			$term_names = $_POST['term_name'];
			if( $term_id >  0 ) {
				$term_names = array( $term_names );
			} else {
				$term_names = explode( ',', $term_names );
			}			
			$term_names = array_map( 'sanitize_text_field', $term_names );
		
			foreach( $term_names as $term_name ) {
				$term_name = WOO_VPF_Functions::format_string( $term_name );
				
				if( ! empty( $term_name ) ) {
					
					// Check if term already exists
					$existing_term_id = WOO_VPF_Functions::term_exists( $term_name, $parent_id );
					
					if( $term_id >  0 ) {
						// Update existing term
						if( ! $existing_term_id || $existing_term_id == $term_id ) {
							$term = WOO_VPF_Functions::update_term( $term_id, $term_name, $parent_id );
							
							if ( is_wp_error( $term ) ) {
								vpf_set_cookie ( 'messages', array ( 'type' => 'error', 'text'	=> sprintf( __( '<strong>%s</strong> - %s', WOO_VPF_TEXT_DOMAIN ), $term_name, $term->get_error_message() ) ), 'append' );
							} else {
								vpf_set_cookie ( 'messages', array ( 'type' => 'success', 'text'	=> sprintf( __( '<strong>%s</strong> - Term has been updated successfully.', WOO_VPF_TEXT_DOMAIN ), $term_name ) ), 'append' );
								
								if( $term > 0 ) {
									clean_term_cache( $term, 'product_make' );
								}
							}
						} else {
							vpf_set_cookie ( 'messages', array ( 'type' => 'error', 'text'	=> sprintf( __( '<strong>%s</strong> - A term with the name provided already exists with this parent.', WOO_VPF_TEXT_DOMAIN ), $term_name ) ), 'append' );
						}
					} else {
						// Insert new term
						if( ! $existing_term_id ) {
							$term = WOO_VPF_Functions::insert_term( $term_name, $parent_id );
							
							if ( is_wp_error( $term ) ) {
								vpf_set_cookie ( 'messages', array ( 'type' => 'error', 'text'	=> sprintf( __( '<strong>%s</strong> - %s', WOO_VPF_TEXT_DOMAIN ), $term_name, $term->get_error_message() ) ), 'append' );
							} else {
								vpf_set_cookie ( 'messages', array ( 'type' => 'success', 'text'	=> sprintf( __( '<strong>%s</strong> - Term has been added successfully.', WOO_VPF_TEXT_DOMAIN ), $term_name ) ), 'append' );
								
								if( $term > 0 ) {
									clean_term_cache( $term, 'product_make' );
								}
							}
						} else {
							vpf_set_cookie ( 'messages', array ( 'type' => 'error', 'text'	=> sprintf( __( '<strong>%s</strong> - A term with the name provided already exists with this parent.', WOO_VPF_TEXT_DOMAIN ), $term_name ) ), 'append' );
						}
					}
				}
			}		
		}
	}
	
	/**
	 * Delete All Terms
	 */
	public function delete_terms() {
		if( isset( $_POST['vpf_action'] ) && $_POST['vpf_action'] == 'woo_vpf_delete_terms' ) {
			WOO_VPF_Functions::delete_all_terms ();
			
			vpf_set_cookie ( 'messages', array ( 'type' => 'success', 'text'	=> __( '<strong>Success</strong> - All VPF Terms have been deleted successfully.', WOO_VPF_TEXT_DOMAIN ) ), 'append' );
			
			wp_redirect( '?taxonomy=' . $_REQUEST['taxonomy'] . '&post_type=' . $_REQUEST['post_type'] );
			exit;
		}
	}
	
	/**
	 * Global Notices
	 */
	public function term_notices() {
		$messages = vpf_get_cookie ( 'messages' );
		if( ! empty( $messages ) ) {
			foreach( $messages as $notice ) {
				if( isset( $notice['text'] ) && ! empty( $notice['text'] ) ) {
					?><div class="notice notice-<?php echo $notice['type']; ?>">
						<p><?php echo $notice['text']; ?></p>
					</div><?php
				}
			}
			
			vpf_set_cookie ( 'messages', '' );
		}
	}
}

new WOO_VPF_Admin_Actions();
