"use strict";

jQuery( document ).ready(function($) {
	
	// Universal Product?
	$('.woo-vpf-form-container').on('change', '.vpf_universal', function(e) {
		e.preventDefault();
		
		if( $(this).is(':checked') ) {
			$('.woo-vpf-form-container .woo-vpf-terms-table-container').addClass('woo-vpf-hidden');
			$('.woo-vpf-form-container .woo-vpf-remove-term-rows').addClass('woo-vpf-hidden');
			$('.woo-vpf-add-term-row').addClass('woo-vpf-hidden');
		} else {
			$('.woo-vpf-form-container .woo-vpf-terms-table-container').removeClass('woo-vpf-hidden');
			$('.woo-vpf-form-container .woo-vpf-remove-term-rows').removeClass('woo-vpf-hidden');
			$('.woo-vpf-add-term-row').removeClass('woo-vpf-hidden');
		}
	});
	$('.woo-vpf-form-container .vpf_universal').trigger('change');
	
	// Add New Row
	$('.woo-vpf-add-term-row').on('click', function(e) {
		e.preventDefault();
		
		var $elem = $(this).closest('.postbox').find('tbody tr:last');
				
		var $elem_clone_row = $elem.clone();		
		$elem_clone_row.find('select').val('');
		$elem_clone_row.find('select:not(:first)').each(function() {
			$(this).find('option:not(:first)').remove();
		});
		$elem_clone_row.removeClass('woo-vpf-hidden');
		
		$elem.closest('tbody').prepend( $elem_clone_row );
	});
	
	// Remove Single Row
	$('.woo-vpf-form-table').on('click', '.woo-vpf-remove-term-row', function(e) {
		e.preventDefault();
		
		if( confirm( woo_vpf_tmb_params.msg_confirm ) ) {
			$(this).closest('tr').remove();
		}
	});
	
	// Remove All Row
	$('.woo-vpf-form-container').on('click', '.woo-vpf-remove-term-rows', function(e) {
		e.preventDefault();
		
		if( confirm( woo_vpf_tmb_params.msg_confirm ) ) {
			var $elem_table = $(this).closest('.woo-vpf-form-container').find('.woo-vpf-form-table');
			
			$elem_table.find('tbody').find('tr:not(:last)').remove();
			$elem_table.find('tbody').find('tr select').val('');
		}
	});
	
	// Reset Form on Page Load
	$('.woo-vpf-form-table .woo-vpf-terms-row-add select').val('');
});
