"use strict";

jQuery( document ).ready(function($) {
	
	// Dynamic DropDowns
	if( $('.woo-vpf-form-container').find('.woo_vpf_model').length ) {
		$('.woo-vpf-form-container').on('change', '.woo_vpf_make', function() {
			
			if( $(this).closest('.woo-vpf-terms-row').length ) {
				var $elem = $(this).closest('.woo-vpf-terms-row');
			} else {
				var $elem = $(this).closest('.woo-vpf-form-container');
			}
			
			$elem.addClass('woo-vpf-processing');
		
			var $term_id = $(this).val();
			$.post( woo_vpf_tdl_params.ajax_url, {'parent':$term_id, 'action':'woo_vpf_get_terms'}, function( response ) {
				$elem.removeClass('woo-vpf-processing');
				$elem.find('.woo_vpf_model option:not(:first)').remove();
				$elem.find('.woo_vpf_model').append( response );
				
				$elem.find('.woo_vpf_year option:not(:first)').remove();
			
				if( $elem.find('.woo_vpf_engine').length ) {
					$elem.find('.woo_vpf_engine option:not(:first)').remove();
				}
				
				$( document.body ).trigger( 'woo_vpf_models_updated', [ $elem, $elem.find('.woo_vpf_model') ] );
			});
		});
	}
	
	if( $('.woo-vpf-form-container').find('.woo_vpf_year').length ) {
		$('.woo-vpf-form-container').on('change', '.woo_vpf_model', function() {
			
			if( $(this).closest('.woo-vpf-terms-row').length ) {
				var $elem = $(this).closest('.woo-vpf-terms-row');
			} else {
				var $elem = $(this).closest('.woo-vpf-form-container');
			}
			
			$elem.addClass('woo-vpf-processing');
		
			var $term_id = $(this).val();
			$.post( woo_vpf_tdl_params.ajax_url, {'parent':$term_id, 'action':'woo_vpf_get_terms'}, function( response ) {
				$elem.removeClass('woo-vpf-processing');
				$elem.find('.woo_vpf_year option:not(:first)').remove();
				$elem.find('.woo_vpf_year').append( response );
				
				if( $elem.find('.woo_vpf_engine').length ) {
					$elem.find('.woo_vpf_engine option:not(:first)').remove();
				}
				
				$( document.body ).trigger( 'woo_vpf_years_updated', [ $elem, $elem.find('.woo_vpf_year') ] );
			});
		});
	}
	
	if( $('.woo-vpf-form-container').find('.woo_vpf_engine').length ) {
		$('.woo-vpf-form-container').on('change', '.woo_vpf_year', function() {
			
			if( $(this).closest('.woo-vpf-terms-row').length ) {
				var $elem = $(this).closest('.woo-vpf-terms-row');
			} else {
				var $elem = $(this).closest('.woo-vpf-form-container');
			}
			
			$elem.addClass('woo-vpf-processing');
		
			var $term_id = $(this).val();
			$.post( woo_vpf_tdl_params.ajax_url, {'parent':$term_id, 'action':'woo_vpf_get_terms'}, function( response ) {
				$elem.removeClass('woo-vpf-processing');
				$elem.find('.woo_vpf_engine option:not(:first)').remove();
				$elem.find('.woo_vpf_engine').append( response );
				
				$( document.body ).trigger( 'woo_vpf_engines_updated', [ $elem, $elem.find('.woo_vpf_engine') ] );
			});
		});
	}
});
