"use strict";

/*global ajaxurl */
;(function ( $, window ) {
	/**
	 * importForm handles the import process
	 */
	var importForm = function( $form ) {
		this.$form				= $form;
		this.xhr				= false;
		this.mapping			= woo_vpf_import_params.mapping;
		this.position			= 0;
		this.file				= woo_vpf_import_params.file;
		this.delete_existing	= woo_vpf_import_params.delete_existing;
		this.product_column		= woo_vpf_import_params.product_column;
		this.delimiter			= woo_vpf_import_params.delimiter;
		this.security			= woo_vpf_import_params.import_nonce;

		// Number of import successes/failures.
		this.imported			= 0;
		this.failed				= 0;
		this.skipped			= 0;

		// Initial state.
		this.$form.find('.woocommerce-importer-progress').val( 0 );

		this.run_import = this.run_import.bind( this );

		// Start importing.
		this.run_import();
	};

	/**
	 * Run the import in batches until finished.
	 */
	importForm.prototype.run_import = function() {
		var $this = this;

		$.ajax( {
			type:		'POST',
			url:		ajaxurl,
			data:		{
				action			: 'woo_vpf_import',
				position		: $this.position,
				mapping			: $this.mapping,
				file			: $this.file,
				delete_existing	: $this.delete_existing,
				product_column	: $this.product_column,
				delimiter		: $this.delimiter,
				security		: $this.security
			},
			dataType:	'json',
			success:	function( response ) {
				if ( response.success ) {
					$this.position  = response.data.position;
					$this.imported += response.data.imported;
					$this.failed   += response.data.failed;
					$this.skipped  += response.data.skipped;
					$this.$form.find('.woocommerce-importer-progress').val( response.data.percentage );

					if ( 'done' === response.data.position ) {
						window.location = response.data.url + '&terms-imported=' + parseInt( $this.imported, 10 ) + '&terms-failed=' + parseInt( $this.failed, 10 ) + '&terms-skipped=' + parseInt( $this.skipped, 10 );
					} else {
						$this.run_import();
					}
				}
			}
		} ).fail( function( response ) {
			window.console.log( response );
		} );
	};

	/**
	 * Function to call importForm on jQuery selector.
	 */
	$.fn.woo_vpf_importer = function() {
		new importForm( this );
		return this;
	};

	$( '.woocommerce-importer' ).woo_vpf_importer();

})( jQuery, window );
