<?php
/*
 * WPSPowerbox
 * @author   AcmeeDesign
 * @url     http://acmeedesign.com
*/

class wpspb_class_functions {

    private $wpspb_options = null;
    private $wps_options = null;

    public function __construct() {
        $this->wpspb_options = $this->get_wps_option_data(POWERBOX_OPTIONS_SLUG);
        $this->wps_options = $this->get_wps_option_data(WPSHAPERE_OPTIONS_SLUG);
        add_filter('login_redirect', [$this, 'wpspb_login_redirect_user'], 10, 3 );
        add_action( 'in_admin_header', [ $this, 'wp_metaboxes' ], 10 );
        add_action( 'in_admin_header', [ $this, 'remove_metaboxes' ], 20 );
        add_action( 'admin_init', [$this, 'wpspb_import_sidebar_settings' ] );
    }

    private function get_wps_option_data( $option_id ) {
        if($this->is_wps_single_site()) {
            $get_wps_option_data = (is_serialized(get_option($option_id))) ? unserialize(get_option($option_id)) : get_option($option_id);
        }
        else {
            $get_wps_option_data = (is_serialized(get_site_option($option_id))) ? unserialize(get_site_option($option_id)) : get_site_option($option_id);
        }
        return $get_wps_option_data;
	}

    private function is_wps_single_site() {
	    if(!is_multisite())
		return true;
	    elseif(is_multisite() && !defined('NETWORK_ADMIN_CONTROL'))
		return true;
	    else return false;
	}

    private function wps_get_user_role() {
        global $current_user;
        $get_user_roles = $current_user->roles;
        $get_user_role = array_shift($get_user_roles);
        return $get_user_role;
    }

    function wps_get_wproles() {
        global $wp_roles;
        if ( ! isset( $wp_roles ) ) {
            $wp_roles = new WP_Roles();
        }
        return $wp_roles->get_names();
    }

    /* get roles by blog based @since 6.1.4 */
    function wps_get_wproles_blog( $blog_id ) {

    $switched = is_multisite() ? switch_to_blog( $blog_id ) : false;
    $wp_roles = new WP_Roles();
    $roles = $wp_roles->get_names();
    if ( $switched ) {
        restore_current_blog();
    }
    return $roles;

    }

    function wpspb_login_redirect_user($redirect_to, $request, $user) {
        if ( isset( $user->roles ) && is_array( $user->roles ) ) {

            $the_user_role = $user->roles;

            $redirect_page = isset($this->wpspb_options['manage']['wpspb_redirect_users'][$the_user_role[0]]) ? $this->wpspb_options['manage']['wpspb_redirect_users'][$the_user_role[0]] : null;
            if(!empty($redirect_page)) {
                if($this->is_page_type($redirect_page) == "toplevel") {
                    return admin_url( $redirect_page );
                }
                elseif($this->is_page_type($redirect_page) == "pluginspage") {
                    return admin_url( "admin.php?page=".$redirect_page );
                }
                elseif(!empty($redirect_page)) {
                    return $redirect_page;
                }
            }
        }

        return $redirect_to;

    }

    function is_page_type($url) {
        if (stripos($url, 'http') === 0) {
            return "custom";
        }
        elseif(strpos($url, '.php') !== false) {
            return "toplevel";
        }
        else {
            return "pluginspage";
        }
    }

    //remove metaboxes
    function remove_metaboxes() {

        global $wp_meta_boxes;

        $current_user_role = $this->wps_get_user_role();
        $current_user_id = get_current_user_id();
        $wps_privilege_users = (!empty($this->wps_options['privilege_users'])) ? $this->wps_options['privilege_users'] : array(); 

        // Check for privilege users
        if (is_super_admin($current_user_id) && !empty($wps_privilege_users) && in_array($current_user_id, $wps_privilege_users)) 
            return;

        $hidden_metaboxes = isset( $this->wpspb_options['hidden_metaboxes'][$current_user_role] ) ? $this->wpspb_options['hidden_metaboxes'][$current_user_role] : NULL;

        if (!empty($wp_meta_boxes) && is_array($wp_meta_boxes) &&
        !empty($hidden_metaboxes) && is_array($hidden_metaboxes)) {

            foreach ($hidden_metaboxes as $post_type => $contexts) { // 'post', 'product'
                foreach ($contexts as $context_key => $priorities) { // 'side', 'normal'
                    foreach ($priorities as $priority_key => $boxes) { // 'core', 'high'
                        foreach ($boxes as $box_id => $box_val) { // 'submitdiv', ...
                            unset($wp_meta_boxes[$post_type][$context_key][$priority_key][$box_id]);
                        }
                    }
                }
            }
        }

    }

    function wp_metaboxes() {

        global $wp_meta_boxes, $pagenow;

        $wppost_type = null;
        if ( 'post.php' === $pagenow && isset($_GET['post']) ) {
            $wppost_type = get_post_type( $_GET['post'] );
        }

        $all_meta_boxes = array();

        if( !empty($wppost_type) && !empty($wp_meta_boxes) && is_array($wp_meta_boxes) ) {

        foreach ($wp_meta_boxes[$wppost_type] as $box_key => $priority ) {

            foreach ( array( 'high', 'core', 'default', 'low' ) as $priority ) {
                if ( ! isset( $wp_meta_boxes[$wppost_type][ $box_key ][ $priority ] ) ) {
                    continue;
                }
                foreach ( $wp_meta_boxes[ $wppost_type ][ $box_key ][ $priority ] as $box ) {
                if ( false == $box || ! $box['title'] ) {
                    continue;
                }

                $widget_title = $box['title'];

                if ( isset($box['args']) && is_array( $box['args'] ) && isset( $box['args']['__widget_basename'] ) ) {
                    $widget_title = $box['args']['__widget_basename'];
                }

                $all_meta_boxes[ $wppost_type ][$box_key][ $priority ][ $box['id'] ] = array(
                    'id' => $box['id'],
                    'title' => wp_strip_all_tags( $widget_title, true ),
                );

                }
            }

        }

        if( !empty($all_meta_boxes) && is_array($all_meta_boxes) ) {

            $meta_boxes = [
            'wp_meta_boxes' => $all_meta_boxes
            ];

            $saved_data = $this->get_wps_option_data(POWERBOX_OPTIONS_SLUG);

            if($saved_data) {
                $data = $this->wps_array_merge($saved_data, $meta_boxes);
            }
            else
                $data = $meta_boxes;

            $this->updateOption( POWERBOX_OPTIONS_SLUG, $data );

        }

        }
    }

    //import WPSPowerbox menu items
    function wpspb_import_sidebar_settings() {

      global $wpdb;

      if( !empty($_POST['wpspb_sidebar_settings_field'] ) ) {
        //if nonce not set, exit!
        if( !wp_verify_nonce( $_POST['wpspb_sidebar_settings_field'], 'wpspb_sidebar_settings_nonce' ) )
            exit();

          $import_data = wp_unslash( trim( $_POST['wpspb_sidebar_settings'] ) );

          if( empty( $import_data ) ) {
              wp_safe_redirect( admin_url( 'admin.php?page=wpspb_impexport_sidebar&status=dataerror' ) );
              exit();
          }
          else {

              $data = json_decode( $import_data );

              if( is_object( $data ) ) {
                foreach ( $data as $menu_id => $menu_data ) {
                  $wpdb->insert(
                    POWERBOX_MENU_TABLE,
                    array(
                      'menu_title' => $menu_data->menu_title,
                      'menu_data' => $menu_data->menu_data,
                      'user_type' => $menu_data->user_type,
                      'menu_role_id' => $menu_data->menu_role_id,
                      'status' => $menu_data->status,
                      'other_data' => $menu_data->other_data,
                    )
                  );
                }
              }
              wp_safe_redirect( admin_url( 'admin.php?page=wpspb_impexport_sidebar&status=updated' ) );
              exit();
          }
      }

    }

    function wps_array_merge()
    {
        $output = array();
        foreach(func_get_args() as $array) {
            foreach($array as $key => $value) {
                $output[$key] = isset($output[$key]) ?
                    array_merge($output[$key], $value) : $value;
            }
        }
        return $output;
    }

    //fn to save options
    public function updateOption($option='', $data='') {
        if(empty($option)) {
            $option = WPSHAPERE_OPTIONS_SLUG;
        }
        if(isset($data) && !empty($data)) {
            if($this->is_wps_single_site())
            update_option($option, $data);
            else
            update_site_option($option, $data);
        }
    }

}

// Initialize plugin class
new wpspb_class_functions();
