(function($){

    $.fn.validationEngineLanguage = function(){

    };

    $.validationEngineLanguage = {

        newLang: function(){

            $.validationEngineLanguage.allRules = {

                "required": { // Add your regex rules here, you can take telephone as an example

                    "regex": "none",

                    "alertText": "* این فیلد ضروری است",

                    "alertTextCheckboxMultiple": "* لطفا یک گزینه را انتخاب کنید",

                    "alertTextCheckboxe": "* این چک باکس ضروری است",

                    "alertTextDateRange": "* هر دو فیلد‌های بازه‌ی تاریخی ضروری هستند"

                },

                "requiredInFunction": { 

                    "func": function(field, rules, i, options){

                        return (field.val() == "test") ? true : false;

                    },

                    "alertText": "* فیلد باید برابر با آزمون باشد"

                },

                "dateRange": {

                    "regex": "none",

                    "alertText": "* بازه‌ی تاریخی ",

                    "alertText2": "نامعتبر"

                },

                "dateTimeRange": {

                    "regex": "none",

                    "alertText": "* بازه‌ی زمانی",

                    "alertText2": "نامعتبر"

                },

                "minSize": {

                    "regex": "none",

                    "alertText": "* حداقل ",

                    "alertText2": " حرف ضروری است"

                },

                "maxSize": {

                    "regex": "none",

                    "alertText": "* حداکثر ",

                    "alertText2": " حرف وارد کنید"

                },

				"groupRequired": {

                    "regex": "none",

                    "alertText": "* شما باید یکی از فیلد‌های زیر را پر کنید"

                },

                "min": {

                    "regex": "none",

                    "alertText": "* کمترین مقدار معتبر ",

					"alertText2": " است"

                },

                "max": {

                    "regex": "none",

                    "alertText": "* بیش‌ترین مقدار معتبر ",

					"alertText2": "است"

                },

                "past": {

                    "regex": "none",

                    "alertText": "* تاریخ‌های قبل از "

                },

                "future": {

                    "regex": "none",

                    "alertText": "* تاریخ‌های بعد از "

                },	

                "maxCheckbox": {

                    "regex": "none",

                    "alertText": "* بیش‌ترین گزینه‌ی قابل انتخاب ",

                    "alertText2": " است"

                },

                "minCheckbox": {

                    "regex": "none",

                    "alertText": "* لطفا ",

                    "alertText2": " مورد انتخاب کنید"

                },

                "equals": {

                    "regex": "none",

                    "alertText": "* فیلد نامعتبر است"

                },

                "creditCard": {

                    "regex": "none",

                    "alertText": "شماره کارت اعتباری اشتباه"

                },

                "phone": {

                    // credit: jquery.h5validate.js / orefalo

                    "regex": /^([\+][0-9]{1,3}([ \.\-])?)?([\(][0-9]{1,6}[\)])?([0-9 \.\-]{1,32})(([A-Za-z \:]{1,11})?[0-9]{1,4}?)$/,

                    "alertText": "* شماره تلفن معتبر وارد کنید"

                },

                "email": {

                    // Shamelessly lifted from Scott Gonzalez via the Bassistance Validation plugin http://projects.scottsplayground.com/email_address_validation/

                    "regex": /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i,

                    "alertText": "* یک آدرس ایمیل معتبر وارد کنید"

                },

                "integer": {

                    "regex": /^[\-\+]?\d+$/,

                    "alertText": "* عدد معتبر وارد کنید"

                },

                "number": {

                    // Number, including positive, negative, and floating decimal. credit: orefalo

                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,

                    "alertText": "* عدد اعشاری معتبر وارد کنید"

                },

                "date": {

                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/,

                    "alertText": "* تاریخ باید به شکل سال/ماه/روز"

                },

                "ipv4": {

                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,

                    "alertText": "* IP معتبر وارد کنید"

                },

                "url": {

                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,

                    "alertText": "* نشانی معتبر وارد کنید"

                },

                "onlyNumberSp": {

                    "regex": /^[0-9\ ]+$/,

                    "alertText": "* فقط اعداد"

                },

                "onlyLetterSp": {

                    "regex": /^[a-zA-Z\ \']+$/,

                    "alertText": "* فقط حروف انگلیسی"

                },

                "onlyLetterNumber": {

                    "regex": /^[0-9a-zA-Z]+$/,

                    "alertText": "* فقط اعداد و حروف انگلیسی وارد کنید"

                },

				//Start Custom Validation

				//1)First Name,Last Name

				"onlyLetter_specialcharacter": 

				{

                     "regex": /^[a-zA-Z\u0600-\u06FF\ \_\,\`\.\'\^\-]+$/,

                    "alertText": "* فقط نامه ها و ' _,`.'^-' شخصیت مجاز است"

                },

				//2)City,State,Country

				"city_state_country_validation": 

				{

                    "regex": /^[a-zA-Z\u0600-\u06FF\ \_\,\`\.\'\^\-\&]+$/,

                    "alertText": "* فقط نامه ها و  ' _,`.'^-&' شخصیت مجاز است"

                },

				//3)PopUp Category,Medicine Name,Event Name

				"popup_category_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u0600-\u06FF\ \_\,\`\.\'\^]+$/,

                    "alertText": "* فقط نامه ها، اعداد و ' _,`.'^' شخصیت مجاز است"

                },

				//4)Address and Description

				"address_description_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u0600-\u06FF\ \_\,\`\.\'\^\-\&\n]+$/,

                    "alertText": "* فقط نامه ها، اعداد و ' _,`.'^-&' شخصیت مجاز است"

                },

				//5)UserName

				"username_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u0600-\u06FF\_\.\-\@]+$/,

                    "alertText": "* فقط نامه ها، اعداد و '_.-@' شخصیت مجاز است"

                }, 

				//6)Phone Number

				"phone_number": 

				{

                    "regex": /^[0-9\ \-\+]+$/,

                    "alertText": "* فقط تعداد و ' -+' شخصیت مجاز است"

                }, 

				// end Custom Validation

                // --- CUSTOM RULES -- Those are specific to the demos, they can be removed or changed to your likings

                "ajaxUserCall": {

                    "url": "ajaxValidateFieldUser",

                    // you may want to pass extra data on the ajax call

                    "extraData": "name=eric",

                    "alertText": "* این کاربر - نام کاربری قبلا ثبت شده است",

                    "alertTextLoad": "* درحال اعتبار سنجی، لطفا صبر کنید"

                },

				"ajaxUserCallPhp": {

                    "url": "phpajax/ajaxValidateFieldUser.php",

                    // you may want to pass extra data on the ajax call

                    "extraData": "name=eric",

                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates

                    "alertTextOk": "* این نام کاربری آزاد است",

                    "alertText": "* این نام‌کاربری تکراری است",

                    "alertTextLoad": "* درحال اعتبار سنجی، لطفا صبر کنید"

                },

                "ajaxNameCall": {

                    // remote json service location

                    "url": "ajaxValidateFieldName",

                    // error

                    "alertText": "* این نام پیش‌تر ثبت شده است",

                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates

                    "alertTextOk": "* این نام آزاد است",

                    // speaks by itself

                    "alertTextLoad": "* درحال اعتبار سنجی، لطفا صبر کنید"

                },

				 "ajaxNameCallPhp": {

	                    // remote json service location

	                    "url": "phpajax/ajaxValidateFieldName.php",

	                    // error

	                    "alertText": "* این نام تکراری است",

	                    // speaks by itself

	                    "alertTextLoad": "* درحال اعتبار سنجی، لطفا صبر کنید"

	                },

                "validate2fields": {

                    "alertText": "* لطفا مقدار HELLO را وارد کنید"

                },

	            //tls warning:homegrown not fielded 

                "dateFormat":{

                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,

                    "alertText": "* تاریخ نامعتبر"

                },

                //tls warning:homegrown not fielded 

				"dateTimeFormat": {

	                "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,

                    "alertText": "* تاریخ نامعتبر است یا شکل معتبری ندارد",

                    "alertText2": "شکل‌های مورد معتبر: ",

                    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM or ", 

                    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"

	            }

            };

            

        }

    };



    $.validationEngineLanguage.newLang();

    

})(jQuery);

