(function($){

    $.fn.validationEngineLanguage = function(){

    };

    $.validationEngineLanguage = {

        newLang: function(){

            $.validationEngineLanguage.allRules = {

                "required": { // Add your regex rules here, you can take telephone as an example

                    "regex": "none",

                    "alertText": "*  See väli on nõutud",

                    "alertTextCheckboxMultiple": "* Palun valige üks valik",

                    "alertTextCheckboxe": "* Linnuke on nõutud",

                    "alertTextDateRange": "* Mõlemad kuupäeva valikud on nõutud"

                },

                "requiredInFunction": { 

                    "func": function(field, rules, i, options){

                        return (field.val() == "test") ? true : false;

                    },

                    "alertText": "* Väli peab olema võrdne testiga"

                },

                "dateRange": {

                    "regex": "none",

                    "alertText": "* Vigane ",

                    "alertText2": "Kuupäev valik"

                },

                "dateTimeRange": {

                    "regex": "none",

                    "alertText": "* Vigane ",

                    "alertText2": "Aja valik"

                },

                "minSize": {

                    "regex": "none",

                    "alertText": "* Minimaalselt ",

                    "alertText2": " märki lubatud"

                },

                "maxSize": {

                    "regex": "none",

                    "alertText": "* Maksimaalselt ",

                    "alertText2": " märki lubatud"

                },

    			"groupRequired": {

                    "regex": "none",

                    "alertText": "* Palun täidke üks järgnevatest väljadest"

                },

                "min": {

                    "regex": "none",

                    "alertText": "* Minimaalne väärtus on "

                },

                "max": {

                    "regex": "none",

                    "alertText": "* Maksimaalne väärtus on "

                },

                "past": {

                    "regex": "none",

                    "alertText": "* Kuupäev enne "

                },

                "future": {

                    "regex": "none",

                    "alertText": "* Kuupäev peale "

                },	

                "maxCheckbox": {

                    "regex": "none",

                    "alertText": "* Maksimaalselt ",

                    "alertText2": " valikut lubatud"

                },

                "minCheckbox": {

                    "regex": "none",

                    "alertText": "* Palun vali ",

                    "alertText2": " valik(ut)"

                },

                "equals": {

                    "regex": "none",

                    "alertText": "* Väljad ei kattu"

                },

                "creditCard": {

                    "regex": "none",

                    "alertText": "* Kehtetu krediitkaardi number"

                },

                "phone": {

                    // credit: jquery.h5validate.js / orefalo

                    "regex": /^([\+][0-9]{1,3}([ \.\-])?)?([\(][0-9]{1,6}[\)])?([0-9 \.\-]{1,32})(([A-Za-z \:]{1,11})?[0-9]{1,4}?)$/,

                    "alertText": "* Vigane telefoni number"

                },

                "email": {

                    // Shamelessly lifted from Scott Gonzalez via the Bassistance Validation plugin http://projects.scottsplayground.com/email_address_validation/

                    "regex": /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/,

                    "alertText": "* Vigane emaili aadres"

                },

                "integer": {

                    "regex": /^[\-\+]?\d+$/,

                    "alertText": "* Mittesobiv number"

                },

                "number": {

                    // Number, including positive, negative, and floating decimal. credit: orefalo

                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,

                    "alertText": "* Vigane väärtus"

                },

                "date": {

                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/,

                    "alertText": "* Vigane kuupäev. Peab olema AAAA-KK-PP formaadis"

                },

                "ipv4": {

                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,

                    "alertText": "* Vigane IP aadress"

                },

                "url": {

                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,

                    "alertText": "* Vigane URL"

                },

                "onlyNumberSp": {

                    "regex": /^[0-9\ ]+$/,

                    "alertText": "* Numbrid ainult"

                },

                "onlyLetterSp": {

                    "regex": /^[a-zA-Z\ \']+$/,

                    "alertText": "* Tähed ainult"

                },

				"onlyLetterAccentSp":{

                    "regex": /^[a-z\u00C0-\u017F\ ]+$/i,

                    "alertText": "* Tähed ainult"

                },

                "onlyLetterNumber": {

                    "regex": /^[0-9a-zA-Z]+$/,

                    "alertText": "* Eri tähemärke ei lubata"

                },

				//Start Custom Validation

				//1)First Name,Last Name

				"onlyLetter_specialcharacter": 

				{

                     "regex": /^[a-zA-Z\u00C0-\u017F\ ]+$/,

                    "alertText": "* Ainult kirjad ja ' _,`.'^-' Lubatud tähemärgid"

                },

				//2)City,State,Country

				"city_state_country_validation": 

				{

                    "regex": /^[a-zA-Z\u00C0-\u017F\ \_\,\`\.\'\^\-\&]+$/,

                    "alertText": "* Ainult kirjad ja ' _,`.'^-&' Lubatud tähemärgid"

                },

				//3)PopUp Category,Medicine Name,Event Name

				"popup_category_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\ \_\,\`\.\'\^]+$/,

                    "alertText": "* Ainult kirjad, numbrid ja ' _,`.'^' Lubatud tähemärgid"

                },

				//4)Address and Description

				"address_description_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\ \_\,\`\.\'\^\-\&\n]+$/,

                    "alertText": "* Ainult kirjad, numbrid ja ' _,`.'^-&' Lubatud tähemärgid"

                },

				//5)UserName

				"username_validation": 

				{

                    "regex": /^[0-9a-zA-Z\u00C0-\u017F\_\.\-\@]+$/,

                    "alertText": "* Ainult kirjad, numbrid ja '_.-@' Lubatud tähemärgid"

                }, 

				//6)Phone Number

				"phone_number": 

				{

                    "regex": /^[0-9\ \-\+]+$/,

                    "alertText": "* Ainult numbrid ja ' -+' Lubatud tähemärgid"

                }, 

				// end Custom Validation

	            //tls warning:homegrown not fielded 

                "dateFormat":{

                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,

                    "alertText": "* Vigane kuupäev"

                },

                //tls warning:homegrown not fielded 

				"dateTimeFormat": {

	                "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,

                    "alertText": "* Vigane kuupäev või kuupäeva formaat",

                    "alertText2": "Eeldatud formaat: ",

                    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM või ", 

                    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"

	            }

            };

            

        }

    };

    $.validationEngineLanguage.newLang();

})(jQuery);

