<?php

/**
 * Plugin Name: Tickera Seating Charts
 * Plugin URI: http://tickera.com/
 * Description: Create seating charts for your event
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 0.79

 * Update URI: https://api.freemius.com
 * Text Domain: tcsc
 * Domain Path: /languages
 * Copyright 2019 Tickera (http://tickera.com/)
 */
if ( !function_exists( 'seatings_fs' ) ) {
    // Create a helper function for easy SDK access.
    function seatings_fs()
    {
        global  $seatings_fs ;
        
        if ( !isset( $seatings_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_3103_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_3103_MULTISITE', true );
            }
            // Include Freemius SDK.
            
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } else {
                
                if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                    // Try to load SDK from premium parent plugin folder.
                    require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
                } else {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
            
            }
            
            $seatings_fs = fs_dynamic_init( array(
                'id'               => '3103',
                'slug'             => 'seating-charts',
                'premium_slug'     => 'seating-charts',
                'type'             => 'plugin',
                'public_key'       => 'pk_254561f3d24293a2cdd972d5fd74a',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'parent'           => array(
                'id'         => '3102',
                'slug'       => 'tickera-event-ticketing-system',
                'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                'name'       => 'Tickera',
            ),
                'menu'             => array(
                'first-path' => 'plugins.php',
                'support'    => false,
            ),
                'is_live'          => true,
            ) );
        }
        
        return $seatings_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function seatings_fs_is_parent_active_and_loaded()
{
    return function_exists( 'tets_fs' );
}

function seatings_fs_is_parent_active()
{
    $active_plugins = get_option( 'active_plugins', array() );
    
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function seatings_fs_init()
{
    
    if ( seatings_fs_is_parent_active_and_loaded() ) {
        /*
         * Parent is active, add your init code here.
         * Init Freemius.
         */
        seatings_fs();
        if ( !seatings_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        // Parent is inactive, add your error handling here.
    }

}


if ( seatings_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    seatings_fs_init();
} elseif ( seatings_fs_is_parent_active() ) {
    // Init add-on only after the parent is loaded.
    add_action( 'tets_fs_loaded', 'seatings_fs_init' );
} else {
    // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
    seatings_fs_init();
}


if ( !class_exists( 'TC_Seat_Chart' ) ) {
    class TC_Seat_Chart
    {
        var  $version = '0.79' ;
        var  $tc_version_required = '3.3.1' ;
        var  $title = 'Seating Charts' ;
        var  $name = 'tc-seat-charts' ;
        var  $dir_name = 'seating-charts' ;
        var  $location = 'plugins' ;
        var  $plugin_dir = '' ;
        var  $plugin_url = '' ;
        function __construct()
        {
            $this->maybe_create_html_dir();
            require_once $this->plugin_dir . 'includes/php-html-css-js-minifier.php';
            require_once $this->plugin_dir . 'includes/class.tc_firebase.php';
            // require_once( $this->plugin_dir . 'includes/classes/blocks/class.woocommerce-cart.php' );
            add_action( 'init', array( $this, 'capture_update_cart_actions' ) );
            add_action( 'init', array( $this, 'register_custom_posts' ), 0 );
            add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts_and_styles' ) );
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts_and_styles' ) );
            add_action( 'save_post', 'TC_Seat_Chart::save_admin' );
            // save_metabox_values
            add_action( 'wp_ajax_tc_get_event_ticket_types', array( $this, 'get_event_ticket_types_select' ) );
            add_action( 'wp_ajax_nopriv_tc_get_event_ticket_types', array( $this, 'get_event_ticket_types_select' ) );
            add_action( 'wp_ajax_nopriv_tc_validate_woo_seat_availability', array( $this, 'tc_validate_woo_seat_availability' ) );
            add_action( 'wp_ajax_tc_validate_woo_seat_availability', array( $this, 'tc_validate_woo_seat_availability' ) );
            add_action( 'wp_ajax_nopriv_tc_update_cart_seats', array( $this, 'tc_update_cart_seats' ) );
            add_action( 'wp_ajax_tc_update_cart_seats', array( $this, 'tc_update_cart_seats' ) );
            add_action( 'wp_ajax_nopriv_tc_woo_update_cart_seats', array( $this, 'tc_woo_update_cart_seats' ) );
            add_action( 'wp_ajax_tc_woo_update_cart_seats', array( $this, 'tc_woo_update_cart_seats' ) );
            add_action( 'wp_ajax_nopriv_tc_remove_seat_from_cart_ajax', array( $this, 'tc_remove_seat_from_cart_ajax' ) );
            add_action( 'wp_ajax_tc_remove_seat_from_cart_ajax', array( $this, 'tc_remove_seat_from_cart_ajax' ) );
            add_action( 'wp_ajax_tc_wc_get_cart_info', array( $this, 'tc_wc_get_cart_info' ) );
            add_filter(
                'tc_settings_new_menus',
                array( $this, 'tc_settings_new_menus' ),
                10,
                1
            );
            add_action( 'tc_settings_menu_seat_charts', array( $this, 'tc_settings_menu_seat_charts' ) );
            add_action( 'wp_ajax_tc_remove_order_session_data', array( $this, 'ajax_remove_order_session_data' ) );
            add_action( 'wp_ajax_nopriv_tc_remove_order_session_data', array( $this, 'ajax_remove_order_session_data' ) );
            add_action(
                'tc_cart_before_attendee_info_wrap',
                array( $this, 'tc_add_cart_seat_info' ),
                10,
                2
            );
            add_filter(
                'tc_cart_attendee_info_caption',
                array( $this, 'tc_add_seat_info_to_attendee_caption' ),
                10,
                3
            );
            add_filter(
                'tc_checkout_owner_info_ticket_title',
                array( $this, 'tc_maybe_add_seat_info_to_ticket_type' ),
                10,
                4
            );
            add_filter(
                'post_row_actions',
                array( $this, 'post_row_actions' ),
                10,
                2
            );
            add_filter( 'the_content', array( $this, 'modify_the_content' ) );
            add_action( 'admin_notices', array( $this, 'admin_notices' ) );
            add_filter(
                'tc_editable_quantity',
                array( $this, 'tc_editable_quantity' ),
                10,
                3
            );
            add_filter( 'tc_shortcodes', array( $this, 'tc_modify_shortcode_builder_list' ) );
            add_filter( 'tc_gutenberg_blocks', array( $this, 'modify_gutenberg_blocks_list' ) );
            add_filter( 'tc_ticket_fields', array( &$this, 'additional_ticket_type_metabox' ) );
            require_once $this->plugin_dir . 'includes/functions.php';
            require_once $this->plugin_dir . 'includes/classes/class.shortcodes.php';
            add_action( 'wp_ajax_nopriv_tc_seat_chart_get_wc_variations', array( $this, 'tc_seat_chart_get_wc_variations' ) );
            add_action( 'wp_ajax_tc_seat_chart_get_wc_variations', array( $this, 'tc_seat_chart_get_wc_variations' ) );
            add_action( 'wp_ajax_nopriv_tc_seat_chart_get_wc_standing_area_options', array( $this, 'tc_seat_chart_get_wc_standing_area_options' ) );
            add_action( 'wp_ajax_tc_seat_chart_get_wc_standing_area_options', array( $this, 'tc_seat_chart_get_wc_standing_area_options' ) );
            add_action( 'wp_ajax_nopriv_tc_seat_chart_get_standing_area_options', array( $this, 'tc_seat_chart_get_standing_area_options' ) );
            add_action( 'wp_ajax_tc_seat_chart_get_standing_area_options', array( $this, 'tc_seat_chart_get_standing_area_options' ) );
            add_filter(
                'woocommerce_quantity_input_args',
                array( $this, 'tc_seat_chart_maybe_modify_woocommerce_quantity_input_args' ),
                99,
                2
            );
            add_action(
                'tc_woo_show_if_tc_ticket_before',
                array( $this, 'woo_ticket_type_additional_meta' ),
                10,
                1
            );
            add_action(
                'woocommerce_process_product_meta',
                array( $this, 'woo_ticket_type_additional_meta_save' ),
                10,
                1
            );
            add_action(
                'woocommerce_remove_cart_item',
                array( $this, 'woo_cart_item_remove_seat' ),
                10,
                1
            );
            add_action( 'init', array( $this, 'load_plugin_textdomain' ), 11 );
            add_filter(
                'post_row_actions',
                array( $this, 'duplicate_seating_chart_row_action' ),
                10,
                2
            );
            add_action( 'admin_action_tc_duplicate_seating_chart', array( $this, 'duplicate_seating_chart_action' ) );
            add_action( 'admin_footer', array( $this, 'admin_footer_styles' ) );
            add_action(
                'edit_form_after_editor',
                array( $this, 'seating_charts_admin' ),
                10,
                1
            );
            add_action( 'post_edit_form_tag', array( &$this, 'edit_post_enctype' ) );
            add_filter( 'post_updated_messages', array( $this, 'post_updated_messages' ) );
            add_filter( 'admin_body_class', array( $this, 'add_body_class' ) );
            add_action(
                'delete_post',
                array( $this, 'delete_chart_html' ),
                10,
                1
            );
            add_action(
                'wp_trash_post',
                array( $this, 'trash_chart' ),
                10,
                1
            );
            add_action( 'woocommerce_cart_emptied', array( $this, 'delete_cart_seats_persistent' ), 10 );
            add_action(
                'tc_cart_col_after_ticket_type',
                array( $this, 'list_out_single_tickets' ),
                10,
                3
            );
            add_action(
                'woocommerce_after_cart_item_name',
                array( $this, 'woo_cart_list_out_single_tickets' ),
                10,
                2
            );
            add_action(
                'woocommerce_display_item_meta',
                array( &$this, 'additional_order_item_seat_label_meta' ),
                10,
                3
            );
            add_filter(
                'tc_delete_info_plugins_list',
                array( $this, 'tc_delete_info_plugins_list' ),
                10,
                1
            );
            add_action(
                'tc_delete_plugins_data',
                array( $this, 'tc_delete_plugins_data' ),
                10,
                1
            );
            add_action( 'tc_woo_show_if_tc_ticket_before', array( $this, 'tc_show_used_for_seatings_option' ) );
            add_filter(
                'woocommerce_is_purchasable',
                array( $this, 'woo_is_purchasable_from_product_page' ),
                10,
                2
            );
            add_action( 'woocommerce_before_add_to_cart_form', array( &$this, 'woo_before_add_to_cart_form' ) );
            /*
             * Tickera Standalone - Checkout process error handling
             * Cart/Checkout validation
             */
            add_filter( 'tc_has_cart_or_payment_errors', array( $this, 'validate_cart_seats' ) );
            // Payment Page
            add_filter( 'tc_cart_errors', array( $this, 'validate_cart_seats' ) );
            // Cart Page
            add_action( 'tc_cart_before_error_pass_check', array( $this, 'validate_cart_seats' ), 0 );
            // Proceed to checkout
            add_action( 'tc_add_more_final_checks', array( $this, 'validate_cart_seats' ) );
            // Process payment and order creation
            /*
             * Tickera alongside Bridge for Woocommerce
             * Cart/Checkout validation
             */
            add_action(
                'woocommerce_after_checkout_validation',
                array( $this, 'woo_after_checkout_validation' ),
                10,
                2
            );
            add_action( 'woocommerce_check_cart_items', array( &$this, 'woo_validate_cart_seats' ) );
            /*
             * Tickera alongside Bridge for Woocommerce
             * Woocommerce Cart/Checkout Blocks
             *
             * @since 0.79
             */
            // add_action( 'woocommerce_blocks_cart_block_registration', array( $this, 'woo_register_cart_block_script' ) );
        }
        
        /**
         * @param $integration_registry
         * @since 0.79
         */
        function woo_register_cart_block_script( $integration_registry )
        {
            $cart_block = new TCSC_Woocommerce_Cart_Block_Integration();
            $integration_registry->register( $cart_block );
        }
        
        function tc_show_used_for_seatings_option()
        {
            woocommerce_wp_checkbox( array(
                'id'          => '_tc_used_for_seatings',
                'label'       => __( 'Used for Seatings', 'tcsc' ),
                'desc_tip'    => 'true',
                'description' => __( 'Check this box if you are going to use this product on a seatings map. That way, product can be purchased only if it\'s added to cart via a seatings map.', 'tcsc' ),
            ) );
        }
        
        function tc_delete_info_plugins_list( $plugins )
        {
            $plugins[$this->name] = $this->title;
            return $plugins;
        }
        
        function tc_delete_plugins_data( $submitted_data )
        {
            
            if ( array_key_exists( $this->name, $submitted_data ) ) {
                global  $wpdb ;
                // Delete posts and post metas
                $wpdb->query( "DELETE p, pm FROM {$wpdb->posts} p JOIN {$wpdb->postmeta} pm on pm.post_id = p.id WHERE p.post_type IN ('tc_seat_charts')" );
                // Delete options
                $options = array( 'tc_seat_charts_settings' );
                foreach ( $options as $option ) {
                    delete_option( $option );
                }
                // Delete directories and files
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                TC::rrmdir( $upload_dir );
            }
        
        }
        
        function trash_chart( $post_id = false )
        {
            if ( $post_id && get_post_type( $post_id ) == 'tc_seat_charts' ) {
                wp_update_post( [
                    'ID'          => $post_id,
                    'post_status' => 'trash',
                ] );
            }
        }
        
        /**
         * Tickera Standalone - Validate expired and reserved seats in cart page.
         *
         * @param $has
         * @return string
         */
        function validate_cart_seats( $has )
        {
            global  $tc, $tc_cart_errors, $cart_error_number ;
            $reserved_seats = self::get_cart_reserved_seats();
            $expired_seats = self::get_cart_expired_seats();
            /**
             * Executes at Payment Page
             */
            
            if ( doing_filter( 'tc_has_cart_or_payment_errors' ) ) {
                
                if ( $reserved_seats || $expired_seats ) {
                    add_action( 'tc_has_cart_or_payment_errors_action', function () {
                        global  $tc ;
                        $cart_error = '';
                        $reserved_seats = self::get_cart_reserved_seats();
                        $expired_seats = self::get_cart_expired_seats();
                        if ( $expired_seats ) {
                            $cart_error = ( 1 == count( $expired_seats ) ? sprintf(
                                __( '%s expired. Please remove from the %scart%s and try to add them via a Seating Map once again.', 'tcsc' ),
                                '<strong>' . reset( $expired_seats ) . '</strong>',
                                '<a href="' . $tc->get_cart_slug( true ) . '">',
                                '</a>'
                            ) : sprintf(
                                __( '%s expired. Please remove from the %scart%s and try to add them via a Seating Map once again.', 'tcsc' ),
                                '<strong>' . implode( ', ', $expired_seats ) . '</strong>',
                                '<a href="' . $tc->get_cart_slug( true ) . '">',
                                '</a>'
                            ) . '<br><br>' );
                        }
                        if ( $reserved_seats ) {
                            $cart_error = ( 1 == count( $reserved_seats ) ? sprintf(
                                __( 'Seat %s is already booked. Please remove it from the %scart%s.', 'tcsc' ),
                                '<strong>' . reset( $reserved_seats ) . '</strong>',
                                '<a href="' . $tc->get_cart_slug( true ) . '">',
                                '</a>'
                            ) : sprintf(
                                __( 'Seats %s are already booked. Please remove them from the %scart%s.', 'tcsc' ),
                                '<strong>' . implode( ', ', $reserved_seats ) . '</strong>',
                                '<a href="' . $tc->get_cart_slug( true ) . '">',
                                '</a>'
                            ) );
                        }
                        echo  $cart_error ;
                    } );
                    $has = true;
                }
                
                return $has;
            }
            
            /**
             * Executes at Cart Page on Load
             */
            
            if ( doing_filter( 'tc_cart_errors' ) ) {
                $cart_error = '';
                
                if ( $reserved_seats || $expired_seats ) {
                    
                    if ( $expired_seats ) {
                        $cart_error = ( 1 == count( $expired_seats ) ? '<li>' . sprintf( __( '%s expired. Please remove from the cart and try to add them via a Seating Map once again.', 'tcsc' ), '<strong>' . reset( $expired_seats ) . '</strong>' ) . '</li>' : '<li>' . sprintf( __( '%s expired. Please remove from the cart and try to add them via a Seating Map once again.', 'tcsc' ), '<strong>' . implode( ', ', $expired_seats ) . '</strong>' ) . '</li>' );
                        $cart_error_number++;
                    }
                    
                    
                    if ( $reserved_seats ) {
                        $cart_error = ( 1 == count( $reserved_seats ) ? '<li>' . sprintf( __( 'Seat %s is already booked. Please remove it from the cart.', 'tcsc' ), '<strong>' . reset( $reserved_seats ) . '</strong>' ) . '</li>' : '<li>' . sprintf( __( 'Seats %s are already booked. Please remove them from the cart.', 'tcsc' ), '<strong>' . implode( ', ', $reserved_seats ) . '</strong>' ) . '</li>' );
                        $cart_error_number++;
                    }
                
                }
                
                return $cart_error;
            }
            
            /**
             * Executes right upon proceed to checkout from cart page.
             */
            if ( did_action( 'tc_cart_before_error_pass_check' ) ) {
                
                if ( $reserved_seats || $expired_seats ) {
                    
                    if ( $expired_seats ) {
                        $tc_cart_errors = ( 1 == count( $reserved_seats ) ? '<li>' . sprintf( __( '%s expired. Please remove from the cart and try to add them via a Seating Map once again.', 'tcsc' ), '<strong>' . reset( $expired_seats ) . '</strong>' ) . '</li>' : '<li>' . sprintf( __( '%s expired. Please remove from the cart and try to add them via a Seating Map once again.', 'tcsc' ), '<strong>' . implode( ', ', $expired_seats ) . '</strong>' ) . '</li>' );
                        $cart_error_number++;
                    }
                    
                    
                    if ( $reserved_seats ) {
                        $tc_cart_errors = ( 1 == count( $reserved_seats ) ? '<li>' . sprintf( __( 'Seat %s is already booked. Please remove it from the cart.', 'tcsc' ), '<strong>' . reset( $reserved_seats ) . '</strong>' ) . '</li>' : '<li>' . sprintf( __( 'Seats %s are already booked. Please remove them from the cart.', 'tcsc' ), '<strong>' . implode( ', ', $reserved_seats ) . '</strong>' ) . '</li>' );
                        $cart_error_number++;
                    }
                
                }
            
            }
            /**
             * Executes final check on process payment and order creation.
             */
            if ( did_action( 'tc_add_more_final_checks' ) ) {
                
                if ( $reserved_seats || $expired_seats ) {
                    @wp_redirect( $tc->get_cart_slug( true ) );
                    tc_js_redirect( $tc->get_cart_slug( true ) );
                    exit;
                }
            
            }
        }
        
        /**
         * Append Seat Label in Woocommerce Cart Page
         *
         * @param $cart_item
         * @param $cart_item_key
         * @return string
         */
        function woo_cart_list_out_single_tickets( $cart_item, $cart_item_key )
        {
            $seat_label = '';
            $cart_seats = $this->get_cart_seats_cookie();
            $product_type_variable = ( $cart_item['variation_id'] !== 0 ? 'variation_id' : 'product_id' );
            foreach ( array_keys( $cart_seats ) as $key ) {
                if ( $cart_item[$product_type_variable] == $key ) {
                    foreach ( $cart_seats[$cart_item[$product_type_variable]] as $single_cart_seat ) {
                        
                        if ( !empty($single_cart_seat[1]) ) {
                            $seat_label .= '<br /><div class="tc-cart-seat-wrap notranslate">';
                            $seat_label .= '<span class="tc-single-cart-seat">';
                            $seat_label .= '<span class="tc_cart_remove_icon tc_cart_seat_remove" title="' . __( 'Remove from Cart', 'tcsc' ) . '" data-ticket-type-id="' . (int) $cart_item[$product_type_variable] . '" data-seat-sign="' . $single_cart_seat[1] . '" data-seat-id="' . $single_cart_seat[0] . '" data-chart-id="' . (int) $single_cart_seat[2] . '"><i class="fa fa-times" aria-hidden="true"></i></span>';
                            $seat_label .= preg_replace( '/—/i', '-', $single_cart_seat[1] );
                            // Replace long hyphen with regular dash.
                            $seat_label .= "</span></div>";
                        }
                    
                    }
                }
            }
            echo  $seat_label ;
        }
        
        /**
         * Append Seat Label in Cart Page
         *
         * @param $ticket_type
         * @param $tc_show_close
         */
        function list_out_single_tickets( $ticket_type, $tc_show_close )
        {
            global  $tc ;
            $cart_seats = $this->get_cart_seats_cookie();
            $tc_cart_cookie = $tc->get_cart_cookie( true );
            $chart_id = @$cart_seats[$ticket_type->details->ID][0][2];
            echo  '<br /><div class="tc-cart-seat-wrap notranslate">' ;
            foreach ( array_keys( $cart_seats ) as $key ) {
                if ( $ticket_type->id == $key ) {
                    foreach ( $cart_seats[$ticket_type->id] as $single_cart_seat ) {
                        ?>
                        <span class="tc-single-cart-seat">
                        <?php 
                        
                        if ( !empty($single_cart_seat[1]) ) {
                            $seat_label = $single_cart_seat[1];
                            $remove_icon = '<span class="tc_cart_remove_icon tc_cart_seat_remove" title="' . __( 'Remove from Cart', 'tcsc' ) . '" data-ticket-type-id="' . (int) $ticket_type->details->ID . '" data-seat-sign="' . $seat_label . '" data-seat-id="' . $single_cart_seat[0] . '" data-chart-id="' . (int) $single_cart_seat[2] . '"><i class="fa fa-times" aria-hidden="true"></i></span>';
                            if ( isset( $tc_show_close ) && true !== $tc_show_close ) {
                                echo  $remove_icon ;
                            }
                            echo  esc_html( preg_replace( '/—/i', '-', $seat_label ) ) ;
                            // Replace long hyphen with regular dash.
                        }
                        
                        ?>
                        </span>
                    <?php 
                    }
                }
            }
            echo  "</div>" ;
        }
        
        /**
         * Append Seat Label in Woocommerce Order Details Page
         *
         * @param $html
         * @param $item
         * @param $args
         * @return string
         */
        function additional_order_item_seat_label_meta( $html, $item, $args )
        {
            $strings = [];
            foreach ( $item->get_all_formatted_meta_data() as $meta_id => $meta ) {
                $value = ( $args['autop'] ? wp_kses_post( $meta->display_value ) : wp_kses_post( make_clickable( trim( $meta->display_value ) ) ) );
                $strings[] = $args['label_before'] . wp_kses_post( $meta->display_key ) . $args['label_after'] . $value;
            }
            $tickets = get_posts( [
                'post_parent'    => $item->get_order_id(),
                'post_type'      => 'tc_tickets_instances',
                'meta_key'       => 'item_id',
                'meta_value'     => $item->get_id(),
                'fields'         => 'ids',
                'order'          => 'ASC',
                'posts_per_page' => -1,
            ] );
            foreach ( $tickets as $ticket_id ) {
                $seat_label = get_post_meta( $ticket_id, 'seat_label', true );
                
                if ( $seat_label ) {
                    $seat_label = preg_replace( '/—/i', '-', $seat_label );
                    // Replace long hyphen with regular dash.
                    $strings[] = '<p>' . esc_html( $seat_label ) . '</p>';
                }
            
            }
            $html = $args['before'] . implode( $args['separator'], $strings ) . $args['after'];
            return $html;
        }
        
        function delete_chart_html( $post_id = false )
        {
            if ( $post_id && get_post_type( $post_id ) == 'tc_seat_charts' ) {
                try {
                    $upload = wp_upload_dir();
                    $upload_dir = $upload['basedir'];
                    $upload_dir = $upload_dir . '/tc-seating-charts';
                    $filename_front = $post_id . '-front.tcsm';
                    $filename_admin = $post_id . '.tcsm';
                    $path_front = $upload_dir . '/' . $filename_front;
                    $path_admin = $upload_dir . '/' . $filename_admin;
                    if ( file_exists( $path_front ) ) {
                        try {
                            unlink( $path_front );
                        } catch ( Exception $e ) {
                        }
                    }
                    if ( file_exists( $path_admin ) ) {
                        try {
                            unlink( $path_admin );
                        } catch ( Exception $e ) {
                        }
                    }
                } catch ( Exception $e ) {
                }
            }
        }
        
        function maybe_create_html_dir()
        {
            try {
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                
                if ( !is_dir( $upload_dir ) ) {
                    @mkdir( $upload_dir, 0755 );
                    $filename = '.htaccess';
                    $path = $upload_dir . '/' . $filename;
                    
                    if ( !file_exists( $path ) ) {
                        $htaccess = @fopen( $path, "w" );
                        $content = "Deny from all";
                        @fwrite( $htaccess, $content );
                        @fclose( $htaccess );
                        @chmod( $path, 0644 );
                    }
                
                }
            
            } catch ( Exception $e ) {
                // We can't make a directory
            }
        }
        
        function add_body_class( $classes )
        {
            
            if ( get_post_type() == 'tc_seat_charts' && !isset( $_GET['post_type'] ) ) {
                $classes .= ' tc-seat-chart-single ';
                return $classes;
            } else {
                return $classes;
            }
        
        }
        
        function post_updated_messages( $messages )
        {
            global  $post ;
            $class = 'updated notice notice-success is-dismissible tc-tickera-show';
            $permalink = get_permalink( $post->ID );
            $upload = wp_upload_dir();
            $upload_dir = $upload['basedir'];
            $upload_dir = $upload_dir . '/tc-seating-charts';
            $messages['tc_seat_charts'] = array(
                0  => sprintf( __( '<div id="message" class="%1$s tc-donothide"><p>Cannot save! Directory %2$s is not writable.</p></div> ', 'tcsc' ), $class, '<strong>' . $upload_dir . '</strong>' ),
                1  => sprintf( __( '<div id="message" class="%1$s"><p>%2$s</p> </div> ', 'tcsc' ), $class, __( 'Seating Chart updated.', 'tcsc' ) ),
                4  => sprintf( __( '<div id="message" class="%1$s"><p>%2$s</p> </div> ', 'tcsc' ), $class, __( 'Seating Chart updated.', 'tcsc' ) ),
                5  => ( isset( $_GET['revision'] ) ? sprintf( __( '<div id="message" class="%1$s">Seating Chart restored to revision from %s</div>' ), $class, wp_post_revision_title( (int) $_GET['revision'], false ) ) : false ),
                6  => sprintf( __( '<div id="message" class="%1$s"><p>%2$s</p> </div> ', 'tcsc' ), $class, __( 'Seating Chart published.', 'tcsc' ) ),
                7  => sprintf( __( '<div id="message" class="%1$s"><p>%2$s</p> </div> ', 'tcsc' ), $class, __( 'Seating Chart saved.', 'tcsc' ) ),
                8  => sprintf( __( '<div id="message" class="%1$s"><p>Seating Chart submitted. <a target="_blank" href="%s">View Preview</a></p></div>' ), $class, esc_url( add_query_arg( 'preview', 'true', ( isset( $permalink ) ? $permalink : '' ) ) ) ),
                9  => sprintf( __( '<div id="message" class="%1$s">Seating Chart post scheduled for: <strong>%1$s</strong>.</div>' ), $class, date_i18n( __( 'M j, Y @ G:i' ), strtotime( $post->post_date ) ) ),
                10 => sprintf( __( '<div id="message" class="%1$s"><p>%2$s</p> </div> ', 'tcsc' ), $class, __( 'Seating Chart draft updated.', 'tcsc' ) ),
            );
            return $messages;
        }
        
        function seating_charts_admin( $post )
        {
            global  $post_type ;
            
            if ( 'tc_seat_charts' == $post_type ) {
                $this->admin_enqueue_scripts_and_styles();
                include $this->plugin_dir . 'includes/admin-pages/seat_charts_admin.php';
            }
        
        }
        
        /**
         * Set Admin Form Enctype
         */
        function edit_post_enctype()
        {
            $screen = get_current_screen();
            if ( is_admin() && 'tc_seat_charts' == $screen->post_type && 'edit' == $screen->parent_base ) {
                echo  ' enctype="multipart/form-data"' ;
            }
        }
        
        /**
         * Enqueue admin scripts and styles
         *
         * @global type $post
         * @global type $post_type
         */
        function admin_enqueue_scripts_and_styles()
        {
            global  $post, $post_type ;
            
            if ( 'tc_seat_charts' == $post_type ) {
                $tc_seat_charts_settings = TC_Seat_Chart::get_settings();
                wp_enqueue_script(
                    'jquery-pan',
                    plugins_url( 'js/jquery.pan.js', __FILE__ ),
                    array( 'jquery' ),
                    $this->version,
                    true
                );
                wp_enqueue_style( 'tc-seat-charts-assets-admin', plugins_url( 'assets/style-admin.css', __FILE__ ) );
                if ( isset( $post->ID ) ) {
                    wp_enqueue_style( 'tc-seat-charts-assets-admin-single', plugins_url( 'assets/style-admin-single.css', __FILE__ ) );
                }
                wp_enqueue_script(
                    'tc-tinymce',
                    plugins_url( 'assets/js/admin/wordpress-tinymce.js', __FILE__ ),
                    [],
                    $this->version
                );
                wp_enqueue_style( 'tc-seat-charts-jquery-ui', plugins_url( 'assets/js/jquery-ui/jquery-ui.css', __FILE__ ) );
                wp_enqueue_style( 'jquery-ui-rotatable', plugins_url( 'assets/jquery.ui.rotatable.css', __FILE__ ) );
                wp_enqueue_script(
                    'tc-jquery-ui-rotatable',
                    plugins_url( 'assets/js/tc.jquery.ui.rotatable.js', __FILE__ ),
                    [],
                    $this->version
                );
                wp_enqueue_script(
                    'tc-seats-controls-admin',
                    plugins_url( 'assets/js/admin/controls.js', __FILE__ ),
                    array( 'jquery' ),
                    $this->version,
                    true
                );
                wp_localize_script( 'tc-seats-controls-admin', 'tc_controls_vars', array(
                    'ajaxUrl'                => admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ),
                    'are_you_sure'           => __( 'Are you sure?', 'tcsc' ),
                    'label_error_message'    => __( 'Label error message', 'tcsc' ),
                    'yes'                    => __( 'Yes', 'tcsc' ),
                    'ok'                     => __( 'OK', 'tcsc' ),
                    'no'                     => __( 'No', 'tcsc' ),
                    'chart_id'               => ( isset( $_GET['post'] ) ? $_GET['post'] : false ),
                    'tc_reserved_seat_color' => ( isset( $tc_seat_charts_settings['reserved_seat_color'] ) ? $tc_seat_charts_settings['reserved_seat_color'] : '#DCCBCB' ),
                    'tc_blocked_seat_color'  => ( isset( $tc_seat_charts_settings['blocked_seat_color'] ) ? $tc_seat_charts_settings['blocked_seat_color'] : '#AAAAAA' ),
                    'tc_show_as_reserved'    => ( isset( $tc_seat_charts_settings['show_as_reserved'] ) ? $tc_seat_charts_settings['show_as_reserved'] : 'no' ),
                ) );
                wp_enqueue_script(
                    'tc-seats-admin',
                    plugins_url( 'assets/js/admin/seats.js', __FILE__ ),
                    array(
                    'jquery',
                    'tc-seats-controls-admin',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable'
                ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-text-admin',
                    plugins_url( 'assets/js/admin/text.js', __FILE__ ),
                    array(
                    'jquery',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable'
                ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-elements-admin',
                    plugins_url( 'assets/js/admin/elements.js', __FILE__ ),
                    array(
                    'jquery',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable',
                    'jquery-ui-resizable'
                ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-standing-admin',
                    plugins_url( 'assets/js/admin/standing.js', __FILE__ ),
                    array(
                    'jquery',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable',
                    'jquery-ui-resizable'
                ),
                    $this->version,
                    true
                );
                wp_localize_script( 'tc-standing-admin', 'standing_translation', array(
                    'edit'   => __( 'Edit', 'tcsc' ),
                    'Create' => __( 'Create', 'tcsc' ),
                ) );
                wp_enqueue_script(
                    'tc-tables-admin',
                    plugins_url( 'assets/js/admin/tables.js', __FILE__ ),
                    array( 'tc-elements-admin' ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-unslider',
                    plugins_url( 'assets/js/unslider/src/js/unslider.js', __FILE__ ),
                    false,
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-seats-keypress-admin',
                    plugins_url( 'assets/js/admin/keypress-2.1.3.min.js', __FILE__ ),
                    array( 'jquery' ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-settings-admin',
                    plugins_url( 'assets/js/admin/settings.js', __FILE__ ),
                    array(
                    'jquery',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable',
                    'jquery-ui-resizable',
                    'jquery-pan',
                    'tc-seats-admin',
                    'tc-text-admin',
                    'tc-elements-admin',
                    'jquery-ui-tabs',
                    'jquery-ui-dialog'
                ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-seat-labels-admin',
                    plugins_url( 'assets/js/admin/labels.js', __FILE__ ),
                    array( 'tc-settings-admin' ),
                    $this->version,
                    true
                );
                wp_enqueue_script(
                    'tc-seats-common-admin',
                    plugins_url( 'assets/js/admin/common.js', __FILE__ ),
                    array(
                    'jquery',
                    'jquery-ui-selectable',
                    'jquery-ui-draggable',
                    'tc-jquery-ui-rotatable',
                    'jquery-ui-resizable',
                    'jquery-pan',
                    'tc-seats-admin',
                    'tc-text-admin',
                    'tc-elements-admin',
                    'jquery-ui-tabs',
                    'jquery-ui-dialog'
                ),
                    $this->version,
                    true
                );
                wp_enqueue_style( 'tc-unslider', plugins_url( 'assets/js/unslider/src/scss/unslider.css', __FILE__ ) );
                wp_enqueue_script( 'jquery-ui-selectable' );
                wp_enqueue_script(
                    'tc-seats-tooltips-admin',
                    plugins_url( 'assets/js/admin/tooltips.js', __FILE__ ),
                    array( 'tc-seats-common-admin' ),
                    $this->version,
                    true
                );
                wp_localize_script( 'tc-seats-tooltips-admin', 'tc_seatings_tooltips', array(
                    'pan_wrapper'  => __( 'Left click and drag to pan (or use arrow keys). Use mouse wheel to zoom', 'tcsc' ),
                    'draggable'    => __( 'Click and drag to move', 'tcsc' ),
                    'rotate'       => __( 'Click and drag to rotate. Hold SHIFT key to rotate it in precise steps.', 'tcsc' ),
                    'delete'       => __( 'Click to remove the object permanently', 'tcsc' ),
                    'copy'         => __( 'Click to copy the object', 'tcsc' ),
                    'edit'         => __( 'Click to edit the object', 'tcsc' ),
                    'resizable'    => __( 'Click and drag to resize. Hold SHIFT key to resize the object proportionally.', 'tcsc' ),
                    'drag_slider'  => __( 'Drag to change the value', 'tcsc' ),
                    'click_option' => __( 'Click to change the value', 'tcsc' ),
                    'selectable'   => __( 'Click to select / deselect seats. Use CTRL / CMD keys or mouse lasso to mark multiple desired seats at once.', 'tcsc' ),
                    'save'         => __( 'Click to save changes', 'tcsc' ),
                ) );
            }
            
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_script(
                'tc-ticket-type-color-picker-admin',
                plugins_url( 'js/ticket-type-color-picker.js', __FILE__ ),
                array( 'jquery', 'wp-color-picker' ),
                $this->version,
                true
            );
            wp_enqueue_script(
                $this->name . '-admin',
                plugins_url( 'assets/js/admin/admin.js', __FILE__ ),
                '',
                $this->version,
                true
            );
        }
        
        function admin_footer_styles()
        {
            ?>
            <style type="text/css" id="tc_seating_chart_footer_style">
                /* Some style here */
            </style>
        <?php 
        }
        
        /**
         * Load Localisation files (first translation file found will be loaded, others will be ignored)
         */
        public function load_plugin_textdomain()
        {
            $locale = apply_filters( 'plugin_locale', get_locale(), 'tcsc' );
            load_textdomain( 'tcsc', WP_LANG_DIR . '/' . $locale . '.mo' );
            load_textdomain( 'tcsc', WP_LANG_DIR . '/tc-seat-charts/' . $locale . '.mo' );
            load_plugin_textdomain( 'tcsc', false, plugin_basename( dirname( __FILE__ ) ) . "/languages" );
        }
        
        function duplicate_seating_chart_row_action( $actions, $post )
        {
            
            if ( current_user_can( 'edit_posts' ) && $post->post_type == 'tc_seat_charts' ) {
                unset( $actions['inline hide-if-no-js'] );
                $duplicate_url = add_query_arg( array(
                    'post_type' => 'tc_seat_charts',
                    'action'    => 'tc_duplicate_seating_chart',
                    'post'      => $post->ID,
                ), admin_url( 'edit.php' ) );
                $actions['duplicate'] = '<a href="' . $duplicate_url . '" title="' . esc_attr( __( 'Duplicate this Seating Chart', 'tcsc' ) ) . '" rel="permalink">' . __( 'Duplicate', 'tcsc' ) . '</a>';
            }
            
            return $actions;
        }
        
        function maybe_save_duplicated_chart_values()
        {
            if ( isset( $_GET['state'] ) && $_GET['state'] == 'tcclnd' ) {
                ?>
                <script type="text/javascript">
                    jQuery(document).ready(function ($) {
                    });
                </script>
                <?php 
            }
        }
        
        public static function maybe_duplicate_chart()
        {
            global  $post ;
            
            if ( isset( $_GET['state'] ) && $_GET['state'] == 'duplicated' && isset( $_GET['from_post'] ) ) {
                $from_post_id = $_GET['from_post'];
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                // ADMIN file initial
                $filename = $from_post_id . '.tcsm';
                $path_admin = $upload_dir . '/' . $filename;
                // ADMIN: Current file contents
                $handle = fopen( $path_admin, "r" );
                $file_content = fread( $handle, filesize( $path_admin ) );
                // ADMIN file NEW
                $filename = $post->ID . '.tcsm';
                $path_admin_new = $upload_dir . '/' . $filename;
                $file_admin_new = @fopen( $path_admin_new, "w" );
                @fwrite( $file_admin_new, $file_content );
                @fclose( $file_admin_new );
                @chmod( $path_admin_new, 0644 );
                // FRONT file initial
                $filename = $from_post_id . '-front.tcsm';
                $path_front = $upload_dir . '/' . $filename;
                // FRONT: Current file contents
                $handle = fopen( $path_front, "r" );
                $file_content = fread( $handle, filesize( $path_front ) );
                // FRONT file NEW
                $filename = $post->ID . '-front.tcsm';
                $path_front_new = $upload_dir . '/' . $filename;
                $file_front_new = @fopen( $path_front_new, "w" );
                @fwrite( $file_front_new, $file_content );
                @fclose( $file_front_new );
                @chmod( $path_front_new, 0644 );
                wp_redirect( admin_url( 'post.php?post=' . $post->ID . '&action=edit&state=tcclnd' ) );
                tc_js_redirect( admin_url( 'post.php?post=' . $post->ID . '&action=edit&state=tcclnd' ) );
                exit;
            }
        
        }
        
        function duplicate_seating_chart_action( $post_id = false )
        {
            global  $wpdb ;
            $duplicate_title_extension = apply_filters( 'tc_seating_charts_duplicate_title_extension', __( ' [duplicate]', 'tcsc' ) );
            if ( $post_id !== false ) {
                if ( !(isset( $_GET['post'] ) || isset( $_POST['post'] ) || isset( $_REQUEST['action'] ) && 'tc_duplicate_seating_chart' == $_REQUEST['action']) ) {
                    wp_die( __( 'No seating chart to duplicate has been supplied!', 'tcsc' ) );
                }
            }
            /*
             * get the original post id
             */
            $post_id = ( $post_id ? $post_id : (( isset( $_GET['post'] ) ? absint( $_GET['post'] ) : absint( $_POST['post'] ) )) );
            /*
             * and all the original post data then
             */
            $post = get_post( $post_id );
            /*
             * if you don't want current user to be the new post author,
             * then change next couple of lines to this: $new_post_author = $post->post_author;
             */
            $current_user = wp_get_current_user();
            $new_post_author = $current_user->ID;
            /*
             * if post data exists, create the post duplicate
             */
            
            if ( isset( $post ) && $post != null ) {
                /*
                 * new post data array
                 */
                $new_post_author = wp_get_current_user();
                $new_post_date = current_time( 'mysql' );
                $new_post_date_gmt = get_gmt_from_date( $new_post_date );
                $args = apply_filters( 'tc_duplicate_seating_chart_args', array(
                    'post_author'           => $new_post_author->ID,
                    'post_date'             => $new_post_date,
                    'post_date_gmt'         => $new_post_date_gmt,
                    'post_content'          => $post->post_content,
                    'post_content_filtered' => $post->post_content_filtered,
                    'post_title'            => $post->post_title . $duplicate_title_extension,
                    'post_excerpt'          => $post->post_excerpt,
                    'post_status'           => 'draft',
                    'post_type'             => $post->post_type,
                    'comment_status'        => $post->comment_status,
                    'ping_status'           => $post->ping_status,
                    'post_password'         => $post->post_password,
                    'to_ping'               => $post->to_ping,
                    'pinged'                => $post->pinged,
                    'post_modified'         => $new_post_date,
                    'post_modified_gmt'     => $new_post_date_gmt,
                    'menu_order'            => $post->menu_order,
                    'post_mime_type'        => $post->post_mime_type,
                ), $post_id );
                /*
                 * insert the post by wp_insert_post() function
                 */
                $new_post_id = wp_insert_post( $args );
                /*
                 * get all current post terms ad set them to the new post draft
                 */
                $taxonomies = get_object_taxonomies( $post->post_type );
                // returns array of taxonomy names for post type, ex array("category", "post_tag");
                foreach ( $taxonomies as $taxonomy ) {
                    $post_terms = wp_get_object_terms( $post_id, $taxonomy, array(
                        'fields' => 'slugs',
                    ) );
                    wp_set_object_terms(
                        $new_post_id,
                        $post_terms,
                        $taxonomy,
                        false
                    );
                }
                /*
                 * Duplicate all post meta
                 */
                $post_meta_infos = $wpdb->get_results( "SELECT meta_key, meta_value FROM {$wpdb->postmeta} WHERE post_id={$post_id}" );
                
                if ( count( $post_meta_infos ) != 0 ) {
                    $sql_query = "INSERT INTO {$wpdb->postmeta} (post_id, meta_key, meta_value) ";
                    foreach ( $post_meta_infos as $meta_info ) {
                        $meta_key = $meta_info->meta_key;
                        $meta_value = addslashes( $meta_info->meta_value );
                        $sql_query_sel[] = "SELECT {$new_post_id}, '{$meta_key}', '{$meta_value}'";
                    }
                    $sql_query .= implode( " UNION ALL ", $sql_query_sel );
                    $wpdb->query( $sql_query );
                }
                
                do_action( 'tc_after_seat_chart_duplication', $new_post_id, $post_id );
                /*
                 * finally, redirect to the edit post screen for the new draft
                 */
                $new_post_url = add_query_arg( array(
                    'post'      => $new_post_id,
                    'action'    => 'edit',
                    'post'      => $new_post_id,
                    'state'     => 'duplicated',
                    'from_post' => $post_id,
                ), admin_url( 'post.php' ) );
                wp_redirect( $new_post_url );
                exit;
            } else {
                wp_die( 'Post creation failed, could not find original post: ' . $post_id );
            }
        
        }
        
        /**
         * Delete seat in-cart cookie after order completion
         *
         * @global type $tc
         */
        function delete_order_cookie()
        {
            global  $tc ;
            $tc->remove_order_session_data( apply_filters( 'tc_seating_charts_remove_order_session_data_js_fallback', false ), false );
        }
        
        /**
         * Adds Type select box on the product edit screen
         */
        function woo_ticket_type_additional_meta()
        {
            ?>
            <div class="hide_if_grouped hide_if_external">
                <?php 
            woocommerce_wp_text_input( array(
                'id'          => '_seat_color',
                'label'       => __( 'Seat Color', 'tcsc' ),
                'desc_tip'    => 'true',
                'description' => __( 'Color which will be visible on a seating chart(s)', 'tcsc' ),
                'class'       => 'tc-color-picker',
            ) );
            ?>
            </div>
            <?php 
        }
        
        /**
         * Saves type of ticket for Woo products
         *
         * @param type $post_id
         */
        function woo_ticket_type_additional_meta_save( $post_id )
        {
            $post_id = (int) $post_id;
            // Check if product is a ticket
            $_tc_is_ticket = ( isset( $_POST['_tc_is_ticket'] ) ? 'yes' : 'no' );
            
            if ( 'yes' == $_tc_is_ticket ) {
                $valid_product_type = [ 'simple', 'variable', 'woosb' ];
                
                if ( in_array( $_POST['product-type'], $valid_product_type ) ) {
                    update_post_meta( $post_id, '_seat_color', $_POST['_seat_color'] );
                    update_post_meta( $post_id, '_tc_used_for_seatings', ( isset( $_POST['_tc_used_for_seatings'] ) ? 'yes' : 'no' ) );
                } else {
                    delete_post_meta( $post_id, '_seat_color' );
                    delete_post_meta( $post_id, '_tc_used_for_seatings' );
                }
            
            } else {
                delete_post_meta( $post_id, '_seat_color' );
            }
        
        }
        
        /**
         * Disable quantity change for products (and variations) in the cart if the product is a seat
         *
         * @param type $args
         * @param type $product
         * @return type
         */
        function tc_seat_chart_maybe_modify_woocommerce_quantity_input_args( $args, $product )
        {
            
            if ( is_cart() ) {
                $cart_seats = $this->get_cart_seats_cookie();
                $product_id = $product->get_ID();
                
                if ( $cart_seats && isset( $cart_seats[$product_id] ) ) {
                    $is_standee = false;
                    foreach ( $cart_seats[$product_id] as $seat ) {
                        
                        if ( '' === $seat[1] ) {
                            $is_standee = true;
                            break;
                        }
                    
                    }
                    $args['max_value'] = $args['input_value'];
                    $args['min_value'] = $args['input_value'];
                    
                    if ( $is_standee ) {
                        echo  '<div class="tc-quantity-label"><span>' . (int) $args['input_value'] . '</span></div>' ;
                    } else {
                        echo  '<div class="tc-quantity-label"></div>' ;
                    }
                
                }
            
            }
            
            return $args;
        }
        
        /**
         * Prepare and render quantity selector in Standee element in Frontend.
         * Tickera Standalone
         */
        function tc_seat_chart_get_standing_area_options()
        {
            
            if ( isset( $_POST['seat_ticket_type_id'] ) ) {
                $ticket_type_id = (int) $_POST['seat_ticket_type_id'];
                $chart_id = (int) $_POST['chart_id'];
                $seat_id = sanitize_key( $_POST['seat_id'] );
                $selected_quantity = 0;
                $cart_seats = $this->get_cart_seats_cookie();
                if ( $cart_seats && isset( $cart_seats[$ticket_type_id] ) ) {
                    foreach ( $cart_seats[$ticket_type_id] as $seat ) {
                        
                        if ( $chart_id == $seat[2] && '' === $seat[1] && $seat_id == $seat[0] ) {
                            $selected_quantity = $seat[3];
                            break;
                        }
                    
                    }
                }
                $html = tc_quantity_selector( $ticket_type_id, true, $selected_quantity );
                if ( $selected_quantity ) {
                    $html .= '<a href="#" id="tc-remove-from-cart"><small>' . __( 'Remove from cart', 'tcsc' ) . '</small></a>';
                }
                $response = [
                    'html'   => $html,
                    'update' => ( $selected_quantity ? true : false ),
                ];
                wp_send_json( $response );
            }
        
        }
        
        /**
         * Prepare and render quantity selector in Standee element in Frontend.
         * Bridge for Woocommerce
         */
        function tc_seat_chart_get_wc_standing_area_options()
        {
            
            if ( isset( $_POST['seat_ticket_type_id'] ) ) {
                $ticket_type_id = (int) $_POST['seat_ticket_type_id'];
                $chart_id = (int) $_POST['chart_id'];
                $seat_id = sanitize_key( $_POST['seat_id'] );
                $product = wc_get_product( $ticket_type_id );
                $selected_quantity = 0;
                $cart_seats = $this->get_cart_seats_cookie();
                if ( $cart_seats && isset( $cart_seats[$ticket_type_id] ) ) {
                    foreach ( $cart_seats[$ticket_type_id] as $seat ) {
                        
                        if ( $chart_id == $seat[2] && '' === $seat[1] && $seat_id == $seat[0] ) {
                            $selected_quantity = $seat[3];
                            break;
                        }
                    
                    }
                }
                $html = woocommerce_quantity_input( [
                    'input_value' => ( $selected_quantity ? $selected_quantity : 1 ),
                    'max_value'   => ( $product->backorders_allowed() ? '' : $product->get_stock_quantity() ),
                    'min_value'   => 1,
                ], $product, false );
                if ( $selected_quantity ) {
                    $html .= '<a href="#" id="tc-remove-from-cart"><small>' . __( 'Remove from cart', 'tcsc' ) . '</small></a>';
                }
                $response = [
                    'html'   => $html,
                    'update' => ( $selected_quantity ? true : false ),
                ];
                wp_send_json( $response );
            }
        
        }
        
        /**
         * Render variations form into seat maps modal
         * Called from ajax action tc_seat_chart_get_wc_variations
         */
        function tc_seat_chart_get_wc_variations()
        {
            
            if ( isset( $_POST['seat_ticket_type_id'] ) ) {
                $product_id = (int) $_POST['seat_ticket_type_id'];
                $chart_id = (int) $_POST['chart_id'];
                $seat_id = sanitize_key( $_POST['seat_id'] );
                $is_standee = (int) $_POST['is_standee'];
                $selected_seat = [
                    'chart_id' => $chart_id,
                    'seat_id'  => $seat_id,
                ];
                $html = $this->wc_get_product_variations_form( $product_id, $selected_seat, $is_standee );
                $response = [
                    'html' => $html,
                ];
                wp_send_json( $response );
            }
        
        }
        
        /**
         * Variations data shown in the seat map popup when varible product is selected
         *
         * @param type $id
         * @param bool $render_selected_values
         * @param bool $is_standee
         * @return type
         * @global type $product
         */
        function wc_get_product_variations_form( $id, $render_selected_values = false, $is_standee = false )
        {
            global  $product ;
            ob_start();
            $product = wc_get_product( (int) $id );
            $get_variations = sizeof( $product->get_children() ) <= apply_filters( 'woocommerce_ajax_variation_threshold', 30, $product );
            $available_variations = ( $get_variations ? $product->get_available_variations() : false );
            $attributes = $product->get_variation_attributes();
            $attribute_keys = array_keys( $attributes );
            ?>
            <form class="variations_form cart<?php 
            echo  ( $is_standee ? esc_attr( ' standee' ) : '' ) ;
            ?>" method="post" enctype='multipart/form-data' data-product_id="<?php 
            echo  absint( $product->get_id() ) ;
            ?>" data-product_variations="<?php 
            echo  htmlspecialchars( json_encode( $available_variations ) ) ;
            ?>">
                <?php 
            
            if ( empty($available_variations) && false !== $available_variations ) {
                ?>
                    <p class="stock out-of-stock"><?php 
                _e( 'This product is currently out of stock and unavailable.', 'tcsc' );
                ?></p>
                <?php 
            } else {
                $passed_validation = self::tc_validate_woo_seat_availability( true, $id )['tc_validation_passed'];
                
                if ( $passed_validation ) {
                    ?>
                        <table class="variations" cellspacing="0">
                            <tbody>
                            <?php 
                    foreach ( $attributes as $attribute_name => $options ) {
                        ?>
                                <tr>
                                    <td class="label"><label for="<?php 
                        echo  sanitize_title( $attribute_name ) ;
                        ?>"><?php 
                        echo  wc_attribute_label( $attribute_name ) ;
                        ?></label></td>
                                    <td class="value">
                                        <?php 
                        $selected = ( isset( $_REQUEST['attribute_' . sanitize_title( $attribute_name )] ) ? wc_clean( urldecode( $_REQUEST['attribute_' . sanitize_title( $attribute_name )] ) ) : $product->get_variation_default_attribute( $attribute_name ) );
                        wc_dropdown_variation_attribute_options( array(
                            'options'   => $options,
                            'attribute' => $attribute_name,
                            'product'   => $product,
                            'selected'  => $selected,
                        ) );
                        echo  ( end( $attribute_keys ) === $attribute_name ? apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . __( 'Clear', 'tcsc' ) . '</a>' ) : '' ) ;
                        ?>
                                    </td>
                                </tr>
                            <?php 
                    }
                    ?>
                            </tbody>
                        </table>
                        <div id="tc-selected-variations">
                            <ul>
                            <?php 
                    /**
                     * Render selected attributes on seating chart modal.
                     * Standee Elements with Variable Seat
                     * @since 0.76
                     */
                    
                    if ( $render_selected_values ) {
                        $chart_id = $render_selected_values['chart_id'];
                        $seat_id = $render_selected_values['seat_id'];
                        // Get current selected seat quantity
                        $cart_seats = $this->get_cart_seats_cookie();
                        if ( $cart_seats ) {
                            foreach ( $cart_seats as $variation_id => $cart_seat ) {
                                // Expecting a variation ID here
                                foreach ( $cart_seat as $seat ) {
                                    
                                    if ( $chart_id == $seat[2] && '' === $seat[1] && $seat_id == $seat[0] ) {
                                        $selected_quantity = $seat[3];
                                        
                                        if ( 'variation' == tc_wb_get_product_type( $variation_id ) ) {
                                            // If variaton_id is the parent_id it returns "variable". Otherwise, "variation"
                                            $variation = wc_get_product( $variation_id );
                                            $attributes = $variation->get_variation_attributes( false );
                                            echo  '<li data-variation-id="' . (int) $variation_id . '"><div>' ;
                                            foreach ( $attributes as $attribute_key => $attribute_name ) {
                                                echo  '<small data-attribute-key="' . $attribute_key . '" data-attribute-name="' . $attribute_name . '"><b>' . ucfirst( $attribute_key ) . '</b>: ' . esc_html( $attribute_name ) . '</small>' ;
                                            }
                                            echo  '<small><b>' . __( 'Quantity', 'tcsc' ) . '</b>: ' . (int) $selected_quantity . '</small>' ;
                                            echo  '</div><a href="#" data-variation-id="' . (int) $variation_id . '" id="tc-remove-variation-from-cart"><small>' . __( 'Remove from cart', 'tcsc' ) . '</small></a>' ;
                                            echo  '</li>' ;
                                        }
                                    
                                    }
                                
                                }
                            }
                        }
                    }
                    
                    ?>
                            </ul>
                        </div>
                        <div class="single_variation_wrap">
                            <?php 
                    /**
                     * woocommerce_before_single_variation Hook.
                     */
                    do_action( 'woocommerce_before_single_variation' );
                    /**
                     * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
                     * @since 2.4.0
                     * @hooked woocommerce_single_variation - 10 Empty div for variation data.
                     * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
                     */
                    do_action( 'woocommerce_single_variation' );
                    /**
                     * woocommerce_after_single_variation Hook.
                     */
                    do_action( 'woocommerce_after_single_variation' );
                    ?>
                        </div>

                    <?php 
                } else {
                    ?>
                        <button type="button" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only tc_cart_button tc-seat-error" role="button" disabled><?php 
                    _e( 'Seat is currently not available', 'tcsc' );
                    ?></button>
                    <?php 
                }
                
                ?>
                <?php 
            }
            
            ?>
            </form>

            <?php 
            return ob_get_clean();
        }
        
        /**
         * Checks if a chart has orders (so we can disable chart editing etc)
         *
         * @param type $chart_id
         * @return boolean
         */
        public static function is_chart_has_orders( $chart_id )
        {
            $chart_ticket_instances_args = array(
                'posts_per_page' => 1,
                'post_status'    => 'publish',
                'post_type'      => 'tc_tickets_instances',
                'meta_key'       => 'chart_id',
                'meta_value'     => $chart_id,
                'no_found_rows'  => true,
            );
            $chart_ticket_instances = get_posts( $chart_ticket_instances_args );
            return ( count( $chart_ticket_instances ) > 0 ? true : false );
        }
        
        /**
         * Update Tickera's shortcode builder list
         *
         * @param array $shortcodes
         * @return array
         */
        function tc_modify_shortcode_builder_list( $shortcodes )
        {
            $shortcodes['tc_seat_chart'] = __( 'Seating Chart', 'tcsc' );
            return $shortcodes;
        }
        
        /**
         * Update Tickera's gutenberg blocks list
         *
         * @param $blocks
         * @return mixed
         *
         * @since 0.78
         */
        function modify_gutenberg_blocks_list( $blocks )
        {
            $blocks['tc_seat_chart'] = 'tickera/seating-charts';
            return $blocks;
        }
        
        /**
         * Tickera Standalone - Identify expired seats.
         * Compare:
         * - Cart Seats Cookie
         * - Cart Contents
         *
         * If cart content value is not identical to the seats cookie,
         * it indicates a cart item has expired and needs to be reprocessed.
         *
         * @since 0.75
         * @return array
         */
        function get_cart_expired_seats()
        {
            global  $tc ;
            $cart_content = $tc->get_cart_cookie();
            /*
             * Restructure Seat Cookie array.
             * Array | [ [ ticket_type_id => quantity ] ]
             * To be used in a comparison in the later process.
             */
            $in_cart_seats = [];
            foreach ( $this->get_cart_seats_cookie() as $ticket_type_id => $seats ) {
                $seats_count = 0;
                foreach ( $seats as $seat ) {
                    $quantity = ( isset( $seat[3] ) ? (int) $seat[3] : 0 );
                    $seats_count += $quantity;
                }
                $in_cart_seats[$ticket_type_id] = $seats_count;
            }
            $is_bridge_active = apply_filters( 'tc_bridge_for_woocommerce_is_active', false );
            
            if ( !$is_bridge_active ) {
                $expired_seats = [];
                foreach ( $cart_content as $ticket_type_id => $quantity ) {
                    $ticket_type = new TC_Ticket( $ticket_type_id );
                    $is_seating = $ticket_type->details->_tc_used_for_seatings;
                    $is_seating = ( 'yes' == $is_seating ? true : false );
                    if ( $is_seating ) {
                        
                        if ( isset( $in_cart_seats[$ticket_type_id] ) && $in_cart_seats[$ticket_type_id] == $quantity ) {
                            // Continue without error
                        } else {
                            // No associated seat cookie for this item. Return cart error notice
                            $expired_seats[] = get_the_title( $ticket_type_id );
                        }
                    
                    }
                }
                return $expired_seats;
            } else {
                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $prod_id = $cart_item['product_id'];
                    $is_seating = get_post_meta( $prod_id, '_tc_used_for_seatings', true );
                    $is_seating = ( 'yes' == $is_seating ? true : false );
                    $prod_id = ( $cart_item['variation_id'] > 0 ? $cart_item['variation_id'] : $cart_item['product_id'] );
                    $quantity = (int) $cart_item['quantity'] ?? 1;
                    $quantity = ( $quantity ? $quantity : 1 );
                    if ( $is_seating ) {
                        
                        if ( isset( $in_cart_seats[$prod_id] ) && $in_cart_seats[$prod_id] == $quantity ) {
                            // Continue without error
                        } else {
                            // No associated seat cookie for this item. Return cart error notice
                            $notice = ( is_cart() ? wc_add_notice( sprintf( __( '%s expired. Please remove from the cart and try to add them via a Seating Map once again.', 'tcsc' ), get_the_title( $prod_id ) ), 'error' ) : wc_add_notice( sprintf(
                                __( '%s expired. Please remove from the %scart%s and try to add them via a Seating Map once again.', 'tcsc' ),
                                get_the_title( $prod_id ),
                                '<a href="' . wc_get_cart_url() . '">',
                                '</a>'
                            ), 'error' ) );
                        }
                    
                    }
                }
            }
        
        }
        
        /**
         * Get reserved seats based on cart contents
         *
         * @param bool $excluded_order_id
         * @return array
         */
        function get_cart_reserved_seats( $excluded_order_id = false )
        {
            $excluded_order_id = ( $excluded_order_id ? [ $excluded_order_id ] : [] );
            $reserved_order_statuses = $this->get_reserved_order_statuses();
            $in_cart_seats = $this->get_cart_seats_cookie();
            
            if ( self::woo_bridge_dependencies_check() ) {
                $order_id = absint( WC()->session->get( 'order_awaiting_payment' ) );
                if ( $order_id ) {
                    $excluded_order_id[] = $order_id;
                }
            } else {
                global  $tc ;
                if ( !session_id() || !isset( $_SESSION ) ) {
                    @session_start();
                }
                $order_title = $tc->generate_order_id();
                $order_id = tc_get_order_id_by_name( $order_title );
                if ( $order_id ) {
                    $excluded_order_id[] = $order_id;
                }
            }
            
            $reserved_seats = [];
            foreach ( $in_cart_seats as $seat_ticket_type_id => $ticket_type_seats_in_carts ) {
                foreach ( $ticket_type_seats_in_carts as $ticket_type_seats_in_cart ) {
                    $seat_id = $ticket_type_seats_in_cart[0];
                    $chart_id = (int) $ticket_type_seats_in_cart[2];
                    $meta_query = [
                        'relation' => 'AND',
                    ];
                    $meta_query[] = [
                        'key'   => 'seat_id',
                        'value' => $seat_id,
                    ];
                    $meta_query[] = [
                        'key'   => 'chart_id',
                        'value' => $chart_id,
                    ];
                    
                    if ( $excluded_order_id ) {
                        $maybe_reserved_seat_args = [
                            'posts_per_page'      => 1,
                            'post_status'         => 'publish',
                            'post_type'           => 'tc_tickets_instances',
                            'meta_query'          => $meta_query,
                            'no_found_rows'       => true,
                            'post_parent__not_in' => $excluded_order_id,
                        ];
                    } else {
                        $maybe_reserved_seat_args = [
                            'posts_per_page' => 1,
                            'post_status'    => 'publish',
                            'post_type'      => 'tc_tickets_instances',
                            'meta_query'     => $meta_query,
                            'no_found_rows'  => true,
                        ];
                    }
                    
                    $maybe_reserved_seats = get_posts( $maybe_reserved_seat_args );
                    foreach ( $maybe_reserved_seats as $maybe_reserved_seat ) {
                        $order_id = $maybe_reserved_seat->post_parent;
                        $order_status = get_post_status( $order_id );
                        
                        if ( in_array( $order_status, $reserved_order_statuses ) ) {
                            $reserved_seat_sign = TC_Seat_Chart::get_ticket_instance_seat_sign( $maybe_reserved_seat->ID );
                            if ( !empty($reserved_seat_sign) && $reserved_seat_sign !== '' ) {
                                $reserved_seats[] = $reserved_seat_sign;
                            }
                        }
                    
                    }
                }
            }
            return $reserved_seats;
        }
        
        /**
         * Insert seating chart html identifier for single variation page.
         * This identifier is being used in css to hide variation form.
         */
        function woo_before_add_to_cart_form()
        {
            global  $product ;
            
            if ( is_product() && method_exists( $product, 'get_id' ) ) {
                $product_id = ( 'variation' == $product->get_type() ? $product->get_parent_id() : $product->get_id() );
                $_tc_used_for_seatings = get_post_meta( $product_id, '_tc_used_for_seatings', true );
                if ( 'yes' == $_tc_used_for_seatings ) {
                    echo  '<div id="tc_before_variation_form"></div>' ;
                }
            }
        
        }
        
        /**
         * Remove add to cart from a single product page if the product is used for seatings
         *
         * @param boolean $is_purchasable
         * @param type $product
         * @return boolean
         */
        function woo_is_purchasable_from_product_page( $is_purchasable, $product )
        {
            
            if ( is_product() ) {
                $product_type = $product->get_type();
                $product_id = ( 'variation' == $product_type ? $product->get_parent_id() : $product->get_id() );
                $_tc_used_for_seatings = get_post_meta( $product_id, '_tc_used_for_seatings', true );
                
                if ( 'yes' == $_tc_used_for_seatings ) {
                    $is_purchasable = false;
                    if ( 'variation' == $product_type ) {
                        remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
                    }
                }
            
            }
            
            return $is_purchasable;
        }
        
        /**
         * Bridge for Woocommerce - Validate expired and reserved seats in checkout page.
         * Checks if a seat is available upon placing an order
         *
         * @param $data
         * @param $errors
         * @since 0.75
         */
        function woo_after_checkout_validation( $data, $errors )
        {
            $order_id = absint( WC()->session->get( 'order_awaiting_payment' ) );
            $cart_hash = md5( json_encode( wc_clean( WC()->cart->get_cart_for_session() ) ) . WC()->cart->total );
            $reserved_seats = ( $order_id && ($order = wc_get_order( $order_id )) && $order->has_cart_hash( $cart_hash ) && $order->has_status( array( 'pending', 'failed' ) ) ? self::get_cart_reserved_seats( $order_id ) : self::get_cart_reserved_seats() );
            wc_clear_notices();
            if ( $reserved_seats ) {
                
                if ( 1 == count( $reserved_seats ) ) {
                    $errors->add( 'seating-chart', sprintf(
                        __( 'Seat %s is already booked. Please remove it from the %scart%s', 'tcsc' ),
                        '<strong>' . $reserved_seats[0] . '</strong>',
                        '<a href="' . wc_get_cart_url() . '">',
                        '</a>'
                    ) );
                } else {
                    $errors->add( 'seating-chart', sprintf(
                        __( 'Seats %s are already booked. Please remove them from the %scart%s', 'tcsc' ),
                        '<strong>' . implode( ',', $reserved_seats ) . '</strong>',
                        '<a href="' . wc_get_cart_url() . '">',
                        '</a>'
                    ) );
                }
            
            }
            self::get_cart_expired_seats();
        }
        
        /**
         * Bridge for Woocommerce - Validate expired and reserved seats in cart page.
         * @since 0.75
         */
        function woo_validate_cart_seats()
        {
            $error = false;
            $order_id = absint( WC()->session->get( 'order_awaiting_payment' ) );
            $cart_hash = md5( json_encode( wc_clean( WC()->cart->get_cart_for_session() ) ) . WC()->cart->total );
            $reserved_seats = ( $order_id && ($order = wc_get_order( $order_id )) && $order->has_cart_hash( $cart_hash ) && $order->has_status( array( 'pending', 'failed' ) ) ? self::get_cart_reserved_seats( $order_id ) : self::get_cart_reserved_seats() );
            /**
             * Validate seats in cart and checkout pages.
             * Make sure a seat has an active cookie.
             * If session expires, require the customer to reprocess from cart page.
             */
            if ( !WC()->cart->is_empty() ) {
                
                if ( is_cart() ) {
                    
                    if ( $reserved_seats ) {
                        $notice = ( 1 == count( $reserved_seats ) ? wc_add_notice( sprintf( __( 'Seat %s is already booked. Please remove it from the cart', 'tcsc' ), '<strong>' . $reserved_seats[0] . '</strong>' ), 'error' ) : wc_add_notice( sprintf( __( 'Seats %s are already booked. Please remove them from the cart', 'tcsc' ), '<strong>' . implode( ',', $reserved_seats ) . '</strong>' ), 'error' ) );
                        $error = true;
                    }
                    
                    self::get_cart_expired_seats();
                } elseif ( is_checkout() ) {
                    
                    if ( $reserved_seats ) {
                        $notice = ( 1 == count( $reserved_seats ) ? wc_add_notice( sprintf(
                            __( 'Seat %s is already booked. Please remove it from the %scart%s', 'tcsc' ),
                            '<strong>' . $reserved_seats[0] . '</strong>',
                            '<a href="' . wc_get_cart_url() . '">',
                            '</a>'
                        ), 'error' ) : wc_add_notice( sprintf(
                            __( 'Seats %s are already booked. Please remove them from the %scart%s', 'tcsc' ),
                            '<strong>' . implode( ',', $reserved_seats ) . '</strong>',
                            '<a href="' . wc_get_cart_url() . '">',
                            '</a>'
                        ), 'error' ) );
                        $error = true;
                    }
                    
                    self::get_cart_expired_seats();
                }
            
            }
            
            if ( $error ) {
                remove_action( 'woocommerce_proceed_to_checkout', 'wc_get_pay_buttons', 20 );
                remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20 );
            }
        
        }
        
        /**
         * Gets add-on settings
         *
         * @return type
         */
        public static function get_settings()
        {
            return get_option( 'tc_seat_charts_settings' );
        }
        
        /**
         * Adds new admin menu item for the add-on
         *
         * @param array $menus
         * @return array
         */
        function tc_settings_new_menus( $menus )
        {
            $menus['seat_charts'] = __( 'Seating Charts', 'cp' );
            return $menus;
        }
        
        /**
         * Loads admin settings page for the add-on
         */
        function tc_settings_menu_seat_charts()
        {
            include $this->plugin_dir . 'includes/admin-pages/seat_charts_settings.php';
        }
        
        /**
         * Adds admin notices if needed (for admins only if the add-on is not compatible with the parent plugin)
         *
         * @global type $tc
         */
        function admin_notices()
        {
            global  $tc ;
            if ( current_user_can( 'manage_options' ) ) {
                
                if ( isset( $tc->version ) && version_compare( $tc->version, $this->tc_version_required, '<' ) ) {
                    ?>
                    <div class="notice notice-error">
                        <p><?php 
                    printf(
                        __( '%s add-on requires at least %s version of %s plugin. Your current version of %s is %s. Please update it.', 'tcsc' ),
                        $this->title,
                        $this->tc_version_required,
                        $tc->title,
                        $tc->title,
                        $tc->version
                    );
                    ?></p>
                    </div>
                    <?php 
                }
            
            }
        }
        
        /**
         * Adds tc_seat_chart shortcode to the content on the single page of the tc_seat_charts post type (so we can preview a seat map)
         *
         * @global type $post
         * @global type $post_type
         * @param type $content
         * @return type
         */
        function modify_the_content( $content )
        {
            global  $post, $post_type ;
            if ( !is_admin() && isset( $post_type ) && $post_type == 'tc_seat_charts' ) {
                $content .= do_shortcode( '[tc_seat_chart id="' . (int) $post->ID . '" show_legend="true"]' );
            }
            return $content;
        }
        
        /**
         * Hides unneeded actions from the admin
         *
         * @param type $actions
         * @param type $post
         * @return type
         */
        function post_row_actions( $actions, $post )
        {
            if ( $post->post_type == 'tc_seat_charts' ) {
                unset( $actions['inline hide-if-no-js'] );
            }
            return $actions;
        }
        
        /**
         * Remove order session data (after completed payment for instance)
         */
        function ajax_remove_order_session_data()
        {
            ob_start();
            $cookie_id = 'tc_cart_seats_' . COOKIEHASH;
            @setcookie(
                $cookie_id,
                null,
                time() - 1,
                COOKIEPATH,
                COOKIE_DOMAIN
            );
            self::set_cart_seats_persistent( null );
            ob_end_flush();
            exit;
        }
        
        /**
         * Disable quantity change for seats (for standalone version)
         *
         * @param boolean $value
         * @param type $ticket_type_id
         * @param type $ordered_count
         * @return boolean
         */
        function tc_editable_quantity( $value, $ticket_type_id, $ordered_count )
        {
            $cart_seats = $this->get_cart_seats_cookie();
            if ( isset( $cart_seats ) && isset( $cart_seats[$ticket_type_id] ) ) {
                $value = ( isset( $cart_seats[$ticket_type_id][0] ) && isset( $cart_seats[$ticket_type_id][0][1] ) ? false : true );
            }
            return $value;
        }
        
        /**
         * Add seats info needed for the database on the cart page / attendee form
         *
         * @param type $ticket_type
         * @param type $attendee_index
         */
        function tc_add_cart_seat_info( $ticket_type, $attendee_index )
        {
            $cart_seats = $this->get_cart_seats_cookie();
            
            if ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index] ) ) {
                $chart_id = ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index][2] ) ? $cart_seats[$ticket_type->details->ID][$attendee_index][2] : '' );
                $seat_label = ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index][1] ) ? $cart_seats[$ticket_type->details->ID][$attendee_index][1] : '' );
                $seat_id = ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index][0] ) ? $cart_seats[$ticket_type->details->ID][$attendee_index][0] : '' );
                ?>
                <input type="hidden" name="<?php 
                echo  esc_attr( 'owner_data_seat_label_post_meta[' . $ticket_type->details->ID . '][' . $attendee_index . ']' ) ;
                ?>" value="<?php 
                echo  esc_attr( preg_replace( '/—/i', '-', $seat_label ) ) ;
                ?>" /><input type="hidden" name="<?php 
                echo  esc_attr( 'owner_data_chart_id_post_meta[' . $ticket_type->details->ID . '][' . $attendee_index . ']' ) ;
                ?>" value="<?php 
                echo  esc_attr( $chart_id ) ;
                ?>" /><input type="hidden" name="<?php 
                echo  esc_attr( 'owner_data_seat_id_post_meta[' . $ticket_type->details->ID . '][' . $attendee_index . ']' ) ;
                ?>" value="<?php 
                echo  esc_attr( $seat_id ) ;
                ?>" /><?php 
            }
        
        }
        
        /**
         * Get seat sign (A1, A2...) for a specified ticket instance id / ticket
         *
         * @param type $ticket_instance_id
         * @return boolean
         */
        public static function get_ticket_instance_seat_sign( $ticket_instance_id )
        {
            $seat_label = get_post_meta( $ticket_instance_id, 'seat_label', true );
            if ( $seat_label !== '' && !empty($seat_label) ) {
                return $seat_label;
            }
            return false;
        }
        
        /**
         * Add seat sign in the ticket title after purchase
         *
         * @param string $ticket_type_title
         * @param type $ticket_type_id
         * @param array $array
         * @param bool $ticket_instance_id
         * @return string
         */
        function tc_maybe_add_seat_info_to_ticket_type(
            $ticket_type_title,
            $ticket_type_id,
            $array = array(),
            $ticket_instance_id = false
        )
        {
            
            if ( $ticket_instance_id ) {
                $has_seat_sign = TC_Seat_Chart::get_ticket_instance_seat_sign( $ticket_instance_id );
                
                if ( $has_seat_sign ) {
                    $has_seat_sign = preg_replace( '/—/i', '-', $has_seat_sign );
                    // Replace long hyphen with regular dash.
                    $ticket_type_title = $ticket_type_title . ' (' . $has_seat_sign . ')';
                }
            
            }
            
            return $ticket_type_title;
        }
        
        /**
         * Add remove from cart "X" next to an attendee form
         *
         * @param string $attendee_caption
         * @param type $ticket_type
         * @param type $attendee_index
         * @return string
         */
        function tc_add_seat_info_to_attendee_caption( $attendee_caption, $ticket_type, $attendee_index )
        {
            $cart_seats = $this->get_cart_seats_cookie();
            
            if ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index] ) && !empty($cart_seats[$ticket_type->details->ID][$attendee_index][1]) ) {
                $seat_id = $cart_seats[$ticket_type->details->ID][$attendee_index][0];
                $seat_sign = ( isset( $cart_seats[$ticket_type->details->ID][$attendee_index][1] ) ? $cart_seats[$ticket_type->details->ID][$attendee_index][1] : '' );
                $chart_id = $cart_seats[$ticket_type->details->ID][$attendee_index][2];
                $remove_icon = '<span class="tc_cart_remove_icon notranslate" title="' . __( 'Remove from Cart', 'tcsc' ) . '" data-ticket-type-id="' . (int) $ticket_type->details->ID . '" data-seat-sign="' . $seat_sign . '" data-seat-id="' . $seat_id . '" data-chart-id="' . (int) $chart_id . '"><i class="fa fa-times" aria-hidden="true"></i></span>';
                $attendee_caption = $attendee_caption . (( !empty($seat_sign) ? apply_filters( 'tc_attendee_info_has_seat_sign_caption', ' (' . preg_replace( '/—/i', '-', $seat_sign ) . ')', $seat_sign ) : '' )) . $remove_icon;
                // Replace long hyphen with regular dash.
            }
            
            return $attendee_caption;
        }
        
        /**
         * Get seats cookie
         *
         * @return array
         */
        public static function get_cart_seats_cookie()
        {
            $seats = [];
            $cookie_id = 'tc_cart_seats_' . COOKIEHASH;
            
            if ( isset( $_COOKIE[$cookie_id] ) ) {
                $seats_obj = json_decode( stripslashes( $_COOKIE[$cookie_id] ), true );
                foreach ( (array) $seats_obj as $ticket_type_id => $position ) {
                    $seats[(int) $ticket_type_id] = $position;
                }
            } else {
                $saved_cart = TC_Seat_Chart::get_cart_seats_persistant();
                $seats = ( is_null( $saved_cart ) ? [] : $saved_cart );
            }
            
            // Make sure to remove duplicates
            $neat_seats = [];
            foreach ( $seats as $ticket_id => $ticket_seats ) {
                if ( count( $ticket_seats ) ) {
                    $neat_seats[$ticket_id] = array_values( array_unique( $ticket_seats, SORT_REGULAR ) );
                }
            }
            return ( isset( $neat_seats ) ? $neat_seats : [] );
        }
        
        /**
         * Update seats cookie
         *
         * @param $seats
         */
        public static function set_seats_cookie( $seats )
        {
            if ( !session_id() ) {
                @session_start();
            }
            // Make sure to remove duplicates and empty elements
            $neat_seats = [];
            foreach ( $seats as $ticket_id => $ticket_seats ) {
                if ( count( $ticket_seats ) ) {
                    $neat_seats[$ticket_id] = array_values( array_unique( $ticket_seats, SORT_REGULAR ) );
                }
            }
            ob_start();
            $cookie_id = 'tc_cart_seats_' . COOKIEHASH;
            unset( $_COOKIE[$cookie_id] );
            setcookie(
                $cookie_id,
                null,
                -1,
                '/'
            );
            // Set cookie
            $expire = time() + apply_filters( 'tc_cart_cookie_expiration', 172800 );
            // 72 hrs expire by default
            setcookie(
                $cookie_id,
                json_encode( $seats ),
                $expire,
                COOKIEPATH,
                COOKIE_DOMAIN
            );
            $_COOKIE[$cookie_id] = json_encode( $seats );
            ob_end_flush();
            self::set_cart_seats_persistent( $seats );
        }
        
        /**
         * Set seats cookie
         *
         * @param type $seats_info
         */
        function set_cart_seats_cookie( $seats_info )
        {
            $seats = $this->get_cart_seats_cookie();
            foreach ( $seats_info as $seat_info ) {
                /**
                 * Check if the standee exists in the seats cookie
                 * If entry exists, add the last element (quantity) with the recently added quantity
                 * If entry doesn't exists, create new entry
                 */
                $ticket_type_id = (int) array_shift( $seat_info );
                $quantity = ( isset( $seat_info[3] ) ? (int) $seat_info[3] : 0 );
                if ( '' === $seat_info[1] && isset( $seats[$ticket_type_id] ) ) {
                    foreach ( $seats[$ticket_type_id] as $key => $seat ) {
                        
                        if ( $seat[0] == $seat_info[0] && '' === $seat[1] ) {
                            $standee_seat_key = $key;
                            break;
                        }
                    
                    }
                }
                
                if ( isset( $standee_seat_key ) ) {
                    @($seats[$ticket_type_id][$standee_seat_key][3] += $quantity);
                } else {
                    $seats[$ticket_type_id][] = $seat_info;
                }
            
            }
            // Make sure to remove duplicates and empty elements
            $neat_seats = [];
            foreach ( $seats as $ticket_id => $seating_ids ) {
                $neat_seats[$ticket_id] = array_values( array_unique( $seating_ids, SORT_REGULAR ) );
            }
            self::set_seats_cookie( $neat_seats );
        }
        
        public static function get_cart_seats_persistant()
        {
            $cart = array();
            
            if ( get_current_user_id() ) {
                
                if ( $saved_cart = get_user_meta( get_current_user_id(), '_seatings_persistent_cart', true ) ) {
                    $cart = json_decode( stripslashes( $saved_cart['seats_cart'] ), true );
                } elseif ( is_null( $cart ) || empty($cart) ) {
                    $cart = array();
                }
            
            } else {
                $cart = array();
            }
            
            return $cart;
        }
        
        /**
         * Set Cart Seats Cookie Persistent
         *
         * @param $seats
         */
        public static function set_cart_seats_persistent( $seats )
        {
            
            if ( get_current_user_id() ) {
                foreach ( (array) $seats as $seat_key => $seat_value ) {
                    if ( empty($seats[$seat_key]) ) {
                        unset( $seats[$seat_key] );
                    }
                }
                update_user_meta( get_current_user_id(), '_seatings_persistent_cart', [
                    'seats_cart' => json_encode( $seats ),
                ] );
            }
        
        }
        
        function delete_cart_seats_persistent()
        {
            delete_user_meta( get_current_user_id(), '_seatings_persistent_cart' );
            $this->delete_order_cookie();
        }
        
        function destroy_cookies()
        {
            ob_start();
            $cookie_id = 'tc_cart_seats_' . COOKIEHASH;
            unset( $_COOKIE[$cookie_id] );
            setcookie(
                $cookie_id,
                null,
                -1,
                '/'
            );
            ob_end_flush();
        }
        
        /**
         * Capture Cart Update Action.
         * Additional logic to be executed when Seating Chart is activated
         */
        function capture_update_cart_actions()
        {
            if ( isset( $_POST['cart_action'] ) ) {
                
                if ( in_array( $_POST['cart_action'], array( 'proceed_to_checkout', 'update_cart' ) ) ) {
                    global  $cart_error_number, $tc_cart_tickets_error_codes ;
                    
                    if ( $cart_error_number && $tc_cart_tickets_error_codes ) {
                        global  $tc ;
                        $in_cart_seats = $this->get_cart_seats_cookie();
                        $cart = $tc->get_cart_cookie( true );
                        foreach ( $this->get_cart_seats_cookie() as $ticket_type_id => $seats ) {
                            $ticket_error_codes = ( isset( $tc_cart_tickets_error_codes[$ticket_type_id] ) ? $tc_cart_tickets_error_codes[$ticket_type_id]['errors'] : [] );
                            /**
                             * Error Code 101: Required tickets' maximums quantity per order.
                             * Assign maximum quantity value
                             */
                            
                            if ( in_array( 101, $ticket_error_codes ) ) {
                                $max_quantity = get_post_meta( $ticket_type_id, 'max_tickets_per_order', true );
                                array_splice( $in_cart_seats[$ticket_type_id], $max_quantity );
                                $cart[$ticket_type_id] = $max_quantity;
                            }
                            
                            /**
                             * Error Code 102: Not enough ticket quantity left.
                             * Assign remaining quantity
                             */
                            
                            if ( array_intersect( [ 102, 105 ], $ticket_error_codes ) ) {
                                $quantity_left = ( isset( $cart[$ticket_type_id] ) ? $cart[$ticket_type_id] : 0 );
                                array_splice( $in_cart_seats[$ticket_type_id], $quantity_left );
                            }
                            
                            /**
                             * Error Code 103: No item quantity added in cart.
                             * Error Code 104: Has reached the maximum ticket purchases
                             * Remove item in cart
                             */
                            
                            if ( in_array( 103, $ticket_error_codes ) || in_array( 104, $ticket_error_codes ) ) {
                                unset( $cart[$ticket_type_id] );
                                unset( $in_cart_seats[$ticket_type_id] );
                            }
                        
                        }
                        $tc->update_cart_cookie( $cart );
                        self::set_seats_cookie( $in_cart_seats );
                        $discount = new TC_Discounts();
                        $discount->discounted_cart_total();
                        $tc->save_cart_post_data();
                    }
                
                } elseif ( isset( $_POST['cart_action'] ) && 'empty_cart' == $_POST['cart_action'] ) {
                    // Remove seats cookies
                    self::set_seats_cookie( array() );
                }
            
            }
        }
        
        /**
         * Remove a product or product variation from a WooCommerce cart
         *
         * @param type $product_id
         */
        public static function wc_remove_product_from_cart( $product_id )
        {
            $WC = WC();
            // Set the product ID to remove
            $prod_to_remove = (int) $product_id;
            // Cycle through each product in the cart
            foreach ( $WC->cart->get_cart() as $cart_item_key => $cart_item ) {
                // Get the Variation or Product ID
                $prod_id = ( 'product_variation' == get_post_type( $prod_to_remove ) ? $cart_item['variation_id'] : $cart_item['product_id'] );
                // Check to see if IDs match
                
                if ( $prod_to_remove == $prod_id ) {
                    $new_quant = (int) $cart_item['quantity'] - 1;
                    $WC->cart->set_quantity( $cart_item_key, $new_quant, true );
                    if ( 0 == $new_quant ) {
                        $WC->cart->remove_cart_item( $cart_item_key );
                    }
                    break;
                }
            
            }
        }
        
        /**
         * Remove seats from cart when removing an item (per multiple items from cart via "X" button)
         * Do not execute if firebase is enabled.
         *
         * @param type $cart_item_key
         */
        function woo_cart_item_remove_seat( $cart_item_key )
        {
            $cart_item = WC()->cart->get_cart_item( $cart_item_key );
            $seat_ticket_type_id = ( isset( $cart_item['variation_id'] ) && is_int( $cart_item['variation_id'] ) && $cart_item['variation_id'] > 0 ? $cart_item['variation_id'] : $cart_item['product_id'] );
            $in_cart_seats = $this->get_cart_seats_cookie();
            if ( isset( $in_cart_seats ) && isset( $in_cart_seats[$seat_ticket_type_id] ) ) {
                foreach ( $in_cart_seats[$seat_ticket_type_id] as $index => $ticket_type_seats_in_cart ) {
                    $seat_id = $ticket_type_seats_in_cart[0];
                    $chart_id = (int) $ticket_type_seats_in_cart[2];
                    do_action( 'tc_seat_chart_woo_cart_item_remove_seat', $seat_id, $chart_id );
                    unset( $in_cart_seats[$seat_ticket_type_id][$index] );
                }
            }
            self::set_seats_cookie( $in_cart_seats );
        }
        
        /**
         * Remove a product or product variation from a WooCommerce cart
         *
         * @param string $chart_id
         * @param string $seat_id
         * @return array
         */
        public static function tc_remove_seat_from_cart_woo( $chart_id, $seat_id )
        {
            global  $tc ;
            $in_cart_count = 0;
            $in_cart_seats = TC_Seat_Chart::get_cart_seats_cookie();
            $new_seat_cookie = [];
            foreach ( $in_cart_seats as $ticket_id => $seating_ids ) {
                $new_seat_cookie[$ticket_id] = $seating_ids;
                foreach ( $seating_ids as $index => $seat_values ) {
                    
                    if ( $seat_values[2] == $chart_id ) {
                        $seating_id = reset( $seat_values );
                        
                        if ( $seating_id == $seat_id ) {
                            // Remove entry from seat cookie
                            if ( isset( $new_seat_cookie[$ticket_id] ) && isset( $new_seat_cookie[$ticket_id][$index] ) ) {
                                unset( $new_seat_cookie[$ticket_id][$index] );
                            }
                            $new_seat_cookie[$ticket_id] = array_values( $new_seat_cookie[$ticket_id] );
                            self::wc_remove_product_from_cart( $ticket_id );
                        }
                    
                    }
                
                }
            }
            self::set_seats_cookie( $new_seat_cookie );
            $cart_subtotal = WC()->cart->get_cart_total();
            $in_cart_count = apply_filters( 'tc_seat_chart_in_cart_count', $in_cart_count );
            $response = array();
            $response['link'] = sprintf(
                '<span class="tc_in_cart">%s <a href="%s">%s</a></span>',
                apply_filters( 'tc_ticket_added_to_message', __( 'Ticket added to', 'tcsc' ) ),
                $tc->get_cart_slug( true ),
                apply_filters( 'tc_ticket_added_to_cart_message', __( 'Cart', 'tcsc' ) )
            );
            $response['subtotal'] = __( 'Subtotal: ', 'tcsc' );
            $response['total'] = $cart_subtotal;
            $response['in_cart_count'] = $in_cart_count;
            $response['cart_link'] = add_query_arg( [
                'tcrft' => time(),
            ], apply_filters( 'tc_seat_chart_checkout_url', $tc->get_cart_page( true ) ) );
            return $response;
        }
        
        function tc_remove_seat_from_cart_ajax()
        {
            $seat = $_POST['tcsc_seat'];
            $exploded = explode( '-', $seat );
            $chart_id = $exploded[0];
            $seat_id = $exploded[1];
            wp_send_json( self::tc_remove_seat_from_cart( $chart_id, $seat_id ) );
        }
        
        public static function tc_remove_seat_from_cart( $chart_id = '', $seat_id = '' )
        {
            return ( true == apply_filters( 'tc_is_woo', false ) ? self::tc_remove_seat_from_cart_woo( $chart_id, $seat_id ) : self::tc_remove_seat_from_cart_standalone( $chart_id, $seat_id ) );
        }
        
        /**
         * Tickera Standalone.
         * Remove a ticket from cart.
         *
         * @param string $chart_id
         * @param string $seat_id
         * @return array
         * @global type $tc
         */
        public static function tc_remove_seat_from_cart_standalone( $chart_id, $seat_id )
        {
            global  $tc ;
            $in_cart_seats = TC_Seat_Chart::get_cart_seats_cookie();
            $cart_content = $tc->get_cart_cookie( true );
            // Make sure to remove duplicates from the seats cookie
            $temp_seat_cookie = [];
            foreach ( $in_cart_seats as $ticket_id => $seating_ids ) {
                $temp_seat_cookie[$ticket_id] = array_values( array_unique( $seating_ids, SORT_REGULAR ) );
            }
            $new_seat_cookie = [];
            foreach ( $temp_seat_cookie as $ticket_id => $seating_ids ) {
                $new_seat_cookie[$ticket_id] = $seating_ids;
                foreach ( $seating_ids as $index => $seat_values ) {
                    
                    if ( $seat_values[2] == $chart_id ) {
                        $seating_id = reset( $seat_values );
                        
                        if ( $seating_id == $seat_id ) {
                            
                            if ( isset( $new_seat_cookie[$ticket_id] ) && isset( $new_seat_cookie[$ticket_id][$index] ) ) {
                                // Remove entry from seat cookie
                                unset( $new_seat_cookie[$ticket_id][$index] );
                                // Remove an item from cart cookie
                                $cart_content[$ticket_id] = @$cart_content[$ticket_id] - 1;
                            }
                            
                            $new_seat_cookie[$ticket_id] = array_values( $new_seat_cookie[$ticket_id] );
                        }
                    
                    }
                
                }
            }
            $tc->update_cart_cookie( $cart_content );
            self::set_seats_cookie( $new_seat_cookie );
            // Update cart totals
            $discount = new TC_Discounts();
            $discount->discounted_cart_total();
            $tc->save_cart_post_data();
            $totals = self::tc_recalculate_subtotal();
            $in_cart_count = apply_filters( 'tc_seat_chart_in_cart_count', $totals['in_cart_count'] );
            $response = array();
            $response['link'] = sprintf(
                '<span class="tc_in_cart">%s <a href="%s">%s</a></span>',
                apply_filters( 'tc_ticket_added_to_message', __( 'Ticket removed from', 'tcsc' ) ),
                $tc->get_cart_slug( true ),
                apply_filters( 'tc_ticket_removed_from_cart_message', __( 'Cart', 'tcsc' ) )
            );
            $response['subtotal'] = __( 'Subtotal: ', 'tcsc' );
            $response['total'] = apply_filters( 'tc_cart_currency_and_format', $totals['subtotal'] );
            $response['in_cart_count'] = $in_cart_count;
            $response['cart_link'] = add_query_arg( [
                'tcrft' => time(),
            ], $tc->get_cart_page( true ) );
            return $response;
        }
        
        function tc_wc_get_cart_info()
        {
            ob_start();
            global  $tc ;
            $response = array();
            $response['error'] = false;
            $cart_subtotal = 0;
            $in_cart_count = apply_filters( 'tc_seat_chart_in_cart_count', $in_cart_count );
            $response['link'] = sprintf(
                '<span class="tc_in_cart">%s <a href="%s">%s</a></span>',
                apply_filters( 'tc_ticket_added_to_message', __( 'Ticket added to', 'tcsc' ) ),
                $tc->get_cart_slug( true ),
                apply_filters( 'tc_ticket_added_to_cart_message', __( 'Cart', 'tcsc' ) )
            );
            $response['subtotal'] = __( 'Subtotal: ', 'tcsc' );
            $response['total'] = apply_filters( 'tc_seat_chart_cart_subtotal', apply_filters( 'tc_cart_currency_and_format', ( isset( $cart_subtotal ) ? $cart_subtotal : 0 ) ) );
            $response['in_cart_count'] = $in_cart_count;
            echo  json_encode( $response ) ;
            ob_end_flush();
            exit;
        }
        
        /**
         * Validate Seats availability based on Woo Products Attributes
         *
         * @param $object_type | True when used in ajax call
         * @param null $ticket_type_id
         * @return array
         */
        function tc_validate_woo_seat_availability( $object_type, $ticket_type_id = null )
        {
            // Initialize Variables
            $response = [];
            // Collects browser cookies for reserved and in cart seats
            $in_cart_seats = $this->get_cart_seats_cookie();
            // Retrieve Seat Items
            $tc_seat_cart_item = ( isset( $_POST['tc_seat_cart_items'] ) ? reset( $_POST['tc_seat_cart_items'] ) : '' );
            $tc_seat_cart_item = explode( '-', $tc_seat_cart_item );
            // Set Product ID
            $product_id = ( $ticket_type_id ? $ticket_type_id : absint( $tc_seat_cart_item[0] ) );
            // Retrieve Chart ID
            $chart_id = ( isset( $_POST['seat_chart_id'] ) && $_POST['seat_chart_id'] ? (int) $_POST['seat_chart_id'] : end( $tc_seat_cart_item ) );
            // Set Quantity
            $quantity = ( isset( $_POST['standing_qty'] ) ? (int) $_POST['standing_qty'] : 1 );
            $quantity = ( $quantity ? $quantity : 1 );
            // Reassign product id if type is variation
            $product_obj = wc_get_product( $product_id );
            $product_status = get_post_status( $product_id );
            // Initialize pre validation
            $pre_validation = true;
            // Validate per product attributes
            
            if ( 'publish' != $product_status ) {
                $pre_validation = false;
            } elseif ( $product_obj->get_sold_individually() ) {
                // Collects all reserved seats
                $tickets_instances = get_posts( array(
                    'post_type'      => 'tc_tickets_instances',
                    'post_status'    => 'publish',
                    'posts_per_page' => -1,
                    'meta_key'       => 'chart_id',
                    'meta_value'     => $chart_id,
                    'no_found_rows'  => true,
                ) );
                $ticket_instances_ticket_ids = [];
                foreach ( $tickets_instances as $tickets_instance ) {
                    $ticket_instances_ticket_id = get_post_meta( $tickets_instance->ID, 'ticket_type_id', true );
                    $ticket_instances_ticket_ids[] = ( $product_obj->has_child() ? wp_get_post_parent_id( $ticket_instances_ticket_id ) : $ticket_instances_ticket_id );
                }
                // Check if selected seat is in cart or reserved
                if ( isset( $in_cart_seats[$product_id] ) && $in_cart_seats[$product_id] || in_array( $product_id, $ticket_instances_ticket_ids ) ) {
                    $pre_validation = false;
                }
                // Check if product variation is already in the cart
                
                if ( $product_obj->has_child() ) {
                    $variations = $product_obj->get_available_variations();
                    foreach ( $variations as $variation ) {
                        
                        if ( isset( $in_cart_seats[$variation['variation_id']] ) && $in_cart_seats[$variation['variation_id']] ) {
                            $pre_validation = false;
                            break;
                        }
                    
                    }
                }
            
            }
            
            $error_message = ( !$pre_validation ? __( 'Seat is currently not available.', 'tcsc' ) : '' );
            $passed_validation = apply_filters(
                'woocommerce_add_to_cart_validation',
                $pre_validation,
                $product_id,
                $quantity
            );
            $response['tc_error'] = !$passed_validation;
            $response['tc_validation_passed'] = $passed_validation;
            $response['tc_error_message'] = apply_filters( 'tc_seat_validation_error_message', $error_message );
            // Executes if not an ajax call
            if ( true == $object_type ) {
                return $response;
            }
            wp_send_json( $response );
        }
        
        /**
         * Add/Update/Remove Seats/Standee from Cart
         * Tickera alongside Bridge for Woocommerce
         *
         * @throws Exception
         */
        function tc_woo_update_cart_seats()
        {
            
            if ( isset( $_POST['action'] ) && 'tc_woo_update_cart_seats' == $_POST['action'] ) {
                // Return the executed action.
                $did_action = '';
                $error = false;
                $seat_cart_items = $_POST['tc_seat_cart_items'];
                $quantity = ( isset( $_POST['quantity'] ) ? (int) $_POST['quantity'] : 1 );
                // Previously tc_quantity. Changed to quantity to follow the default Woocommerce parameter.
                $variation_id = ( isset( $_POST['variation_id'] ) ? (int) $_POST['variation_id'] : 0 );
                $seat_cookie = self::get_cart_seats_cookie();
                foreach ( $seat_cart_items as $seat_cart_item ) {
                    $seat_cart_item = explode( '-', $seat_cart_item );
                    $chart_id = $seat_cart_item[3];
                    $seat_id = $seat_cart_item[1];
                    $seat_label = $seat_cart_item[2];
                    $is_standee = ( !$seat_label ? true : false );
                    $parent_product_id = $seat_cart_item[0];
                    $ticket_type_id = ( $variation_id ? $variation_id : $parent_product_id );
                    $pre_validation = self::tc_validate_woo_seat_availability( true );
                    $pre_validation = $pre_validation['tc_validation_passed'];
                    $passed_validation = apply_filters(
                        'woocommerce_add_to_cart_validation',
                        $pre_validation,
                        $parent_product_id,
                        $quantity
                    );
                    $product_status = get_post_status( $parent_product_id );
                    // Initialize seat cookie variable
                    if ( !isset( $seat_cookie[$ticket_type_id] ) ) {
                        $seat_cookie[$ticket_type_id] = [];
                    }
                    if ( $passed_validation && 'publish' === $product_status ) {
                        
                        if ( !$quantity ) {
                            // Remove seat from the cart and seat cookie variable if quantity is zero.
                            foreach ( $seat_cookie[$ticket_type_id] as $key => $seats ) {
                                // Quantity is zero, remove seat from cookie
                                
                                if ( $chart_id == $seats[2] && $seat_id == $seats[0] ) {
                                    unset( $seat_cookie[$ticket_type_id][$key] );
                                    foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
                                        
                                        if ( in_array( $ticket_type_id, [ $values['product_id'], $values['variation_id'] ] ) ) {
                                            $deducted_quantity = $values['quantity'] - (int) $seats[3];
                                            $deducted_quantity = ( $deducted_quantity >= 0 ? $deducted_quantity : 0 );
                                            WC()->cart->set_quantity( $cart_item_key, $deducted_quantity );
                                            break;
                                        }
                                    
                                    }
                                    $did_action = 'removed';
                                    break;
                                }
                            
                            }
                        } elseif ( !$is_standee ) {
                            
                            if ( false !== WC()->cart->add_to_cart( $ticket_type_id, $quantity ) ) {
                                $seat_cookie[$ticket_type_id][] = [
                                    $seat_id,
                                    $seat_label,
                                    $chart_id,
                                    $quantity
                                ];
                                $did_action = 'added';
                            } else {
                                $error = true;
                            }
                        
                        } elseif ( $is_standee ) {
                            $exists = false;
                            $total_item_quantity = 0;
                            // Update existing seat quantity in the cart and seat cookie variables.
                            foreach ( $seat_cookie[$ticket_type_id] as $key => $seats ) {
                                // Update existing seat cookie's quantity
                                
                                if ( $chart_id == $seats[2] && $seat_id == $seats[0] ) {
                                    $seat_cookie[$ticket_type_id][$key][3] = $quantity;
                                    $total_item_quantity += $quantity;
                                    $exists = true;
                                } else {
                                    $total_item_quantity += $seats[3];
                                }
                            
                            }
                            // Update cart item quantity
                            if ( $exists ) {
                                foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
                                    
                                    if ( in_array( $ticket_type_id, [ $values['product_id'], $values['variation_id'] ] ) ) {
                                        WC()->cart->set_quantity( $cart_item_key, $total_item_quantity );
                                        break;
                                    }
                                
                                }
                            }
                            // Insert additional seat in the cart and seat cookie variables if entry not yet exists.
                            
                            if ( !$exists ) {
                                
                                if ( false !== WC()->cart->add_to_cart( $ticket_type_id, $quantity ) ) {
                                    $seat_cookie[$ticket_type_id][] = [
                                        $seat_id,
                                        $seat_label,
                                        $chart_id,
                                        $quantity
                                    ];
                                    $did_action = 'added';
                                } else {
                                    $error = true;
                                }
                            
                            } else {
                                $did_action = 'updated';
                            }
                        
                        }
                    
                    }
                }
                // Update Seats Cookie
                self::set_seats_cookie( $seat_cookie );
                $response = [];
                $response['error'] = $error;
                $response['action'] = $did_action;
                $response['subtotal'] = __( 'Subtotal: ', 'tcsc' );
                $response['total'] = apply_filters( 'tc_seat_chart_cart_subtotal', apply_filters( 'tc_cart_currency_and_format', 0 ) );
                $response['in_cart_count'] = apply_filters( 'tc_seat_chart_in_cart_count', 0 );
                wp_send_json( $response );
            }
        
        }
        
        /**
         * Add/Update/Remove Seats from Cart
         * Tickera Standalone
         * @since 0.76
         */
        function tc_update_cart_seats()
        {
            
            if ( isset( $_POST['action'] ) && 'tc_update_cart_seats' == $_POST['action'] ) {
                global  $tc ;
                // Return the executed action.
                $did_action = '';
                $quantity = ( isset( $_POST['tc_quantity'] ) ? (int) $_POST['tc_quantity'] : 1 );
                $seat_cart_items = $_POST['tc_seat_cart_items'];
                $seat_cookie = self::get_cart_seats_cookie();
                $cart_cookie = $tc->get_cart_cookie();
                foreach ( $seat_cart_items as $seat_cart_item ) {
                    $seat_cart_item = explode( '-', $seat_cart_item );
                    $ticket_type_id = $seat_cart_item[0];
                    $chart_id = $seat_cart_item[3];
                    $seat_id = $seat_cart_item[1];
                    $seat_label = $seat_cart_item[2];
                    $is_standee = ( !$seat_label ? true : false );
                    // Initialize seat cookie variable
                    if ( !isset( $seat_cookie[$ticket_type_id] ) ) {
                        $seat_cookie[$ticket_type_id] = [];
                    }
                    // Initialize cart cookie variable
                    if ( !isset( $cart_cookie[$ticket_type_id] ) ) {
                        $cart_cookie[$ticket_type_id] = 0;
                    }
                    
                    if ( !$quantity ) {
                        // Remove seat from the cart and seat cookie variable if quantity is zero.
                        foreach ( $seat_cookie[$ticket_type_id] as $key => $seats ) {
                            // Quantity is zero, remove seat from cookie
                            
                            if ( $chart_id == $seats[2] && $seat_id == $seats[0] ) {
                                unset( $seat_cookie[$ticket_type_id][$key] );
                                // Deduct from cart cookie
                                
                                if ( isset( $cart_cookie[$ticket_type_id] ) ) {
                                    $cart_cookie[$ticket_type_id] -= $seats[3];
                                    // Remove from cart cookie if zero quantity
                                    if ( $cart_cookie[$ticket_type_id] <= 0 ) {
                                        unset( $cart_cookie[$ticket_type_id] );
                                    }
                                }
                                
                                $did_action = 'removed';
                                break;
                            }
                        
                        }
                    } elseif ( !$is_standee ) {
                        $seat_cookie[$ticket_type_id][] = [
                            $seat_id,
                            $seat_label,
                            $chart_id,
                            $quantity
                        ];
                        $cart_cookie[$ticket_type_id] += $quantity;
                        $did_action = 'added';
                    } elseif ( $is_standee ) {
                        $exists = false;
                        $total_item_quantity = 0;
                        // Update existing seat quantity in the cart and seat cookie variables.
                        foreach ( $seat_cookie[$ticket_type_id] as $key => $seats ) {
                            // Update existing seat cookie's quantity
                            
                            if ( $chart_id == $seats[2] && $seat_id == $seats[0] ) {
                                $seat_cookie[$ticket_type_id][$key][3] = $quantity;
                                $total_item_quantity += $quantity;
                                $exists = true;
                            } else {
                                $total_item_quantity += $seats[3];
                            }
                        
                        }
                        // Update cart cookie
                        $cart_cookie[$ticket_type_id] = $total_item_quantity;
                        // Insert additional seat in the cart and seat cookie variables if entry not yet exists.
                        
                        if ( !$exists ) {
                            $seat_cookie[$ticket_type_id][] = [
                                $seat_id,
                                $seat_label,
                                $chart_id,
                                $quantity
                            ];
                            $cart_cookie[$ticket_type_id] += $quantity;
                            $did_action = 'added';
                        } else {
                            $did_action = 'updated';
                        }
                    
                    }
                
                }
                // Update Seats Cookie
                self::set_seats_cookie( $seat_cookie );
                // Update Cart Cookie
                $tc->set_cart_cookie( $cart_cookie );
                // Update cart totals
                $discount = new TC_Discounts();
                $discount->discounted_cart_total();
                $tc->save_cart_post_data();
                // Recalculate total values
                $totals = self::tc_recalculate_subtotal();
                $response = [];
                $response['action'] = $did_action;
                $response['total'] = apply_filters( 'tc_cart_currency_and_format', $totals['subtotal'] );
                $response['in_cart_count'] = apply_filters( 'tc_seat_chart_in_cart_count', $totals['in_cart_count'] );
                wp_send_json( $response );
            }
        
        }
        
        /**
         * Recalculate Cart Subtotal
         *
         * @return array
         */
        public static function tc_recalculate_subtotal()
        {
            global  $tc ;
            $cart_subtotal = 0;
            $in_cart_count = 0;
            $cart_contents = $tc->get_cart_cookie();
            foreach ( $cart_contents as $ticket_type => $ordered_count ) {
                $ticket = new TC_Ticket( $ticket_type );
                $cart_subtotal = $cart_subtotal + tc_get_ticket_price( $ticket->details->ID ) * $ordered_count;
                if ( $ordered_count > 0 ) {
                    $in_cart_count++;
                }
            }
            return [
                'subtotal'      => $cart_subtotal,
                'in_cart_count' => $in_cart_count,
            ];
        }
        
        /**
         * Register tc_seat_charts custom post type
         */
        function register_custom_posts()
        {
            $args = array(
                'labels'             => array(
                'name'               => __( 'Seating Charts', 'tcsc' ),
                'singular_name'      => __( 'Seating Chart', 'tcsc' ),
                'add_new'            => __( 'Create New', 'tcsc' ),
                'add_new_item'       => __( 'Create New Seating Chart', 'tcsc' ),
                'edit_item'          => __( 'Edit Seating Chart', 'tcsc' ),
                'edit'               => __( 'Edit', 'tcsc' ),
                'new_item'           => __( 'New Seating Chart', 'tcsc' ),
                'view_item'          => __( 'View Seating Chart', 'tcsc' ),
                'search_items'       => __( 'Search Seating Charts', 'tcsc' ),
                'not_found'          => __( 'No Seating Charts Found', 'tcsc' ),
                'not_found_in_trash' => __( 'No Seating Charts found in Trash', 'tcsc' ),
                'view'               => __( 'View Seating Chart', 'tcsc' ),
            ),
                'public'             => false,
                'show_ui'            => true,
                'publicly_queryable' => true,
                'hierarchical'       => false,
                'query_var'          => true,
                'show_in_menu'       => 'edit.php?post_type=tc_events',
                'supports'           => array( 'title', 'editor' ),
            );
            register_post_type( 'tc_seat_charts', apply_filters( 'tc_seat_charts_post_type_args', $args ) );
        }
        
        /**
         * Tickera Standalone - Additional Metabox in Ticket Type admin configuration page
         *
         * @param type $fields
         * @return string
         */
        function additional_ticket_type_metabox( $fields )
        {
            // Used for Seatings
            $fields[] = array(
                'field_name'       => '_tc_used_for_seatings',
                'field_title'      => __( 'Used for Seatings', 'tcsc' ),
                'field_type'       => 'function',
                'function'         => 'tcsc_yes_no',
                'tooltip'          => __( 'Check this box if you are going to use this product on a seatings map. That way, product can be purchased only if it\'s added to cart via a seatings map.', 'tcsc' ),
                'table_visibility' => false,
                'post_field_type'  => 'post_meta',
            );
            // Seat Color
            $fields[] = array(
                'field_name'       => '_seat_color',
                'field_title'      => __( 'Seat Color', 'tcsc' ),
                'field_type'       => 'text',
                'tooltip'          => __( 'Color which will be visible on a seating chart', 'tcsc' ),
                'table_visibility' => false,
                'post_field_type'  => 'post_meta',
            );
            return $fields;
        }
        
        /**
         * Get seats selected in the admin (just a raw seat map)
         *
         * @param type $seat_map_post_id
         */
        public static function get_occupied_seats( $seat_map_post_id )
        {
            if ( is_object( $seat_map_post_id ) ) {
                $seat_map_post_id = $seat_map_post_id->ID;
            }
            $seats = get_post_meta( $seat_map_post_id, 'tc_seat_cords', true );
            $seats = explode( '|', $seats );
            $seat_ticket_types = get_post_meta( $seat_map_post_id, 'tc_seat_ticket_types', true );
            $seat_ticket_types = explode( '|', $seat_ticket_types );
            $seat_signs = get_post_meta( $seat_map_post_id, 'tc_seat_signs', true );
            $seat_signs = explode( '|', $seat_signs );
            $seat_directions = get_post_meta( $seat_map_post_id, 'tc_seat_directions', true );
            $seat_directions = explode( '|', $seat_directions );
            ?>
            <script type="text/javascript">
                var tc_seats = new Array();
                <?php 
            $i = 0;
            foreach ( $seats as $seat ) {
                
                if ( !empty($seat) ) {
                    $seat_sign_val = ( isset( $seat_signs ) && is_array( $seat_signs ) && count( $seat_signs ) > 0 && !empty($seat_signs) && isset( $seat_signs[$i] ) ? $seat_signs[$i] : '' );
                    $seat_direction_val = ( isset( $seat_directions ) && is_array( $seat_directions ) && count( $seat_directions ) > 0 && !empty($seat_directions) && isset( $seat_directions[$i] ) ? $seat_directions[$i] : '' );
                    ?>
                tc_seats[ '<?php 
                    echo  $seat ;
                    ?>' ] = new Array(<?php 
                    echo  $seat_ticket_types[$i] ;
                    ?>, <?php 
                    echo  '"' . $seat_sign_val . '"' ;
                    ?>, <?php 
                    echo  '"' . $seat_direction_val . '"' ;
                    ?>);
                <?php 
                    $i++;
                }
            
            }
            ?>

                var tc_seat_colors = new Array();

                <?php 
            $unique_ticket_types = array_unique( $seat_ticket_types );
            $i = 0;
            foreach ( $unique_ticket_types as $unique_ticket_type ) {
                
                if ( !empty($unique_ticket_type) ) {
                    $seat_color_default = apply_filters( 'tc_seat_color_default', '#6b5f89' );
                    $blocked_seat_color_default = apply_filters( 'tc_blocked_seat_color_default', '#aaaaaa' );
                    $seat_color = get_post_meta( $unique_ticket_type, '_seat_color', true );
                    // $blocked_seat_color = get_post_meta($unique_ticket_type, '_seat_color', true);
                    if ( empty($seat_color) ) {
                        $seat_color = $seat_color_default;
                    }
                    ?>
                tc_seat_colors[ '<?php 
                    echo  $unique_ticket_type ;
                    ?>' ] = "<?php 
                    echo  $seat_color ;
                    ?>";
                <?php 
                    $i++;
                }
            
            }
            ?>
            </script>
        <?php 
        }
        
        public static function get_seating_chart_html( $post_id, $front = false )
        {
            try {
                $content = '';
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                $filename = ( $front ? $post_id . '-front.tcsm' : $post_id . '.tcsm' );
                $path = $upload_dir . '/' . $filename;
                if ( file_exists( $path ) ) {
                    try {
                        $content = file_get_contents( $path );
                    } catch ( Exception $e ) {
                        $myfile = fopen( $path, "r" );
                        $content = fread( $myfile, filesize( $path ) );
                        fclose( $myfile );
                    }
                }
                return $content;
            } catch ( Exception $e ) {
                return '';
            }
        }
        
        public static function save_admin( $post_id )
        {
            
            if ( get_post_type( $post_id ) == 'tc_seat_charts' && isset( $_POST['tc_chart_content'] ) ) {
                if ( wp_is_post_revision( $post_id ) && !current_user_can( apply_filters( 'tc_seating_chart_save_post_capability', 'publish_post' ) ) ) {
                    return;
                }
                remove_action(
                    'save_post',
                    'TC_Seat_Chart::save_admin',
                    10,
                    1
                );
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                
                if ( !is_writable( $upload_dir ) ) {
                    wp_redirect( admin_url( 'post.php?post=' . $post_id . '&action=edit&message=0' ) );
                    exit;
                }
                
                $chart_post = array(
                    'ID'           => $post_id,
                    'post_status'  => 'publish',
                    'post_content' => '',
                    'post_name'    => ( isset( $permalink[1] ) ? $permalink[1] : false ),
                );
                
                if ( isset( $_POST['tc_chart_title'] ) ) {
                    $permalink = get_sample_permalink( $post_id, $_POST['tc_chart_title'], sanitize_title( $_POST['tc_chart_title'] ) );
                    $chart_post['post_name'] = ( isset( $permalink[1] ) ? $permalink[1] : false );
                }
                
                $upload = wp_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/tc-seating-charts';
                // Admin file
                $filename = $post_id . '.tcsm';
                $path = $upload_dir . '/' . $filename;
                $file = @fopen( $path, "w" );
                @fwrite( $file, ( isset( $_POST['tc_chart_content'] ) ? stripslashes( minify_output( $_POST['tc_chart_content'] ) ) : '' ) );
                @fclose( $file );
                @chmod( $path, 0644 );
                // Front file
                $filename_front = $post_id . '-front.tcsm';
                $path_front = $upload_dir . '/' . $filename_front;
                $tc_chart_content_front_minified = stripslashes( minify_output( ( isset( $_POST['tc_chart_content_front'] ) ? $_POST['tc_chart_content_front'] : '' ) ) );
                $tc_chart_content_front = preg_replace( '/<div class=\\"tc-group-controls\\">.*?<\\/div>/', '', $tc_chart_content_front_minified );
                $tc_chart_content_front = preg_replace( '/<!--.*?-->/', '', $tc_chart_content_front );
                $file_front = @fopen( $path_front, "w" );
                @fwrite( $file_front, ( isset( $_POST['tc_chart_content_front'] ) ? $tc_chart_content_front : '' ) );
                @fclose( $file_front );
                @chmod( $path_front, 0644 );
                // Update the post into the database
                wp_update_post( $chart_post );
                $metas = array();
                foreach ( $_POST as $field_name => $field_value ) {
                    if ( preg_match( '/_post_meta/', $field_name ) ) {
                        $metas[str_replace( '_post_meta', '', $field_name )] = $field_value;
                    }
                    $metas = apply_filters( 'tc_seat_charts_metas', $metas );
                    if ( isset( $metas ) ) {
                        foreach ( $metas as $key => $value ) {
                            update_post_meta( $post_id, $key, $value );
                        }
                    }
                }
            }
        
        }
        
        /**
         * Save metabox values for the seat map
         *
         * @param type $post_id
         * @return void
         */
        public static function save_metabox_values( $post_id )
        {
            
            if ( 'tc_seat_charts' == get_post_type( $post_id ) ) {
                if ( wp_is_post_revision( $post_id ) || !isset( $_POST['tc_seat_cords_post_meta'] ) ) {
                    return;
                }
                delete_transient( 'tc_seat_chart_floor_html_' . $post_id );
                delete_transient( 'tc_seat_chart_floor_html_front_' . $post_id );
                remove_action(
                    'save_post',
                    'TC_Seat_Chart::save_metabox_values',
                    10,
                    1
                );
                $metas = array();
                foreach ( $_POST as $field_name => $field_value ) {
                    if ( preg_match( '/_post_meta/', $field_name ) ) {
                        $metas[str_replace( '_post_meta', '', $field_name )] = $field_value;
                    }
                    $metas = apply_filters( 'tc_seat_charts_metas', $metas );
                    if ( isset( $metas ) ) {
                        foreach ( $metas as $key => $value ) {
                            update_post_meta( $post_id, $key, $value );
                        }
                    }
                }
            }
        
        }
        
        /**
         * Dependencies Checker
         *
         * @return bool
         */
        function woo_bridge_dependencies_check()
        {
            return ( class_exists( 'TC_WooCommerce_Bridge' ) && class_exists( 'WooCommerce' ) ? true : false );
        }
        
        /**
         * Enqueue front-end scripts
         *
         * @global TC_Seat_Chart $TC_Seat_Chart
         */
        function enqueue_scripts_and_styles()
        {
            $tc_seat_charts_settings = TC_Seat_Chart::get_settings();
            $use_firebase_integration = ( isset( $tc_seat_charts_settings['user_firebase_integration'] ) ? $tc_seat_charts_settings['user_firebase_integration'] : '0' );
            wp_enqueue_script(
                'tc-seat-charts-cart-front',
                plugins_url( '/js/tc-seat-charts-cart-front.js', __FILE__ ),
                array( 'jquery' ),
                $this->version,
                true
            );
            wp_enqueue_script(
                'tc-seat-charts-documentsize',
                plugins_url( '/assets/js/front/jquery.documentsize.min.js', __FILE__ ),
                array( 'jquery' ),
                $this->version,
                true
            );
            wp_localize_script( 'tc-seat-charts-cart-front', 'tc_seat_chart_cart_ajax', array(
                'ajaxUrl'              => admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ),
                'firebase_integration' => $use_firebase_integration,
            ) );
            wp_enqueue_style( 'tc-seatings-front', plugins_url( 'assets/seatings-default.css', __FILE__ ) );
        }
        
        /**
         * Render fields by type (function, text, textarea, etc)
         *
         * @param $field
         * @param bool $show_title
         */
        public static function render_field( $field, $show_title = true )
        {
            global  $post ;
            $seat_chart = get_post( $post->ID );
            $seat_chart_fields = get_post_custom( $post->ID );
            
            if ( $show_title ) {
                ?>
                <label id="<?php 
                echo  esc_attr( $field['field_name'] . '_label' ) ;
                ?>" class="tc_seat_chart_label"><?php 
                echo  ( isset( $field['field_title'] ) ? $field['field_title'] : '' ) ;
                ?>
            <?php 
            }
            
            // Button
            if ( $field['field_type'] == 'button' ) {
                submit_button(
                    $field['text'],
                    $field['type'],
                    $field['field_name'],
                    false
                );
            }
            // Function
            
            if ( $field['field_type'] == 'function' ) {
                eval($field['function'] . '("' . $field['field_name'] . '"' . (( isset( $post->ID ) ? ',' . $post->ID : '' )) . ');');
                ?>
                <span class="description"><?php 
                echo  ( isset( $field['field_description'] ) ? $field['field_description'] : '' ) ;
                ?></span>
                <?php 
            }
            
            // Text
            
            if ( $field['field_type'] == 'text' ) {
                $class = ( isset( $field['class'] ) ? $field['class'] : '' );
                ?>
                <input type="text" <?php 
                echo  ( isset( $field['disabled'] ) ? 'disabled' : '' ) ;
                ?> class="regular-<?php 
                echo  $field['field_type'] . ' ' . $class ;
                ?>" value="<?php 
                if ( isset( $post->ID ) ) {
                    
                    if ( $field['post_field_type'] == 'post_meta' ) {
                        echo  esc_attr( ( isset( $seat_chart_fields[$field['field_name']][0] ) ? $seat_chart_fields[$field['field_name']][0] : (( isset( $field['default_value'] ) ? $field['default_value'] : '' )) ) ) ;
                    } else {
                        echo  esc_attr( $seat_chart_fields[$field['post_field_type']][0] ) ;
                    }
                
                }
                ?>" id="<?php 
                echo  $field['field_name'] ;
                ?>" name="<?php 
                echo  $field['field_name'] . '_' . $field['post_field_type'] ;
                ?>">
                <span class="description"><?php 
                echo  ( isset( $field['field_description'] ) ? $field['field_description'] : '' ) ;
                ?></span>
                <?php 
            }
            
            // Textarea
            
            if ( $field['field_type'] == 'textarea' ) {
                ?>
                <textarea <?php 
                echo  ( isset( $field['disabled'] ) ? 'disabled' : '' ) ;
                ?> class="regular-<?php 
                echo  $field['field_type'] ;
                ?>" id="<?php 
                echo  $field['field_name'] ;
                ?>" name="<?php 
                echo  $field['field_name'] . '_' . $field['post_field_type'] ;
                ?>"><?php 
                if ( isset( $post->ID ) ) {
                    
                    if ( $field['post_field_type'] == 'post_meta' ) {
                        echo  esc_textarea( ( isset( $seat_chart_fields[$field['field_name']][0] ) ? $seat_chart_fields[$field['field_name']][0] : (( isset( $field['default_value'] ) ? $field['default_value'] : '' )) ) ) ;
                    } else {
                        echo  esc_textarea( $seat_chart_fields[$field['post_field_type']] ) ;
                    }
                
                }
                ?></textarea>
                <span class="description"><?php 
                echo  $field['field_description'] ;
                ?></span>
                <?php 
            }
            
            // Editor
            
            if ( $field['field_type'] == 'textarea_editor' ) {
                ?>
                <?php 
                
                if ( isset( $post->ID ) ) {
                    
                    if ( $field['post_field_type'] == 'post_meta' ) {
                        $editor_content = ( isset( $seat_chart_fields[$field['field_name']][0] ) ? $seat_chart_fields[$field['field_name']][0] : (( isset( $field['default_value'] ) ? $field['default_value'] : '' )) );
                    } else {
                        $editor_content = $seat_chart_fields[$field['post_field_type']];
                    }
                
                } else {
                    $editor_content = '';
                }
                
                wp_editor( html_entity_decode( stripcslashes( $editor_content ) ), $field['field_name'], array(
                    'textarea_name' => $field['field_name'] . '_' . $field['post_field_type'],
                    'textarea_rows' => 5,
                ) );
                ?>
                <span class="description"><?php 
                echo  $field['field_description'] ;
                ?></span>
                <?php 
            }
            
            // Image
            
            if ( $field['field_type'] == 'image' ) {
                ?>
                <div class="file_url_holder">
                    <label>
                        <input class="file_url" type="text" size="36" name="<?php 
                echo  $field['field_name'] . '_file_url_' . $field['post_field_type'] ;
                ?>" value="<?php 
                if ( isset( $post->ID ) ) {
                    echo  esc_attr( ( isset( $seat_chart_fields[$field['field_name'] . '_file_url'] ) ? $seat_chart_fields[$field['field_name'] . '_file_url'] : '' ) ) ;
                }
                ?>" />
                        <input class="file_url_button button-secondary" type="button" value="<?php 
                _e( 'Browse', 'tcsc' );
                ?>" />
                        <span class="description"><?php 
                echo  $field['field_description'] ;
                ?></span>
                    </label>
                </div>
                <?php 
            }
            
            if ( $show_title ) {
                ?>
                </label>
                <?php 
            }
        }
        
        /**
         * Get unique ticket types.
         * Used in tc_seat_chart shortcode
         *
         * @param type $seat_map_post_id
         * @return type
         */
        public static function get_unique_ticket_types( $seat_map_post_id )
        {
            $seat_ticket_types = get_post_meta( $seat_map_post_id, 'tc_ticket_types', true );
            $seat_ticket_types = explode( ',', $seat_ticket_types );
            return array_filter( $seat_ticket_types );
        }
        
        /**
         * General settings metabox input fields
         */
        public static function show_general_settings_metabox()
        {
            $is_chart_has_orders = ( isset( $_REQUEST['post'] ) ? TC_Seat_Chart::is_chart_has_orders( $_REQUEST['post'] ) : false );
            if ( $is_chart_has_orders ) {
                ?>
                <input type="hidden" id="tc_chart_has_orders" value="1" />
                <?php 
            }
            ?>
            <input type="hidden" id="tc_square_size" value="<?php 
            echo  esc_attr( TC_Seat_Chart::chart_measure() ) ;
            ?>" />
            <?php 
            if ( isset( $_REQUEST['post'] ) ) {
                TC_Seat_Chart::get_reserved_seats( $_REQUEST['post'] );
            }
            TC_Seat_Chart::render_field( array(
                'field_title'       => __( 'Seating Chart Rows', 'tcsc' ),
                'field_type'        => 'text',
                'post_field_type'   => 'post_meta',
                'field_name'        => 'seat_chart_rows',
                'post_field_type'   => 'post_meta',
                'field_description' => __( 'Set a number of rows (including the empty ones)', 'tcsc' ),
                'default_value'     => 20,
            ) );
            TC_Seat_Chart::render_field( array(
                'field_title'       => __( 'Seating Chart Columns', 'tcsc' ),
                'field_type'        => 'text',
                'post_field_type'   => 'post_meta',
                'field_name'        => 'seat_chart_cols',
                'post_field_type'   => 'post_meta',
                'field_description' => __( 'Set a number of columns (including the empty ones)', 'tcsc' ),
                'default_value'     => 20,
            ) );
            TC_Seat_Chart::render_field( array(
                'field_name'        => 'event_name',
                'field_title'       => __( 'Event Name', 'tcsc' ),
                'placeholder'       => '',
                'field_type'        => 'function',
                'function'          => 'tc_get_events',
                'field_description' => '',
                'table_visibility'  => true,
                'post_field_type'   => 'post_meta',
            ) );
            if ( !$is_chart_has_orders ) {
                TC_Seat_Chart::render_field( array(
                    'field_type' => 'button',
                    'field_name' => 'tc_seat_chart_change_settings_button',
                    'text'       => __( 'Change & Save', 'tcsc' ),
                    'type'       => 'primary',
                ) );
            }
            ?>
            <br clear="all" />
            <?php 
        }
        
        public static function chart_measure( $data = 'size' )
        {
            $size = apply_filters( 'tc_chart_measure_size', 35 );
            $font = apply_filters( 'tc_chart_measure_size', 35 );
            switch ( $data ) {
                case 'size':
                    $value = $size;
                    break;
                case 'font':
                    $value = $font;
                    break;
                default:
                    $value = $size;
            }
            return $value;
        }
        
        public static function show_seat_controls_metabox()
        {
            ?>
            <div class="tc_seating_chart_canvas_controls">
                <span class="zoom-in">Zoom In</span>
                <span class="zoom-out">Zoom Out</span>
                <input type="range" class="zoom-range">
                <span class="reset">Reset</span>
            </div>
            <?php 
        }
        
        /**
         * Seating chart metabox / floor plan
         *
         * @global type $post
         */
        public static function show_seat_chart_metabox()
        {
            global  $post ;
            $id = $post->ID;
            $seat_chart_rows = get_post_meta( $id, 'seat_chart_rows', true );
            if ( empty($seat_chart_rows) || !is_numeric( $seat_chart_rows ) ) {
                $seat_chart_rows = 30;
            }
            $seat_chart_cols = get_post_meta( $id, 'seat_chart_cols', true );
            if ( empty($seat_chart_cols) || !is_numeric( $seat_chart_cols ) ) {
                $seat_chart_cols = 30;
            }
            $canvas_width = $seat_chart_cols * TC_Seat_Chart::chart_measure();
            $canvas_height = $seat_chart_rows * TC_Seat_Chart::chart_measure();
            $selectable_row_html = '';
            ?>

            <div class="selectable_row tc_seating_chart_canvas" style="width:<?php 
            echo  $canvas_width ;
            ?>px;height:<?php 
            echo  $canvas_height ;
            ?>px;">
                <!--SEATING CHART HERE ADMIN-->
            </div>
            <br clear="all" />
            <p class="description"><?php 
            _e( 'HINT: use SHIFT and CTRL / CMD keys or mouse (lasso) in order to select or deselect multiple seats at once.', 'tcsc' );
            ?></p>
            <style type="text/css">
                .tc_seating_selectable_group .tc_seat_unit {
                    width: <?php 
            echo  TC_Seat_Chart::chart_measure() ;
            ?>px;
                    height: <?php 
            echo  TC_Seat_Chart::chart_measure() ;
            ?>px;
                }

                .tc_seating_selectable_group .tc_seat_unit .tc-add-font {
                    font-size: <?php 
            echo  TC_Seat_Chart::chart_measure( 'font' ) ;
            ?>px;
                }
            </style>
            <?php 
            TC_Seat_Chart::render_field( array(
                'field_title'     => __( 'Seat Cords', 'tcsc' ),
                'field_type'      => 'text',
                'post_field_type' => 'post_meta',
                'field_name'      => 'tc_seat_cords',
                'post_field_type' => 'post_meta',
            ) );
            TC_Seat_Chart::render_field( array(
                'field_title'     => __( 'Seat Ticket Types', 'tcsc' ),
                'field_type'      => 'text',
                'post_field_type' => 'post_meta',
                'field_name'      => 'tc_seat_ticket_types',
                'post_field_type' => 'post_meta',
            ) );
            TC_Seat_Chart::render_field( array(
                'field_title'     => __( 'Seat Signs', 'tcsc' ),
                'field_type'      => 'text',
                'post_field_type' => 'post_meta',
                'field_name'      => 'tc_seat_signs',
                'post_field_type' => 'post_meta',
            ) );
            TC_Seat_Chart::render_field( array(
                'field_title'     => __( 'Seat Directions', 'tcsc' ),
                'field_type'      => 'text',
                'post_field_type' => 'post_meta',
                'field_name'      => 'tc_seat_directions',
                'post_field_type' => 'post_meta',
            ) );
            TC_Seat_Chart::get_occupied_seats( $id );
        }
        
        /**
         * Show seating chart on the front-end
         *
         * @global type $post
         * @param type $id
         */
        public static function show_seat_chart_front( $id = false )
        {
            global  $post ;
            $id = ( $id ? $id : $post->ID );
            $seat_chart_rows = get_post_meta( $id, 'seat_chart_rows', true );
            if ( empty($seat_chart_rows) || !is_numeric( $seat_chart_rows ) ) {
                $seat_chart_rows = 20;
            }
            $seat_chart_cols = get_post_meta( $id, 'seat_chart_cols', true );
            if ( empty($seat_chart_cols) || !is_numeric( $seat_chart_cols ) ) {
                $seat_chart_cols = 20;
            }
            $seat_data = TC_Seat_Chart::get_occupied_seats_front_php( $id );
            $tc_seats = $seat_data[0];
            $tc_seat_colors = $seat_data[1];
            $selectable_row_html = '';
            for ( $i = 1 ;  $i < $seat_chart_rows + 1 ;  $i++ ) {
                $selectable_row_html .= '<div class="tc_seat_row_row">';
                for ( $j = 1 ;  $j < $seat_chart_cols + 1 ;  $j++ ) {
                    $k = $i . '_' . $j;
                    //key made of row and col number
                    $attributes = '';
                    $tc_add_font_class = '';
                    $seat_classes = '';
                    $seat_color = 'style="color: #0085BA;"';
                    
                    if ( isset( $tc_seats[$k] ) ) {
                        if ( isset( $tc_seat_colors[$tc_seats[$k][0]] ) ) {
                            $seat_color = 'style="color:' . $tc_seat_colors[$tc_seats[$k][0]] . ';"';
                        }
                        $attributes .= ' data-ticket-type-id="' . $tc_seats[$k][0] . '"';
                        //ticket type id
                        $attributes .= ' data-seat-sign="' . $tc_seats[$k][1] . '"';
                        //seat sign
                        $attributes .= ' data-has-variations="' . $tc_seats[$k][2] . '"';
                        //is woocommerce product variation
                        $seat_classes = 'tc_set_seat tc_seat_as';
                        $tc_add_font_class = $tc_seats[$k][3];
                        //rotation
                    }
                    
                    /*
                     * Seat seat sign attribute
                     * Create row html
                     */
                    $selectable_row_html .= '<div class="tc_seat_unit tc_seat_' . $k . ' ' . $seat_classes . '" data-seat-r="' . $i . '" data-seat-c="' . $j . '" ' . $attributes . '><span class="tc-add-font ' . $tc_add_font_class . '" ' . $seat_color . '></span><i class="fa fa-times tc_sc_rfc" aria-hidden="true" style="display:none;"></i></div>';
                }
                $selectable_row_html .= '</div>';
            }
            ?>
            <div class="tc_selectable_holder">
                <div class="selectable_row selectable_row_<?php 
            echo  esc_attr( $id ) ;
            ?>" data-seat-chart-id="<?php 
            echo  esc_attr( $id ) ;
            ?>" data-seat-chart-rows="<?php 
            echo  esc_attr( $seat_chart_rows ) ;
            ?>" data-seat-chart-cols="<?php 
            echo  esc_attr( $seat_chart_cols ) ;
            ?>">
                    <!--SEATING CHART HERE-->
                    <?php 
            echo  $selectable_row_html ;
            ?>
                </div>
            </div>
            <?php 
            TC_Seat_Chart::get_occupied_seats_front( $id );
        }
        
        public static function get_reserved_order_statuses()
        {
            return apply_filters( 'tc_seat_charts_get_reserved_seats_order_statuses', array( 'order_received', 'order_paid' ) );
        }
        
        /**
         * Get all reserved seats
         *
         * @param bool $chart_id
         * @return void
         */
        public static function get_reserved_seats( $chart_id = false )
        {
            $post_status = TC_Seat_Chart::get_reserved_order_statuses();
            if ( !is_array( $post_status ) ) {
                $post_status = array( $post_status );
            }
            if ( !$chart_id ) {
                return;
            }
            $args = array(
                'post_type'      => 'tc_tickets_instances',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'meta_key'       => 'chart_id',
                'meta_value'     => (string) $chart_id,
                'no_found_rows'  => true,
            );
            $tickets_instances = get_posts( $args );
            ?>
            <script type="text/javascript">
                if ( typeof tc_reserved_seats == "undefined" ) {
                    var tc_reserved_seats = new Array();
                }
                tc_reserved_seats[<?php 
            echo  $chart_id ;
            ?>] = new Array(); <?php 
            $i = 0;
            foreach ( $tickets_instances as $ticket_instance ) {
                
                if ( in_array( get_post_status( $ticket_instance->post_parent ), $post_status ) ) {
                    $seat_id = get_post_meta( $ticket_instance->ID, 'seat_id', true );
                    
                    if ( $seat_id ) {
                        ?>
                            tc_reserved_seats[<?php 
                        echo  $chart_id ;
                        ?>][ '<?php 
                        echo  $seat_id ;
                        ?>' ] = 1;
                        <?php 
                    }
                    
                    $i++;
                }
            
            }
            ?>
            </script>
        <?php 
        }
        
        /**
         * Get the formatted seats cookie data.
         * This data will be forwarded to the js scripts global variable.
         *
         * @param $chart_id
         * @return array
         */
        public static function get_in_cart_seats_format( $chart_id )
        {
            $tc_in_cart_seats = [];
            foreach ( TC_Seat_Chart::get_cart_seats_cookie() as $in_cart_ticket_type ) {
                foreach ( $in_cart_ticket_type as $in_cart_seat ) {
                    // Check if any of the ticket types which belong to the current chart_id is in the cart
                    if ( $in_cart_seat[2] == $chart_id ) {
                        $tc_in_cart_seats[$chart_id][$in_cart_seat[0]] = 1;
                    }
                }
            }
            return $tc_in_cart_seats;
        }
        
        /**
         * Get seats which are in the cart of current user
         *
         * @param bool $chart_id
         * @return void
         * @global type $tc
         */
        public static function get_in_cart_seats( $chart_id = false )
        {
            if ( !$chart_id ) {
                return;
            }
            $tc_in_cart_seats = self::get_in_cart_seats_format( $chart_id );
            ?>
            <script type="text/javascript">
                if (typeof tc_in_cart_seats == "undefined") {
                    var tc_in_cart_seats = [];
                }
                tc_in_cart_seats[<?php 
            echo  $chart_id ;
            ?>] = []; // Initialize tc_in_cart_seats with callback empty array.
                tc_in_cart_seats = <?php 
            echo  json_encode( $tc_in_cart_seats ) ;
            ?>;
            </script>
            <?php 
            // Open PHP for succeeding source codes
        }
        
        /**
         * Checks if ticket type is product or product variation (WooCommerce)
         *
         * @param type $ticket_type_id
         * @return boolean
         */
        public static function is_woo_variable_product( $ticket_type_id )
        {
            
            if ( function_exists( 'wc_get_product' ) ) {
                $product = wc_get_product( $ticket_type_id );
                return ( $product && $product->is_type( 'variable' ) ? true : false );
            }
        
        }
        
        public static function qty_left( $ticket_type_id )
        {
            
            if ( function_exists( 'wc_get_product' ) ) {
                $product = wc_get_product( $ticket_type_id );
                
                if ( $product ) {
                    $qty = $product->get_stock_quantity();
                    return ( is_numeric( $qty ) ? $product->get_stock_quantity() : 999 );
                } else {
                    
                    if ( function_exists( 'tc_get_tickets_count_left' ) ) {
                        $qty = tc_get_tickets_count_left( $ticket_type_id );
                        $qty = ( !is_numeric( $qty ) ? 1 : $qty );
                        return $qty;
                    }
                
                }
            
            } else {
                
                if ( function_exists( 'tc_get_tickets_count_left' ) ) {
                    $qty = tc_get_tickets_count_left( $ticket_type_id );
                    $qty = ( !is_numeric( $qty ) ? 1 : $qty );
                    return $qty;
                }
            
            }
            
            return 1;
        }
        
        /**
         * Shows floor map on the front-end
         * @global boolean $tc_seats_defined
         * @param type $seat_map_post_id
         */
        public static function get_occupied_seats_front( $seat_map_post_id )
        {
            $seats = get_post_meta( $seat_map_post_id, 'tc_seat_cords', true );
            $seats = explode( '|', $seats );
            $seat_ticket_types = get_post_meta( $seat_map_post_id, 'tc_seat_ticket_types', true );
            $seat_ticket_types = explode( '|', $seat_ticket_types );
            $seat_signs = get_post_meta( $seat_map_post_id, 'tc_seat_signs', true );
            $seat_signs = explode( '|', $seat_signs );
            $seat_directions = get_post_meta( $seat_map_post_id, 'tc_seat_directions', true );
            $seat_directions = explode( '|', $seat_directions );
            ?>
            <script type="text/javascript" >
                if (typeof tc_seats == "undefined") {
                    var tc_seats = new Array();
                }
                tc_seats[<?php 
            echo  $seat_map_post_id ;
            ?>] = new Array();
                <?php 
            $i = 0;
            $has_seat_signs = ( is_array( $seat_signs ) && count( $seat_signs ) > 0 && !empty($seat_signs) ? true : false );
            $has_seat_direction = ( is_array( $seat_directions ) && count( $seat_directions ) > 0 && !empty($seat_directions) ? true : false );
            foreach ( $seats as $seat ) {
                
                if ( !empty($seat) ) {
                    $seat_sign_val = ( $has_seat_signs && isset( $seat_signs[$i] ) ? $seat_signs[$i] : '' );
                    $seat_direction_val = ( $has_seat_direction && isset( $seat_directions[$i] ) ? $seat_directions[$i] : 'bc' );
                    ?>tc_seats[<?php 
                    echo  $seat_map_post_id ;
                    ?>][ '<?php 
                    echo  $seat ;
                    ?>' ] = new Array(<?php 
                    echo  $seat_ticket_types[$i] ;
                    ?>, <?php 
                    echo  '"' . $seat_sign_val . '"' ;
                    ?>, <?php 
                    echo  ( TC_Seat_Chart::is_woo_variable_product( $seat_ticket_types[$i] ) ? 1 : 0 ) ;
                    ?>, <?php 
                    echo  '"' . $seat_direction_val . '"' ;
                    ?>);<?php 
                    $i++;
                }
            
            }
            ?>
                if (typeof tc_seat_colors == "undefined") {
                    var tc_seat_colors = new Array();
                }
                <?php 
            $unique_ticket_types = array_unique( $seat_ticket_types );
            $i = 0;
            foreach ( $unique_ticket_types as $unique_ticket_type ) {
                
                if ( !empty($unique_ticket_type) ) {
                    $seat_color_default = apply_filters( 'tc_seat_color_default', '#6b5f89' );
                    $seat_color = get_post_meta( $unique_ticket_type, '_seat_color', true );
                    if ( empty($seat_color) ) {
                        $seat_color = $seat_color_default;
                    }
                    ?>
                tc_seat_colors[ '<?php 
                    echo  $unique_ticket_type ;
                    ?>' ] = "<?php 
                    echo  $seat_color ;
                    ?>";
                <?php 
                    $i++;
                }
            
            }
            ?>
            </script>
            <?php 
        }
        
        public static function get_occupied_seats_front_php( $seat_map_post_id )
        {
            $seats = get_post_meta( $seat_map_post_id, 'tc_seat_cords', true );
            $seats = explode( '|', $seats );
            $seat_ticket_types = get_post_meta( $seat_map_post_id, 'tc_seat_ticket_types', true );
            $seat_ticket_types = explode( '|', $seat_ticket_types );
            $seat_signs = get_post_meta( $seat_map_post_id, 'tc_seat_signs', true );
            $seat_signs = explode( '|', $seat_signs );
            $seat_directions = get_post_meta( $seat_map_post_id, 'tc_seat_directions', true );
            $seat_directions = explode( '|', $seat_directions );
            $tc_seats = array();
            $i = 0;
            $has_seat_signs = ( is_array( $seat_signs ) && count( $seat_signs ) > 0 && !empty($seat_signs) ? true : false );
            $has_seat_direction = ( is_array( $seat_directions ) && count( $seat_directions ) > 0 && !empty($seat_directions) ? true : false );
            foreach ( $seats as $seat ) {
                
                if ( !empty($seat) ) {
                    $seat_sign_val = ( $has_seat_signs && isset( $seat_signs[$i] ) ? $seat_signs[$i] : '' );
                    $seat_direction_val = ( $has_seat_direction && isset( $seat_directions[$i] ) ? $seat_directions[$i] : 'bc' );
                    $tc_seats[$seat] = array(
                        $seat_ticket_types[$i],
                        $seat_sign_val,
                        ( TC_Seat_Chart::is_woo_variable_product( $seat_ticket_types[$i] ) ? 1 : 0 ),
                        $seat_direction_val
                    );
                    $i++;
                }
            
            }
            $tc_seat_colors = array();
            $unique_ticket_types = array_unique( $seat_ticket_types );
            $i = 0;
            foreach ( $unique_ticket_types as $unique_ticket_type ) {
                
                if ( !empty($unique_ticket_type) ) {
                    $seat_color_default = apply_filters( 'tc_seat_color_default', '#6b5f89' );
                    $seat_color = get_post_meta( $unique_ticket_type, '_seat_color', true );
                    if ( empty($seat_color) ) {
                        $seat_color = $seat_color_default;
                    }
                    $tc_seat_colors[$unique_ticket_type] = $seat_color;
                    $i++;
                }
            
            }
            return array( $tc_seats, $tc_seat_colors );
        }
        
        /**
         * Seat Sign metabox
         */
        public static function show_seat_sign_settings_metabox()
        {
            ?>
            <div class="tc_box_overlay"><span><?php 
            _e( 'Select assigned seats and add seat labels.', 'tcsc' );
            ?></span></div>
            <div class="tc_seat_sign_settings_single_holder">
                <label><?php 
            _e( 'Label', 'tcsc' );
            ?>
                    <input type="text" value="" id="tc_seat_sign_settings_single_seat_row_sign">
                </label>
                <?php 
            TC_Seat_Chart::render_field( array(
                'field_type' => 'button',
                'field_name' => 'tc_seat_sign_settings_single_set_button',
                'text'       => __( 'Set', 'tcsc' ),
                'type'       => 'primary',
            ) );
            ?>
            </div>
            <div class="tc_seat_sign_settings_multi_holder">
                <label class="tc_seat_label_one_third"><?php 
            _e( 'Row Label', 'tcsc' );
            ?>
                    <input type="text" value="" id="tc_seat_sign_settings_multi_seat_row_sign">
                </label>
                <label class="tc_seat_label_two_third"><?php 
            _e( 'Col Label (from - to)', 'tcsc' );
            ?><br />
                    <input type="text" value="" placeholder="<?php 
            _e( 'From', 'tcsc' );
            ?>" id="tc_seat_sign_settings_multi_seat_col_sign_from">
                    <span class="tc_col_label_invert">↔</span>
                    <input type="text" value="" placeholder="<?php 
            _e( 'To', 'tcsc' );
            ?>" id="tc_seat_sign_settings_multi_seat_col_sign_to">
                </label>
                <?php 
            TC_Seat_Chart::render_field( array(
                'field_type' => 'button',
                'field_name' => 'tc_seat_sign_settings_multi_set_button',
                'text'       => __( 'Set', 'tcsc' ),
                'type'       => 'primary',
            ) );
            ?>
            </div>
            <br clear="all" />
            <?php 
        }
        
        /**
         * Seat Sign metabox
         */
        public static function show_seat_direction_settings_metabox()
        {
            ?>
            <div class="tc_box_overlay"><span><?php 
            _e( 'Select assigned seats and set their direction.', 'tcsc' );
            ?></span></div>

            <div class="tc_seat_direction_holder">
                <div class="tc_seat_direction_box tl"><span>↑</span></div>
                <div class="tc_seat_direction_box tc"><span>↑</span></div>
                <div class="tc_seat_direction_box tr"><span>↑</span></div>

                <div class="tc_seat_direction_box lc"><span>←</span></div>
                <div class="tc_seat_direction_box blank"><span>☼</span></div>
                <div class="tc_seat_direction_box rc"><span>→</span></div>

                <div class="tc_seat_direction_box bl"><span>↓</span></div>
                <div class="tc_seat_direction_box bc tc-selected-direction"><span>↓</span></div>
                <div class="tc_seat_direction_box br"><span>↓</span></div>
            </div>
            <input type="hidden" value="bc" id="tc_seat_direction_settings_value"><!--<p class="tc_seat_sign_settings_message"><?php 
            _e( 'Select one or more seats which have assigned ticket type in order to set seat(s) sign.', 'tcsc' );
            ?></p>-->
            <br clear="all" />
            <?php 
        }
        
        public static function show_add_seats_metabox()
        {
            ?>
            <label class="tc_seat_label_two_third">
                <input type="text" value="10" placeholder="<?php 
            _e( 'Rows', 'tcsc' );
            ?>" id="tc_seat_add_seats_rows">
                <input type="text" value="10" placeholder="<?php 
            _e( 'Cols', 'tcsc' );
            ?>" id="tc_seat_add_seats_cols">
            </label>
            <?php 
            TC_Seat_Chart::render_field( array(
                'field_type' => 'button',
                'field_name' => 'tc_add_seats_button',
                'text'       => __( 'Create', 'tcsc' ),
                'type'       => 'primary',
            ) );
        }
        
        /**
         * Ticket type settings metabox
         */
        public static function show_ticket_type_settings_metabox()
        {
            ?>
            <div class="ticket_type_id_wrapper">
                <label><?php 
            _e( 'Ticket Type', 'tcsc' );
            ?>
                    <select name="ticket_type_id" id="ticket_type_id">
                        <option value=""><?php 
            _e( 'Loading...', 'tcsc' );
            ?></option>
                    </select>
                </label>
            </div>
            <?php 
            TC_Seat_Chart::render_field( array(
                'field_type' => 'button',
                'field_name' => 'tc_seat_chart_unset_ticket_type_settings_button',
                'text'       => __( 'Unset', 'tcsc' ),
                'type'       => 'secondary',
            ) );
            TC_Seat_Chart::render_field( array(
                'field_type' => 'button',
                'field_name' => 'tc_seat_chart_change_ticket_type_settings_button',
                'text'       => __( 'Set', 'tcsc' ),
                'type'       => 'primary',
            ) );
            ?>
            <br clear="all" />
            <?php 
        }
        
        public static function set_event_ticket_types_colors( $event_id = false, $front = false )
        {
            
            if ( $event_id && !empty($event_id) ) {
                $event_id = get_post_meta( $event_id, 'event_name', true );
                $args = array(
                    'post_type'      => 'tc_tickets',
                    'post_status'    => 'any',
                    'posts_per_page' => -1,
                    'meta_key'       => 'event_name',
                    'meta_value'     => (string) $event_id,
                    'orderby'        => 'post_title',
                    'order'          => 'ASC',
                    'no_found_rows'  => true,
                );
                $args = apply_filters( 'tc_get_event_ticket_types_args', $args );
                $ticket_types = apply_filters(
                    'tc_get_event_ticket_types',
                    get_posts( $args ),
                    $event_id,
                    false
                );
                $ticket_type_colors = '';
                $ticket_types_colors_script = '';
                foreach ( $ticket_types as $ticket_type ) {
                    $seat_color_default = apply_filters( 'tc_seat_color_default', '#6b5f89' );
                    $seat_color = get_post_meta( $ticket_type->ID, '_seat_color', true );
                    if ( empty($seat_color) ) {
                        $seat_color = $seat_color_default;
                    }
                    $ticket_type_colors .= 'tc_seat_default_colors[' . $ticket_type->ID . '] = "' . $seat_color . '";';
                }
                $ticket_types_colors_script .= '<script type="text/javascript">
                var tc_seat_default_colors = new Array();';
                $ticket_types_colors_script .= $ticket_type_colors;
                if ( $front ) {
                    $ticket_types_colors_script .= '' . 'if (window.tc_controls !== null || window.tc_controls !== "undefined") {' . 'window.tc_controls.set_default_colors();' . '}';
                }
                $ticket_types_colors_script .= '</script>';
                echo  $ticket_types_colors_script ;
            }
        
        }
        
        /**
         * Shows select box with ticket types
         *
         * @return void
         */
        function get_event_ticket_types_select()
        {
            if ( !isset( $_POST['event_id'] ) ) {
                return;
            }
            $event_id = (int) $_POST['event_id'];
            $args = [
                'post_type'      => 'tc_tickets',
                'post_status'    => 'any',
                'posts_per_page' => -1,
                'meta_key'       => 'event_name',
                'meta_value'     => $event_id,
                'orderby'        => 'post_title',
                'order'          => 'ASC',
                'no_found_rows'  => true,
            ];
            $args = apply_filters( 'tc_get_event_ticket_types_args', $args );
            $ticket_types = apply_filters(
                'tc_get_event_ticket_types',
                get_posts( $args ),
                $event_id,
                false
            );
            
            if ( !$ticket_types ) {
                $ticket_type = new stdClass();
                $ticket_type->ID = null;
                $ticket_type->post_title = __( 'No ticket types available for this event', 'tcsc' );
                $ticket_types = [ $ticket_type ];
            }
            
            $ticket_type_colors = '';
            $ticket_types_html = '<select name="ticket_type_id" id="ticket_type_id" class="ticket_type_id">';
            foreach ( $ticket_types as $ticket_type ) {
                $ticket_type_id = $ticket_type->ID;
                $ticket_type_tile = $ticket_type->post_title;
                $ticket_type_title = apply_filters( 'tc_checkout_owner_info_ticket_title', $ticket_type_tile, $ticket_type_id );
                $ticket_types_html .= '<option value="' . esc_attr( $ticket_type_id ) . '">' . esc_attr( $ticket_type_title ) . '</option>';
                $seat_color_default = apply_filters( 'tc_seat_color_default', '#6b5f89' );
                $seat_color = get_post_meta( $ticket_type_id, '_seat_color', true );
                if ( empty($seat_color) ) {
                    $seat_color = $seat_color_default;
                }
                if ( $ticket_type_id ) {
                    $ticket_type_colors .= 'tc_seat_colors[' . $ticket_type_id . '] = "' . $seat_color . '";';
                }
            }
            $ticket_types_html .= '</select>';
            $ticket_types_html .= '<script type="text/javascript"> var tc_seat_colors = new Array();' . $ticket_type_colors . '</script>';
            echo  $ticket_types_html ;
            exit;
        }
    
    }
    /*if (!function_exists('is_plugin_active_for_network')) {
              require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
          }
      
      if( seatings_fs_is_parent_active_and_loaded() && seatings_fs()->can_use_premium_code() ){
          if (is_multisite() && is_plugin_active_for_network(plugin_basename(__FILE__))) {
      
              function tc_seat_chart_load() {
                  global $TC_Seat_Chart;
                  $TC_Seat_Chart = new TC_Seat_Chart();
              }
              add_action('tets_fs_loaded', 'tc_seat_chart_load');
      
          } else {
              $TC_Seat_Chart = new TC_Seat_Chart();
          }
        }*/
    $TC_Seat_Chart = new TC_Seat_Chart();
}
