<?php
/**
 * Integrates Woocommerce gutenberg blocks.
 * https://github.com/woocommerce/woocommerce-blocks/blob/trunk/docs/third-party-developers/extensibility/checkout-block/integration-interface.md#getting-data-added-in-get_script_data
 * https://github.com/woocommerce/woocommerce-blocks/blob/trunk/docs/third-party-developers/extensibility/checkout-block/available-filters.md
 * https://github.com/woocommerce/woocommerce-blocks/blob/trunk/packages/checkout/filter-registry/README.md
 *
 * Dependencies:
 * @woocommerce/settings
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

if ( ! class_exists( 'TCSC_Woocommerce_Cart_Block_Integration' ) ) {

    class TCSC_Woocommerce_Cart_Block_Integration implements IntegrationInterface {

        /**
         * @inheritDoc
         */
        public function get_name() {
            global $TC_Seat_Chart;
            return $TC_Seat_Chart->name;
        }

        /**
         * @inheritDoc
         */
        public function initialize() {
            global $TC_Seat_Chart;
            // wp_register_script( $TC_Seat_Chart->name . '-woocommerce-cart-block', plugins_url( '../../../build/index.js', __FILE__ ), [ 'jquery' ], $TC_Seat_Chart->version );
            // wp_register_script( $TC_Seat_Chart->name . '-woocommerce-cart-block', plugins_url( '../../../assets/js/blocks/woocommerce-cart.js', __FILE__ ), [ 'jquery' ], $TC_Seat_Chart->version );
        }

        /**
         * @inheritDoc
         */
        public function get_script_handles() {
            global $TC_Seat_Chart;
            return array( $TC_Seat_Chart->name . '-woocommerce-cart-block' );
        }

        /**
         * @inheritDoc
         */
        public function get_editor_script_handles() {
            global $TC_Seat_Chart;
            return array( $TC_Seat_Chart->name . '-woocommerce-cart-block' );
        }

        /**
         * @inheritDoc
         */
        public function get_script_data() {
            return [ 'expensive_data_calculation' => 'test' ];
        }
    }
}
