jQuery(document).ready(function ($) {

    const tc_front = {

        /**
         * Get inset property
         *
         * @param allStyle
         * @returns {undefined|*}
         */
        getInsetStyle: function( allStyle ) {
            let styles = allStyle.split( '; ' );
            for ( let i = 0; i < styles.length; i++ ) {
                let astyle = styles[i].split( ': ' );
                if ( 'inset' == astyle[0] ){
                    return astyle[1];
                }
            }
            return undefined;
        },

        /**
         * Add/Update cart for Seating Chart items.
         *
         * @param action
         */
        update_cart_seats: function( action ) {

            var button = $( '#tc-regular-modal button.tc_cart_button' ),
                selected_seat = $( '.ui-selected' ),
                ticket_type_id = button.parent().find( '.tc_regular_modal_ticket_type_id' ).val(),
                color = $( 'li.tt_' + ticket_type_id ).css( 'color' );

            let quantity = $( '.model_extras .tc_quantity_selector' ).val(),
                get_href_value = $( '.tc-checkout-button' ).attr( 'href' ),
                tc_seat_cart_items = [],
                tc_seat_cart_items_firebase = [];

            switch ( action ) {

                case 'add':
                    button.html( tc_seat_chart_ajax.tc_adding_to_cart_title );
                    break;

                case 'update':
                    button.html( tc_seat_chart_ajax.tc_updating_cart_title );
                    break;
            }

            button.prop( 'disabled', true );
            selected_seat.addClass( 'tc_seat_in_cart' );
            $( '.tc-checkout-button' ).removeAttr( 'href' );
            $( '.tc-checkout-button' ).attr( 'style', 'opacity: 0.4;' );

            if ( typeof quantity === 'undefined' ) {
                quantity = 1;
            }

            let chart_id = button.parent().find( '.tc_regular_modal_seating_chart_id' ).val(),
                seat_id = button.parent().find( '.tc_regular_modal_seat_id' ).val(),
                seat_label = $( '#tc-regular-modal .tc_regular_modal_seat_label' ).html(),
                seat = ticket_type_id + '-' + seat_id + '-' + seat_label.replace( /-/g, '—' ) + '-' + chart_id, // Replace hyphen with long hyphen.
                seat_firebase = chart_id + '-' + seat_id + '-' + ticket_type_id,
                is_standee = selected_seat.hasClass( 'tc-object-selectable' );

            tc_seat_cart_items.push( seat );
            tc_seat_cart_items_firebase.push( seat_firebase );

            // For non-standee elements only
            if ( 1 == tc_seat_chart_ajax.tc_check_firebase && ! is_standee ) {
                $.post(tc_seat_chart_ajax.ajaxUrl, { action: 'tc_add_seat_to_firebase_cart', tc_seat_cart_items: tc_seat_cart_items_firebase }, function ( data ) {});
            }

            $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_update_cart_seats', tc_seat_cart_items: tc_seat_cart_items, tc_quantity: quantity }, function ( response ) {

                if ( response ) {
                    $( '#tc-regular-modal .tc_cart_button' ).prop( 'disabled', false );
                    $( '.ui-dialog-content' ).dialog( 'close' );
                    $( '.tc-seatchart-subtotal strong' ).html( response.total );
                    $( '.tc-seatchart-in-cart-count' ).val( response.in_cart_count );
                    $( '.tc-checkout-button' ).attr( 'href', get_href_value );
                    $( '.tc-checkout-button' ).attr( 'style', 'opacity: 1; cursor: pointer;' );

                    if ( 'removed' == response.action ) {
                        selected_seat.removeClass( 'tc_seat_in_cart' );
                        selected_seat.css( { 'background-color': color, 'color': color } );
                    }
                }

                button.prop( 'disabled', false );
                tc_mark_in_cart_seat();
            });
        }
    }

    /**
     * Set legend invisible when on phone
     */
    function tc_legend_set() {

        if ( $( '.tc-legend-arrow' ).hasClass( 'tc-legend-open' ) ) {
            var tc_seating_legend = $( '.tc-seating-legend-wrap' ).outerWidth();
            $( ".tc-seating-legend-wrap" ).css( 'left', -Math.abs( tc_seating_legend ) );
        }

        var get_window_width = $( this ).width();

        if ( get_window_width < 780 ) {
            var tc_seating_legend = $( '.tc-seating-legend-wrap' ).outerWidth();
            $( ".tc-seating-legend-wrap" ).animate( {
                left: -Math.abs( tc_seating_legend ),
            }, 0, function() {
                // Animation complete.
            } );

            $( '.tc-legend-arrow' ).removeClass( 'tc-legend-close' );
            $( '.tc-legend-arrow' ).addClass( 'tc-legend-open' );

        }
    }

    $('body').on('click', '.tc_seating_map_button', function (e) {

        $('.tc_seating_map').html('');
        $('.tc-modal-wrap').remove();

        let seating_map_id = $(this).data('seating-map-id'),
            show_legend = $(this).data('show_legend'),
            button_title = $(this).data('button_title'),
            subtotal_title = $(this).data('subtotal_title'),
            cart_title = $(this).data('cart_title'),
            seating_map_html = $('.tc_seating_map_' + seating_map_id).html();

        $( window ).on( 'resize', function( e ) {
            tc_controls.centerPoint();
        } );

        $('.tc_seating_map_' + seating_map_id).css({
            position: 'fixed',
            top: 0,
            right: 0,
            bottom: 0,
            left: 0,
            zIndex: 999999,
            display: 'block'
        });

        $('body').prepend('<div class="tc-chart-preloader"><div class="tc-loader"></div></div>');
        $( 'body' ).addClass( 'tcsc-disabled' );

        $.post(tc_common_vars.ajaxUrl, {
            action: "tc_load_seating_map",
            chart_id: seating_map_id,
            show_legend: show_legend,
            button_title: button_title,
            subtotal_title: subtotal_title,
            cart_title: cart_title

        }, function (data) {

            let body = $( 'body' );
            if ( ! body.hasClass( 'single-tc_seat_charts' ) ) {
                body.addClass( 'single-tc_seat_charts' );
            }

            $('.tc_seating_map_' + seating_map_id).html(data);
            $('html').css('overflow', 'hidden');

            function tc_cart_hover() {
                var tc_ticket_cart_height = $('.tc-tickets-cart').height();
                $('.tc-tickets-cart').css('bottom', tc_ticket_cart_height * -1);
            }

            // Mark Seats
            tc_mark_in_cart_seats(seating_map_id);
            tc_mark_reserved_seats(seating_map_id);
            tc_mark_reserved_standings(seating_map_id);
            tc_mark_unavailable_seats(seating_map_id);
            tc_mark_blocked_seats(seating_map_id);

            // Remove Unneeded Classes
            $('.tc-group-wrap').removeClass('ui-draggable');
            $(".tc-group-wrap *").removeClass('ui-draggable-handle');
            $(".tc-group-wrap").find('.tc-group-controls').remove();
            $(".tc-group-wrap").find('.ui-rotatable-handle').remove();
            $(".tc-group-wrap").find('.ui-resizable-handle').remove();
            $(".tc-group-wrap").find('.ui-resizable-autohide').removeClass('ui-resizable-autohide');
            $(".tc-group-wrap").find('.ui-resizable').removeClass('ui-resizable');

            // Selectables
            tc_front_selectables();

            // Set Wrapper Height
            tc_controls.set_wrapper_height();

            // Initialize Zoom Slider
            $(".tc-zoom-slider").slider({
                value: tc_common_vars.front_zoom_level,
                orientation: "horizontal",
                min: 0.30,
                max: 1,
                step: 0.10,
                slide: function (event, ui) {
                    var init_zoom = window.tc_seat_zoom_level;
                    $(this).parent().find('.tc-slider-value').val(ui.value);
                    window.tc_seat_zoom_level = ui.value;
                    tc_controls.zoom();
                },
                create: function (event, ui) {
                    var bar = $(this).slider('value');
                    $(this).parent().find('.tc-slider-value').val(bar);
                }
            });

            // Make sure to always replace inset property with the general top, right, bottom, left properties
            $.each( $( '.tc-group-wrap' ), function () {

                let getStyle = $(this).attr( 'style' ),
                    element = tc_front.getInsetStyle( getStyle );

                if ( element !== undefined ) {

                    let value = element.split(' '),
                        topPosition = value[0] ? value[0] : 'auto',
                        rightPosition = value[1] ? value[1] : 'auto',
                        bottomPosition = value[2] ? value[2] : 'auto',
                        leftPosition = value[3] ? value[3] : 'auto',
                        removeTrail = leftPosition.replace( ';', '' );

                    $(this).css( { 'inset': '', 'top': topPosition, 'left': removeTrail } );
                }
            });

            // Init Controls
            tc_controls.init();
            window.dispatchEvent(new Event('resize'));

            $('.tc-chart-preloader').remove();
            $( 'body' ).removeClass( 'tcsc-disabled' );
            tc_controls.tc_legend_set();
        });

        /**
         * Validates in cart data when proceeding to cart page
         */
        $('body').on('click', '.tc-checkout-button', function( event ) {
            tc_check_minimum_tickets( event );
        });
    });

    /**
     * Add seat to cart.
     * Update seats in cart.
     *
     * @since 0.76
     */
    $('body').on('click', '#tc-regular-modal .tc_cart_button', function (e) {
        let action = $( this ).attr( 'data-action' );
        tc_front.update_cart_seats( action );
    });

    /**
     * Standee modal "Remove from cart"
     *
     * @since 0.76
     */
    $( 'body' ).on( 'click', '#tc-remove-from-cart', function ( e ) {
        e.preventDefault();
        $( '.model_extras .tc_quantity_selector' ).val( 0 )
        tc_front.update_cart_seats( 'update' );
    });

    $('body').on('click', '#tc-modal-added-to-cart .tc_remove_from_cart_button', function (e) {
        tc_seat_chart_remove_from_cart($(this));
    });

    /**
     * Remove seat from cart
     *
     * @param button
     */
    function tc_seat_chart_remove_from_cart( button ) {

        button.prop( 'disabled', true );
        $( '#tc-modal-added-to-cart button.tc_remove_from_cart_button' ).html( tc_seat_chart_ajax.tc_removing_from_cart_title );

        let selected_seat = $( '.ui-selected' ),
            ticket_type = selected_seat.attr( 'data-tt-id' ),
            color = $( 'li.tt_' + ticket_type ).css( 'color' ),
            chart_id = button.parent().find( '.tc_regular_modal_seating_chart_id' ).val(),
            ticket_type_id = button.parent().find( '.tc_regular_modal_ticket_type_id' ).val(),
            seat_id = button.parent().find( '.tc_regular_modal_seat_id' ).val(),
            is_standee = selected_seat.hasClass( 'tc-object-selectable' ),
            tcsc_seat = chart_id + '-' + seat_id + '-' + ticket_type_id;

        selected_seat.removeClass( 'tc_seat_in_cart' );
        selected_seat.css( { 'background-color': color, 'color': color } );

        if ( 1 == tc_seat_chart_ajax.tc_check_firebase && !is_standee ) {
            $.post(tc_seat_chart_ajax.ajaxUrl, { action: "tc_remove_seat_from_firebase_cart", seat_id: seat_id, chart_id: chart_id }, function ( data ) {} );
        }

        $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_remove_seat_from_cart_ajax', tcsc_seat: tcsc_seat }, function ( response ) {

            if ( response ) {
                $( '#tc-modal-added-to-cart .tc_remove_from_cart_button' ).prop( 'disabled', false );
                $( '.ui-dialog-content' ).dialog('close' );
                $( '.tc-seatchart-subtotal strong' ).html( response.total );
                $( '.tc-seatchart-in-cart-count' ).val( response.in_cart_count );
                $( '#tc-modal-added-to-cart button.tc_remove_from_cart_button' ).html( tc_seat_chart_ajax.tc_remove_from_cart_button_title );
                tc_mark_in_cart_seat();
            }
        });
    }

    /**
     * Function checks if requirement of minimum tickets is met
     * @param event
     */
    function tc_check_minimum_tickets(event) {

        jQuery('.tc-seating-legend ul li.tc-ticket-listing').each(function () {

            var tc_min_tickets_per_order = jQuery(this).attr('data-min-tickets-per-order'),
                tc_max_tickets_per_order = jQuery(this).attr('data-max-tickets-per-order'),
                tc_ticket_type_id = jQuery(this).attr('data-ticket-type-id');

            if (tc_min_tickets_per_order != 0 || tc_max_tickets_per_order != 0 || tc_min_tickets_per_order != '' || tc_max_tickets_per_order != '') {

                i = 0;

                jQuery('.tc_seat_unit.tc_seat_in_cart').each(function () {
                    var tc_this_ticket_id = jQuery(this).attr('data-tt-id');

                    if (tc_ticket_type_id == tc_this_ticket_id) {
                        i++;
                    }

                });

                if (tc_min_tickets_per_order > i && i !== 0 && tc_min_tickets_per_order != '') {
                    $("#tc-ticket-requirements").dialog({
                        bgiframe: true,
                        closeOnEscape: false,
                        draggable: false,
                        resizable: false,
                        dialogClass: "no-close",
                        modal: true,
                        title: false,
                        closeText: "<i class='fa fa-times'></i>",
                        buttons: [
                            {
                                text: 'OK',
                                click: function () {
                                    $(this).dialog("close");
                                }
                            }
                        ]
                    });

                    event.preventDefault();

                    var tc_ticket_title = jQuery('.tt_' + tc_ticket_type_id).attr('data-tt-title');

                    jQuery('#tc-ticket-requirements').html(tc_seat_chart_ajax.tc_minimum_tickets_message + tc_ticket_title + tc_seat_chart_ajax.tc_minimum_tickets_message_is + tc_min_tickets_per_order + '!');

                }

                if (tc_max_tickets_per_order < i && i !== 0 && tc_max_tickets_per_order != '') {

                    $("#tc-ticket-requirements").dialog({
                        bgiframe: true,
                        closeOnEscape: false,
                        draggable: false,
                        resizable: false,
                        dialogClass: "no-close",
                        modal: true,
                        title: false,
                        closeText: "<i class='fa fa-times'></i>",
                        buttons: [
                            {
                                text: 'OK',
                                click: function () {
                                    $(this).dialog("close");

                                }
                            }
                        ]
                    });

                    event.preventDefault();

                    var tc_ticket_title = jQuery('.tt_' + tc_ticket_type_id).attr('data-tt-title');

                    jQuery('#tc-ticket-requirements').html(tc_seat_chart_ajax.tc_maximum_tickets_message + tc_ticket_title + tc_seat_chart_ajax.tc_minimum_tickets_message_is + tc_max_tickets_per_order + '!');

                }
            }
        });
    }

    /**
     * Call this method to display error dialog box
     * @param error_message
     */
    function display_error_dialog_box( error_message ) {

        // Display a dialog box with error message
        $("#tc-ticket-requirements").dialog({
            bgiframe: true,
            closeOnEscape: false,
            draggable: false,
            resizable: false,
            dialogClass: "no-close",
            modal: true,
            title: false,
            closeText: "<i class='fa fa-times'></i>",
            buttons: [ { text: 'OK', click: function () { $(this).dialog("destroy");  $(".tc-group-wrap *").removeClass('ui-selected'); } } ]
        });

        jQuery('#tc-ticket-requirements').html( error_message );
    }

    function tc_mark_in_cart_seat() {
        $.each($(".tc_seat_in_cart"), function () {
            $(this).css('background-color', tc_seat_chart_ajax.tc_in_cart_seat_color);
            $(this).css('color', tc_seat_chart_ajax.tc_in_cart_seat_color);
            $(this).addClass('tc_seat_in_cart');
            $(this).removeClass('ui-selected');
        });
    }

    /**
     * Mark in-cart seats on the specified chart
     *
     * @param {type} seat_chart_id
     * @returns {undefined}
     */
    function tc_mark_in_cart_seats( seat_chart_id ) {
        for (var k in tc_in_cart_seats[seat_chart_id]) {
            if (tc_in_cart_seats[seat_chart_id].hasOwnProperty(k)) {

                $('.tc_seating_map_' + seat_chart_id + ' #' + k).css('background-color', tc_seat_chart_ajax.tc_in_cart_seat_color);
                $('.tc_seating_map_' + seat_chart_id + ' #' + k).css('color', tc_seat_chart_ajax.tc_in_cart_seat_color);
                $('.tc_seating_map_' + seat_chart_id + ' #' + k).addClass('tc_seat_in_cart');
                $('.tc_seating_map_' + seat_chart_id + ' #' + k).removeClass('ui-selected ui-selectee');
            }
        }
    }

    /**
     * Mark reserved seats on the chart
     *
     * @param {type} seat_chart_id
     * @returns {undefined}
     */
    function tc_mark_reserved_seats( seat_chart_id ) {
        for ( var k in tc_reserved_seats[seat_chart_id] ) {
            if ( tc_reserved_seats[seat_chart_id].hasOwnProperty(k) ) {
                $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).css( 'background-color', tc_seat_chart_ajax.tc_reserved_seat_color );
                $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).css( 'color', tc_seat_chart_ajax.tc_reserved_seat_color );
                $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).addClass( 'tc_seat_reserved' );
                $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).removeClass( 'ui-selected ui-selectee tc_seat_in_cart' );
            }
        }
    }

    /**
     * Set default color for blocked seats in frontend.
     *
     * @param seat_chart_id
     */
    function tc_mark_blocked_seats( seat_chart_id ) {

        let show_as_reserved = tc_seat_chart_ajax.tc_show_as_reserved,
            blocked_seat_color = tc_seat_chart_ajax.tc_blocked_seat_color;

        if ( 'yes' == show_as_reserved ) {
            blocked_seat_color = tc_seat_chart_ajax.tc_reserved_seat_color;
        }

        $( '.tc_seating_map_' + seat_chart_id + ' .tc_blocked_seat' ).each( function() {
            $( this ).css( { 'background-color': blocked_seat_color, 'color' : blocked_seat_color } );
        });
    }

    function tc_mark_unavailable_seats(seat_chart_id) {
        $('.tc-seating-legend ul li.tc-ticket-listing').each(function () {

            var is_sales_available = $(this).attr('data-is-sales-available');
            var ticket_type_id = $(this).data('ticket-type-id');

            if (is_sales_available !== '1') {
                $('.tc_seat_unit, .tc-object-selectable, .tc-table-chair').each(function () {
                    var tc_this_ticket_id = $(this).attr('data-tt-id');
                    if (ticket_type_id == tc_this_ticket_id) {
                        $(this).css('background-color', tc_seat_chart_ajax.tc_unavailable_seat_color);
                        $(this).css('color', tc_seat_chart_ajax.tc_unavailable_seat_color);
                        $(this).addClass('tc_seat_unavailable');
                        $(this).removeClass('ui-selected ui-selectee');
                    }
                });
            }
        });
    }

    /**
     * Mark standee Seats as reserved
     *
     * @param seat_chart_id
     */
    function tc_mark_reserved_standings( seat_chart_id ) {

        $.each( $( '.tc-object-selectable' ), function () {
            let ticket_type_id = $( this ).data( 'tt-id' ),
                qty_left = $( '.tc-seating-legend .tt_' + ticket_type_id ).data( 'qty-left' );

            if ( 0 == qty_left ) {
                $( this ).css( 'background-color', tc_seat_chart_ajax.tc_reserved_seat_color );
                $( this ).addClass( 'tc_seat_reserved' );
                $( this ).removeClass( 'ui-selected ui-selectee tc_seat_in_cart' );
            }
        });
    }

    function tc_front_selectables() {

        $( '.ui-selectable' ).selectable({
            filter: '.tc_set_seat',
            cancel: '.tc_seat_reserved, .tc_blocked_seat, .tc_seat_in_others_cart, .tc_seat_unavailable, .tc-dragging',
            selected: function ( e, ui ) {

                /**
                 * Draggable add to cart/remove from cart modal
                 */
                // $( '.tc-modal-wrap' ).css( { top: 0, left: 0 } ).draggable();

                /**
                 * Disable modal while dragging
                 * @since 0.77
                 */
                // if ( window.tcsc.dragging ) {
                //     window.tcsc.dragging = false;
                //     return;
                // }

                var check_class = $( ui.selected ).attr( 'class' );

                if ( e.srcElement !== undefined ) {
                    var checkElement = e.srcElement;

                } else {
                    var checkElement = e.target;
                    checkElement.id = 'mozila';
                }

                if ( check_class.indexOf( 'tc_seat_unavailable ' ) == -1 && checkElement.id !== '' && checkElement.type !== 'mousemove' ) {

                    if ( $( ui.selected ).hasClass( 'tc_seat_in_others_cart' ) ) {
                        $( ui.selected ).removeClass( 'ui-selected' );
                    }

                    var selected = $( '.ui-selected' ).last(),
                        selected_seat_id = selected.attr( 'id' );

                    if ( ! selected.hasClass( 'tc_seat_reserved' )
                        && ! selected.hasClass( 'tc_blocked_seat' )
                        && typeof window.data_blocked_seats !== 'undefined'
                        && window.data_blocked_seats.indexOf( selected_seat_id ) == -1 ) {

                        var seating_chart_id = selected.closest( '.tc_seating_map' ).attr( 'data-seating-chart-id' ),
                            ticket_type = selected.attr( 'data-tt-id' ),
                            ticket_type_title = $( 'li.tt_' + ticket_type ).attr( 'data-tt-title' ),
                            ticket_type_price = $( 'li.tt_' + ticket_type ).attr( 'data-tt-price' ),
                            ticket_seat_number = selected.find( 'span p' ).html();

                        ticket_seat_number = ( typeof ticket_seat_number !== 'undefined' || ticket_seat_number ) ? ticket_seat_number.replace( /—/g, '-' ) : ''; // Replace long hyphen with regular dash.

                        if ( ! selected.hasClass( 'tc_seat_in_cart' ) || ( selected.hasClass( 'tc_seat_in_cart' ) && selected.hasClass( 'tc-object-selectable' ) ) ) {

                            $( '#tc-regular-modal .model_extras .tc_quantity_selector' ).remove();

                            if ( ( selected.hasClass( 'tc-object-selectable' ) ) ) {

                                $( '#tc-regular-modal button.tc_cart_button' ).hide();
                                $( '#tc-regular-modal .model_extras' ).html( tc_seat_chart_ajax.tc_loading_options_message );

                                $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_seat_chart_get_standing_area_options', seat_ticket_type_id: ticket_type, chart_id: seating_chart_id, seat_id: selected_seat_id }, function ( response ) {

                                    if ( typeof response !== 'undefined' ) {

                                        $( '#tc-regular-modal .model_extras' ).html( response.html );

                                        if ( response.update ) {
                                            $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'update' ).html( tc_seat_chart_ajax.tc_update_cart_button_title );

                                        } else {
                                            $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );
                                        }

                                        $( '#tc-regular-modal button.tc_cart_button' ).show();
                                    }
                                });

                                $( '#tc-regular-modal .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                $( '#tc-regular-modal .tc_regular_modal_seat_label' ).html( ticket_seat_number );
                                $( '#tc-regular-modal .tc_regular_modal_price' ).html( ticket_type_price );
                                $( '#tc-regular-modal .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                $( '#tc-regular-modal .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                $( '#tc-regular-modal .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                $( '#tc-regular-modal' ).dialog({
                                    resizable: false,
                                    draggable: false,
                                    height: "auto",
                                    width: 490,
                                    modal: true,
                                    close: function ( event, ui ) {
                                        $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                    }
                                });

                            } else {

                                $( '#tc-regular-modal button.tc_cart_button' ).show();
                                $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );

                                $( '#tc-regular-modal .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                $( '#tc-regular-modal .tc_regular_modal_seat_label' ).html( ticket_seat_number );
                                $( '#tc-regular-modal .tc_regular_modal_price' ).html( ticket_type_price );
                                $( '#tc-regular-modal .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                $( '#tc-regular-modal .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                $( '#tc-regular-modal .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                $( '#tc-regular-modal' ).dialog({
                                    dialogClass: 'tc-tickera-seating-modal',
                                    resizable: false,
                                    draggable: false,
                                    height: "auto",
                                    closeOnEscape: true,
                                    width: 490,
                                    modal: true,
                                    close: function ( event, ui ) {
                                        $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                    }
                                });
                            }

                        } else {

                            $( '#tc-modal-added-to-cart button.tc_cart_button' ).html( tc_seat_chart_ajax.tc_remove_from_cart_button_title );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_seat_label' ).html( ticket_seat_number );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_price' ).html( ticket_type_price );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                            $( '#tc-modal-added-to-cart .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                            $( '#tc-modal-added-to-cart' ).dialog({
                                dialogClass: 'tc-tickera-seating-modal',
                                resizable: false,
                                draggable: false,
                                height: "auto",
                                width: 490,
                                closeOnEscape: true,
                                modal: true,
                                close: function ( event, ui ) {
                                    $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                }
                            });
                        }
                    }
                }
            },

            selecting: function (e, ui) {

                if ( $( '.ui-selected, .ui-selecting' ).length > 1 ) {
                    $( '.ui-selecting' ).removeClass( 'ui-selecting' );
                }
            },
        });
    }
});
