( function( $ ) {

    window.tc_front_woo = {

        init: function() {},

        /**
         * Get inset property
         *
         * @param allStyle
         * @returns {undefined|*}
         */
        getInsetStyle: function( allStyle ) {
            let styles = allStyle.split( '; ' );
            for ( let i = 0; i < styles.length; i++ ) {
                let astyle = styles[i].split( ': ' );
                if ( 'inset' == astyle[0] ){
                    return astyle[1];
                }
            }
            return undefined;
        },

        /**
         * Add/Update cart for Seating Chart items.
         *
         * @param action
         */
        update_cart_seats: function( action, button ) {

            var selected_seat = $( '.ui-selected' ),
                wrapper = button.closest( '.tc-modal-wrap' ),
                ticket_type_id = wrapper.find( '.tc_regular_modal_ticket_type_id' ).val(),
                color = $( 'li.tt_' + ticket_type_id ).css( 'color' );

            let get_href_value = $( '.tc-checkout-button' ).attr( 'href' ),
                quantity = button.parent().find( '.model_extras .input-text.qty.text' ).val(),
                tc_seat_cart_items = [],
                tc_seat_cart_items_firebase = [];

            switch ( action ) {

                case 'add':
                    button.html( tc_seat_chart_ajax.tc_adding_to_cart_title );
                    break;

                case 'update':
                    button.html( tc_seat_chart_ajax.tc_updating_cart_title );
                    break;
            }

            button.prop( 'disabled', true );
            $( '.tc-checkout-button' ).removeAttr( 'href' );
            $( '.tc-checkout-button' ).attr( 'style', 'opacity: 0.4;' );

            if ( typeof quantity === 'undefined' ) {

                // Check if a quantity field from a variation form exists.
                quantity = $( '#tc-modal-woobridge .input-text.qty.text' ).val();
                if ( typeof quantity === 'undefined' ) {
                    quantity = 1;
                }
            }

            let chart_id = wrapper.find( '.tc_regular_modal_seating_chart_id' ).val(),
                seat_id = wrapper.find( '.tc_regular_modal_seat_id' ).val(),
                variation_id = wrapper.find( 'input[name="variation_id"]' ).val(),
                seat_label = wrapper.find( '.tc_regular_modal_seat_label' ).html(),
                seat = ticket_type_id + '-' + seat_id + '-' + seat_label.replace( /-/g, '—' ) + '-' + chart_id, // Replace hyphen with long hyphen.
                seat_firebase = chart_id + '-' + seat_id + '-' + ticket_type_id,
                is_standee = selected_seat.hasClass( 'tc-object-selectable' );

            tc_seat_cart_items.push( seat );
            tc_seat_cart_items_firebase.push( seat_firebase );

            // For non-standee elements only
            if ( 1 == tc_seat_chart_ajax.tc_check_firebase && !is_standee ) {
                $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_add_seat_to_firebase_cart', tc_seat_cart_items: tc_seat_cart_items_firebase }, function ( data ) {} );
            }

            $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_woo_update_cart_seats', tc_seat_cart_items: tc_seat_cart_items, variation_id: variation_id, quantity: quantity }, function ( response ) {

                if ( response ) {

                    // Refresh Woocommerce fragments
                    $( document.body ).trigger( 'wc_fragment_refresh' );

                    $( '.ui-dialog-content' ).dialog( 'close' );
                    $( '.tc-seatchart-subtotal' ).html( response.subtotal + '<strong>' + response.total + '</strong>' );
                    $( '.tc-seatchart-in-cart-count' ).val( response.in_cart_count );
                    $( '.tc-checkout-button' ).attr( 'href', get_href_value );
                    $( '.tc-checkout-button' ).attr( 'style', 'opacity: 1; cursor: pointer;' );

                    // Add mark to seat if successfully added onto cart
                    if ( false == response.error ) {
                        button.prop( 'disabled', false );
                        selected_seat.addClass( 'tc_seat_in_cart' );
                    }

                    if ( 'removed' == response.action ) {

                        if ( wrapper.find( '#tc-selected-variations li' ).length > 1 ) {
                            /*
                             * Remain selected/added-in-cart if standee element still have existing selected variations.
                             * Set the condition to > 1 since the selected variation container remains as is until the variation form is reloaded.
                             */

                        } else {

                            // Seats/Tables
                            selected_seat.removeClass( 'tc_seat_in_cart' );
                            selected_seat.css( { 'background-color': color, 'color': color } );
                        }
                    }
                }

                tc_front_woo.tc_mark_in_cart_seat();
            });
        },

        /**
         * Remove Seats from cart
         *
         * @param button
         */
        tc_seat_chart_remove_from_cart: function ( button ) {

            // Loading | "Removing from cart, please wait..."
            button.prop( 'disabled', true );
            $( '#tc-modal-added-to-cart button.tc_remove_from_cart_button' ).html( tc_seat_chart_ajax.tc_removing_from_cart_title );

            let selected_seat = $( '.ui-selected' ),
                ticket_type = selected_seat.attr( 'data-tt-id' ),
                color = $( 'li.tt_' + ticket_type ).css( 'color' );

            selected_seat.removeClass( 'tc_seat_in_cart' )
            selected_seat.css( { 'background-color': color } );
            selected_seat.css( { 'color': color } );

            let chart_id = $( '#tc-modal-added-to-cart .tc_regular_modal_seating_chart_id' ).val(),
                ticket_type_id = $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type_id' ).val(),
                seat_id = $( '#tc-modal-added-to-cart .tc_regular_modal_seat_id' ).val(),
                is_standee = selected_seat.hasClass( 'tc-object-selectable' ),
                tcsc_seat = chart_id + '-' + seat_id + '-' + ticket_type_id;

            if ( 1 == tc_seat_chart_ajax.tc_check_firebase && !is_standee ) {
                $.post(tc_seat_chart_ajax.ajaxUrl, { action: "tc_remove_seat_from_firebase_cart", seat_id: seat_id, chart_id: chart_id }, function ( data ) {} );
            }

            $.post(tc_seat_chart_ajax.ajaxUrl, { action: 'tc_remove_seat_from_cart_ajax', tcsc_seat: tcsc_seat }, function ( response ) {

                if ( response ) {

                    // Refresh Woocommerce fragments
                    $( document.body ).trigger( 'wc_fragment_refresh' );

                    $( '#tc-modal-added-to-cart .tc_remove_from_cart_button' ).prop( 'disabled', false );
                    $( '.ui-dialog-content' ).dialog( 'close' );
                    $( '.tc-seatchart-subtotal' ).html( response.subtotal + '<strong>' + response.total + '</strong>' );
                    $( '.tc-seatchart-in-cart-count' ).val( response.in_cart_count );
                    $( '#tc-modal-added-to-cart button.tc_remove_from_cart_button' ).html( tc_seat_chart_ajax.tc_remove_from_cart_button_title );
                    $( '#tc-regular-modal .tc_cart_button' ).prop( 'disabled', false).removeClass( 'tc-seat-error' );
                    tc_front_woo.tc_mark_in_cart_seat();
                }
            });
        },

        /**
         * Mark the seat that was successfully added to the cart
         */
        tc_mark_in_cart_seat: function () {
            $.each($(".tc_seat_in_cart"), function () {
                $(this).css('background-color', tc_seat_chart_ajax.tc_in_cart_seat_color);
                $(this).css('color', tc_seat_chart_ajax.tc_in_cart_seat_color);
                $(this).addClass('tc_seat_in_cart');
                $(this).removeClass('ui-selected');
            });
        },

        /**
         * Mark in-cart seats on the specified chart
         * @param {type} seat_chart_id
         * @returns {undefined}
         */
        tc_mark_in_cart_seats: function( seat_chart_id ) {
            for ( var k in tc_in_cart_seats[ seat_chart_id ] ) {
                if ( tc_in_cart_seats[ seat_chart_id ].hasOwnProperty( k ) ) {

                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k ).css( 'background-color', tc_seat_chart_ajax.tc_in_cart_seat_color );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k ).css( 'color', tc_seat_chart_ajax.tc_in_cart_seat_color );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k ).addClass( 'tc_seat_in_cart' );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k ).removeClass( 'ui-selected ui-selectee' );
                }
            }
        },

        /**
         * Mark reserved seats on the chart
         * @param {type} seat_chart_id
         * @returns {undefined}
         */
        tc_mark_reserved_seats: function( seat_chart_id ) {
            for ( var k in tc_reserved_seats[ seat_chart_id ] ) {
                if ( tc_reserved_seats[ seat_chart_id ].hasOwnProperty( k ) ) {
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).css( 'background-color', tc_seat_chart_ajax.tc_reserved_seat_color );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).css( 'color', tc_seat_chart_ajax.tc_reserved_seat_color );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).addClass( 'tc_seat_reserved' );
                    $( '.tc_seating_map_' + seat_chart_id + ' #' + k + ':not(.tc-object-selectable)' ).removeClass( 'ui-selected ui-selectee' );
                }
            }
        },

        tc_mark_unavailable_seats: function( seat_chart_id ) {

            $( '.tc-seating-legend ul li.tc-ticket-listing' ).each( function() {

                var is_sales_available = $( this ).attr( 'data-is-sales-available' ),
                    ticket_type_id = $( this ).data( 'ticket-type-id' );

                if ( is_sales_available !== '1' ) {
                    $( '.tc_seat_unit, .tc-object-selectable, .tc-table-chair' ).each( function() {
                        var tc_this_ticket_id = $( this ).attr( 'data-tt-id' );
                        if ( ticket_type_id == tc_this_ticket_id ) {
                            $( this ).css( 'background-color', tc_seat_chart_ajax.tc_unavailable_seat_color );
                            $( this ).css( 'color', tc_seat_chart_ajax.tc_unavailable_seat_color );
                            $( this ).addClass( 'tc_seat_unavailable' );
                            $( this ).removeClass( 'ui-selected ui-selectee' );
                        }
                    } );
                }
            } );
        },

        tc_mark_reserved_standings: function (seat_chart_id) {

            $.each($(".tc-object-selectable"), function () {
                var ticket_type_id = $(this).data('tt-id'),
                    qty_left = $('.tc-seating-legend .tt_' + ticket_type_id).data('qty-left');

                if (qty_left == 0) {
                    $(this).css('background-color', tc_seat_chart_ajax.tc_reserved_seat_color);
                    $(this).addClass('tc_seat_reserved');
                    $(this).removeClass('ui-selected ui-selectee');
                }
            });
        },

        tc_mark_blocked_seats: function ( seat_chart_id ) {

            let show_as_reserved = tc_seat_chart_ajax.tc_show_as_reserved,
                blocked_seat_color = tc_seat_chart_ajax.tc_blocked_seat_color;

            if ( 'yes' == show_as_reserved ) {
                blocked_seat_color = tc_seat_chart_ajax.tc_reserved_seat_color;
            }

            $( '.tc_seating_map_' + seat_chart_id + ' .tc_blocked_seat' ).each( function() {
                $( this ).css( { 'background-color': blocked_seat_color, 'color' : blocked_seat_color } );
            });
        },

        tc_front_selectables: function () {

            $( '.ui-selectable' ).selectable({
                filter: '.tc_set_seat',
                cancel: '.tc_seat_reserved, .tc_blocked_seat, .tc_seat_in_others_cart, .tc_seat_unavailable, .tc-dragging',
                selected: function ( e, ui ) {

                    /**
                     * Draggable add to cart/remove from cart modal
                     * To do: For some reasons, interaction in the mobile view is delayed
                     */
                    // $( '#tc-modal-woobridge' ).css( { top: 0, left: 0 } ).draggable( {});

                    /**
                     * Disable modal while dragging
                     * @since 0.77
                     */
                    // if ( window.tcsc.dragging ) {
                    //     window.tcsc.dragging = false;
                    //     return;
                    // }

                    if ( e.srcElement !== undefined ) {
                        var checkElement = e.srcElement,
                            originalElement = e.originalEvent;

                    } else {
                        var checkElement = e.target,
                            originalElement = e.target;

                        checkElement.id = 'mozila';
                    }

                    var check_class = $( ui.selected ).attr( 'class' );

                    if ( check_class.indexOf( 'tc_seat_unavailable' ) == -1 && checkElement.id !== '' && originalElement.type !== 'mousemove' ) {

                        if ( $( ui.selected ).hasClass( 'tc_seat_in_others_cart' ) ) {
                            $( ui.selected ).removeClass( 'ui-selected' );
                        }

                        var selected = $( '.ui-selected' ).last(),
                            selected_seat_id = selected.attr( 'id' );

                        if ( ! selected.hasClass( 'tc_seat_reserved' )
                            && ! selected.hasClass( 'tc_blocked_seat' )
                            && typeof window.data_blocked_seats !== 'undefined'
                            && window.data_blocked_seats.indexOf( selected_seat_id ) == -1 ) {

                            var seating_chart_id = selected.closest( '.tc_seating_map' ).attr( 'data-seating-chart-id' ),
                                ticket_type = selected.attr( 'data-tt-id' ),
                                ticket_type_title = $( 'li.tt_' + ticket_type ).attr( 'data-tt-title' ),
                                ticket_type_price = $( 'li.tt_' + ticket_type ).attr( 'data-tt-price' ),
                                is_variable = $( 'li.tt_' + ticket_type ).attr( 'data-is-variable' ),
                                ticket_seat_number = selected.find( 'span p' ).html(),
                                ticket_seat_label = '';

                            if ( typeof ticket_seat_number !== 'undefined' || ticket_seat_number ) {
                                ticket_seat_number = ticket_seat_number.replace( /-/g, '—' ); // Replace hyphen with long hyphen.
                                ticket_seat_label = ticket_seat_number.replace( /—/g, '-' ); // Replace long hyphen with regular dash.

                            } else {
                                ticket_seat_number = '';
                            }

                            $( '.model_extras .quantity' ).remove();

                            if ( '1' == is_variable ) {

                                if ( !selected.hasClass( 'tc_seat_in_cart' ) || ( selected.hasClass( 'tc_seat_in_cart' ) && selected.hasClass( 'tc-object-selectable' ) ) ) {

                                    /**
                                     * Variable Seat/Standee Modal.
                                     * @since 0.76
                                     */

                                    let is_standee = ( selected.hasClass( 'tc-object-selectable' ) ) ? 1 : 0;

                                    $( '#tc-modal-woobridge .tc-modal-woobridge-inner' ).html( tc_seat_chart_ajax.tc_loading_options_message );

                                    $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_seat_chart_get_wc_variations', seat_ticket_type_id: ticket_type, chart_id: seating_chart_id, seat_id: selected_seat_id, is_standee: is_standee }, function ( response ) {

                                        if ( typeof response !== 'undefined' ) {

                                            $( '#tc-modal-woobridge .tc-modal-woobridge-inner' ).html( response.html );
                                            $( '#tc-modal-woobridge .single_add_to_cart_button' ).addClass( 'disabled wc-variation-selection-needed' );

                                            // Update button label Add/Update label
                                            if ( typeof response.update !== 'undefined' ) {
                                                $( '#tc-modal-woobridge .wc-variation-selection-needed' ).addClass( 'tc_cart_button' ).attr( 'data-action', 'update' ).html( tc_seat_chart_ajax.tc_update_cart_button_title );

                                            } else {
                                                $( '#tc-modal-woobridge .wc-variation-selection-needed' ).addClass( 'tc_cart_button' ).attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );
                                            }

                                            // Hide quantity selector in regular seats variation form
                                            if ( ! selected.hasClass( 'tc-object-selectable' ) ) {
                                                $( '#tc-modal-woobridge .input-text.qty.text' ).hide();
                                            }

                                            let form = $( '#tc-modal-woobridge' ).find( '.variations_form' );

                                            if ( form ) {

                                                form.wc_variation_form();

                                                // Update quantity value
                                                if ( typeof response.quantity !== 'undefined' ) {
                                                    $( '#tc-modal-woobridge .input-text.qty.text' ).val( response.quantity );
                                                }

                                                // Update selected variation
                                                if ( typeof response.variation !== 'undefined' ) {
                                                    let attribute_key = response.variation[ 0 ],
                                                        attribute_value = response.variation[ 1 ];
                                                    $( '#tc-modal-woobridge select[name="' + attribute_key + '"]' ).val( attribute_value );
                                                }
                                            }
                                        }
                                    });

                                    $( '#tc-modal-woobridge .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                    $( '#tc-modal-woobridge .tc_regular_modal_seat_label' ).html( ticket_seat_label );
                                    $( '#tc-modal-woobridge .tc_regular_modal_price' ).html( ticket_type_price );
                                    $( '#tc-modal-woobridge .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                    $( '#tc-modal-woobridge .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                    $( '#tc-modal-woobridge .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                    $( '#tc-modal-woobridge' ).dialog({
                                        resizable: false,
                                        draggable: false,
                                        height: "auto",
                                        width: 490,
                                        modal: true,
                                        close: function ( event, ui ) {
                                            $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                        }
                                    });

                                } else {

                                    /**
                                     * Remove from cart dialog
                                     * @since 0.76
                                     */

                                    $( '#tc-modal-added-to-cart button.tc_cart_button' ).html( tc_seat_chart_ajax.tc_remove_from_cart_button_title );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_seat_label' ).html( ticket_seat_label );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_price' ).html( ticket_type_price );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                    $( '#tc-modal-added-to-cart .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                    $( '#tc-modal-added-to-cart' ).dialog({
                                        resizable: false,
                                        draggable: false,
                                        height: "auto",
                                        width: 490,
                                        modal: true,
                                        close: function ( event, ui ) {
                                            $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                        }
                                    });
                                }

                            } else {

                                /**
                                 * Simple Seats/Standee Modal
                                 * @since 0.76
                                 */

                                if ( ( selected.hasClass( 'tc-object-selectable' ) ) ) {

                                    $( '#tc-regular-modal button.tc_cart_button' ).hide();
                                    $( '#tc-regular-modal .model_extras' ).html( tc_seat_chart_ajax.tc_loading_options_message );

                                    $.post( tc_seat_chart_ajax.ajaxUrl, { action: 'tc_seat_chart_get_wc_standing_area_options', seat_ticket_type_id: ticket_type, chart_id: seating_chart_id, seat_id: selected_seat_id }, function ( response ) {

                                        if ( typeof response !== 'undefined' ) {

                                            $( '#tc-regular-modal .model_extras' ).html( response.html );

                                            if ( response.update ) {
                                                $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'update' ).html( tc_seat_chart_ajax.tc_update_cart_button_title );

                                            } else {
                                                $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );
                                            }

                                            $( '#tc-regular-modal button.tc_cart_button' ).show();
                                        }
                                    });

                                    $( '#tc-regular-modal .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                    $( '#tc-regular-modal .tc_regular_modal_seat_label' ).html( ticket_seat_label );
                                    $( '#tc-regular-modal .tc_regular_modal_price' ).html( ticket_type_price );
                                    $( '#tc-regular-modal .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                    $( '#tc-regular-modal .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                    $( '#tc-regular-modal .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );

                                    $( '#tc-regular-modal' ).dialog({
                                        resizable: false,
                                        draggable: false,
                                        height: "auto",
                                        width: 490,
                                        modal: true,
                                        close: function ( event, ui ) {
                                            $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                        }
                                    });

                                } else {

                                    if ( !selected.hasClass( 'tc_seat_in_cart' ) ) {

                                        $( '#tc-regular-modal button.tc_cart_button' ).show();
                                        $( '#tc-regular-modal button.tc_cart_button' ).attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );

                                        $( '#tc-regular-modal button.tc_cart_button' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );
                                        $( '#tc-regular-modal .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                        $( '#tc-regular-modal .tc_regular_modal_seat_label' ).html( ticket_seat_label );
                                        $( '#tc-regular-modal .tc_regular_modal_price' ).html( ticket_type_price );
                                        $( '#tc-regular-modal .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                        $( '#tc-regular-modal .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                        $( '#tc-regular-modal .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                        $( '#tc-regular-modal' ).dialog({
                                            resizable: false,
                                            draggable: false,
                                            height: "auto",
                                            width: 490,
                                            modal: true,
                                            close: function ( event, ui ) {
                                                $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                            }
                                        });

                                    } else {

                                        $( '#tc-modal-added-to-cart button.tc_cart_button' ).html( tc_seat_chart_ajax.tc_remove_from_cart_button_title );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type' ).html( ticket_type_title );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_seat_label' ).html( ticket_seat_label );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_price' ).html( ticket_type_price );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_seating_chart_id' ).val( seating_chart_id );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_ticket_type_id' ).val( ticket_type );
                                        $( '#tc-modal-added-to-cart .tc_regular_modal_seat_id' ).val( selected.attr( 'id' ) );
                                        $( '#tc-modal-added-to-cart' ).dialog({
                                            resizable: false,
                                            draggable: false,
                                            height: "auto",
                                            width: 490,
                                            modal: true,
                                            close: function ( event, ui ) {
                                                $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    }

                    // Check if seat is currently available or not
                    tc_front_woo.tc_validate_woo_seat_availability();
                },

                selecting: function ( e, ui ) {
                    if ( $( '.ui-selected, .ui-selecting' ).length > 1 ) {
                        $( '.ui-selecting' ).removeClass( 'ui-selecting' );
                    }
                },
            });
        },

        /**
         * Check for seat availability
         */
        tc_validate_woo_seat_availability: function () {

            // Initialize Variables
            let tc_seat_cart_items = [],
                button = $('#tc-regular-modal button.tc_cart_button'),
                standing_qty = button.parent().find('.model_extras .quantity .qty').val();

            $.each($(".ui-selected"), function () {

                let chart_id = button.parent().find('.tc_regular_modal_seating_chart_id').val(),
                    ticket_type_id = button.parent().find('.tc_regular_modal_ticket_type_id').val(),
                    seat_id = button.parent().find('.tc_regular_modal_seat_id').val(),
                    seat_label = $('#tc-regular-modal .tc_regular_modal_seat_label').html(),
                    seat = ticket_type_id + '-' + seat_id + '-' + seat_label.replace( /-/g, '—' ) + '-' + chart_id; // Replace hyphen with long hyphen.

                /*
                 * Not a regular item. Check if product is a variation
                 * When a concatenated seat with a string of '---', it is an indication that the selected seat was not detected.
                 */
                if ( '---' == seat ) {

                    chart_id = $('#tc-modal-woobridge .tc_regular_modal_seating_chart_id').val();
                    ticket_type_id = $('#tc-modal-woobridge .tc_regular_modal_ticket_type_id').val();
                    seat_id = $('#tc-modal-woobridge .tc_regular_modal_seat_id').val();
                    seat_label = $('#tc-modal-woobridge .tc_regular_modal_seat_label').html();
                    seat = ticket_type_id + '-' + seat_id + '-' + seat_label.replace( /-/g, '—' ) + '-' + chart_id; // Replace hyphen with long hyphen.
                }

                tc_seat_cart_items.push(seat);
            });

            if ( tc_seat_cart_items ) {
                $.post(tc_seat_chart_ajax.ajaxUrl, {action: "tc_validate_woo_seat_availability", tc_seat_cart_items: tc_seat_cart_items, standing_qty: standing_qty}, function ( response ) {

                    // Disable button if validation failed
                    if ( true == response.tc_error ) {

                        $('#tc-regular-modal .tc_cart_button').prop("disabled", true).addClass('tc-seat-error');
                        $('#tc-regular-modal button.tc_cart_button').html(response.tc_error_message);
                    }
                });
            }
        }
    }

    $( document ).ready( function() {

        $( 'body' ).on( 'click', '.tc_seating_map_button', function ( e ) {

            $('.tc_seating_map').html('');
            $('.tc-modal-wrap').remove();

            var seating_map_id = $(this).data('seating-map-id'),
                show_legend = $(this).data('show_legend'),
                button_title = $(this).data('button_title'),
                subtotal_title = $(this).data('subtotal_title'),
                cart_title = $(this).data('cart_title'),
                seating_map_html = $('.tc_seating_map_' + seating_map_id).html();

            $( window ).on( 'resize', function( e ) {

                /*
                 * Disabled when running Tickera alongside Bridge for Woocommerce.
                 *
                 * Issue: tc_seat_chart_get_wc_variations | wc_get_product_variations_form triggers resize.
                 * Every time a user select a variable seat, map is reposition back to the center causing a jump effect in the user perspective.
                 */
                // tc_controls.centerPoint();
            } );

            $('.tc_seating_map_' + seating_map_id).css({
                position: 'fixed',
                top: 0,
                right: 0,
                bottom: 0,
                left: 0,
                zIndex: 999999,
                display: 'block'
            });

            $( 'body' ).prepend('<div class="tc-chart-preloader"><div class="tc-loader"></div></div>');
            $( 'body' ).addClass( 'tcsc-disabled' );

            $.post(tc_common_vars.ajaxUrl, {
                action: "tc_load_seating_map",
                chart_id: seating_map_id,
                show_legend: show_legend,
                button_title: button_title,
                subtotal_title: subtotal_title,
                cart_title: cart_title
            }, function (data) {

                let body = $( 'body' );
                if ( ! body.hasClass( 'single-tc_seat_charts' ) ) {
                    body.addClass( 'single-tc_seat_charts' );
                }

                $('.tc_seating_map_' + seating_map_id).html(data);
                $('html').css('overflow', 'hidden');

                function tc_cart_hover() {
                    var tc_ticket_cart_height = $('.tc-tickets-cart').height();
                    $('.tc-tickets-cart').css('bottom', tc_ticket_cart_height * -1);
                }

                tc_front_woo.tc_mark_in_cart_seats(seating_map_id);
                tc_front_woo.tc_mark_reserved_seats(seating_map_id);
                tc_front_woo.tc_mark_unavailable_seats(seating_map_id);
                tc_front_woo.tc_mark_reserved_standings(seating_map_id);
                tc_front_woo.tc_mark_blocked_seats(seating_map_id);

                // Remove Unneeded Classes
                $('.tc-group-wrap').removeClass('ui-draggable');
                $(".tc-group-wrap *").removeClass('ui-draggable-handle');
                $(".tc-group-wrap").find('.tc-group-controls').remove();
                $(".tc-group-wrap").find('.ui-rotatable-handle').remove();
                $(".tc-group-wrap").find('.ui-resizable-handle').remove();
                $(".tc-group-wrap").find('.ui-resizable-autohide').removeClass('ui-resizable-autohide');
                $(".tc-group-wrap").find('.ui-resizable').removeClass('ui-resizable');

                // Selectables
                tc_front_woo.tc_front_selectables();

                // Set Wrapper Height
                tc_controls.set_wrapper_height();

                // Initialize Zoom Slider
                $(".tc-zoom-slider").slider({
                    value: tc_common_vars.front_zoom_level,
                    orientation: "horizontal",
                    min: 0.30,
                    max: 1,
                    step: 0.10,
                    slide: function (event, ui) {

                        var init_zoom = window.tc_seat_zoom_level;

                        $(this).parent().find('.tc-slider-value').val(ui.value);

                        window.tc_seat_zoom_level = ui.value;

                        tc_controls.zoom();
                    },
                    create: function (event, ui) {
                        var bar = $(this).slider('value');
                        $(this).parent().find('.tc-slider-value').val(bar);
                    }
                });

                // Make sure to always replace inset property with the general top, right, bottom, left properties
                $.each( $( '.tc-group-wrap' ), function () {

                    let getStyle = $(this).attr( 'style' ),
                        element = tc_front_woo.getInsetStyle( getStyle );

                    if ( element !== undefined ) {

                        let value = element.split(' '),
                            topPosition = value[0] ? value[0] : 'auto',
                            rightPosition = value[1] ? value[1] : 'auto',
                            bottomPosition = value[2] ? value[2] : 'auto',
                            leftPosition = value[3] ? value[3] : 'auto',
                            removeTrail = leftPosition.replace( ';', '' );

                        $(this).css( { 'inset': '', 'top': topPosition, 'left': removeTrail } );
                    }
                });

                // Init Controls
                tc_controls.init();
                window.dispatchEvent(new Event('resize'));

                $('.tc-chart-preloader').remove();
                $( 'body' ).removeClass( 'tcsc-disabled' );
                tc_controls.tc_legend_set();
            });
        });

        /**
         * Add seat/standee to cart.
         * Update simple seat in cart.
         *
         * @since 0.76
         *
         * @param action
         * @param button
         */
        $('body').on('click', '.tc-modal-wrap .tc_cart_button', function (e) {
            if ( ! $( this ).hasClass( 'disabled' ) ) {
                e.preventDefault();

                let button = $( this ),
                    action = $( this ).attr( 'data-action' );

                tc_front_woo.update_cart_seats( action, button );
            }
        });

        /**
         * Simple Standee Modal "Remove from cart"
         *
         * @since 0.76
         *
         * @param action
         * @param button
         */
        $( 'body' ).on( 'click', '.tc-modal-wrap #tc-remove-from-cart', function ( e ) {
            e.preventDefault();

            let wrapper = $( this ).closest( '.tc-modal-wrap' ),
                button = wrapper.find( '.tc_cart_button' ),
                action = 'update';

            wrapper.find( '.input-text.qty.text' ).val( 0 );
            tc_front_woo.update_cart_seats( action, button );
        });

        /**
         * Remove selected variation from cart.
         *
         * @since 0.76
         */
        $( 'body' ).on( 'click', '.tc-modal-wrap #tc-remove-variation-from-cart', function( e ) {
            e.preventDefault();

            let container = $( this ).closest( '.tc-modal-wrap' ),
                button = container.find( '.tc_cart_button' ),
                wrapper = $( this ).closest( 'li' ),
                attributes = wrapper.find( 'div > small' ),
                variationId = wrapper.data( 'variation-id' );

            if ( attributes ) {

                $.each( attributes, function() {
                    let attributeKey = $( this ).data( 'attribute-key' ),
                        attributeName = $( this ).data( 'attribute-name' );

                    container.find( 'select#' + attributeKey ).val( attributeName );
                    container.find( '.input-text.qty.text' ).val( 0 );
                    container.find( 'input[name="variation_id"]' ).val( variationId )
                } );

                tc_front_woo.update_cart_seats( 'update', button );
            }
        });

        /**
         * Change add to cart button with update cart if the selected variation already selected.
         *
         * @since 0.76
         */
        $( 'body' ).on( 'change', '#tc-modal-woobridge .variations select', function () {

            let wrapper = $( this ).closest( '.tc-modal-wrap' ),
                variationId = wrapper.find( 'input[name="variation_id"]' ).val(),
                button = wrapper.find( '.tc_cart_button' ),
                selected = wrapper.find( '#tc-selected-variations li[data-variation-id="'+ variationId +'"]' );

            if ( selected.length ) {
                button.attr( 'data-action', 'update' ).html( tc_seat_chart_ajax.tc_update_cart_button_title );

            } else {
                button.attr( 'data-action', 'add' ).html( tc_seat_chart_ajax.tc_add_to_cart_button_title );
            }
        } );

        /**
         * Remove a seat from cart
         */
        $( 'body' ).on( 'click', '#tc-modal-added-to-cart .tc_remove_from_cart_button', function( e ) {
            tc_front_woo.tc_seat_chart_remove_from_cart( $( this ) );
        } );

        /**
         * Listen to ajax completed call.
         * Executes Woocommerce Fragment Refresh whenever this function detects a seating add to cart event.
         */
        $( document ).ajaxComplete( function( event, xhr, settings ){

            if ( typeof settings['data'] !== 'undefined' ) {

                $.each( settings[ 'data' ].split( '&' ), function( key, value ) {

                    if ( value.includes( 'action=' ) ) {

                        if ( 'tc_remove_seat_from_cart_ajax' == value.split( '=' )[ 1 ]
                            || 'tc_woo_update_cart_seats' == value.split( '=' )[ 1 ] ) {
                            $( document.body ).trigger( 'wc_fragment_refresh' );
                        }
                    }
                } );
            }
        });
    })

} )( jQuery );
