window.tc_seat_zoom_level_prev = tc_common_vars.front_zoom_level;
window.tc_seat_zoom_level = tc_common_vars.front_zoom_level;

jQuery( document ).ready( function ( $ ) {

    $('body').on( 'click', '.tc-legend-arrow', function () {

        if ( $(this).hasClass('tc-legend-close') ) {

            var tc_seating_legend = $('.tc-seating-legend-wrap').outerWidth();

            $('.tc-seating-legend-wrap').animate({
                left: -Math.abs(tc_seating_legend),
            }, 400, function () { /* Animation complete. */ });

            $('.tc-legend-arrow').removeClass('tc-legend-close');
            $('.tc-legend-arrow').addClass('tc-legend-open');

        } else {

            var tc_seating_legend = $('.tc-seating-legend-wrap').outerWidth();

            $(".tc-seating-legend-wrap").animate({
                left: 0,
            }, 400, function () { /* Animation complete. */ });

            $('.tc-legend-arrow').removeClass('tc-legend-open');
            $('.tc-legend-arrow').addClass('tc-legend-close');
        }

    });

    var resizeTimer;

    function tc_legend_set() {

        if ( $('.tc-legend-arrow').hasClass('tc-legend-open') ) {
            var tc_seating_legend = $('.tc-seating-legend-wrap').outerWidth();
            $(".tc-seating-legend-wrap").css('left', -Math.abs(tc_seating_legend));
        }

        var get_window_width = $(this).width();

        if ( get_window_width < 780 ) {

            var tc_seating_legend = $('.tc-seating-legend-wrap').outerWidth();

            $('.tc-seating-legend-wrap').animate({
                left: -Math.abs(tc_seating_legend),
            }, 0, function() { /* Animation complete. */ });

            $('.tc-legend-arrow').removeClass('tc-legend-close');
            $('.tc-legend-arrow').addClass('tc-legend-open');
        }
    }

    $(window).on( 'resize', function ( e ) {
        tc_legend_set();
    });


    $('body').on( 'click', '.tc_modal_close_dialog', function ( e ) {
        $('.ui-dialog-content').dialog('close');
    });

    $('body').on( 'click', '.tc-full-screen', function ( e ) {

        let body = $( 'body' );
        if ( body.hasClass( 'single-tc_seat_charts' ) ) {
            body.removeClass( 'single-tc_seat_charts' );
        }

        $('html').css('overflow', '');
        $('.tc_seating_map').css({ display: 'none' });
    });

    $('html').keydown( function ( e ) {

        if ( 40 == e.keyCode ) { // Down
            tc_controls.position_pan_wrapper('down');
            e.preventDefault();
        }

        if ( 38 == e.keyCode ) { // Up
            tc_controls.position_pan_wrapper('up');
            e.preventDefault();
        }

        if ( 37 == e.keyCode ) { // Left
            tc_controls.position_pan_wrapper('left');
            e.preventDefault();
        }

        if ( 39 == e.keyCode  ) { // Right
            tc_controls.position_pan_wrapper('right');
            e.preventDefault();
        }
    });

    $(window).resize( function () {
        tc_controls.set_wrapper_height();
    });

    /**
     * Zoom Controls Events
     */
    $('body').on( 'click', '.tc-zoom-wrap .tc-plus-wrap', function ( event ) {
        tc_controls.zoom_plus();
    });

    $('body').on( 'click', '.tc-zoom-wrap .tc-minus-wrap', function ( event ) {
        tc_controls.zoom_minus();
    });

    $('body').on( 'click', '#collapse-menu', function ( event ) {
        tc_controls.position_zoom_controls();
    });

    /**
     * Mouse Events
     */
    $('body').on( 'mousewheel DOMMouseScroll', '.tc-wrapper', function (e) {

        /*
         * Returns an error on browsers that supports passive event listener
         * Solution: Disable PreventDefault()
         * e.preventDefault();
         */

        if ( 'DOMMouseScroll' == e.type ) { // Firefox
            scroll = e.originalEvent.detail * ( 40 * -1 );

        } else {
            scroll = e.originalEvent.wheelDelta;
        }

        if ( scroll / 120 > 0 ) {
            tc_controls.zoom_plus();

        } else {
            tc_controls.zoom_minus();
        }
    });

    var supportsTouch = 'ontouchstart' in window || navigator.msMaxTouchPoints;

    if ( supportsTouch !== true ) {

        $('body').on( 'mouseenter', '.tc_set_seat, .tc-object-selectable.ui-selectee', function ( event ) {

            if ( !$( event.target ).is('.tc_seat_unavailable') ) {

                var ticket_type = $(this).attr('data-tt-id'),
                    ticket_type_title = $('li.tt_' + ticket_type).attr('data-tt-title'),
                    ticket_type_price = $('li.tt_' + ticket_type).attr('data-tt-price'),
                    ticket_seat_number = $(this).find('span p').html();

                ticket_seat_number = ( typeof ticket_seat_number !== 'undefined' || ticket_seat_number ) ? '<div class="tc-front-seat-number">' + tc_common_vars.seat_translation + ': <strong>' + ticket_seat_number.replace( /—/g, '-' ) + '</strong></div>' : ''; // Replace long hyphen with regular dash

                var tc_top = event.clientY + 20,
                    tc_bottom = event.clientX;

                $( '.tc-wrapper' ).append('<span class="tc-ticket-info-wrap" style="left:' + tc_bottom + 'px; top:' + tc_top + 'px; position: absolute;   -webkit-animation-name: fadeIn; -webkit-animation-duration: 0.2s;  animation-name: fadeIn; animation-duration: 0.2s;"><div class="tc-arrow-up"></div><div class="tc-ticket-info-inside"><ul><li><span><strong class="tc_ticket_type_price_hover_wrapper">' + ticket_type_price + '</strong> - </span>' + ticket_type_title + '</li></ul>' + ticket_seat_number + '</div></span>');
            }
        });

        $('body').on( 'mouseout', '.tc_set_seat, .tc-object-selectable.ui-selectee', function () {
            $(".tc-wrapper").find('span.tc-ticket-info-wrap').remove();
        });
    }

    jQuery('.hover').bind('touchend', function (e) {
        tc_controls.set_wrapper_height();
    });
});
