( function ( $ ) {

    $( document ).ready( function() {

        window.tc_controls = {

            /**
             * Creates new element
             * @returns {undefined}
             */
            change_event_confirmation: function() {

                var selected_event_id = $( "#tc-settings .tc-event-wrap option:selected" ).val(),
                    selected_event_id_orig = $( '#tc_init_event_id' ).val();

                if ( ( selected_event_id !== selected_event_id_orig ) ) {

                    if ( $( '.tc-pan-wrapper' ).html() !== '' ) {

                        $( '#tc-seating-change-event-dialog' ).dialog( {

                            bgiframe: true,
                            closeOnEscape: false,
                            draggable: false,
                            resizable: false,
                            dialogClass: 'no-close',
                            modal: true,
                            title: tc_controls_vars.are_you_sure,
                            buttons: [
                                {
                                    text: tc_controls_vars.no,
                                    click: function() {
                                        $( this ).dialog( "close" );
                                        tc_controls.change_event_confirmation_callback( false );
                                    }
                                },
                                {
                                    text: tc_controls_vars.yes,
                                    click: function() {
                                        $( this ).dialog( "close" );
                                        tc_controls.change_event_confirmation_callback( true );
                                    }
                                }
                            ]
                        } );

                    } else {
                        $( '#tc_init_event_id' ).val( selected_event_id );
                        tc_controls.get_event_ticket_types();
                    }
                }
            },

            change_event_confirmation_callback: function( value ) {

                if ( value == true ) {

                    var selected_event_id = $( '#tc-settings .tc-event-wrap option:selected' ).val();

                    $( '#tc_init_event_id' ).val( selected_event_id );
                    tc_controls.get_event_ticket_types();

                    $.each( $( '.tc_set_seat, .tc-object-selectable' ), function() {

                        if ( !$( this ).hasClass( 'tc_seat_reserved' ) ) {
                            $( this ).removeClass( 'tc_set_seat' );
                            $( this ).removeAttr( 'data-tt-id' );
                            $( this ).css( { 'background-color': '', 'color': '' } );
                        }
                    } );
                }
            },

            delete_confirmation: function( obj_to_delete ) {

                $( '#tc-seating-dialog' ).dialog( {
                    bgiframe: true,
                    closeOnEscape: false,
                    draggable: false,
                    resizable: false,
                    dialogClass: 'no-close',
                    modal: true,
                    title: tc_controls_vars.are_you_sure,
                    closeText: "<i class='fa fa-times'></i>",
                    buttons: [
                        {
                            text: tc_controls_vars.no,
                            click: function() {
                                $( this ).dialog( 'close' );
                                tc_controls.delete_confirmation_callback( false, obj_to_delete );
                            }
                        },
                        {
                            text: tc_controls_vars.yes,
                            click: function() {
                                $( this ).dialog( 'close' );
                                tc_controls.delete_confirmation_callback( true, obj_to_delete );
                            }
                        }
                    ]
                } );
            },

            delete_confirmation_callback: function( value, obj_to_delete ) {

                if ( value == true ) {
                    obj_to_delete.remove();
                    $( '.tc-sidebar' ).tabs( { collapsible: true, active: false } );
                    tc_controls.hide_ticket_type_box();
                    $( '.tc-group-wrap' ).removeClass( 'tc-edit-mode' );
                }
            },

            rgb2hex: function( rgb ) {

                rgb = rgb.match( /^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i );
                return ( rgb && rgb.length === 4 ) ? "#" +
                    ( "0" + parseInt( rgb[ 1 ], 10 ).toString( 16 ) ).slice( -2 ) +
                    ( "0" + parseInt( rgb[ 2 ], 10 ).toString( 16 ) ).slice( -2 ) +
                    ( "0" + parseInt( rgb[ 3 ], 10 ).toString( 16 ) ).slice( -2 ) : '';
            },

            set_default_settings_values: function() {

                // Seatings
                $( '#tc_seating_group_title' ).val( '' );
                $( '#tc_seating_group_widget .tc_seat_add_controls' ).show();
                $( '#tc_seating_group_widget .tc_seat_edit_controls' ).hide();
                $( '#tc_seating_group_widget .tc-seat-rows-slider' ).show();
                $( '#tc_seating_group_widget .tc-seat-cols-slider' ).show();

                // Standing
                $( '#tc_standing_group_title' ).val( '' );
                $( '#tc_standing_widget .tc_seat_add_controls' ).show();
                $( '#tc_standing_widget .tc_seat_edit_controls' ).hide();
                $( '#tc_standing_widget .tc-assign-ticket-type' ).show();

                // Table
                $( '.tc_table_title' ).val( '' );
                $( '#tc-table .tc_table_add_controls' ).show();
                $( '#tc-table .tc_table_edit_controls' ).hide();
                $( '#tc-table .tc-input-slider' ).show();

                // Element
                $( '.tc_element_title' ).val( '' );
                $( '#tc_element_widget .tc_element_add_controls' ).show();
                $( '#tc_element_widget .tc_element_edit_controls' ).hide();

                // Text
                $( '.tc_text_title' ).val( '' );
                $( '#tc_text_widget .tc_text_add_controls' ).show();
                $( '#tc_text_widget .tc_text_edit_controls' ).hide();
            },

            next_part_number: function() {
                var next_part_no = $( '#tc_part_no' ).val();
                next_part_no = parseInt( next_part_no ) + 1;
                $( '#tc_part_no' ).val( next_part_no );
                return next_part_no;
            },

            /**
             * Unset all active tabs
             *
             * @param event
             */
            set_tabs_inactive: function( event ) {

                if ( 'tc-wrapper' == $( event.target ).attr( 'class' ) ) {
                    $( '.tc-sidebar' ).tabs( { collapsible: true, active: false } );
                    tc_controls.hide_ticket_type_box();
                    $( '.tc-group-wrap' ).removeClass( 'tc-edit-mode' );
                    $( '#tc-block-seat-wrap' ).hide();
                }
            },

            unselect_all: function() {
                $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                $( '.tc-group-wrap' ).removeClass( 'tc-edit-mode' );
            },

            zoom: function() {

                if ( window.tc_seat_zoom_level <= 1 && window.tc_seat_zoom_level >= 0.30 ) {

                    let prev_value = $( ".tc-zoom-slider" ).slider( "option", "value" );
                    window.tc_seat_zoom_level_prev = prev_value;

                    if ( window.tc_seat_zoom_level_prev < window.tc_seat_zoom_level ) {
                        zoom_level = ( ( window.tc_seat_zoom_level - window.tc_seat_zoom_level_prev ) ) + 1;

                    } else {
                        zoom_level = ( ( window.tc_seat_zoom_level_prev - window.tc_seat_zoom_level ) ) + 1;
                    }

                    $( '.tc-pan-wrapper' ).css( {
                            '-webkit-transform': 'scale(' + window.tc_seat_zoom_level + ')',
                            '-moz-transform': 'scale(' + window.tc_seat_zoom_level + ')',
                            '-ms-transform': 'scale(' + window.tc_seat_zoom_level + ')',
                            '-o-transform': 'scale(' + window.tc_seat_zoom_level + ')',
                            'transform': 'scale(' + window.tc_seat_zoom_level + ')'
                        }
                    );

                    $( '#tc_admin_zoom_level' ).val( window.tc_seat_zoom_level );
                    $( '.tc-zoom-slider' ).slider( 'value', window.tc_seat_zoom_level );
                    $( '.tc-wrapper' ).css( 'background-size', 80 * window.tc_seat_zoom_level );
                }
            },

            zoom_plus: function() {
                if ( window.tc_seat_zoom_level < 1 ) {
                    window.tc_seat_zoom_level = window.tc_seat_zoom_level + 0.10;
                    tc_controls.zoom();
                }
            },

            zoom_minus: function() {
                if ( window.tc_seat_zoom_level > 0.3 ) {
                    window.tc_seat_zoom_level = window.tc_seat_zoom_level - 0.10;
                    tc_controls.zoom();
                }
            },

            position_zoom_controls: function() {
                var admin_menu_width = $( '#adminmenuwrap' ).width();
                $( '.tc-zoom-wrap' ).css( 'left', admin_menu_width + 15 )
            },

            set_wrapper_height: function() {
                $( '.tc-wrapper' ).height( $( window ).height() - $( '#wpadminbar' ).height() );
            },

            center: function( element ) {

                element.css( 'position', 'absolute' );
                var position = $( '.tc-pan-wrapper' ).position();

                if ( position.left < 0 && position.top < 0 ) {
                    var top = Math.abs( position.top ),
                        left = Math.abs( position.left );

                } else if ( position.left > 0 && position.top > 0 ) {
                    var top = -position.top,
                        left = -position.left;

                } else if ( position.left > 0 && position.top < 0 ) {
                    var top = Math.abs( position.top ),
                        left = -position.left;

                } else if ( position.left < 0 && position.top > 0 ) {
                    var top = -position.top,
                        left = Math.abs( position.left );
                }

                var tc_wrap_width = $( '.tc-wrapper' ).width(),
                    tc_wrap_width = tc_wrap_width / 2,
                    tc_wrap_height = $( '.tc-wrapper' ).height(),
                    tc_wrap_height = tc_wrap_height / 2;

                element.css( 'top', ( top + tc_wrap_height - 50 ) + 'px' );
                element.css( 'left', ( left + tc_wrap_width ) + 'px' );
                return element;
            },

            /**
             * Move all seat groups inside the main span to obtain the correct center point.
             * Dependency of the following:
             * 1. Middle Zoom in/out
             * 2. Automatically centers seating map
             */
            set_pan_wrapper_dimension: function() {

                var min_top, max_top, min_left, max_left,
                    min_top_offset, max_top_offset, min_left_offset, max_left_offset;

                /*
                 * Step 1:
                 * Collect all seat groups positions.
                 */
                $( '.tc-pan-wrapper .tc-group-wrap' ).each( function() {

                    let element = $( this ),
                        top = parseFloat( element.css( 'top' ) ),
                        left = parseFloat( element.css( 'left' ) ),
                        top_offset = element.find( 'div.tc-group-background, div.tc-element-group' ).height(), // Since margin, padding and border are being excluded in the frontend, use height() instead of outerHeight()
                        left_offset = element.find( 'div.tc-group-background, div.tc-element-group' ).width(); // Since margin, padding and border are being excluded in the frontend, use height() instead of outerHeight()

                    // Calculate Min & Max seat group top position
                    if ( typeof min_top === 'undefined' ) {
                        min_top = top; max_top = top;
                        min_top_offset = top_offset; max_top_offset = top_offset;

                    } else if ( top < min_top ) {

                        if ( min_top > max_top ) {
                            max_top = min_top; max_top_offset = min_top_offset;
                        }

                        min_top = top; min_top_offset = top_offset;

                    } else if ( top > max_top ) {
                        max_top = top; max_top_offset = top_offset;
                    }

                    // Calculate Min & Max seat group left position
                    if ( typeof min_left === 'undefined' ) {
                        min_left = left; max_left = left;
                        min_left_offset = left_offset; max_left_offset = left_offset;

                    } else if ( left < min_left ) {

                        if ( min_left > max_left ) {
                            max_left = min_left; max_left_offset = min_left_offset;
                        }

                        min_left = left; min_left_offset = left_offset;

                    } else if ( left > max_left ) {
                        max_left = left; max_left_offset = left_offset;
                    }
                });

                /*
                 * Step 2:
                 * Resize tc-pan-wrapper width/height
                 */
                let group_total_width = Math.abs( max_left - min_left ) + max_left_offset,
                    group_total_height = Math.abs( max_top - min_top ) + max_top_offset;

                $( '.tc-pan-wrapper' ).css( { width: group_total_width + 'px', height: group_total_height + 'px' } );

                /*
                 * Step 3:
                 * Reposition tc-group-wrap to fit in the tc-pan-wrapper.
                 */
                $( '.tc-pan-wrapper .tc-group-wrap' ).each( function() {

                    let element = $( this ),
                        top = parseFloat( element.css( 'top' ) ),
                        left = parseFloat( element.css( 'left' ) );

                    $( this ).css( { top: ( top - min_top ) + 'px', left: ( left - min_left ) + 'px' } );
                });
            },

            position_pan_wrapper: function( position ) {

                console.log( position )

                var move_val = 50;

                switch ( position ) {

                    case 'up':
                        $( '.tc-pan-wrapper' ).css( 'top', $( '.tc-pan-wrapper' ).position().top - move_val );
                        tc_controls.position_background();
                        break;

                    case 'right':
                        $( '.tc-pan-wrapper' ).css( 'left', $( '.tc-pan-wrapper' ).position().left + move_val );
                        tc_controls.position_background();
                        break;

                        case 'down':
                        $( '.tc-pan-wrapper' ).css( 'top', $( '.tc-pan-wrapper' ).position().top + move_val );
                        tc_controls.position_background();
                        break;

                        case 'left':
                        $( '.tc-pan-wrapper' ).css( 'left', $( '.tc-pan-wrapper' ).position().left - move_val );
                        tc_controls.position_background();
                        break;
                }
            },

            position_background: function() {
                $( ".tc-wrapper" ).css( 'background-position-x', $( '.tc-pan-wrapper' ).position().left );
                $( ".tc-wrapper" ).css( 'background-position-y', $( '.tc-pan-wrapper' ).position().top );
            },

            save_distinct_ticket_types: function() {

                var items = {};
                $( '.tc_set_seat' ).each( function() {
                    items[ $( this ).attr( 'data-tt-id' ) ] = true;
                } );

                var result = new Array();
                for ( var i in items ) {
                    result.push( i );
                }

                var results = result.toString();
                $( '#tc_ticket_types' ).val( results );
            },

            save_confirmation: function() {

                var unassigned_seats = 0;

                $.each( $( '.tc_set_seat' ), function() {
                    if ( $( this ).find( 'span' ).length == 0 ) {
                        if ( !$( this ).hasClass( 'tc_seat_reserved' ) && !$( this ).hasClass( 'tc-object-selectable' ) ) {
                            $( this ).removeClass( 'tc_need_seat_label' ).addClass( 'tc_need_seat_label' ); // Require seats label for unassigned seats
                            unassigned_seats++;
                        }
                    }
                } );

                if ( unassigned_seats > 0 ) {
                    $( '#tc-seating-required-label-dialog' ).dialog( {
                        bgiframe: true,
                        closeOnEscape: false,
                        draggable: false,
                        resizable: false,
                        dialogClass: 'no-close',
                        modal: true,
                        title: tc_controls_vars.are_you_sure,
                        closeText: "<i class='fa fa-times'></i>",
                        buttons: [
                            {
                                text: tc_controls_vars.ok,
                                click: function() {
                                    $( this ).dialog( 'close' );
                                    tc_controls.save_confirmation_callback( false );
                                }
                            },
                        ]
                    } );

                } else {
                    tc_controls.save_confirmation_callback( true );
                }
            },

            save_confirmation_callback: function( value ) {

                if ( value == true ) {

                    $( '.tc-wrapper' ).prepend( "<div class='tc-chart-preloader'><div class='tc-loader'></div></div>" );
                    tc_controls.unselect_all();
                    tc_controls.save_distinct_ticket_types();

                    $( '.tc_need_seat_label' ).removeClass( 'tc_need_seat_label' );
                    $( '.tc_seat_reserved' ).removeClass( 'tc_seat_reserved' );

                    $( '#title' ).val( $( '#tc_chart_title' ).val() );
                    $( '#tc_chart_content' ).val( $( '.tc-pan-wrapper' ).html() );
                    $( '#tc_chart_content_front' ).val( '<div class="tc-pan-wrapper" style="' + $( '.tc-pan-wrapper' ).attr( 'style' ) + '">' + $( '.tc-pan-wrapper' ).html() + '</div>' );

                    $( '#tc_pan_position_left' ).val( $( '.tc-pan-wrapper' ).position().left );
                    $( '#tc_pan_position_top' ).val( $( '.tc-pan-wrapper' ).position().top );
                    $( '#publishing-action input[type="submit"]' ).click();
                }
            },

            save: function() {
                tc_controls.set_pan_wrapper_dimension();
                tc_controls.save_confirmation();
            },

            /**
             * Initialize seats current and default attributes ( colors, sizes, positions and values ).
             */
            init: function() {

                $( '#content-tmce' ).click();
                window.tc_seat_zoom_level_prev = parseFloat( $( '#tc_admin_zoom_level' ).val() );
                window.tc_seat_zoom_level = parseFloat( $( '#tc_admin_zoom_level' ).val() );
                tc_controls.zoom();

                $( '.tc-pan-wrapper' ).css( {
                    top: $( '#tc_pan_position_top' ).val() + 'px',
                    left: $( '#tc_pan_position_left' ).val() + 'px',
                    position: 'absolute'
                } );

                tc_controls.position_background();
                tc_controls.set_default_colors();
                tc_controls.tc_mark_reserved_seats();
                tc_controls.tc_mark_blocked_seats();

                $( '.tc-wrapper, .tc-sidebar' ).fadeTo( 600, 1, function() { /* Animation completed. */ } );

                // Make sure to always replace inset property with top, right, bottom, left properties
                $.each( $( '.tc-group-wrap' ), function() {

                    let getStyle = $( this ).attr( 'style' ),
                        element = tc_controls.getInsetStyle( getStyle );

                    if ( element !== undefined ) {

                        let value = element.split( ' ' ),
                            topPosition = value[ 0 ] ? value[ 0 ] : 'auto',
                            rightPosition = value[ 1 ] ? value[ 1 ] : 'auto',
                            bottomPosition = value[ 2 ] ? value[ 2 ] : 'auto',
                            leftPosition = value[ 3 ] ? value[ 3 ] : 'auto',
                            removeTrail = leftPosition.replace( ';', '' );

                        $( this ).css( { 'inset': '', 'top': topPosition, 'left': removeTrail } );
                    }
                } );

                tc_controls.set_pan_wrapper_dimension();
            },

            /**
             * Get inset property
             *
             * @param allStyle
             * @returns {undefined|*}
             */
            getInsetStyle: function( allStyle ) {

                let styles = allStyle.split( '; ' );

                for ( let i = 0; i < styles.length; i++ ) {

                    let astyle = styles[ i ].split( ': ' );

                    if ( 'inset' == astyle[ 0 ] ) {
                        return astyle[ 1 ];
                    }
                }

                return undefined;
            },

            set_default_colors: function() {

                $.each( $( '.tc_set_seat' ), function() {

                    let ticket_type_id = $( this ).attr( 'data-tt-id' ),
                        seat_color = tc_seat_default_colors[ ticket_type_id ];

                    if ( typeof seat_color === 'undefined' || '' == seat_color ) {
                        seat_color = '#0085BA';
                    }

                    $( this ).css( { 'background-color': seat_color, 'color': seat_color } );
                } )
            },

            tc_mark_reserved_seats: function( seat_id ) {
                let chart_id = tc_controls_vars.chart_id;
                for ( var k in tc_reserved_seats[ chart_id ] ) {
                    if ( typeof seat_id === "undefined" || ( typeof seat_id !== "undefined" && k == seat_id ) ) {
                        $( '#' + k ).css( { 'background-color': tc_controls_vars.tc_reserved_seat_color } );
                        $( '#' + k ).css( { 'color': tc_controls_vars.tc_reserved_seat_color } );
                        $( '#' + k ).addClass( 'tc_seat_reserved' );
                        $( '#' + k ).removeClass( 'ui-selected ui-selectee' );
                    }
                }
            },

            tc_mark_blocked_seats: function() {

                let show_as_reserved = tc_controls_vars.tc_show_as_reserved,
                    blocked_seat_color = tc_controls_vars.tc_blocked_seat_color;

                if ( 'yes' == show_as_reserved ) {
                    blocked_seat_color = tc_controls_vars.tc_reserved_seat_color;
                }

                $.each( $( '.tc_set_seat.tc_blocked_seat' ), function() {
                    $( this ).css( { 'background-color': blocked_seat_color, 'color': blocked_seat_color } );
                } );
            },

            get_event_ticket_types: function() {

                $( '.tc-icon-edit' ).hide();
                $( '.tc-ticket-type-wrap select' ).prop( 'disabled', true );

                var event_id = $( 'select.tc-event-name' ).val();

                $.post( tc_controls_vars.ajaxUrl, {
                    action: 'tc_get_event_ticket_types',
                    event_id: event_id
                }, function( data ) {
                    $( '.tc-ticket-type-wrap select' ).remove();
                    $( '.tc-ticket-type-wrap' ).append( data );
                    $( '.tc-icon-edit' ).show();
                } );
            },

            show_ticket_type_box: function( event, ui, show_labels ) {

                $( '.tc_seat_reserved' ).removeClass( 'ui-selected' );

                if ( show_labels !== false ) {
                    tc_controls.show_labels( event, ui );
                }

                if ( $( '.ui-selected' ).length ) {

                    let ui_selected = $( event.target ).find( '.ui-selected' ),
                        seat_ticket_type_id = ui_selected.attr( 'data-tt-id' ),
                        blocked_seat = ui_selected.attr( 'data-tt-blocked-seat' );

                    if ( typeof blocked_seat !== 'undefined' || blocked_seat === true ) {
                        $( '#tc-block-seat-wrap .switch-checkbox' ).prop( 'checked', false );

                    } else {
                        $( '#tc-block-seat-wrap .switch-checkbox' ).prop( 'checked', true );
                    }

                    $( '#ticket_type_id' ).val( seat_ticket_type_id );
                    $( '#tc_ticket_type_widget' ).show();
                    $( '.tc-sidebar' ).tabs( { collapsible: true, active: false } );

                } else {
                    tc_controls.hide_ticket_type_box();
                }
            },

            show_labels: function( event, ui ) {

                if ( $( '.tc_set_seat.ui-selected:not(.tc-object-selectable)' ).length ) {

                    $( '#tc-seat-labels-num' ).html( ' (' + $( '.tc_set_seat.ui-selected:not(.tc-object-selectable)' ).length + ')' );
                    $( '#tc-seat-labels-settings' ).show();

                    var selected_assigned_ticket_type_num = $( '.tc_set_seat.ui-selected:not(.tc-object-selectable)' ).length;

                    if ( selected_assigned_ticket_type_num == 1 ) {
                        var single_label = $( '.tc_set_seat.ui-selected span p' ).html();
                        $( '#tc-labels-single-select .tc_label_letter' ).val( single_label );
                        $( '#tc-labels-single-select' ).show();
                        $( '#tc-labels-multi-select' ).hide();

                    } else {
                        // Multiple selected
                        $( '.tc_label_from_multi' ).val( '1' );
                        $( '.tc_label_to_multi' ).val( selected_assigned_ticket_type_num );
                        $( '#tc-labels-multi-select' ).show();
                        $( '#tc-labels-single-select' ).hide();
                    }
                } else {
                    tc_controls.hide_labels();
                }
            },

            hide_labels: function() {
                $( '#tc-seat-labels-settings' ).hide();
            },

            hide_ticket_type_box: function() {
                $( '#tc_ticket_type_widget' ).hide();
            },

            render_blocked_seats( this_element ) {

                let tc_blocked_seats = $( '#tc-block-seat-wrap .switch-checkbox:checked' ).length,
                    show_as_reserved = tc_controls_vars.tc_show_as_reserved,
                    blocked_seat_color = tc_controls_vars.tc_blocked_seat_color;

                if ( 'yes' == show_as_reserved ) {
                    blocked_seat_color = tc_controls_vars.tc_reserved_seat_color;
                }

                if ( !tc_blocked_seats ) {

                    this_element.attr( 'data-tt-blocked-seat', true );
                    this_element.addClass( 'tc_blocked_seat' );
                    this_element.animate( { 'background-color': blocked_seat_color, 'color': blocked_seat_color } );

                } else {

                    let ticket_type_id = this_element.attr( 'data-tt-id' ),
                        tc_seat_color = tc_seat_colors[ ticket_type_id ];

                    this_element.removeAttr( 'data-tt-blocked-seat' );
                    this_element.removeClass( 'tc_blocked_seat' );
                    this_element.css( { 'background-color': tc_seat_color, 'color': tc_seat_color } );
                }
            },

            change_ticket_type: function() {

                if ( $( '#ticket_type_id' ).val() !== undefined && $( '#ticket_type_id' ).val() != null && $( '#ticket_type_id' ).val().length > 0 ) {

                    $.each( $( '.ui-selected:not(.tc-object-selectable)' ), function() {
                        $( this ).attr( 'data-tt-id', $( '#ticket_type_id' ).val() );
                        tc_controls.render_blocked_seats( $( this ) );
                        $( this ).removeClass( 'tc_set_seat' );
                        $( this ).addClass( 'tc_set_seat' );
                        $( this ).removeClass( 'ui-selected' );
                    } );
                }

                $( '#tc-block-seat-wrap .switch-checkbox' ).prop( 'checked', true );
                $( '#tc_ticket_type_widget' ).hide();
                $( '#tc-seat-labels-settings' ).hide();
            },

            unset_ticket_type: function() {

                $.each( $( ".ui-selected" ), function() {

                    $( this ).removeAttr( 'data-tt-id' );
                    if ( $( this ).hasClass( 'tc-table-chair' ) || $( this ).hasClass( 'tc_seat_unit' ) ) {
                        $( this ).css( { 'background-color': '' } );
                    }

                    if ( $( this ).hasClass( 'tc-icon-seat' ) ) {
                        $( this ).css( 'color', '' );
                    }

                    $( this ).removeClass( 'tc_set_seat' );
                    $( this ).removeClass( 'ui-selected' );
                } );
                $( '#tc_ticket_type_widget' ).hide();
                $( '#tc-seat-labels-settings' ).hide();
            }
        }
    } );
})( jQuery );
