<?php

if ( isset( $atts ) ) {
    extract( shortcode_atts( array(
        'event_id' => false,
        'speakers_display' => false,
        'show_categories' => false,
        'grid_count' => false,
    ), $atts ) );
}

$tc_speakers_settings = get_option( 'tc_speakers_settings' );
$tc_get_post_type = get_post_type( get_the_ID() );

if ( ! isset( $event_id ) || $event_id == false ) {
    $event_id = get_the_ID();
}

if ( ! isset( $speakers_display ) || $speakers_display == false ) {
    $speakers_display = get_post_meta( $event_id, 'tc_speakers_view', true );
}

if ( ! isset( $grid_count ) || $grid_count == false ) {
    $grid_count = get_post_meta( $event_id, 'tc_speakers_grid_num', true );
}

if ( ! isset( $show_categories ) || $show_categories == false ) {
    $show_categories = get_post_meta( get_the_ID(), 'tc_speakers_grid_show_cats', true );
}

$tc_event_speakers_list = get_post_meta( $event_id, 'tc_speakers', true );
$tc_event_speakers_list = ( $tc_event_speakers_list ) ? $tc_event_speakers_list : [];

if ( in_array( 'all', $tc_event_speakers_list ) ) {
    $tc_event_speakers_list = get_posts( [
        'post_type' => 'tc_speakers',
        'fields' => 'ids',
        'posts_per_page' => -1
    ]);
}

if ( $speakers_display == 'tc_grid' ) {
    // Include grid template
    include plugin_dir_path( __FILE__ ) . 'tc-grid-template.php';

} elseif ( $speakers_display == 'tc_slider' ) {
    // Include grid template with featured image
    include plugin_dir_path( __FILE__ ) . 'tc-slider-speakers.php';

} elseif ( $speakers_display == 'tc_list' ) {
    // Include grid template with featured image
    include plugin_dir_path( __FILE__ ) . 'tc-list.php';
}
wp_reset_query(); ?>
<div class="tc-clear"></div>
