( function( $ ) {

    $( window ).ready( function( $ ) {

        setTimeout( function() {

            var $grid = $( '.tc-masonry-cat-wrap' ).isotope( {
                itemSelector: '.tc-speakers-grid',
                layoutMode: 'fitRows'
            } );

        }, 500 );

        /**
         * Filter functions
         *
         * @type {{ium: (function(): *), numberGreaterThan50: (function(): boolean)}}
         */
        var filterFns = {

            // Show if number is greater than 50
            numberGreaterThan50: function() {
                var number = $( this ).find( '.number' ).text();
                return parseInt( number, 10 ) > 50;
            },

            // Show if name ends with -ium
            ium: function() {
                var name = $( this ).find( '.name' ).text();
                return name.match( /ium$/ );
            }
        };

        var $grid = $( '.tc-masonry-cat-wrap' ).isotope( {
            itemSelector: '.tc-speakers-grid',
            layoutMode: 'fitRows'
        } );

        // Use filterFn if matches value
        $( '#tc-speakers-tax' ).on( 'click', '.tc-sort-button', function() {
            var filterValue = $( this ).attr( 'data-filter' );
            filterValue = filterFns[ filterValue ] || filterValue;
            $grid.isotope( { filter: filterValue } );
        } );

        // Bind sort button click
        $( '#sorts' ).on( 'click', 'button', function() {
            var sortByValue = $( this ).attr( 'data-sort-by' );
            $grid.isotope( { sortBy: sortByValue } );
        } );

        if ( 'yes' == tc_event_parameters.tc_speakers_popup ) {

            $( '.tc-magnific-popup-ajax' ).click( function() {

                var tc_speaker_id = $( this ).attr( 'data-post-id' ),
                    data = { 'action': 'tc_ajax_load_speaker', 'tc_speaker_id': tc_speaker_id };

                $.post( tc_event_parameters.ajaxurl, data, function( response ) {
                    $( '#tc-speaker-popup' ).html( response );
                } );
            } );

            function tc_animate_popup_open() {

                var checkExist = setInterval( function() {

                    if ( $( '.tc-popup-content-wrap' ).length ) {

                        $( '.tc-popup-content-wrap' ).animate( {
                            top: "-65",
                            opacity: 1
                        }, 500, function() { /* Animation complete. */ } );

                        $( '.tc-speaker-featured-image-popup img' ).animate( {
                            left: "0",
                            opacity: 1
                        }, 500, function() { /* Animation complete. */ } );

                        $( '#tc-speaker-popup .mfp-close.mfp-close-in-featured' ).animate( {
                            top: "10",
                            opacity: 1
                        }, 500, function() { /* Animation complete. */ } );

                        clearInterval( checkExist );
                    }
                }, 100 ); // Check every 100ms
            }

            function tc_animate_popup_close() {

                $( '.tc-popup-content-wrap' ).animate( {
                    top: "0",
                    opacity: 0
                }, 500, function() { /* Animation complete. */ } );

                $( '.tc-speaker-featured-image-popup img' ).animate( {
                    left: "150",
                    opacity: 0
                }, 500, function() { /* Animation complete. */ } );

                $( '#tc-speaker-popup .mfp-close.mfp-close-in-featured' ).animate( {
                    top: "-35",
                    opacity: 0
                }, 500, function() { /* Animation complete. */ } );
            }

            $( '.tc-magnific-popup-ajax' ).magnificPopup( {
                type: 'inline',
                showCloseBtn: true,
                closeBtnInside: true,
                midClick: true,
                removalDelay: 500,
                callbacks: {
                    beforeClose: function() {
                        tc_animate_popup_close();

                    },
                    close: function() {
                        setTimeout( function() {
                            $( '#tc-speaker-popup' ).html( '' );
                        }, 500 );
                    },
                    open: function() {
                        tc_animate_popup_open();
                    }
                }
            } );
        }

        if ( 'tc_grid_featured_image' == tc_event_parameters.tc_speakers_view ) {

            $( '.tc-speakers-grid' ).click( function() {

                var tc_speakers_id = $( this ).attr( 'data-post-id' ),
                    data = { 'action': 'tc_get_selected_speaker', 'tc_post_id': tc_speakers_id };

                // Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                $.post( tc_event_parameters.ajaxurl, data, function( response ) {
                    $( '.tc-featured-speaker' ).html( response );
                } );
            } );
        }

        if ( 'tc_slider' == tc_event_parameters.tc_speakers_view ) {

            $( '.tc-speaker-image-wrap, .tc-speakers-slider .flex-direction-nav li a' ).hover( function() {
                var tc_height_description = $( this ).find( '.tc-speaker-excerpt' ).height();
                $( this ).find( '.tc-speaker-description-wrap' ).attr( 'style', 'bottom: 0;' );

            }, function() {
                var tc_height_description = $( this ).find( '.tc-speaker-excerpt' ).height();
                $( this ).find( '.tc-speaker-description-wrap' ).attr( 'style', 'bottom: -' + tc_height_description + 'px;' );
            } );

        }
    } );

    $( window ).load( function() {

        $( '.tc-speakers-slider' ).flexslider( {
            animation: "slide",
            smoothHeight: true,
            prevText: "<i class='fa fa-angle-left' aria-hidden='true'></i>", // String: Set the text for the "previous" directionNav item
            nextText: "<i class='fa fa-angle-right' aria-hidden='true'></i>",
            directionNav: false,
            controlNav: true,
            start: function() {
                $( '.tc-speakers-slider li' ).each( function() {
                    var tc_height_description = $( this ).find( '.tc-speaker-excerpt' ).height();
                    $( this ).find( '.tc-speaker-description-wrap' ).attr( 'style', 'bottom: -' + tc_height_description + 'px;' );
                } );

            },
            after: function() {},
        } );

        function tc_set_nav_images() {

            var tc_previous_image = $( 'li.flex-active-slide' ).prev().find( '.tc-speaker-image-wrap img' ).attr( "src" ),
                tc_next_image = $( 'li.flex-active-slide' ).next().find( '.tc-speaker-image-wrap img' ).attr( "src" );

            $( '.tc-speakers-slider .flex-direction-nav .flex-next' ).html( '<img src=' + tc_next_image + '>' );
            $( '.tc-speakers-slider .flex-direction-nav .flex-prev' ).html( '<img src=' + tc_previous_image + '>' );
        }
    } );

} )( jQuery );
