<?php
if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( ! class_exists( 'TC_Cart_Form' ) ) {

    class TC_Cart_Form {

        var $form_title = '';
        var $valid_admin_fields_type = [ 'text', 'textarea', 'checkbox', 'function' ];
        var $ticket_type_id = '';

        function __construct( $ticket_type_id = '' ) {
            $this->ticket_type_id = $ticket_type_id;
            $this->valid_admin_fields_type = apply_filters( 'tc_valid_admin_fields_type', $this->valid_admin_fields_type );
        }

        function TC_Cart_Form( $ticket_type_id = '' ) {
            $this->__construct( $ticket_type_id );
        }

        function get_buyer_info_fields() {

            $user_info = get_userdata( get_current_user_id() );

            $default_fields = array(
                array(
                    'field_name' => 'first_name',
                    'field_title' => __( 'First Name', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true,
                    'default_value' => isset( $user_info->first_name ) ? $user_info->first_name : ''
                ),
                array(
                    'field_name' => 'last_name',
                    'field_title' => __( 'Last Name', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true,
                    'default_value' => isset( $user_info->last_name ) ? $user_info->last_name : ''
                ),
                array(
                    'field_name' => 'email',
                    'field_title' => __( 'E-mail', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true,
                    'validation_type' => 'email',
                    'default_value' => isset( $user_info->user_email ) ? $user_info->user_email : ''
                ),
                array(
                    'field_name' => 'confirm_email',
                    'field_title' => __( 'Confirm E-mail', 'tc' ),
                    'field_type' => 'email',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true,
                    'validation_type' => 'email',
                    'default_value' => isset( $user_info->user_email ) ? $user_info->user_email : ''
                ),
            );

            return apply_filters( 'tc_buyer_info_fields', $default_fields, isset( $ticket_type_id ) ? $ticket_type_id : '' );
        }

        /**
         * Get default value for input text or text area
         *
         * @param $field
         * @return mixed|string
         */
        function get_default_value( $field ) {
            return isset( $field[ 'default_value' ] ) ? $field[ 'default_value' ] : '';
        }

        function get_owner_info_fields( $ticket_type_id = '' ) {

            $excluded_fields = [];
            $tc_general_settings = get_option( 'tc_general_setting', false );

            // Visibility of First and Last Names Fields
            if ( isset( $tc_general_settings[ 'show_attendee_first_and_last_name_fields' ] )
                && 'no' == $tc_general_settings[ 'show_attendee_first_and_last_name_fields' ] ) {
                $excluded_fields = [ 'first_name', 'last_name' ];
            }

            // Visibility of Attendee's Email Fields
            if ( isset( $tc_general_settings[ 'show_owner_email_field' ] )
                && 'no' == $tc_general_settings[ 'show_owner_email_field' ] ) {
                $excluded_fields[] = 'owner_email';
            }

            // Visibility of Attendee's Email Verification Fields
            if ( ( isset( $tc_general_settings[ 'email_verification_buyer_owner' ] ) && 'no' == $tc_general_settings[ 'email_verification_buyer_owner' ] )
                || in_array( 'owner_email', $excluded_fields ) ) {
                $excluded_fields[] = 'owner_confirm_email';
            }

            $default_fields = array(
                array(
                    'field_name' => 'ticket_type_id',
                    'field_title' => __( 'Ticket Type ID', 'tc' ),
                    'field_type' => 'function',
                    'function' => 'tc_get_ticket_type_form_field',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => false
                ),
                array(
                    'field_name' => 'first_name',
                    'field_title' => __( 'First Name', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true
                ),
                array(
                    'field_name' => 'last_name',
                    'field_title' => __( 'Last Name', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true
                ),
                array(
                    'field_name' => 'owner_email',
                    'field_title' => __( 'E-Mail', 'tc' ),
                    'field_type' => 'text',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true
                ),
                array(
                    'field_name' => 'owner_confirm_email',
                    'field_title' => __( 'Confirm E-Mail', 'tc' ),
                    'field_type' => 'email',
                    'field_description' => '',
                    'post_field_type' => 'post_meta',
                    'required' => true
                ),
            );

            // Remove excluded fields from the default fields
            foreach ( $default_fields as $key => $field ) {
                if ( in_array( $field[ 'field_name' ], $excluded_fields ) ) {
                    unset( $default_fields[ $key ] );
                }
            }

            return apply_filters( 'tc_owner_info_fields', $default_fields, $ticket_type_id );
        }

        function get_columns() {

            $fields = $this->get_event_fields();
            $results = search_array( $fields, 'table_visibility', true );

            $columns = array();
            $columns[ 'ID' ] = __( 'ID', 'tc' );

            foreach ( $results as $result ) {
                $columns[ $result[ 'field_name' ] ] = $result[ 'field_title' ];
            }

            $columns[ 'edit' ] = __( 'Edit', 'tc' );
            $columns[ 'delete' ] = __( 'Delete', 'tc' );

            return $columns;
        }

        function check_field_property( $field_name, $property ) {
            $fields = $this->get_event_fields();
            $result = search_array( $fields, 'field_name', $field_name );
            return $result[ 0 ][ 'post_field_type' ];
        }

        function is_valid_event_field_type( $field_type ) {
            return ( in_array( $field_type, $this->valid_admin_fields_type ) ) ? true : false;
        }
    }
}
