var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.editor.BlockControls;

if ( tc_event_tickets_left_block_editor.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    RichText = wp.editor.RichText,
    SelectControl = wp.components.SelectControl,
    RangeControl = wp.components.RangeControl,
    TextControl = wp.components.TextControl,
    ToggleControl = wp.components.ToggleControl;

var __ = wp.i18n.__;

if ( tc_event_tickets_left_block_editor.tc_dev ) {

    var supports_args = {
        html: false,
        spacing: {
            padding: true,
            margin: true,
            __experimentalDefaultControls: {
                padding: true,
                margin: true
            }
        },
        color: {
            background: true,
            gradients: true,
            text: true,
            __experimentalSkipSerialization: true,
            __experimentalDefaultControls: {
                background: true,
                gradients: true,
                text: true
            }
        },
        __experimentalBorder: {
            width: true,
            style: true,
            color: true,
            radius: true,
            __experimentalSkipSerialization: true,
            __experimentalDefaultControls: {
                width: true,
                style: true,
                color: true,
                radius: true,
            }
        },
        typography: {
            fontSize: true,
            lineHeight: true,
            __experimentalFontFamily: true,
            __experimentalFontWeight: true,
            __experimentalFontStyle: true,
            __experimentalTextTransform: true,
            __experimentalTextDecoration: true,
            __experimentalLetterSpacing: true,
            __experimentalDefaultControls: {
                fontSize: true
            }
        }
    };

} else {
    var supports_args = { html: false };
}

registerBlockType( 'tickera/event-tickets-left', {
    title: __( 'Event Tickets Left' ),
    description: __( 'Shows number of tickets left (unsold) for an event' ),
    icon: 'info',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Tickets' ),
        __( 'Left' )
    ],
    supports: supports_args,
    attributes: {
        event_id: {
            type: 'string',
        },
    },
    edit: function( props ) {

        var events = jQuery.parseJSON( tc_event_tickets_left_block_editor.events ),
            event_ids = [];

        events.forEach( function( entry ) {
            event_ids.push( { value: entry[ 0 ], label: entry[ 1 ] } );
        } );

        return [
            el(
                InspectorControls,
                { key: 'controls' },
                el(
                    SelectControl,
                    {
                        label: __( 'Event' ),
                        className: 'tc-gb-component',
                        value: props.attributes.event_id,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { event_id: value } );
                        },
                        options: event_ids
                    }
                ),
            ),
            el( ServerSideRender, {
                block: "tickera/event-tickets-left",
                attributes: props.attributes
            } )
        ];
    },
    save: function( props ) {
        return null;
    },
} );
