<?php if ( 'true' == apply_filters( 'tc_ef_show_event_filters', $tc_show_event_filters ) ) : ?>
    <div class="tc-event-filter">
        <?php if ( 'true' == apply_filters( 'tc_ef_show_event_categories', $tc_show_categories ) ) : ?>
            <div class="tc-categories-list tc-event-filters-section">
                <h5><?php _e( 'Categories:', 'tclist' ); ?></h5>
                <select id="tc_category_ids" class="tc_category_ids tc-multiple-select" <?php if ( !strpos($_SERVER['REQUEST_URI'], 'block-renderer') !== false ) { ?>multiple="multiple" <?php } else { echo 'disabled'; } ?>>
                    <?php foreach ( $tc_event_categories_terms as $tc_single_event_cat ) { ?>
                        <option value="<?php echo $tc_single_event_cat->term_id; ?>"><?php echo $tc_single_event_cat->name; ?></option>
                    <?php } ?>
                </select>
            </div><!-- .tc-categories-list -->
        <?php endif; ?>
        <?php if ( 'true' == apply_filters( 'tc_ef_show_event_date_filter', $tc_show_date_filtering ) ) : ?>
            <div class="tc-event-dates-range tc-event-filters-section">
                <h5><?php _e( 'Date Range:', 'tclist' ); ?></h5>
                <div class="tc-wrap-date-around">
                    <div class="tc-date-wrap">
                        <label><input type="text" autocomplete="off" placeholder="<?php _e( 'Start Date', 'tclist' ); ?>" id="tc_start_date" name="tc_start_date" class="tc-event-datepicker" /></label>
                    </div>
                    <div class="tc-date-wrap">
                        <label><input type="text" autocomplete="off" placeholder="<?php _e( 'End Date', 'tclist' ); ?>" id="tc_end_date" name="tc_end_date" class="tc-event-datepicker" /></label>
                    </div>
                </div>
            </div><!-- .tc-event-dates-range -->
        <?php endif; ?>
        <div class="tc-event-filter-button tc-event-filters-section">
            <button name="tc_filter_events" id="filter_events"><?php _e( 'Filter Events', 'tclist' ); ?></button>
        </div><!-- .tc-event-filters-section -->
    </div><!-- .tc-event-filter -->
<?php endif;
do_action('tc_ef_after_filters');
