var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.BlockControls;

if ( tc_event_filter_vals.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    SelectControl = wp.SelectControl,
    RangeControl = wp.RangeControl,
    TextControl = wp.TextControl,
    ToggleControl = wp.ToggleControl,
    RadioControl = wp.components.RadioControl;

var __ = wp.i18n.__;
registerBlockType( 'tickera/event-filters', {
    title: __( 'Ticket Event Listing' ),
    description: __( 'Display Tickera Events' ),
    icon: 'tickets-alt',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Event' ),
        __( 'Filter' ),
        __( 'List' )
    ],
    supports: {
        html: false,
    },
    attributes: {
        tc_event_categories: {
            type: 'string',
            default: 'all_categories'
        },
        tc_number_of_columns: {
            type: 'string',
            default: 1
        },
        tc_show_event_filters: {
            type: 'boolean',
            default: true,
        },
        tc_show_categories: {
            type: 'boolean',
            default: true,
        },
        tc_show_date_filtering: {
            type: 'boolean',
            default: true,
        },
        tc_show_past_events: {
            type: 'boolean',
            default: true,
        },
        tc_show_excerpt: {
            type: 'boolean',
            default: true,
        },
        tc_show_number_of_posts: {
            type: 'number',
            default: 10,
        },
        tc_show_default_featured_image: {
            type: 'boolean',
            default: true,
        },
        tc_order_events_by: {
            type: 'string',
            default: 'asc'
        }
    },
    edit: function( props ) {

        jQuery( '.tc-display-filter-events' ).addClass( 'tc-remove-spinner' );

        let event_categories = jQuery.parseJSON( tc_event_filter_vals.tc_event_categories ),
            cat_ids = [];

        cat_ids.push( { value: 'all_categories', label: tc_event_filter_vals.allCategories } );
        event_categories.forEach( function( entry ) {
            cat_ids.push( { value: entry[ 'term_id' ], label: entry[ 'name' ] } );
        } );

        return [
            el(
                InspectorControls, { key: 'controls' },
                el( SelectControl, {
                    label: __( 'Choose Event Category' ),
                    className: 'tc-gb-component',
                    value: props.attributes.tc_event_categories,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_event_categories: value } );
                    },
                    options: cat_ids
                } ),
                el( SelectControl, {
                    label: __( 'Number Of Columns' ),
                    className: 'tc-gb-component',
                    value: props.attributes.tc_number_of_columns,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_number_of_columns: value } );
                    },
                    options: [
                        { value: '1', label: __( '1' ) },
                        { value: '2', label: __( '2' ) },
                        { value: '3', label: __( '3' ) },
                        { value: '4', label: __( '4' ) }
                    ]
                } ),
                el( ToggleControl, {
                    label: __( 'Display Past Events' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_past_events,
                    value: props.attributes.tc_show_past_events,
                    onChange: function onChange( value ) {
                        return props.setAttributes( { tc_show_past_events: value } );
                    },

                } ),
                el( ToggleControl, {
                    label: __( 'Display Event Filters' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_event_filters,
                    value: props.attributes.tc_show_event_filters,
                    onChange: function onChange( value ) {
                        return props.setAttributes( { tc_show_event_filters: value } );
                    },
                } ),
                el( ToggleControl, {
                    label: __( 'Display Categories' ),
                    className: 'tc-gb-component',
                    value: props.attributes.tc_show_categories,
                    checked: props.attributes.tc_show_categories,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_show_categories: value } );
                    },
                } ),
                el( ToggleControl, {
                    label: __( 'Display Filtering By Date' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_date_filtering,
                    value: props.attributes.tc_show_date_filtering,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_show_date_filtering: value } );
                    },
                } ),
                el( ToggleControl, {
                    label: __( 'Display Excerpt' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_excerpt,
                    value: props.attributes.tc_show_excerpt,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_show_excerpt: value } );
                    },
                } ),
                el( ToggleControl, {
                    label: __( 'Display Default Featured Image' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_default_featured_image,
                    value: props.attributes.tc_show_default_featured_image,
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_show_default_featured_image: value } );
                    },

                } ),
                el( RadioControl, {
                    label: __( 'Order Events By' ),
                    className: 'tc-gb-component',
                    selected: props.attributes.tc_order_events_by,
                    options: [ { value: 'asc', label: __( 'ASC' ) }, { value: 'desc', label: __( 'DESC' ) }, ],
                    onChange: function change_val( value ) {
                        return props.setAttributes( { tc_order_events_by: value } );
                    },
                } ),
                el( TextControl, {
                    label: __( 'Display Number Of Posts' ),
                    className: 'tc-gb-component',
                    checked: props.attributes.tc_show_number_of_posts,
                    value: props.attributes.tc_show_number_of_posts,
                    onChange: function change_val( value ) {
                        let _value = parseInt( value );
                        _value = ( !isNaN( _value ) ) ? _value : 0;
                        return props.setAttributes( { tc_show_number_of_posts: _value } );
                    },
                } )
            ),
            el( ServerSideRender, {
                block: "tickera/event-filters",
                attributes: props.attributes
            } )
        ];
    },
    save: function( props ) {

        var content = props.attributes.content,
            alignment = props.attributes.alignment;

        return el( wp.blockEditor.RichText.Content, {
            className: props.className,
            style: { textAlign: alignment },
            value: content
        } );
    },
} );
