var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.editor.BlockControls;

if ( tc_calendar_block_editor.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    RichText = wp.editor.RichText,
    SelectControl = wp.components.SelectControl,
    RangeControl = wp.components.RangeControl,
    TextControl = wp.components.TextControl,
    ToggleControl = wp.components.ToggleControl;

var __ = wp.i18n.__;

registerBlockType( 'tickera/event-calendar', {
    title: __( 'Event Calendar' ),
    description: __( 'Shows event calendar' ),
    icon: 'calendar',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Event' ),
        __( 'Calendar' )
    ],
    supports: {
        html: true,
    },
    attributes: {
        color_scheme: {
            type: 'string',
            default: 'default'
        },
        lang: {
            type: 'string',
            default: 'en'
        },
        show_past_events: {
            type: 'boolean',
            default: false
        },
        event_terms: {
            type: 'array'
        }
        // display_popup_title: {
        //     type: 'boolean',
        //     default: false
        // },
    },
    edit: function( props ) {

        var color_schemes_list = jQuery.parseJSON( tc_calendar_block_editor.color_schemes ),
            color_schemes_ids = [],
            languages_ids = [ { value: 'en', label: 'English' }, { value: 'ar-ma', label: 'Arabic (Morocco)' }, { value: 'ar-sa', label: 'Arabic (Saudi Arabia)' }, { value: 'ar-tn', label: 'Arabic (Tunisia)' }, { value: 'ar', label: 'Arabic' }, { value: 'bg', label: 'Bulgarian' }, { value: 'ca', label: 'Catalan' }, { value: 'cs', label: 'Czech' }, { value: 'da', label: 'Danish' }, { value: 'de-at', label: 'German (Austria)' }, { value: 'de', label: 'German' }, { value: 'el', label: 'Greek' }, { value: 'en-au', label: 'English (Australia)' }, { value: 'en-ca', label: 'English (Canada)' }, { value: 'en-gb', label: 'English (United Kingdom)' }, { value: 'es', label: 'Spanish' }, { value: 'fi', label: 'Finnish' }, { value: 'fr-ca', label: 'French (Canada)' }, { value: 'fr', label: 'French' }, { value: 'he', label: 'Hebrew' }, { value: 'hi', label: 'Hindi (India)' }, { value: 'hr', label: 'Croatian' }, { value: 'hu', label: 'Hungarian' }, { value: 'id', label: 'Indonesian' }, { value: 'is', label: 'Icelandic' }, { value: 'it', label: 'Italian' }, { value: 'ja', label: 'Japanese' }, { value: 'ko', label: 'Korean' }, { value: 'lt', label: 'Lithuanian' }, { value: 'lv', label: 'Latvian' }, { value: 'nb', label: 'Norwegian Bokmål (Norway)' }, { value: 'nl', label: 'Dutch' }, { value: 'pl', label: 'Polish' }, { value: 'pt-br', label: 'Portuguese (Brazil)' }, { value: 'pt', label: 'Portuguese' }, { value: 'ro', label: 'Romanian' }, { value: 'ru', label: 'Russian' }, { value: 'sk', label: 'Slovak' }, { value: 'sl', label: 'Slovenian' }, { value: 'sr-cyrl', label: 'Serbian Cyrillic' }, { value: 'sr', label: 'Serbian' }, { value: 'sv', label: 'Swedish' }, { value: 'th', label: 'Thai' }, { value: 'tr', label: 'Turkish' }, { value: 'uk', label: 'Ukrainian' }, { value: 'vi', label: 'Vietnamese' }, { value: 'zh-cn', label: 'Chinese (China)' }, { value: 'zh-tw', label: 'Chinese (Taiwan)' } ];

        var event_terms = jQuery.parseJSON( tc_calendar_block_editor.event_terms ),
            terms = [];

        event_terms.forEach( function( entry ) {
            terms.push( { value: entry[ 0 ], label: entry[ 1 ] } );
        } );

        color_schemes_list.forEach( function( entry ) {
            color_schemes_ids.push( { value: entry[ 0 ], label: entry[ 1 ] } );
        } );

        return [
            el(
                InspectorControls,
                { key: 'controls' },
                el(
                    SelectControl,
                    {
                        label: __( 'Color Scheme' ),
                        className: 'tc-gb-component',
                        value: props.attributes.color_scheme,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { color_scheme: value } );
                        },
                        options: color_schemes_ids
                    }
                ),
                el(
                    SelectControl,
                    {
                        label: __( 'Language' ),
                        className: 'tc-gb-component',
                        value: props.attributes.lang,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { lang: value } );
                        },
                        options: languages_ids
                    }
                ),
                el(
                    ToggleControl,
                    {
                        label: __( 'Show Past Events' ),
                        className: 'tc-gb-component',
                        checked: props.attributes.show_past_events,
                        value: props.attributes.show_past_events,
                        onChange: function onChange( value ) {
                            return props.setAttributes( { show_past_events: value } );
                        },
                    }
                ),
                el(
                    SelectControl,
                    {
                        multiple: true,
                        label: __( 'Event Categories' ),
                        className: 'tc-gb-component',
                        value: props.attributes.event_terms,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { event_terms: value } );
                        },
                        options: terms
                    }
                ),
                // el(
                //     ToggleControl,
                //     {
                //         label: __( 'Show Event Image on Hover' ),
                //         className: 'tc-gb-component',
                //         checked: props.attributes.display_popup_title,
                //         value: props.attributes.display_popup_title,
                //         onChange: function onChange( value ) {
                //             return props.setAttributes( { display_popup_title: value } );
                //         },
                //     }
                // ),
            ),
            el( ServerSideRender, {
                block: "tickera/event-calendar",
                attributes: props.attributes
            } )
        ];
    },
    save: function( props ) {
        return null;
    },
} );
