( function( $ ) {

    $( document ).ready( function() {

        /**
         * Render add to cart button.
         * Table with Event tickets - Shortcode
         * Display Type: Dropdown
         */
        $( document ).on( 'change', '.tc-wb-event-dropdown-wrap select.ticket-type-id', function() {

            let wrapper = $( this ).closest( '.tc-wb-event-dropdown-wrap' ),
                ticketId = $( this ).val(),
                actionsContainer = wrapper.find( '.actions' ),
                addToCartContainer = actionsContainer.find( '[id="ticket-type-' + ticketId + '"]' );

            addToCartContainer.prependTo( actionsContainer );
        });

        /**
         * Update add to cart data-quantity attribute on quantity change.
         */
        $( document ).on( 'change', '.tc-wb-quantity-selector', function() {

            let wrapper = $( this ).closest( '.event_tickets' ),
                quantity = $( this ).val();

            wrapper = ( ! wrapper.length )
                ? $( this ).closest( '.tc-wb-event-dropdown-wrap' ) // Display type: Dropdown
                : wrapper; // Display type: Table

            wrapper.find( '.tc-wb-add-to-cart .add_to_cart_button' ).attr( 'data-quantity', quantity );
        });
    });

} )( jQuery );
