( function ( $ ) {

    /**
     * General
     */
    $( document ).ready( function() {
        tcbw.init();
    } );

    const tcbw = {

        init: function() {

            // Initialize Chosen
            $( '.tc_chosen' ).each( function() {
                tc_admin.chosen( $( this ) );
                tc_admin.fix_chosen( $( this ) );
            });

            tcbw.tc_show_and_hide_panels();
            tcbw.tc_show_and_hide_ticket_checkin_availability_dates();
            tcbw.tc_show_and_hide_ticket_checkin_availability_after_order_time();
            tcbw.tc_show_and_hide_ticket_checkin_availability_after_first_checkin();
            tcbw.tc_show_and_hide_ticket_availability_dates();
            tcbw.tc_show_and_hide_checkins_time_basis_fields();
        },

        /**
         * Toggle Ticket's Options
         */
        tc_show_and_hide_panels: function() {

            $( document ).on( 'change', 'input#_tc_is_ticket', function() {
                tcbw.tc_show_and_hide_panels();
            } );

            let is_ticket = $( 'input#_tc_is_ticket:checked' ).length;
            if ( is_ticket ) {
                $( '.show_if_tc_ticket' ).show();

            } else {
                $( '.show_if_tc_ticket' ).hide();
            }
        },

        /**
         * Available dates / times for check-in
         * Option: During selected date range
         */
        tc_show_and_hide_ticket_checkin_availability_dates: function() {

            $( document ).on( 'change', 'input[name="_ticket_checkin_availability"]', function() {
                tcbw.tc_show_and_hide_ticket_checkin_availability_dates();
                tcbw.tc_show_and_hide_ticket_checkin_availability_after_order_time();
                tcbw.tc_show_and_hide_ticket_checkin_availability_after_first_checkin();
            } );

            let _ticket_checkin_availability_element_exist = $( 'input[name="_ticket_checkin_availability"]' ).size();
            if ( _ticket_checkin_availability_element_exist ) {

                let _ticket_availability = $( 'input[name="_ticket_checkin_availability"]:checked' ).val();
                if ( 'range' == _ticket_availability ) {
                    $( '#_ticket_checkin_availability_dates' ).show();

                } else {
                    $( '#_ticket_checkin_availability_dates' ).hide();
                }
            }
        },

        /**
         * Available dates / times for check-in
         * Option: Within the following time after order is placed
         */
        tc_show_and_hide_ticket_checkin_availability_after_order_time: function() {

            let _ticket_checkin_availability_element_exist = $( 'input[name="_ticket_checkin_availability"]' ).size();
            if ( _ticket_checkin_availability_element_exist ) {

                let _ticket_availability = $( 'input[name="_ticket_checkin_availability"]:checked' ).val();
                if ( 'time_after_order' == _ticket_availability ) {
                    $( '#_ticket_checkin_availability_after_order_time' ).show();

                } else {
                    $( '#_ticket_checkin_availability_after_order_time' ).hide();
                }
            }
        },

        /**
         * Available dates / times for check-in
         * Option: Within the following time after first check-in
         */
        tc_show_and_hide_ticket_checkin_availability_after_first_checkin: function() {

            let _ticket_checkin_availability_element_exist = $( 'input[name="_ticket_checkin_availability"]' ).size();
            if ( _ticket_checkin_availability_element_exist ) {

                let _ticket_availability = $( 'input[name="_ticket_checkin_availability"]:checked' ).val();
                if ( 'time_after_first_checkin' == _ticket_availability ) {
                    $( '#_ticket_checkin_availability_after_first_checkin' ).show();

                } else {
                    $( '#_ticket_checkin_availability_after_first_checkin' ).hide();
                }
            }
        },

        /**
         * Available dates for tickets selling
         * Option: During selected date range
         */
        tc_show_and_hide_ticket_availability_dates: function() {

            $( document ).on( 'change', 'input[name="_ticket_availability"]', function() {
                tcbw.tc_show_and_hide_ticket_availability_dates();
            } );

            let _ticket_availability_element_exist = $( 'input[name="_ticket_availability"]' ).size();
            if ( _ticket_availability_element_exist ) {

                let _ticket_availability = $( 'input[name="_ticket_availability"]:checked' ).val();
                if ( 'range' == _ticket_availability ) {
                    $( '#_ticket_availability_dates' ).show();

                } else {
                    $( '#_ticket_availability_dates' ).hide();
                }
            }
        },

        /**
         * Limit Check-ins on Time Basis
         */
        tc_show_and_hide_checkins_time_basis_fields: function() {

            $( document ).on( 'change', 'input[name="_checkins_time_basis"]', function() {
                tcbw.tc_show_and_hide_checkins_time_basis_fields();
            } );

            let _checkins_time_basis = $( 'input[name="_checkins_time_basis"]' ).size();
            if ( _checkins_time_basis ) {

                let enabled = $( 'input[name="_checkins_time_basis"]:checked' ).val();
                if ( enabled ) {
                    $( '#_checkins_time_basis_fields' ).show();

                } else {
                    $( '#_checkins_time_basis_fields' ).hide();
                }
            }
        }
    };

})( jQuery );
