( function ( $ ) {

    var template_classes = new Array(),
        dropareaCounter = 0;

    $( document ).ready( function() {
        tccf.init();
    } );

    const tccf = {

        init: function() {

            $( window ).resize( function() {
                tccf.tc_fix_template_elements_sizes();
            } );

            $( window ).scroll( tccf.sticky_relocate );
            tccf.sticky_relocate();

            tccf.wp_media_browser();
            tccf.init_fields();
            tccf.cf_delete_field();
            tccf.on_submit();

            tccf.sortable();
            tccf.draggable();

            tccf.tc_custom_forms_change_events();
            tccf.on_checkbox_change();
            tccf.update_li();
            tccf.tc_fix_template_elements_sizes();
        },

        init_fields: function() {

            $( '.tc_forms_wrap #side-sortables input[type="text"]' ).val( '' );
            $( '.tc_forms_wrap #side-sortables input[type="hidden"]' ).val( '' );
            $( '.tc_forms_wrap #side-sortables textarea' ).val( '' );

            $( '.tc-custom-forms-droparea' ).on( 'DOMSubtreeModified', function() {

                if ( ! dropareaCounter ) {
                    tccf.cf_delete_field();
                    dropareaCounter++;
                }
            } );
        },

        init_chosen: function( action ) {

            $( '.tc-custom-forms-droparea select' ).each( function() {

                if ( typeof $( this ).data( 'chosen' ) === 'undefined' ) {
                    $( this ).chosen( { disable_search_threshold: 5 } );
                }

                $( this ).css( { 'width': '25em', 'display': 'none' } ).attr( 'data-chosen', true );
                $( this ).next().css( { 'width': '100%', 'max-width': '27em', 'min-width': '1em' } );
            });
        },

        sticky_relocate: function() {

            if ( $( '#sticky-anchor' ).length ) {

                var window_top = $( window ).scrollTop(),
                    div_top = $( '#sticky-anchor' ).offset().top;

                if ( window_top > div_top ) {
                    $( '.tc-custom-forms-dragables-wrap' ).addClass( 'tc-custom-form-stick' );

                } else {
                    $( '.tc-custom-forms-dragables-wrap' ).removeClass( 'tc-custom-form-stick' );
                }
            }
        },

        sortable: function() {

            $( '.rows' ).sortable( {
                items: 'ul',
                receive: function( template, ui ) {
                    tccf.update_rows();
                },
                stop: function( template, ui ) {
                    tccf.update_rows();
                    tccf.tc_custom_forms_change_events();
                }
            } );

            $( '.form-layout ul.sortables' ).sortable( {
                connectWith: 'ul',
                forcePlaceholderSize: true,
                receive: function( template, ui ) {
                    $( '.rows ul li' ).last().addClass( 'last_child' );
                    tccf.update_li();
                },
                stop: function( template, ui ) {
                    tccf.update_li();
                    $( '.rows ul li' ).last().addClass( 'last_child' );
                    tccf.tc_custom_forms_change_events();
                }
            } );
        },

        draggable: function() {

            // Destroy all chosen fields to avoid duplicates in later action
            $( '.draggable li' ).each( function() {
                let selectField = $( this ).find( 'select' );
                selectField.chosen( 'destroy' );
            });

            $( '.draggable li' ).draggable( {
                helper: 'clone',
                connectToSortable: '.form-layout ul.sortables',
                drag: function() {
                    dropareaCounter = 0;
                }
            } );
        },

        update_rows: function() {

            $( '.rows ul' ).each( function( index ) {
                $( this ).attr( 'id', 'row_' + ( index + 1 ) );
                $( this ).find( '.rows_classes' ).attr( 'name', 'rows_' + ( index + 1 ) + '_post_meta' );
                $( this ).find( '.field_row' ).val( index + 1 );
            } );
        },

        update_li: function() {

            var children_num = 0;

            $( '.rows ul' ).each( function() {

                var row_id = $( this ).attr( 'id' );

                if ( typeof row_id !== 'undefined' ) {
                    var row_num = row_id.replace( "row_", "" );
                    $( '#' + row_id + ' .field_row' ).val( row_num );
                }

                template_classes.length = 0; // Empty the array
                children_num = $( this ).children( 'li' ).length;

                $( this ).children( 'li' ).removeClass();
                $( this ).children( 'li' ).addClass( 'ui-state-default' );
                $( this ).children( 'li' ).addClass( 'cols cols_' + children_num );
                $( this ).children( 'li' ).last().addClass( 'last_child' );
                $( this ).find( 'li' ).each( function( index, element ) {
                    $( this ).find( '.field_order' ).val( index );
                    if ( $.inArray( $( this ).attr( 'data-class' ), template_classes ) == -1 ) {
                        template_classes.push( $( this ).attr( 'data-class' ) );
                    }
                } );

                $( this ).find( '.rows_classes' ).val( template_classes.join() );
            } );

            tccf.tc_fix_template_elements_sizes()
            tccf.init_chosen();
        },

        tc_custom_forms_change_events: function() {

            $( '.required_check' ).change( function() {

                if ( this.checked ) {
                    $( this ).parent().find( '.field_required' ).val( '1' );

                } else {
                    $( this ).parent().find( '.field_required' ).val( '0' );
                }
            } );

            $( '.order_column_check' ).change( function() {

                if ( this.checked ) {
                    $( this ).parent().find( '.field_order_column' ).val( '1' );

                } else {
                    $( this ).parent().find( '.field_order_column' ).val( '0' );
                }
            } );

            $( '.order_details_check' ).change( function() {

                if ( this.checked ) {
                    $( this ).parent().find( '.field_order_details' ).val( '1' );

                } else {
                    $( this ).parent().find( '.field_order_details' ).val( '0' );
                }
            } );

            $( '.export_check' ).change( function() {

                if ( this.checked ) {
                    $( this ).parent().find( '.field_export' ).val( '1' );

                } else {
                    $( this ).parent().find( '.field_export' ).val( '0' );
                }
            } );

            $( '.as_ticket_template_check' ).change( function() {

                if ( this.checked ) {
                    $( this ).parent().find( '.field_as_ticket_template' ).val( '1' );

                } else {
                    $( this ).parent().find( '.field_as_ticket_template' ).val( '0' );
                }
            } );
        },

        tc_fix_template_elements_sizes: function() {

            $( '.rows ul' ).each( function() {

                var maxHeight = -1;

                $( this ).find( 'li' ).each( function() {
                    $( this ).removeAttr( 'style' );
                    maxHeight = maxHeight > $( this ).height() ? maxHeight : $( this ).height();
                } );

                $( this ).find( 'li' ).each( function() {
                    $( this ).height( maxHeight + 10 );
                } );
            } );

            $( '#side-sortables .sortables li' ).each( function() {
                $( this ).height( 'auto' );
            } );
        },

        on_checkbox_change: function() {

            $( 'body' ).on( 'change', '.tc_custom_forms_editable .field-checkbox', function( e ) {

                var checkbox_values_field = $( this ).parent().parent().find( '.checkbox_values' );
                checkbox_values_field.val( '' );

                $( this ).parent().parent().find( 'input' ).each( function( key, value ) {
                    if ( $( this ).is( ':checked' ) ) {
                        checkbox_values_field.val( checkbox_values_field.val() + '' + $( this ).val() + ',' );
                    }
                } );
            } );
        },

        /**
         * Native WP media browser for file module (for instructors)
         */
        wp_media_browser: function() {

            $( '.file_url_button' ).on( 'click', function() {
                var target_url_field = $( this ).prevAll( '.file_url:first' );
                wp.media.editor.send.attachment = function( props, attachment ) {
                    $( target_url_field ).val( attachment.url );
                };
                wp.media.editor.open( this );
                return false;
            } );
        },

        cf_delete_field: function() {

            $( '.tc-custom-field-delete' ).on( 'click', function() {

                var post_id = $( this ).parent().parent().find( '.field_post_id' ).val();
                $( this ).parent().parent().remove();

                if ( post_id !== '' ) {
                    $( '.tc_forms_wrap form' ).append( '<input type="hidden" name="fields_to_remove[]" value="' + post_id + '" />' );
                }

                tccf.update_li();
                tccf.tc_fix_template_elements_sizes();
            } );
        },

        on_submit: function() {

            $( '#tc_custom_forms_add_new_form' ).click( function( e ) {

                $( '.cf-required-field' ).each( function() {
                    $( this ).remove();
                } );

                let required = 0;

                $( '.tc-custom-forms-droparea .cf-required' ).each( function() {
                    if ( $( this ).val().length === 0 ) {
                        $( this ).after( '<p class="cf-required-field">' + tc_custom_fields_vars.error_message_required + '</p>' );
                        required = 1;
                    }
                } );

                if ( required === 1 ) {
                    e.preventDefault();
                }
            } );
        }
    }

})( jQuery );
