<?php
global $plugin_url, $version;
$additional_classes = isset( $attributes[ 'className' ] ) ? sanitize_text_field( $attributes[ 'className' ] ) : '';
$version = rand( 99, 9999999 ); ?>
<!DOCTYPE html>
<html>
<head>
    <?php
    $raw_checkinera_setting_fields = TC_Checkinera_Settings::get_checkinera_fields();

    // Initialize default min/max tickets per page values
    $min_tickets_per_page = 10;
    $max_tickets_per_page = 50;

    foreach ( $raw_checkinera_setting_fields as $key => $field ) {

        if ( 'tickets_per_page' == $field[ 'field_name' ] ) {
            $min_tickets_per_page = $field[ 'min' ];
            $max_tickets_per_page = $field[ 'max' ];
            break;
        }
    }

    $tc_checkinera_settings = get_option( 'tc_checkinera_settings' );

    if ( isset( $tc_checkinera_settings['use_analytics'] ) && 'yes' == $tc_checkinera_settings['use_analytics'] ) {
        echo stripslashes($tc_checkinera_settings['analytics_code']);
    }

    if ( isset( $tc_checkinera_settings['tickets_per_page'] ) && $tc_checkinera_settings['tickets_per_page'] ) {

        if ( $tc_checkinera_settings['tickets_per_page'] < $min_tickets_per_page ) {
            $tickets_per_page = $min_tickets_per_page;

        } elseif ( $tc_checkinera_settings['tickets_per_page'] > $max_tickets_per_page ) {
            $tickets_per_page = $max_tickets_per_page;

        } else {
            $tickets_per_page = $tc_checkinera_settings['tickets_per_page'];
        }

    } else {
        $tickets_per_page = "10";
    }
    ?>
    <link rel="shortcut icon" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/favicon.ico'; ?>" type="image/x-icon" />
    <link rel="apple-touch-icon" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon.png'; ?>" />
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-57x57.png'; ?>" />
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-72x72.png'; ?>" />
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-76x76.png'; ?>" />
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo trailingslashit( $plugin_url) . '/assets/images/icons/apple-touch-icon-114x114.png'; ?>" />
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-120x120.png'; ?>" />
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-144x144.png'; ?>" />
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-152x152.png'; ?>" />
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo trailingslashit( $plugin_url ) . '/assets/images/icons/apple-touch-icon-180x180.png'; ?>" />
    <!--<link rel="manifest" href="<?php // echo trailingslashit( $plugin_url ) . '/assets/manifest.json?v=' . $version; ?>">-->
    <meta name="viewport" content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width,viewport-fit=cover">
    <link rel="stylesheet" type="text/css" href="<?php echo trailingslashit( $plugin_url ) . '/assets/css/main.css?v=' . $version; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo trailingslashit( $plugin_url ) . '/assets/css/colors.css?v=' . $version; ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo trailingslashit( $plugin_url ) . '/assets/css/responsive.css?v=' . $version; ?>">
    <script src="https://code.jquery.com/jquery-3.4.1.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
    <script type="text/javascript" src="<?php echo trailingslashit( $plugin_url ) . '/assets/js/keypress-2.1.3.min.js?v=' . $version; ?>"></script>
    <script type="text/javascript" src="<?php echo trailingslashit( $plugin_url ) . '/assets/js/notify.js?v=' . $version; ?>"></script>
    <script type="text/javascript" src="<?php echo trailingslashit( $plugin_url ) . '/assets/js/main.js?v=' . $version; ?>"></script>
    <script type='text/javascript'>
        /* <![CDATA[ */
        var checkinera_ajax = {
            "ajaxUrl"           : "<?php echo admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ); ?>",
            "fail_sound_url"    : "<?php echo trailingslashit( $plugin_url ) . '/assets/sounds/fail.mp3'; ?>",
            "use_ga"            : "<?php echo ( isset( $tc_checkinera_settings['use_analytics'] ) && 'yes' == $tc_checkinera_settings['use_analytics'] ) ? "1" : "0"; ?>",
            "track_logins_ga"   : "<?php echo ( isset( $tc_checkinera_settings['track_logins_ga'] ) && 'yes' == $tc_checkinera_settings['track_logins_ga'] ) ? "1" : "0"; ?>",
            "track_checkins_ga" : "<?php echo ( isset( $tc_checkinera_settings['track_checkins_ga'] ) && 'yes' == $tc_checkinera_settings['track_checkins_ga'] ) ? "1" : "0"; ?>",
            "tickets_per_page"    : "<?php echo $tickets_per_page; ?>",
        };
        /* ]]> */
    </script>
    <?php do_action( 'tc_checkinera_after_header_scripts' ); ?>
    <title class="APP_TITLE"><?php _e( 'Check-in', 'tc_ch' ); ?></title>
    <style><?php echo tc_checkinera_css_colors(); ?></style>
</head>
<body class="<?php echo esc_attr( $additional_classes ); ?>">
    <div class="tc-status-wrap">
        <div class="online_status">
            <div class="online"><span class="icon-wireless"></span></div>
            <div class="offline"><span class="icon-wireless-offline"></span></div>
        </div>
    </div><!-- .tc-status-wrap -->
    <?php include_once( 'layout-login.php' ); ?>
    <?php if( chk_fs()->can_use_premium_code() ){ ?>
        <?php include_once( 'layout-home.php' ); ?>
        <?php include_once( 'layout-list.php' ); ?>
        <?php include_once( 'layout-attendee.php' ); ?>
        <?php include_once( 'layout-checkin.php' ); ?>
        <div id="checkinera-singout">
            <div class="tc-checkiner-singout-inside">
                <span class="tc-dialog-title SIGN_OUT"><?php _e( 'Sign Out', 'tc_ch' ); ?></span>
                <div class="tc-dialog-content">
                    <p class="DIALOG_TEXT"><?php _e( 'Are you sure you want to sign out?', 'tc_ch' ); ?></p>
                    <button class="checkinera_signout SIGN_OUT"><?php _e( 'Sign Out', 'tc_ch' ); ?></button>
                    <button class="checkinera_signout_cancel CANCEL"><?php _e( 'Cancel', 'tc_ch' ); ?></button>
                </div>
            </div>
        </div>
    <?php } ?>
</body>
</html>
