<?php

/**
 * Plugin Name: Checkinera
 * Plugin URI: https://tickera.com
 * Description: Attendee check in app for Tickera. Just place a shortcode <strong>[tc_checkin]</strong> in a page / post content
 * Author: Tickera
 * Author URI: https://tickera.com
 * Version: 1.3.6

 * Update URI: https://api.freemius.com
 * TextDomain: tc_ch
 * Domain Path: /languages/
 * Copyright 2020 Tickera (https://tickera.com)
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly

if ( !class_exists( 'Checkinera' ) ) {
    class Checkinera
    {
        public  $version = '1.3.6' ;
        public  $title = 'Checkinera' ;
        public  $name = 'checkinera' ;
        public  $dir_name = 'checkinera-premium' ;
        public  $location = 'plugins' ;
        public  $plugin_dir = '' ;
        public  $plugin_url = '' ;
        public function __construct()
        {
            global  $pagenow ;
            // Quick and easy white label
            if ( defined( 'CHECKIN_PLUGIN_TITLE' ) ) {
                $this->title = CHECKIN_PLUGIN_TITLE;
            }
            if ( defined( 'CHECKIN_PLUGIN_NAME' ) ) {
                $this->name = CHECKIN_PLUGIN_NAME;
            }
            if ( defined( 'CHECKIN_PLUGIN_DIR_NAME' ) ) {
                $this->dir_name = CHECKIN_PLUGIN_TITLE;
            }
            $this->init_vars();
            add_shortcode( 'tc_checkin', array( $this, 'tc_checkin_shortcode' ) );
            add_action( 'template_redirect', array( $this, 'template_redirect' ), 1 );
            add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
            add_action( 'admin_enqueue_scripts', array( $this, 'admin_header' ) );
            add_filter( 'tc_pages_array', array( $this, 'tc_add_checkinera_page' ) );
            // Ajax requests
            add_action( 'wp_ajax_checkinera_check_credentials', array( $this, 'api_check_credentials' ) );
            add_action( 'wp_ajax_nopriv_checkinera_check_credentials', array( $this, 'api_check_credentials' ) );
            add_action( 'wp_ajax_checkinera_translation', array( $this, 'api_translation' ) );
            add_action( 'wp_ajax_nopriv_checkinera_translation', array( $this, 'api_translation' ) );
            add_action( 'wp_ajax_checkinera_event_essentials', array( $this, 'event_essentials' ) );
            add_action( 'wp_ajax_nopriv_checkinera_event_essentials', array( $this, 'event_essentials' ) );
            add_action( 'wp_ajax_checkinera_tickets_info', array( $this, 'tickets_info' ) );
            add_action( 'wp_ajax_nopriv_checkinera_tickets_info', array( $this, 'tickets_info' ) );
            add_action( 'wp_ajax_checkinera_ticket_checkins', array( $this, 'ticket_checkins' ) );
            add_action( 'wp_ajax_nopriv_checkinera_ticket_checkins', array( $this, 'ticket_checkins' ) );
            add_action( 'wp_ajax_checkinera_check_in', array( $this, 'check_in' ) );
            add_action( 'wp_ajax_nopriv_checkinera_check_in', array( $this, 'check_in' ) );
            add_action( 'wp_ajax_checkinera_sync', array( $this, 'sync' ) );
            add_action( 'wp_ajax_nopriv_checkinera_sync', array( $this, 'sync' ) );
            add_filter( 'tc_shortcodes', array( $this, 'chk_shortcode_list' ) );
            add_filter( 'tc_gutenberg_blocks', array( $this, 'modify_gutenberg_blocks_list' ) );
            // Register Gutenberg Blocks
            
            if ( function_exists( 'register_block_type' ) && 'widgets.php' != $pagenow ) {
                add_action( 'init', array( $this, 'tc_register_checkin_gutenberg_blocks' ) );
                add_action( 'enqueue_block_editor_assets', array( $this, 'register_extra_scripts' ) );
            }
            
            // Load color settings class
            require_once $this->plugin_dir . 'includes/classes/checkinera_settings.php';
            // Load chk_fields class
            require_once $this->plugin_dir . 'includes/classes/class-fields.php';
            add_filter(
                'checkinera_ssl_verify',
                array( $this, 'add_exception' ),
                98,
                2
            );
        }
        
        /**
         * Setup proper directories
         */
        function init_vars()
        {
            
            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;
            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc_ch' ), $this->title ) );
            }
        
        }
        
        function in_admin_pages_require_admin_styles()
        {
            $tc_get_page = ( isset( $_GET['page'] ) ? $_GET['page'] : '' );
            return ( $tc_get_page == $this->name . '_tc_admin' ? true : false );
        }
        
        function admin_header()
        {
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_media();
            wp_enqueue_script( 'media-upload' );
            wp_enqueue_script(
                $this->name . '-checkinera-admin-script',
                $this->plugin_url . 'assets/js/admin.js',
                array( 'jquery', 'wp-color-picker', 'jquery-ui-tooltip' ),
                '1.0.0',
                true
            );
            wp_enqueue_style(
                $this->name . '-admin',
                $this->plugin_url . 'assets/css/admin.css',
                array(),
                $this->version
            );
        }
        
        function register_extra_scripts()
        {
            global  $wp_version ;
            wp_register_script(
                'tc_checkin_block_editor',
                plugins_url( 'gutenberg/tc_checkin_block_editor.js', __FILE__ ),
                array(
                'wp-editor',
                'wp-blocks',
                'wp-i18n',
                'wp-element',
                'jquery'
            ),
                $this->version
            );
            wp_localize_script( 'tc_checkin_block_editor', 'tc_checkin_block_editor', array(
                'since_611' => ( version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ),
            ) );
            wp_enqueue_script( 'tc_checkin_block_editor' );
        }
        
        function tc_register_checkin_gutenberg_blocks()
        {
            register_block_type( 'tickera/checkin', array(
                'editor_script'   => 'tc_checkin_block_editor',
                'render_callback' => array( $this, 'tc_checkin_shortcode' ),
                'attributes'      => [],
            ) );
        }
        
        /**
         * Add plugin admin menu items
         */
        function add_admin_menu()
        {
            $handler = 'tc_admin';
            $capability = 'manage_options';
            add_menu_page(
                $this->name,
                $this->title,
                $capability,
                $handler . '_' . $this->name,
                'Checkinera::admin_settings',
                'dashicons-yes'
            );
            add_submenu_page(
                $this->name . '_' . $handler,
                '',
                '',
                $capability,
                $handler . ' ' . $this->name,
                'Checkinera::admin_settings'
            );
        }
        
        public static function admin_settings()
        {
            require_once 'includes/admin-pages/settings.php';
        }
        
        function tc_add_checkinera_page( $tc_pages_array )
        {
            $tc_pages_array[] = 'tc_admin_checkinera';
            return $tc_pages_array;
        }
        
        function get_page_content( $post_id = 0, $more_link_text = null, $stripteaser = false )
        {
            global  $post ;
            $post = get_post( $post_id );
            setup_postdata( $post, $more_link_text, $stripteaser );
            return get_the_content();
            wp_reset_postdata( $post );
        }
        
        function tc_checkin_shortcode( $attributes = '' )
        {
            ob_start();
            global  $plugin_url, $version ;
            $plugin_url = $this->plugin_url;
            $version = $this->version;
            include $this->plugin_dir . 'layout.php';
            return ob_get_clean();
        }
        
        function template_redirect( $some )
        {
            $post = get_post();
            $page_object = get_queried_object();
            $page_id = get_queried_object_id();
            $content = $this->get_page_content( $page_id );
            
            if ( isset( $post->post_content ) && has_blocks( $post->post_content ) ) {
                $blocks = parse_blocks( $post->post_content );
                foreach ( $blocks as $single_block ) {
                    
                    if ( $single_block['blockName'] === 'tickera/checkin' ) {
                        echo  $this->tc_checkin_shortcode() ;
                        exit;
                    } elseif ( $single_block['blockName'] === 'core/paragraph' && strpos( $single_block['innerHTML'], 'tc_checkin' ) !== false ) {
                        echo  $this->tc_checkin_shortcode() ;
                        exit;
                    }
                
                }
            } elseif ( has_shortcode( $content, 'tc_checkin' ) ) {
                echo  $this->tc_checkin_shortcode() ;
                exit;
            }
        
        }
        
        function api_post( $url, $args = array() )
        {
            $response = wp_remote_post( $url, array(
                'method'      => 'POST',
                'timeout'     => 45,
                'redirection' => 5,
                'httpversion' => '1.0',
                'blocking'    => true,
                'headers'     => array(),
                'body'        => $args,
                'cookies'     => array(),
                'sslverify'   => apply_filters( 'checkinera_ssl_verify', true, $url ),
            ) );
            $response = ( is_wp_error( $response ) ? $response->get_error_message() : wp_remote_retrieve_body( $response ) );
            if ( defined( 'TC_DEBUG' ) && TC_DEBUG && !$this->is_json( $response ) ) {
                if ( $this->is_html( $response ) ) {
                    wp_send_json( [
                        'error' => htmlspecialchars( $response ),
                    ] );
                }
            }
            return $response;
        }
        
        function add_exception( $value, $url )
        {
            $domain_list = array();
            $domain_list[] = 'update.tickera.com';
            $home_domain_parse = parse_url( home_url() );
            $home = $home_domain_parse['host'];
            $domain_list[] = $home;
            $parse = parse_url( $url );
            $domain = $parse['host'];
            if ( in_array( $domain, $domain_list ) ) {
                return false;
            }
            return $value;
        }
        
        function is_html( $string )
        {
            return ( $string != strip_tags( $string ) ? true : false );
        }
        
        function is_json( $string )
        {
            json_decode( $string );
            return json_last_error() == JSON_ERROR_NONE;
        }
        
        /**
         * Update Tickera's shortcode builder list
         *
         * @param $shortcode_list
         * @return mixed
         */
        function chk_shortcode_list( $shortcode_list )
        {
            $shortcode_list['tc_checkin'] = 'Checkin App';
            return $shortcode_list;
        }
        
        /**
         * Update Tickera's gutenberg blocks list
         *
         * @param $blocks
         * @return mixed
         *
         * @since 1.3.6
         */
        function modify_gutenberg_blocks_list( $blocks )
        {
            $blocks['tc_checkin'] = 'tickera/checkin';
            return $blocks;
        }
        
        function api_check_credentials()
        {
            $request = $_POST;
            $request = $request['data'];
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/check_credentials?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                if ( $this->is_html( $response ) ) {
                    $response = __( 'Response from the server doesn\'t appear to be valid.', 'tc_ch' );
                }
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                
                if ( isset( $json_response->pass ) ) {
                    
                    if ( true == $json_response->pass ) {
                        $data['timestamp'] = $request['timestamp'];
                        $data['license_key'] = $json_response->license_key;
                        $data['email'] = $json_response->admin_email;
                        $data['check_type'] = ( isset( $json_response->check_type ) ? $json_response->check_type : 'license' );
                        
                        if ( $data['check_type'] == 'email' ) {
                            $license_key_response = $this->api_post( 'https://update.tickera.com/license.php', $data );
                        } else {
                            unset( $data['email'] );
                            $license_key_response = $this->api_post( 'https://update.tickera.com/license_check/fr', $data );
                        }
                        
                        $license_key_response = json_decode( $license_key_response );
                        
                        if ( isset( $license_key_response->error ) ) {
                            $resp = [];
                            $resp['is_valid'] = true;
                            wp_send_json( $resp );
                        } else {
                            
                            if ( true == $license_key_response->is_valid ) {
                                $resp = [];
                                $resp['is_valid'] = true;
                                wp_send_json( $resp );
                            } else {
                                $resp = [];
                                $resp['is_valid'] = false;
                                wp_send_json( $resp );
                            }
                        
                        }
                    
                    } else {
                        // Good response from server but key is wrong
                        $resp = [];
                        $resp['wrong_url_or_key'] = true;
                        wp_send_json( $resp );
                    }
                
                } else {
                    // Error on server or wrong url / response is not OK?
                    $resp = [];
                    $resp['wrong_url_or_key'] = true;
                    wp_send_json( $resp );
                }
            
            }
        
        }
        
        function api_translation()
        {
            $request = $_POST;
            $request = $request['data'];
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/translation?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
        
        function event_essentials()
        {
            $request = $_POST;
            $request = $request['data'];
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/event_essentials?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
        
        function tickets_info()
        {
            $request = $_POST;
            
            if ( isset( $request['search_key'] ) ) {
                $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/tickets_info/' . $request['tickets_per_page'] . '/' . $request['page_num'] . '/' . $request['page_num'] . '/?timestamp=' . $request['timestamp'];
            } else {
                $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/tickets_info/' . $request['tickets_per_page'] . '/' . $request['page_num'] . '?timestamp=' . $request['timestamp'];
            }
            
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
        
        function ticket_checkins()
        {
            $request = $_POST;
            $request = $request['data'];
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/' . 'ticket_checkins' . '/' . $request['checksum'] . '/?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
        
        function check_in()
        {
            $request = $_POST;
            $request = $request['data'];
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/' . 'check_in' . '/' . $request['checksum'] . '/?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
        
        function sync()
        {
            $request = $_POST;
            $url = trailingslashit( $request['site_url'] ) . 'tc-api/' . $request['api_key'] . '/' . 'check_in' . '/' . $request['checksum'] . '/?timestamp=' . $request['timestamp'];
            $response = $this->api_post( $url );
            
            if ( !$this->is_json( $response ) ) {
                $resp = [];
                $resp['error'] = $response;
                wp_send_json( $resp );
            } else {
                $json_response = json_decode( $response );
                wp_send_json( $json_response );
            }
        
        }
    
    }
    function tc_checkinera_css_colors()
    {
        $tc_checkinera_settings = get_option( 'tc_checkinera_settings' );
        $main_color_checkinera = ( isset( $tc_checkinera_settings['main_color_checkinera'] ) ? $tc_checkinera_settings['main_color_checkinera'] : '#6b5f89' );
        $highlights_color_checkinera = ( isset( $tc_checkinera_settings['highlights_color_checkinera'] ) ? $tc_checkinera_settings['highlights_color_checkinera'] : '#ffdf3b' );
        $menu_active_color_checkinera = ( isset( $tc_checkinera_settings['menu_active_color_checkinera'] ) ? $tc_checkinera_settings['menu_active_color_checkinera'] : '#3c3c3c' );
        $menu_text_color_checkinera = ( isset( $tc_checkinera_settings['menu_text_color_checkinera'] ) ? $tc_checkinera_settings['menu_text_color_checkinera'] : '#fff' );
        $regular_text_color_checkinera = ( isset( $tc_checkinera_settings['regular_text_color_checkinera'] ) ? $tc_checkinera_settings['regular_text_color_checkinera'] : '#3E3D40' );
        $background_color_checkinera = ( isset( $tc_checkinera_settings['background_color_checkinera'] ) ? $tc_checkinera_settings['background_color_checkinera'] : '#fff' );
        $confirmation_notification_color_checkinera = ( isset( $tc_checkinera_settings['confirmation_notification_color_checkinera'] ) ? $tc_checkinera_settings['confirmation_notification_color_checkinera'] : '#72C1A0' );
        $confirmation_text_color_checkinera = ( isset( $tc_checkinera_settings['confirmation_text_color_checkinera'] ) ? $tc_checkinera_settings['confirmation_text_color_checkinera'] : '#fff' );
        $error_notification_color_checkinera = ( isset( $tc_checkinera_settings['error_notification_color_checkinera'] ) ? $tc_checkinera_settings['error_notification_color_checkinera'] : '#FF5F4E' );
        $error_text_color_checkinera = ( isset( $tc_checkinera_settings['error_text_color_checkinera'] ) ? $tc_checkinera_settings['error_text_color_checkinera'] : '#fff' );
        $button_color_checkinera = ( isset( $tc_checkinera_settings['button_color_checkinera'] ) ? $tc_checkinera_settings['button_color_checkinera'] : '#3c3c3c' );
        $checkin_button_color_checkinera = ( isset( $tc_checkinera_settings['checkin_button_color_checkinera'] ) ? $tc_checkinera_settings['checkin_button_color_checkinera'] : '#fff' );
        $checkinera_colors = '
            .tc-sidebar-mask,
            .tc-title,
            .tc-login,
            .tc-content-heading,
            .tc-notifications-wrap button,
            button,
            .lds-ellipsis div,
            #checkinera-singout .tc-dialog-title,
            .checkinera-dialog-box .ui-dialog-buttonset button {
                background-color: ' . $main_color_checkinera . ';
            }

            .tc-tickets-one .tc-ticket-info span,
            .tc-ticket-info-single span .ticket_field_value,
            .tc-buyer-address span.tc-span-wrap span,
            .tc-additional-info-hide,
            .camera,
            #checkinera-singout .checkinera_signout_cancel {
                color: ' . $main_color_checkinera . ';
            }

            .tc-sidebar ul li.active a,
            .tc-sidebar ul li a:hover,
            button:hover,
            .tc-login-button,
            input[type="checkbox"]:checked + span.tc-login-image .tc-login-ball,
            .checkinera-dialog-box .ui-dialog-buttonset button:hover {
                background-color: ' . $highlights_color_checkinera . ';
            }

            .tc-sidebar ul li.active a,
            .tc-sidebar ul li a:hover {
                color: ' . $menu_active_color_checkinera . ';
            }

            .online,
            .offline,
            #checkinera-singout .checkinera_signout_cancel:hover {
                color: ' . $highlights_color_checkinera . ';
            }

            .tc-sidebar ul li:hover, .tc-sidebar ul li.active {
                border-color: ' . $highlights_color_checkinera . ';
            }

            .tc-sidebar h1,
            .tc-title h2,
            .tc-sidebar ul li a,
            .tc-content-heading h2,
            label {
                color:  ' . $menu_text_color_checkinera . ';
            }

            .tc-half-content span.tc-ticket-info,
            .tc-tickets-one h3 ,
            .tc-tickets-one .tc-ticket-info,
            .tc-ticket-info-single h3,
            .tc-buyer-address span.tc-span-wrap,
            .tc-checkins ul li,
            .tc-ticket-additional-info span,
            .tc-checkins h4,
            .barcode_holder h1,
            input[type="text"], input[type="password"] {
                color: ' . $regular_text_color_checkinera . ';
            }

            .barcode_holder .barcode-main .tc-notification {
                color: ' . $regular_text_color_checkinera . ' !important;
            }

            .info-message,
            .tc-login .info-message {
                color: ' . $menu_text_color_checkinera . '!important;
            }

            .tc-content,
            .tc-notifications-wrap {
                background-color: ' . $background_color_checkinera . ';
            }

            .tc-tickets-list,
            .checkinera-dialog-box {
                background-color: ' . $background_color_checkinera . ' !important;
            }

            .tc-tickets-one a.tc-list-link:hover,
            a.tc-back-arrow:hover {
                background-color: ' . $main_color_checkinera . ';
                color: ' . $menu_text_color_checkinera . ';
            }

            .notifyjs-wrapper .notifyjs-bootstrap-success,
            .tc-checkin-button.success {
                background-color: ' . $confirmation_notification_color_checkinera . ';
                color: ' . $confirmation_text_color_checkinera . ';
            }

            .tc-checkin-button.error {
                background-color: ' . $error_notification_color_checkinera . ';
                color: ' . $error_text_color_checkinera . ';
            }

            .tc-login-button {
                color: ' . $button_color_checkinera . ';
            }
            .tc-checkin-button {
                color: ' . $checkin_button_color_checkinera . ';
            }';
        return $checkinera_colors;
    }

}

$Checkinera = new Checkinera();
function show_tc_checkin_attributes()
{
    ?>
    <table id="tc-checkin-shortcode" class="shortcode-table" style="display:none">
        <tr>
            <th scope="row"><?php 
    _e( 'Without extra attributes', 'chk' );
    ?></th>
            <td><?php 
    _e( 'Just insert the shortcode and checkin page will appear on the front.', 'chk' );
    ?></td>
        </tr>
    </table>
<?php 
}

if ( !function_exists( 'chk_fs' ) ) {
    // Create a helper function for easy SDK access.
    function chk_fs( $standalone = false )
    {
        global  $chk_fs ;
        
        if ( !isset( $chk_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_5935_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_5935_MULTISITE', true );
            }
            // Include Freemius SDK.
            
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } elseif ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                // Try to load SDK from premium parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
            } else {
                require_once dirname( __FILE__ ) . '/freemius/start.php';
            }
            
            $tc_fs_show = ( function_exists( 'tc_iw_is_wl' ) && tc_iw_is_wl() == true || defined( 'CHECKIN_PLUGIN_TITLE' ) && CHECKIN_PLUGIN_TITLE !== '' ? false : true );
            $init_args = array(
                'id'               => '5935',
                'slug'             => 'checkinera',
                'type'             => 'plugin',
                'public_key'       => 'pk_b7f567a7f753ae3e2ca56bb6707eb',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'menu'             => array(
                'slug'       => 'tc_admin_checkinera',
                'first-path' => 'admin.php?page=tc_admin_checkinera',
                'contact'    => $tc_fs_show,
                'support'    => false,
                'pricing'    => false,
            ),
                'secret_key'       => 'sk_atg;E>wmr_Yfo9%@tyIBEFJHZI3Ql',
            );
            if ( !$standalone ) {
                $init_args['parent'] = array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                );
            }
            $chk_fs = fs_dynamic_init( $init_args );
        }
        
        return $chk_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function chk_fs_is_parent_active_and_loaded()
{
    return function_exists( 'tets_fs' );
}

function chk_fs_is_parent_active()
{
    $active_plugins = get_option( 'active_plugins', array() );
    
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function chk_fs_init()
{
    
    if ( chk_fs_is_parent_active_and_loaded() ) {
        // Init Freemius.
        chk_fs();
        // Signal that the add-on's SDK was initiated.
        do_action( 'chk_fs_loaded' );
        // Parent is active, add your init code here.
    } else {
        // Parent is inactive, we'll run a standalone Version
        chk_fs( true );
    }

}


if ( chk_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    chk_fs_init();
} elseif ( chk_fs_is_parent_active() ) {
    // Init add-on only after the parent is loaded.
    add_action( 'tets_fs_loaded', 'chk_fs_init' );
} else {
    // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
    chk_fs_init();
}
