<?php
if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

function ch_yes_no( $field_name, $default_value = '' ) {

    $tc_checkinera_settings = get_option( 'tc_checkinera_settings' );
    $checked = ( isset( $tc_checkinera_settings[$field_name] ) )
        ? $tc_checkinera_settings[$field_name]
        : ( ( $default_value !== '' ) ? $default_value : 'no' ); ?>

    <label><input type="radio" class="<?php echo esc_attr( $field_name ); ?>" name="tc_checkinera_settings[<?php echo esc_attr( $field_name ); ?>]" value="yes" <?php checked( $checked, 'yes', true ); ?>  /><?php _e( 'Yes', 'tc_ch' ); ?></label>
    <label><input type="radio" class="<?php echo esc_attr( $field_name ); ?>" name="tc_checkinera_settings[<?php echo esc_attr( $field_name ); ?>]" value="no" <?php checked( $checked, 'no', true ); ?> /><?php _e( 'No', 'tc_ch' ); ?></label>
<?php }

function ch_yes_no_has_conditional( $field_name, $default_value = '' ) {

    $tc_checkinera_settings = get_option('tc_checkinera_settings');
    $checked = ( isset( $tc_checkinera_settings[$field_name] ) )
        ? $tc_checkinera_settings[$field_name]
        : ( ( $default_value !== '' ) ? $default_value : 'no' ); ?>

    <label><input type="radio" class="<?php echo esc_attr( $field_name.' has_conditional' ); ?>" name="tc_checkinera_settings[<?php echo esc_attr( $field_name ); ?>]" value="yes" <?php checked( $checked, 'yes', true ); ?>  /><?php _e( 'Yes', 'tc_ch' ); ?></label>
    <label><input type="radio" class="<?php echo esc_attr( $field_name.' has_conditional' ); ?>" name="tc_checkinera_settings[<?php echo esc_attr( $field_name ); ?>]" value="no" <?php checked( $checked, 'no', true ); ?> /><?php _e( 'No', 'tc_ch' ); ?></label>
<?php }

if ( !class_exists( 'TC_Checkinera_Settings' ) ) {

    class TC_Checkinera_Settings {

        function __construct() {}

        function TC_Checkinera_Settings() {
            $this->__construct();
        }

        public static function get_settings_sections() {

            return array (
                array (
                    'name' => 'checkinera_colors',
                    'title' => __( 'Checkin App Colors', 'tc_ch' ),
                    'description' => ''
                ),
                array (
                    'name' => 'checkinera_analytics',
                    'title' => __( 'Google Analytics', 'tc_ch' ),
                    'description' => ''
                ),
                array (
                    'name' => 'checkinera_miscellaneous',
                    'title' => __( 'Miscellaneous', 'tc_ch' ),
                    'description' => ''
                )
            );
        }

        public static function get_checkinera_fields() {

            $tc_file_url = plugins_url( '/', __FILE__ );
            $tc_file_url = rtrim( $tc_file_url, 'includes/classes/assets/' );

            $checkinera_settings_default_fields = array (
                array (
                    'field_name' => 'app_logo_checkinera',
                    'field_title' => __( 'Logo', 'tc_ch' ),
                    'field_type' => 'file',
                    'default_value' => $tc_file_url . '/assets/images/tickera-logo.png',
                    'tooltip' => __( 'Set the logo at the login screen. To not display the logo leave it empty.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'main_color_checkinera',
                    'field_title' => __( 'Main Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#6b5f89',
                    'tooltip' => __( 'Set the main color that is most recognized in your color branding', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'highlights_color_checkinera',
                    'field_title' => __( 'Highlights Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#ffdf3b',
                    'tooltip' => __( 'Set the highlight color of the elements. It is usually best to use secondary color in your color branding', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'button_color_checkinera',
                    'field_title' => __( 'Login Button Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#3c3c3c',
                    'tooltip' => __( 'Set the color of the text in the login button.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'checkin_button_color_checkinera',
                    'field_title' => __( 'Check-in Button Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#fff',
                    'tooltip' => __( 'Set the color of the text in the check-in button.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'menu_text_color_checkinera',
                    'field_title' => __( 'Menu Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#fff',
                    'tooltip' => __( 'Set the color of the menu text. Usually it is some color in the contrast of the main color', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'menu_active_color_checkinera',
                    'field_title' => __( 'Active Menu Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#3c3c3c',
                    'tooltip' => __( 'Set the text color of the active menu item. Usually it is some color in the contrast of the highlights color', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'regular_text_color_checkinera',
                    'field_title' => __( 'Regular Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#3E3D40',
                    'tooltip' => __( 'Set the color of the regular text. Usually it is some color in the contrast of the background color', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'background_color_checkinera',
                    'field_title' => __( 'Background Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#fff',
                    'tooltip' => __( 'Set the check-in app background color. It is best to use some neutral color like white or gray', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'confirmation_notification_color_checkinera',
                    'field_title' => __( 'Confirmation Background Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#72C1A0',
                    'tooltip' => __( 'Set the color of the confirmation notifications. Usually it some shade of green.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'confirmation_text_color_checkinera',
                    'field_title' => __( 'Confirmation Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#fff',
                    'tooltip' => __( 'Set the text color of the confirmation notifications.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'error_notification_color_checkinera',
                    'field_title' => __( 'Error Background Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#FF5F4E',
                    'tooltip' => __( 'Set the color of the error notifications. Usually it some shade of red.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),
                array (
                    'field_name' => 'error_text_color_checkinera',
                    'field_title' => __( 'Error Text Color', 'tc_ch' ),
                    'field_type' => 'color_field',
                    'default_value' => '#fff',
                    'tooltip' => __( 'Set the text color of the error notifications.', 'tc_ch' ),
                    'section' => 'checkinera_colors'
                ),

                // Analytics Fields
                array (
                    'field_name' => 'use_analytics',
                    'field_title' => __( 'Use Google Analytics', 'tc_ch' ),
                    'field_type' => 'function',
                    'function' => 'ch_yes_no_has_conditional',
                    'default_value' => 'no',
                    'tooltip' => __( 'Use Google Analytics to track check-ins and other user events within the app.', 'tc_ch' ),
                    'section' => 'checkinera_analytics'
                ),
                array (
                    'field_name' => 'analytics_code',
                    'field_title' => __( 'Google Analytics Tracking Code', 'tc_ch' ),
                    'field_type' => 'textarea',
                    'default_value' => '',
                    'tooltip' => __( 'You can copy the code from your Google Analytics account.', 'tc_ch' ),
                    'section' => 'checkinera_analytics',
                    'conditional' => array (
                        'field_name' => 'use_analytics',
                        'field_type' => 'radio',
                        'value' => 'no',
                        'action' => 'hide'
                    )
                ),
                array (
                    'field_name' => 'track_logins_ga',
                    'field_title' => __( 'Track Logins', 'tc_ch' ),
                    'field_type' => 'function',
                    'function' => 'ch_yes_no_has_conditional',
                    'default_value' => 'yes',
                    'tooltip' => __( 'Track when users log into the app and from which type of device (web or app)', 'tc_ch' ),
                    'section' => 'checkinera_analytics',
                    'conditional' => array (
                        'field_name' => 'use_analytics',
                        'field_type' => 'radio',
                        'value' => 'no',
                        'action' => 'hide'
                    )
                ),
                array (
                    'field_name' => 'track_checkins_ga',
                    'field_title' => __( 'Track Checkins', 'tc_ch' ),
                    'field_type' => 'function',
                    'function' => 'ch_yes_no_has_conditional',
                    'default_value' => 'yes',
                    'tooltip' => __( 'Track success and failed check-ins.', 'tc_ch' ),
                    'section' => 'checkinera_analytics',
                    'conditional' => array (
                        'field_name' => 'use_analytics',
                        'field_type' => 'radio',
                        'value' => 'no',
                        'action' => 'hide'
                    ),
                ),

                // Miscellaneous
                array (
                    'field_name' => 'prefill_url',
                    'field_title' => __( 'Prefill Installation URL', 'tc_ch' ),
                    'field_type' => 'function',
                    'function' => 'ch_yes_no',
                    'default_value' => 'no',
                    'tooltip' => __( 'Use URL of this website as login URL in Checkinera automatically. If set to Yes, the website URL field will disappear in Checkinera login screen and URL of this website will be used.', 'tc_ch' ),
                    'section' => 'checkinera_miscellaneous'
                ),
                array (
                    'field_name' => 'tickets_per_page',
                    'field_title' => __( 'Attendees per page', 'tc_ch' ),
                    'field_type' => 'number',
                    'default_value' => 20,
                    'min' => apply_filters( 'checkinera_minimum_tickets_per_page', 10 ),
                    'max' => apply_filters( 'checkinera_maximum_tickets_per_page', 200 ),
                    'tooltip' => __( 'Specify the number of attendees to display per page within the "list" section (ranging from 10 to 200)', 'tc_ch' ),
                    'section' => 'checkinera_miscellaneous'
                )
            );

            return apply_filters( 'tc_checkinera_settings_fields, ', $checkinera_settings_default_fields );
        }
    }
}
