var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.editor.BlockControls;

if ( tc_checkin_block_editor.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    RichText = wp.editor.RichText,
    SelectControl = wp.components.SelectControl,
    RangeControl = wp.components.RangeControl,
    TextControl = wp.components.TextControl,
    ToggleControl = wp.components.ToggleControl;

var __ = wp.i18n.__;

registerBlockType( 'tickera/checkin', {
    title: __( 'Checkin App' ),
    description: __( 'Display a checkin app on your page' ),
    icon: 'tickets-alt',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Checkin' ),
    ],
    supports: { html: false, },
    attributes: {},
    edit: function( props ) {

        return [
            el( ServerSideRender, {
                block: "tickera/checkin",
                attributes: props.attributes
            } )
        ];
    },
    save: function( props ) {

        return null;

        var content = props.attributes.content,
            alignment = props.attributes.alignment,
            columns = props.attributes.columns;

        return el( RichText.Content, {
            className: props.className,
            style: { textAlign: alignment },
            value: content
        } );
    },
} );
