jQuery(window).ready(function ($) {

    jQuery('.chk_color_field').each(function () {

        tc_default_color = jQuery(this).prev().val();

        myOptions = {
            defaultColor: tc_default_color,
        };

        jQuery(this).wpColorPicker(myOptions);

    });

    $('.chk_tooltip').tooltip({
        content: function () {
            return $(this).prop('title');
        },
        show: null,
        close: function (event, ui) {
            ui.tooltip.hover(
                    function () {
                        $(this).stop(true).fadeTo(100, 1);
                    },
                    function () {
                        $(this).fadeOut("100", function () {
                            $(this).remove();
                        })
                    });
        }
    });

    $('.file_url_button').click(function ()
    {
        var target_url_field = $(this).prevAll(".file_url:first");
        wp.media.editor.send.attachment = function (props, attachment)
        {
            $(target_url_field).val(attachment.url);
        };
        wp.media.editor.open(this);
        return false;
    });

    $(document).on('change','.has_conditional', function () {
      chk_conditionals_init();
    });

    function chk_conditionals_init( ) {
      $('.chk_conditional').each(function (i, obj) {
        console.log('YEAH 2');
        chk_conditional($(this));
      });
    }

    function chk_conditional(obj) {

      var field_name = $(obj).attr('data-condition-field_name');

      if (!$('.' + field_name).hasClass('has_conditional')) {
        $('.' + field_name).addClass('has_conditional');
      }

      var field_type = $(obj).attr('data-condition-field_type');
      var value = $(obj).attr('data-condition-value');
      var action = $(obj).attr('data-condition-action');
      if (field_type == 'radio') {
        var selected_value = $('.' + field_name + ':checked').val( );
      }

      if (field_type == 'text' || field_type == 'textarea' || field_type == 'select') {
        var selected_value = $('.' + field_name).val( );
      }

      if (value == selected_value) {
        if (action == 'hide') {
          $(obj).hide();
        }
        if (action == 'show') {
          $(obj).show(200);
        }
      } else {
        if (action == 'hide') {
          $(obj).show(200);
        }
        if (action == 'show') {
          $(obj).hide();
        }
      }
    }

    chk_conditionals_init();

});
