<?php
if ( isset( $_POST[ 'tc_terms' ] ) ) {
    $tc_terms = $_POST[ 'tc_terms' ];
    $tc_terms = stripslashes_deep_terms_conditions( $tc_terms );
    if ( wp_verify_nonce( $_POST[ 'save_terms_settings_nonce' ], 'save_terms_settings' ) ) {
        update_option( 'tc_terms_settings', $tc_terms );
    }
}

/**
 * Function for stripping slashes on fields
 *
 * @param $value
 * @return array|string
 */
function stripslashes_deep_terms_conditions( $value ) {
    $value = is_array( $value ) ?
        array_map( 'stripslashes_deep_terms_conditions', $value ) :
        stripslashes( $value );
    return $value;
}

$tc_terms_settings = get_option( 'tc_terms_settings' );
$tc_list_pages = get_pages();
?>
<div class="wrap tc_wrap" style="opacity: 1;">
    <div id="poststuff" class="metabox-holder tc-settings">
        <form action="" method="post" name="save_terms_options" enctype="multipart/form-data">
            <div id="store_settings" class="postbox">
                <h3 class="hndle">
                    <span>
                        <?php _e( 'Terms And Conditions Options', 'tac' ); ?>
                    </span>
                </h3>
                <div class="inside">
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row"><label for="list_id"><?php _e( 'Disable Terms And Conditions', 'tac' ) ?></label></th>
                                <td>
                                    <input name="tc_terms[disable_terms]" type="checkbox" id="disable_terms" value="1" <?php if ( isset( $tc_terms_settings[ 'disable_terms' ] ) ) { echo "checked"; } ?>>
                                    <p class="description"><?php _e( 'Check to disable Terms and Conditions.', 'tac' ); ?></p>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row"><label for="tc_term_popup"><?php _e( 'Terms And Conditions display', 'tac' ); ?></label>
                                </th>
                                <td>
                                    <label>
                                        <input type="radio" id="tc_term_popup" name="tc_terms[term_display]" value="p" <?php if ( ! isset( $tc_terms_settings[ 'term_display' ] ) || $tc_terms_settings[ 'term_display' ] == 'p' ) { echo 'checked="checked"'; } ?>><?php _e( 'Show in a popup.', 'tac' ) ?>
                                    </label>
                                    <label>
                                        <input type="radio" id="tc_term_page" name="tc_terms[term_display]" <?php if ( isset( $tc_terms_settings[ 'term_display' ] ) && 'l' == $tc_terms_settings[ 'term_display' ] ) { echo 'checked="checked"'; } ?> value="l"><?php _e( 'Link to a page', 'tac' ) ?>
                                    </label>
                                </td>
                            </tr>
                            <tr id="tc_term_select_page">
                                <th scope="row"><label for="terms"><?php _e( 'Select Terms And Conditions Page', 'tac' ) ?></label>
                                </th>
                                <td>
                                    <select name="tc_terms[terms_page]">
                                        <?php foreach ( $tc_list_pages as $tc_page ) { ?>
                                            <option <?php if ( isset( $tc_terms_settings[ 'terms_page' ] ) && $tc_page->ID == $tc_terms_settings[ 'terms_page' ] ) { echo 'selected'; } ?> value="<?php echo esc_attr( $tc_page->ID ); ?>"><?php echo esc_html( $tc_page->post_title ); ?></option>
                                        <?php } ?>
                                    </select>
                                    <p class="description"><?php _e( 'Set the Terms And Conditions text that will be shown to customers when they click the link.', 'tac' ); ?></p>
                                </td>
                            </tr>
                            <tr id="tc_term_editor">
                                <th scope="row"><label for="terms"><?php _e( 'Terms And Conditions Text', 'tac' ) ?></label>
                                </th>
                                <td>
                                    <?php wp_editor( isset( $tc_terms_settings[ 'terms' ] ) ? $tc_terms_settings[ 'terms' ] : '', 'terms', $settings = array( 'textarea_name' => 'tc_terms[terms]' ) ); ?>
                                    <p class="description"><?php _e( 'Set the Terms And Conditions text that will be shown to customers when they click the link.', 'tac' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><label for="link_title"><?php _e( 'Link Title', 'tac' ) ?></label></th>
                                <td>
                                    <input name="tc_terms[link_title]" type="text" id="link_title" value="<?php echo esc_attr( isset( $tc_terms_settings[ 'link_title' ] ) ? $tc_terms_settings[ 'link_title' ] : 'I agree to the Terms and Conditions' ); ?>" class="regular-text">
                                    <p class="description"><?php _e( 'Set the link title for Terms And Conditions', 'tac' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><label for="error_text"><?php _e( 'Error Text', 'tac' ) ?></label></th>
                                <td>
                                    <input name="tc_terms[error_text]" type="text" id="error_text" value="<?php echo esc_attr( isset( $tc_terms_settings[ 'error_text' ] ) ? $tc_terms_settings[ 'error_text' ] : 'You must agree to the terms and conditions before proceeding to the checkout.' ); ?>" class="regular-text">
                                    <p class="description"><?php _e( "Set the error text that will be shown if users don't agree to Terms And Conditions", 'tac' ); ?></p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div><!-- inside -->
            </div><!-- store-settings -->
            <div id="privacy_policy" class="postbox">
                <h3 class="hndle">
                    <span>
                        <?php _e( 'Privacy Policy Options', 'tac' ); ?>
                    </span>
                </h3>
                <div class="inside">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th scope="row"><label for="list_id"><?php _e( 'Disable Privacy Policy', 'tac' ) ?></label></th>
                            <td>
                                <?php $disable_privacy = ( ! isset( $tc_terms_settings[ 'privacy' ] ) || isset( $tc_terms_settings[ 'disable_privacy' ] ) ) ? true : false ?>
                                <input name="tc_terms[disable_privacy]" type="checkbox" id="disable_privacy" value="1" <?php if ( $disable_privacy ) { echo "checked"; } ?>>
                                <p class="description"><?php _e( 'Check to disable Privacy Policy.', 'tac' ); ?></p>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row"><label for="tc_privacy_popup"><?php _e( 'Privacy Policy Display', 'tac' ); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="radio" id="tc_privacy_popup" name="tc_terms[privacy_display]" value="p" <?php if ( ! isset( $tc_terms_settings[ 'privacy_display' ] ) || $tc_terms_settings[ 'privacy_display' ] == 'p' ) { echo 'checked="checked"'; } ?>><?php _e( 'Show in a popup.', 'tac' ) ?>
                                </label>
                                <label>
                                    <input type="radio" id="tc_privacy_page" name="tc_terms[privacy_display]" <?php if ( isset( $tc_terms_settings[ 'privacy_display' ] ) && 'l' == $tc_terms_settings[ 'privacy_display' ] ) { echo 'checked="checked"'; } ?> value="l"><?php _e( 'Link to a page', 'tac' ) ?>
                                </label>
                            </td>
                        </tr>
                        <tr id="tc_privacy_select_page">
                            <th scope="row"><label for="privacy"><?php _e( 'Select Privacy Policy Page', 'tac' ) ?></label>
                            </th>
                            <td>
                                <select name="tc_terms[privacy_page]">
                                    <?php foreach ( $tc_list_pages as $tc_page ) { ?>
                                        <option <?php if ( isset( $tc_terms_settings[ 'privacy_page' ] ) && $tc_page->ID == $tc_terms_settings[ 'privacy_page' ] ) { echo 'selected'; } ?> value="<?php echo esc_attr( $tc_page->ID ); ?>"><?php echo esc_html( $tc_page->post_title ); ?></option>
                                    <?php } ?>
                                </select>
                                <p class="description"><?php _e( 'Set the Privacy Policy text that will be shown to customers when they click the link.', 'tac' ); ?></p>
                            </td>
                        </tr>
                        <tr id="tc_privacy_editor">
                            <th scope="row"><label for="privacy"><?php _e( 'Privacy Policy Text', 'tac' ) ?></label>
                            </th>
                            <td>
                                <?php wp_editor( isset( $tc_terms_settings[ 'privacy' ] ) ? $tc_terms_settings[ 'privacy' ] : '', 'privacy', $settings = array( 'textarea_name' => 'tc_terms[privacy]' ) ); ?>
                                <p class="description"><?php _e( 'Set the Privacy Policy text that will be shown to customers when they click the link.', 'tac' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="privacy_link_title"><?php _e( 'Link Title', 'tac' ) ?></label></th>
                            <td>
                                <input name="tc_terms[privacy_link_title]" type="text" id="privacy_link_title" value="<?php echo esc_attr( isset( $tc_terms_settings[ 'privacy_link_title' ] ) ? $tc_terms_settings[ 'privacy_link_title' ] : 'I agree to the Privacy Policy' ); ?>" class="regular-text">
                                <p class="description"><?php _e( 'Set the link title for Privacy Policy', 'tac' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="privacy_error_text"><?php _e( 'Error Text', 'tac' ) ?></label></th>
                            <td>
                                <input name="tc_terms[privacy_error_text]" type="text" id="privacy_error_text" value="<?php echo esc_attr( isset( $tc_terms_settings[ 'privacy_error_text' ] ) ? $tc_terms_settings[ 'privacy_error_text' ] : 'You must agree to the privacy policy before proceeding to the checkout.' ); ?>" class="regular-text">
                                <p class="description"><?php _e( "Set the error text that will be shown if users don't agree to Privacy Policy", 'tac' ); ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div><!-- inside -->
            </div><!-- store-settings -->
            <?php wp_nonce_field( 'save_terms_settings', 'save_terms_settings_nonce' ); ?>
            <?php submit_button( '', 'primary', 'save_terms_options' ); ?>
        </form>
    </div><!-- poststuff -->
</div><!-- wrap -->
