<?php
/* 
Plugin Name: PrivateContent
Plugin URI: https://lcweb.it/privatecontent
Description: The WordPress membership solution
Author: پرشین اسکریپت
Version: 7.121
Author URI: https://www.persianscript.ir
*/  


/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define('PC_DIR', $wp_plugin_dir);

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define('PC_URL', $wp_plugin_url);

// plugin version
define('PC_VERS', 7.121);




/////////////////////////////////////////////
/////// FORCING DEBUG ///////////////////////
/////////////////////////////////////////////

if(isset($_REQUEST['pc_php_debug'])) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);	
}




/////////////////////////////////////////////
/////// MULTILANGUAGE SUPPORT ///////////////
/////////////////////////////////////////////

function pc_multilanguage() {
  $param_array = explode(DIRECTORY_SEPARATOR, PC_DIR);
  $folder_name = end($param_array);
  
  if(is_admin()) {
	 load_plugin_textdomain('pc_ml', false, $folder_name . '/lang_admin');  
  }
  load_plugin_textdomain('pc_ml', false, $folder_name . '/languages');  
}
add_action('init', 'pc_multilanguage', 1);



/////////////////////////////////////////////
/////// DATABASE MANAGEMENT /////////////////
/////////////////////////////////////////////

// database table constants
function pc_db_constants() {
	global $wpdb;
	
	if(!defined('PC_USERS_TABLE')) {
		define('PC_USERS_TABLE', $wpdb->prefix . "pc_users");
		define('PC_META_TABLE', $wpdb->prefix . "pc_user_meta");
	}
}
add_action('init', 'pc_db_constants', 1);


function pc_db_manag() {
	include_once(PC_DIR . '/db_manag.php');
}
register_activation_hook(__FILE__, 'pc_db_manag');

// do also on specific recall
if(isset($_GET['pc_update_db_v7'])) { 
	function pc_forced_db_manag() {
		pc_db_manag(); 
	}
	add_action('admin_init', 'pc_forced_db_manag', 1);
}



/////////////////////////////////////////////
/////// WP USERS SYNC INITIALIZATION ////////
/////////////////////////////////////////////

function pc_wp_user_sync_init() {
	global $pc_users;
	
	if($pc_users->wp_user_sync) {
		include_once(PC_DIR . '/wp_user_tricks.php');
		
		add_role('pvtcontent', 'PrivateContent',
			array(
				'read'         => false,
				'edit_posts'   => false,
				'delete_posts' => false
			)
		);
	} else {
		remove_role('pvtcontent');
	}
}
add_action('init', 'pc_wp_user_sync_init', 1);



/////////////////////////////////////////////
/////// CURRENT USER CAN EDIT? GLOBAL FLAG //
/////////////////////////////////////////////

function pc_cuc_flag() {
	$au_cap = get_option('pg_min_role_tmu', get_option('pg_min_role', 'upload_files'));
	$cuc = (empty($au_cap)) ? true :  current_user_can($au_cap);
		
	if($cuc && !is_admin() && current_user_can('pvtcontent')) {
		$cuc = false;
	}
	
	$GLOBALS['pc_cuc_edit'] = $cuc;	
}
add_action('init', 'pc_cuc_flag', 10); // must be exec after pc_init_session_check_cookie()



/////////////////////////////////////////////
// REGISTER TAXONOMY FOR REGISTATION FORMS //
/////////////////////////////////////////////

function pc_reg_form_ct() {
    $labels = array( 
        'name' => 'PrivateContent registration forms',
        'singular_name' => 'PrivateContent registration form',
        'search_items' => 'Search PrivateContent registration forms',
        'popular_items' => 'Popular PrivateContent registration forms',
        'all_items' => 'All PrivateContent registration forms',
        'parent_item' => 'Parent PrivateContent registration form',
        'parent_item_colon' => 'Parent PrivateContent registration form:',
        'edit_item' => 'Edit PrivateContent registration form',
        'update_item' => 'Update PrivateContent registration form',
        'add_new_item' => 'Add New PrivateContent registration form',
        'new_item_name' => 'New PrivateContent registration form',
        'separate_items_with_commas' => 'Separate privatecontent registration forms with commas',
        'add_or_remove_items' => 'Add or remove PrivateContent registration forms',
        'choose_from_most_used' => 'Choose from most used PrivateContent registration forms',
        'menu_name' => 'PrivateContent registration forms',
    );

    $args = array( 
        'labels' => $labels,
        'public' => false,
        'show_in_nav_menus' => false,
        'show_ui' => false,
        'show_tagcloud' => false,
        'show_admin_column' => false,
        'hierarchical' => false,
        'rewrite' => false,
        'query_var' => false
    );
    register_taxonomy('pc_reg_form', null, $args);
}
add_action('init', 'pc_reg_form_ct', 1);



//////////////////////////////////////////////
// REGISTER TAXONOMY FOR LIGHTBOX INSTANCES //
//////////////////////////////////////////////

function pc_lightboxes_ct() {
    $labels = array( 
        'name' => 'PrivateContent lightboxes',
        'singular_name' => 'PrivateContent lightbox',
        'search_items' => 'Search PrivateContent lightboxes',
        'popular_items' => 'Popular PrivateContent lightboxes',
        'all_items' => 'All PrivateContent lightboxes',
        'parent_item' => 'Parent PrivateContent lightbox',
        'parent_item_colon' => 'Parent PrivateContent lightbox:',
        'edit_item' => 'Edit PrivateContent lightbox',
        'update_item' => 'Update PrivateContent lightbox',
        'add_new_item' => 'Add New PrivateContent lightbox',
        'new_item_name' => 'New PrivateContent lightbox',
        'separate_items_with_commas' => 'Separate privatecontent lightboxes with commas',
        'add_or_remove_items' => 'Add or remove PrivateContent lightboxes',
        'choose_from_most_used' => 'Choose from most used PrivateContent lightboxes',
        'menu_name' => 'PrivateContent lightboxes',
    );

    $args = array( 
        'labels' => $labels,
        'public' => false,
        'show_in_nav_menus' => false,
        'show_ui' => false,
        'show_tagcloud' => false,
        'show_admin_column' => false,
        'hierarchical' => false,
        'rewrite' => false,
        'query_var' => false
    );
    register_taxonomy('pc_lightboxes', null, $args);
}
add_action('init', 'pc_lightboxes_ct', 1);





///////////////////////////////////////////////////////////////
/////// FLAG FOR LOGGED WP USER - IF CAN BYPASS RESTRICTIONS //
///////////////////////////////////////////////////////////////

function pc_testing_mode_flag() {
	if(!is_admin() && !defined('PC_WP_USER_PASS')) {
		$pc_min_role = get_option('pg_min_role', 'upload_files');	
		$testing_mode = get_option('pg_test_mode');
		$GLOBALS['pc_testing_mode'] = $testing_mode;
		
		if($testing_mode) {
			$val = (!is_user_logged_in() || !current_user_can($pc_min_role)) ? true : false;
		} else {
			$val = (!is_user_logged_in() || !current_user_can($pc_min_role)) ? false : true;	
		}

		define('PC_WP_USER_PASS', $val);
	}
}
add_action('init', 'pc_testing_mode_flag', 1);





/////////////////////////////////////////////
/////// MAIN SCRIPT & CSS INCLUDES //////////
/////////////////////////////////////////////

// global script enqueuing
function pc_global_scripts() { 
	wp_enqueue_script("jquery"); 
	wp_enqueue_style('pc_fontawesome', PC_URL . '/css/font-awesome/css/font-awesome.min.css', 999, '4.7.0');
	
	
	// admin css
	if(is_admin()) {  
		wp_enqueue_style('pc_admin', PC_URL . '/css/admin.css', 999, PC_VERS);	
		wp_enqueue_style('pc_settings', PC_URL . '/settings/settings_style.css', 999, PC_VERS);	
		
		
		// add tabs scripts
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('jquery-ui-slider');
		
		// lc switch
		wp_enqueue_style( 'pc-switch', PC_URL.'/js/lc-switch/lc_switch.css', 999);
		
		// colorpicker
		wp_enqueue_style( 'pc-colpick', PC_URL.'/js/colpick/css/colpick.css', 999);

		// chosen
		wp_enqueue_style( 'pc-chosen', PC_URL.'/js/chosen/chosen.css', 999);
	}
	
	
	// login, registering and logout JS file
	if(!is_admin()) {
		wp_enqueue_script('pc_frontend', PC_URL . '/js/frontend.min.js', 999, PC_VERS, true);	
		wp_enqueue_style('pc_multiselect', PC_URL.'/js/multiple-select/multiple-select.css', 50, PC_VERS);
		wp_enqueue_script('pc_multiselect', PC_URL . '/js/multiple-select/multiple.select.min.js', 999, PC_VERS, true);	
		
		// if using recaptcha system
		if(get_option('pg_antispam_sys') == 'recaptcha') {
			wp_enqueue_script('grecaptcha', 'https://www.google.com/recaptcha/api.js');	
		}
		
		add_action('wp_head', 'pc_dynamic_js_vars', 50);
	}
	
	// lightbox scripts - only if there are instances
	if(!is_admin() && wp_count_terms('pc_lightboxes', array('hide_empty' => false))) {
		$GLOBALS['pc_has_lightboxes'] = true;
		
		wp_enqueue_style('pc_lightbox', PC_URL.'/js/magnific_popup/magnific-popup.css', 50, PC_VERS);	
		wp_enqueue_script('pc_lightbox', PC_URL . '/js/magnific_popup/magnific-popup.pckg.js', 999, PC_VERS, true);	
	}
	
	// custom frontend style - only if is not disabled by settings
	if(!is_admin() && !get_option('pg_disable_front_css')) {  
		$style = get_option('pg_style', 'minimal');
		
		if((!get_option('pg_inline_css') && !get_option('pg_force_inline_css')) || $style != 'custom') {
			wp_enqueue_style('pc_frontend', PC_URL . '/css/'.$style.'.css', 999, PC_VERS);		
		}
		else {add_action('wp_head', 'pc_inline_css', 989);}
	}
}
add_action('wp_enqueue_scripts', 'pc_global_scripts', 900);
add_action('admin_enqueue_scripts', 'pc_global_scripts');



// dynamic javascript vars
function pc_dynamic_js_vars() {
	$code = '<script type="text/javascript">';
		
	// multi-select variable to translate
	$code .= 'pc_ms_countSelected = "'. addslashes(__('# of % selected', 'pc_ml')) .'";'; 
	$code .= 'pc_ms_allSelected = "'. addslashes(__('All selected', 'pc_ml')) .'";';
	
	// HTML5 forms validation flag
	$result = (get_option('pg_no_html5_validation')) ? 'false' : 'true'; 
	$code .= 'pc_html5_validation = '.$result.';';
	
	// dropdown texts
	$code .= 'pc_ms_search_placeh = "'. addslashes(__('Search options', 'pc_ml')) .'";'; 
	$code .= 'pc_ms_search_nores = "'. addslashes(__('No matches found', 'pc_ml')) .'";'; 
	
	echo $code .'</script>';
}


// use custom style inline
function pc_inline_css(){
	echo '<style type="text/css">';
	include_once(PC_DIR.'/custom_style.php');
	echo '</style>';
}

// custom css
function pc_custom_css(){
	
	/* PC-ACTION - allows custom CSS to be directly printed inline (before PC custom CSS) */
	do_action('pc_inline_css');
	
	$code = trim(get_option('pg_custom_css', ''));
	if($code) {
		echo '
<!-- privateContent custom CSS -->
<style type="text/css">'. $code .'</style>
';
	}
}
add_action('wp_head', 'pc_custom_css', 999);



// bottom-border and no-label style - body class
function pc_body_tag_class($classes) { 
	if(get_option('pg_bottomborder')) {
		$classes[] = 'pc_bottomborder';	
	}
	if(get_option('pg_nolabel')) {
		$classes[] = 'pc_nolabel';	
	}
	return $classes;
}
add_filter('body_class', 'pc_body_tag_class');	
	




//////////////////////////////////////////////////
/////////// MAIN INCLUDES ////////////////////////
//////////////////////////////////////////////////

// USERS MANAGEMENT CLASS
include_once(PC_DIR . '/classes/users_manag.php');

// WP-SYNC MANAGEMENT CLASS
include_once(PC_DIR . '/classes/wp_user_sync.php');

// META MANAGEMENT CLASS
include_once(PC_DIR . '/classes/meta_manag.php');

// USER AUTH SYSTEM - SESSION SETUP - AJAX LOGIN & LOGOUT
include_once(PC_DIR . '/user_auth.php');

// FRONT AJAX OPERATIONS (user deletion)
include_once(PC_DIR . '/front_ajax.php');

// GOOGLE ANALYTICS CLASS
include_once(PC_DIR . '/classes/google_analytics.php');



// MENU AND TOPBAR PENDING USERS 
include_once(PC_DIR . '/admin_menu.php');

// USER CAT - CUSTOM FIELDS
include_once(PC_DIR . '/user_categories.php');

// PUBLIC API
include_once(PC_DIR . '/public_api.php');

// ADMIN AJAX
include_once(PC_DIR . '/admin_ajax.php');

// USER POST TYPE - PVT PAGE
include_once(PC_DIR . '/users_page_post_type.php');

// RESTRICTIONS WIZARD
include_once(PC_DIR . '/classes/restrictions_wizard.php');

// NAV MENU OPTION
include_once(PC_DIR . '/nav_menu_option.php');

// TINYMCE BUTTON
include_once(PC_DIR . '/tinymce_implementation.php');



// POSTS RESTRICTIONS CACHE
include_once(PC_DIR . '/classes/posts_restr_cache.php');

// SHORTCODES
include_once(PC_DIR . '/shortcodes.php');

// LIGHTBOX ENGINE
include_once(PC_DIR . '/lightbox_engine.php');

// USER REGISTRATION SYSTEM
include_once(PC_DIR . '/user_registration.php');

// LOGIN WIDGET
include_once(PC_DIR . '/login_widget.php');

// USERS PRIVATE PAGE
include_once(PC_DIR . '/user_pvt_page.php');



// COMMENTS RESTRICTION
include_once(PC_DIR . '/restrictions/comments_restriction.php');

// CONTENTS HIDING ENGINE
include_once(PC_DIR . '/restrictions/contents_hiding.php');

// MENU RESTRICTION
include_once(PC_DIR . '/restrictions/menu_restriction.php');

// REDIRECT ENGINE
include_once(PC_DIR . '/restrictions/redirect_engine.php');

// WIDGET RESTRICTION
include_once(PC_DIR . '/restrictions/widgets_restriction.php');

// LIGHTBOX ON PAGE'S OPENING
include_once(PC_DIR . '/restrictions/lightbox_on_opening.php');



// visual composer integration
include_once(PC_DIR . '/builders_integration/visual_composer.php');

// cornerstone integration
include_once(PC_DIR . '/builders_integration/cornerstone.php');

// elementor integration
include_once(PC_DIR . '/builders_integration/elementor.php');







////////////
// DOCUMENTATION'S LINK
if(!isset($GLOBALS['is_pc_bundle'])) {
	
	function pc_doc_link($links, $file) {
		if($file == plugin_basename(__FILE__)) {	
			$links['lc_doc_link'] = '<a href="https://doc.lcweb.it/privatecontent" target="_blank">'. __('Documentation', 'pc_ml') .'</a>';
		}
		
		return $links;
	}
	add_filter('plugin_row_meta', 'pc_doc_link', 50, 2);
}
////////////




////////////
// AUTO UPDATE DELIVER
if(!isset($GLOBALS['is_pc_bundle'])) {
	include_once(PC_DIR . '/classes/lc_plugin_auto_updater.php');
	function pc_auto_updates() {
		if(!get_option('pg_no_auto_upd')) {
			$upd = new lc_wp_autoupdate(__FILE__, 'http://updates.lcweb.it', 'lc_updates', 'pc_on_activation');
		}
	}
	add_action('admin_init', 'pc_auto_updates', 1);
}
////////////








//////////////////////////////////////////////////
// ACTIONS ON PLUGIN ACTIVATION //////////////////
//////////////////////////////////////////////////

function pc_on_activation() {
	include_once(PC_DIR . '/functions.php');
	
	// create custom form style
	if(get_option('pg_style') == 'custom') {
		if(!pc_create_custom_style()) {update_option('pg_inline_css', 1);}
		else {delete_option('pg_inline_css');}
	}

	// minimum role to use plugin
	if(!get_option('pg_min_role')) {
		update_option('pg_min_role', 'upload_files');
	}
	
	// update v6.1 - reset antispam - recaptcha must be configured!
	if(!get_option('pg_recaptcha_public')) {
		delete_option('pg_antispam_sys');	
	}
}
register_activation_hook(__FILE__, 'pc_on_activation');




//////////////////////////////////////////////////
// export users security trick - avoid issues related to php warnings
function pc_export_buffer() {
	ob_start();
}
add_action('admin_init', 'pc_export_buffer', 2);




//////////////////////////////////////////////////
// REMOVE WP HELPER FROM PLUGIN PAGES

function pc_remove_wp_helper() {
	$cs = get_current_screen();
	$hooked = array('toplevel_page_pc_user_manage', 'privatecontent_page_pc_add_user', 'privatecontent_page_pc_import_export', 'privatecontent_page_pc_settings');
	
	if(is_object($cs) && in_array($cs->base, $hooked)) {
		echo '
		<style type="text/css">
		#screen-meta-links {display: none;}
		</style>';	
	}
	
	//var_dump(get_current_screen()); // debug
}
add_action('admin_head', 'pc_remove_wp_helper', 999);




/////////////////////////////////////////////
// RETROCOMPATIBILITY FOR ADD-ONS BEFORE v5 /
/////////////////////////////////////////////

$retro_pc_dir = PC_DIR; define('PG_DIR', $retro_pc_dir);
$retro_pc_url = PC_URL; define('PG_URL', $retro_pc_url);

//////////////////////////////////////////////////////
