<?php
////////////////////////////////////
// DYNAMICALLY CREATE THE CSS //////
////////////////////////////////////
include_once(PC_DIR . '/functions.php');

// remove the HTTP/HTTPS for SSL compatibility
$safe_baseurl = str_replace(array('http:', 'https:', 'HTTP:', 'HTTPS:'), '', PC_URL);

// v6 fields padding - vert/horiz
$fields_padding = get_option('pg_field_padding', array(3, 3));
if(!is_array($fields_padding)) {
	$fields_padding = array($fields_padding, $fields_padding);	
}

// buttons padding
$btn_padding = get_option('pg_buttons_padding', array(6, 15));
?>
/*BASIC STYLES */
@import url("<?php echo $safe_baseurl; ?>/css/frontend.min.css");


/***********************************
    GLOBAL ELEMENTS
 ***********************************/
  
/* containers style */
.pc_registration_form,
.pc_login_form,
.pc_custom_form,
.pc_error_mess,
.pc_success_mess  {
	background-color: <?php echo get_option('pg_forms_bg_col', '#fefefe') ?>;
	color: <?php echo get_option('pg_label_col', '#333') ?>;	
}
.pc_registration_form,
.pc_login_form,
.pc_custom_form {
	border: <?php echo (int)get_option('pg_forms_border_w', 1) ?>px solid <?php echo get_option('pg_forms_border_col', '#ebebeb') ?>;
    border-radius: <?php echo get_option('pg_form_border_radius', 3) ?>px;
}
.pc_error_mess,
.pc_success_mess {
 	border-radius: <?php echo get_option('pg_field_border_radius', 1) ?>px;
}


<?php 
// forms additional padding
$fap = get_option('pg_form_add_padding', array(0,0));
if(is_array($fap) && count($fap) == 2 && ((int)$fap[0] || (int)$fap[1])) :
?>
.pc_registration_form,
.pc_login_form,
.pc_custom_form {
    padding: <?php echo 19 + (int)$fap[0] ?>px <?php echo 24 + (int)$fap[1] ?>px;
}
.pc_login_form {
	padding: <?php echo 15 + (int)$fap[0] ?>px <?php echo 24 + (int)$fap[1] ?>px <?php echo 23 + (int)$fap[0] ?>px;	
}
.pc_nolabel .pc_login_form {
	padding: <?php echo 19 + (int)$fap[0] ?>px <?php echo 24 + (int)$fap[1] ?>px <?php echo 23 + (int)$fap[0] ?>px;		
}
.pc_fluid_form .pc_form_flist {
	padding-right: <?php echo (int)$fap[1] ?>px;
}
.pc_fluid_form .pc_pag_next {
	margin-right: <?php echo 24 + (int)$fap[1] ?>px; <?php // 24 == default form padding ?>
}
<?php endif; ?>


/* fields style */
.pc_rf_field input, .pc_rf_field textarea,
.pc_rf_field .ms-choice, .pc_rf_field .ms-drop,
.pc_login_row input, .pcma_psw_username,
.pc_rf_recaptcha #recaptcha_response_field {
	background: <?php echo get_option('pg_fields_bg_col', '#fefefe') ?>;
    border: <?php echo (int)get_option('pg_field_border_w', 1) ?>px solid <?php echo get_option('pg_fields_border_col', '#ccc') ?>;
    color: <?php echo get_option('pg_fields_txt_col', '#808080') ?>;	
	padding: <?php echo (int)$fields_padding[0] ?>px <?php echo (int)$fields_padding[1] ?>px !important;
	border-radius: <?php echo get_option('pg_field_border_radius', 1) ?>px !important;
}
.pc_rf_field input:hover, .pc_rf_field textarea:hover,
.pc_rf_field input:active, .pc_rf_field textarea:active,
.pc_rf_field input:focus, .pc_rf_field textarea:focus,
.pc_rf_field .ms-choice:hover, .pc_rf_field .ms-choice:active, .pc_rf_field .ms-choice:focus,
.pc_login_row input:hover, .pcma_psw_username:hover,
.pc_login_row input:active, .pcma_psw_username:active,
.pc_login_row input:focus, .pcma_psw_username:focus,
.pc_rf_recaptcha #recaptcha_response_field:focus {
	background: <?php echo get_option('pg_fields_bg_col_h', '#fff') ?>;
    border: <?php echo get_option('pg_field_border_w', 1) ?>px solid <?php echo get_option('pg_fields_border_col_h', '#aaa') ?>;
    color: <?php echo get_option('pg_fields_txt_col_h', '#444') ?>;	
	box-shadow: none;	
}
.pc_login_form label, .pc_form_flist, .pc_form_flist label {
	color: <?php echo get_option('pg_label_col', '#333') ?>;
}

/* placeholders - requires one line per browser */
.pc_rf_field *::-webkit-input-placeholder, .pc_login_row *::-webkit-input-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col', '#888') ?>;	
}
.pc_rf_field *:-ms-input-placeholder, .pc_login_row *:-ms-input-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col', '#888') ?>;		
}
.pc_rf_field *::-moz-placeholder, .pc_login_row *::-moz-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col', '#888') ?>;		
}
.pc_rf_field .ms-choice > span.placeholder {
	color: <?php echo get_option('pg_fields_placeh_col', '#888') ?>;	
}

.pc_rf_field *:hover::-webkit-input-placeholder, .pc_rf_field *:focus::-webkit-input-placeholder, .pc_rf_field *:active::-webkit-input-placeholder, 
.pc_login_row *:hover::-webkit-input-placeholder, .pc_login_row *:focus::-webkit-input-placeholder, .pc_login_row *:active::-webkit-input-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col_h', '#666') ?>;	
}
.pc_rf_field *:hover:-ms-input-placeholder, .pc_rf_field *:focus:-ms-input-placeholder, .pc_rf_field *:active:-ms-input-placeholder, 
.pc_login_row *:hover:-ms-input-placeholder, .pc_login_row *:focus:-ms-input-placeholder, .pc_login_row *:active:-ms-input-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col_h', '#666') ?>;	
}
.pc_rf_field *:hover::-moz-input-placeholder, .pc_rf_field *:focus::-moz-input-placeholder, .pc_rf_field *:active::-moz-input-placeholder, 
.pc_login_row *:hover::-moz-input-placeholder, .pc_login_row *:focus::-moz-input-placeholder, .pc_login_row *:active::-moz-input-placeholder {
	color: <?php echo get_option('pg_fields_placeh_col_h', '#666') ?>;
}
.pc_rf_field .ms-choice:hover > span.placeholder, .pc_rf_field .ms-choice:focus > span.placeholder, .pc_rf_field .ms-choice:active > span.placeholder {
	color: <?php echo get_option('pg_fields_placeh_col_h', '#666') ?>;	
}


/* field icons */
.pc_field_w_icon input,
.pc_field_w_icon .ms-choice {
	padding-left: <?php echo 30 + (int)$fields_padding[1] + 7 ?>px !important;	
}
.pc_field_icon {
    padding-right: <?php echo (int)$fields_padding[1] ?>px;
    left: <?php echo (int)get_option('pg_field_border_w', 1) ?>px;
	top: <?php echo (int)get_option('pg_field_border_w', 1) ?>px;
	bottom: <?php echo (int)get_option('pg_field_border_w', 1) ?>px;
    border-radius: <?php echo get_option('pg_field_border_radius', 1) ?>px 0 0 <?php echo get_option('pg_field_border_radius', 1) ?>px;
    
	color: <?php echo get_option('pg_fields_icon_col', '#808080') ?>;
    background: <?php echo get_option('pg_fields_icon_bg', '#f8f8f8') ?>;
}
.pc_field_container:hover .pc_field_icon,
.pc_focused_field .pc_field_icon {
	color: <?php echo get_option('pg_fields_icon_col_h', '#666') ?>;
    background: <?php echo get_option('pg_fields_icon_bg_h', '#f0f0f0') ?>;
}


/* multiselect fix */
.pc_rf_field .ms-drop {
	padding: 0 !important;	
}
.pc_rf_field .ms-drop li label {
	background: <?php echo get_option('pg_fields_bg_col', '#fefefe') ?>;
    border-color: <?php echo get_option('pg_fields_border_col', '#ccc') ?>;
    color: <?php echo get_option('pg_fields_txt_col', '#808080') ?>;
}
.pc_rf_field .ms-search:before,
.pc_rf_field .ms-search:after,
.pc_rf_field .ms-search {
	border-color: <?php echo get_option('pg_fields_border_col', '#ccc') ?>;	
}
.pc_rf_field .ms-drop li:hover label {
	background: <?php echo get_option('pg_fields_bg_col_h', '#fff') ?>;
    color: <?php echo get_option('pg_fields_txt_col_h', '#444') ?>;	
}
.pc_rf_field .ms-search:hover:before,
.pc_rf_field .ms-search:hover:after,
.pc_rf_field .ms-search:hover {
	border-color: <?php echo get_option('pg_fields_border_col_h', '#aaa') ?>;	
}
.pc_rf_field .ms-search input,
.pc_rf_field .ms-search input:hover {
	border: none !important;	
}

/* custom checkbox */
.pc_checkbox {
	background: <?php echo get_option('pg_fields_bg_col', '#fefefe') ?>;
    border-color: <?php echo get_option('pg_fields_border_col', '#ccc') ?>;
}
.pc_checkbox.pc_checked {
	border-color: <?php echo get_option('pg_fields_border_col_h', '#aaa') ?>;	
}
.pc_checkbox:before {
	background: <?php echo get_option('pg_fields_bg_col_h', '#fff') ?>;
}
.pc_checkbox > span {
	color: <?php echo get_option('pg_fields_txt_col_h', '#444') ?>;
}


/* typography */
.pc_login_row label {
	font-size: <?php echo get_option('pg_lf_font_size', 15); ?>px;
}
.pc_form_flist > li > label,
.pc_disclaimer_txt {
	font-size: <?php echo get_option('pg_rf_font_size', 15); ?>px;
}
<?php if(get_option('pg_forms_font_family')) : ?>
.pc_login_row label, .pc_rf_field > label,
.pc_form_txt_block, .pc_disclaimer_txt,
.pc_auth_btn, .pc_reg_btn, .pc_logout_btn {
	font-family: "<?php get_option('pg_forms_font_family') ?>";
}
<?php endif; ?>


/* submit buttons */
.pc_login_form input[type="button"], .pc_login_form button, .pc_login_form input[type="button"]:focus, .pc_login_form button:focus,  
.pc_registration_form input[type="button"], .pc_registration_form button:not(.ms-choice), .pc_registration_form input[type="button"]:focus, .pc_registration_form button:not(.ms-choice):focus,
.pc_custom_form input[type="button"], .pc_custom_form button:not(.ms-choice), .pc_custom_form input[type="button"]:focus, .pc_custom_form button:not(.ms-choice):focus,
.pc_logout_btn, .pc_logout_btn:focus,
.pc_warn_box_btn {
	background: <?php echo get_option('pg_btn_bg_col', '#f4f4f4') ?> !important;
	border: <?php echo get_option('pg_btn_border_w', 1) ?>px solid <?php echo get_option('pg_btn_border_col', '#cccccc') ?> !important;
	border-radius: <?php echo get_option('pg_btn_border_radius', 1) ?>px !important;
	box-shadow: none;
	color: <?php echo get_option('pg_btn_txt_col', '#444444') ?> !important;	
    padding: <?php echo (int)$btn_padding[0] ?>px <?php echo (int)$btn_padding[1] ?>px !important;
    font-size: <?php echo get_option('pg_btns_font_size', 14) ?>px !important;
}
.pc_login_form input[type="button"]:hover, .pc_login_form input[type="button"]:active, 
.pc_login_form button:hover, .pc_login_form button:active, 
.pc_registration_form input[type="button"]:hover, .pc_registration_form input[type="button"]:active, 
.pc_registration_form button:not(.ms-choice):hover, .pc_registration_form button:not(.ms-choice):active, 
.pc_custom_form input[type="button"]:hover, .pc_custom_form input[type="button"]:active, 
.pc_custom_form button:not(.ms-choice):hover, .pc_custom_form button:not(.ms-choice):active, 
.pc_logout_btn:hover, .pc_logout_btn:active, 
.pc_loading_btn:hover, .pc_loading_btn:active, .pc_loading_btn:focus,
.pc_warn_box_btn:hover {
	background: <?php echo get_option('pg_btn_bg_col_h', '#efefef') ?> !important;
	border-color: <?php echo get_option('pg_btn_border_col_h', '#cacaca') ?> !important;
	color: <?php echo get_option('pg_btn_txt_col_h', '#222222') ?> !important;
}

/* disclaimer */
.pc_rf_disclaimer_sep {
	border-bottom: 1px solid <?php echo get_option('pg_forms_border_col', '#ebebeb') ?>;	
}


/* recaptcha */
.pc_rf_recaptcha #recaptcha_table {
	border-color: <?php echo get_option('pg_fields_border_col', '#ccc') ?> !important;
}	
.pc_rf_recaptcha #recaptcha_response_field {
	background: <?php echo get_option('pg_fields_bg_col', '#fefefe') ?> !important;
	border-color: <?php echo get_option('pg_fields_border_col', '#ccc') ?> !important;	
	color: <?php echo get_option('pg_fields_txt_col', '#ccc') ?> !important;
}
.pc_rf_recaptcha #recaptcha_response_field:focus {
	border-color: <?php echo get_option('pg_fields_border_col_h', '#aaa') ?> !important;	
	color: <?php echo get_option('pg_fields_txt_col_h', '#fff') ?> !important;
    background: <?php echo get_option('pg_fields_bg_col_h', '#fff') ?> !important;
}
.pc_rf_recaptcha #recaptcha_reload_btn {
	background: url('<?php echo $safe_baseurl; ?>/img/recaptcha_icons/refresh_<?php echo get_option('pg_recaptcha_col', 'l') ?>.png') no-repeat center center transparent !important;
}
.pc_rf_recaptcha #recaptcha_switch_audio_btn {
	background: url('<?php echo $safe_baseurl; ?>/img/recaptcha_icons/sound_<?php echo get_option('pg_recaptcha_col', 'l') ?>.png') no-repeat center center transparent !important;
}
.pc_rf_recaptcha #recaptcha_switch_img_btn {
	background: url('<?php echo $safe_baseurl; ?>/img/recaptcha_icons/text_<?php echo get_option('pg_recaptcha_col', 'l') ?>.png') no-repeat center center transparent !important;
}
.pc_rf_recaptcha #recaptcha_whatsthis_btn {
	background: url('<?php echo $safe_baseurl; ?>/img/recaptcha_icons/question_<?php echo get_option('pg_recaptcha_col', 'l') ?>.png') no-repeat center center transparent !important;
}


  
/*********************************
   STANDARD LOGIN FORM ELEMENTS
 ********************************/
  
/* container message */
.pc_login_block p {
    border-radius: <?php echo get_option('pg_field_border_radius', 1) ?>px;
}


/* login form smalls */
.pc_login_smalls {
	margin-bottom: -<?php echo (int)$btn_padding[0] ?>px; /* value equal to button's top padding */
}
.pc_login_smalls small {
	color: <?php echo get_option('pg_label_col', '#333') ?>;	
    opacity: 0.8;
    filter: alpha(opacity=70);
}

/* show and hide recovery form trigger */
.pc_rm_login .pcma_psw_recovery_trigger {
	border-left-color: <?php echo get_option('pg_forms_border_col', '#ebebeb') ?>;	
}


<?php 
// PC-ACTION - print code into custom style CSS
do_action('pc_custom_style_css'); 
?>