(function( $ ) {
    'use strict';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];
    var VisualDotsAnimation = {
        initDots: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualDotsAnimation.initDotsWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualDotsAnimation.initDotsWidget);
        },
        initDotsWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var dotsAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        dotsAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                dotsAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }                   
                    settings.switch = dotsAnimationArgs.marvy_enable_dots_animation;
                    // settings.bgColor = dotsAnimationArgs.marvy_dots_animation_background_color;
                    // settings.colorOne = dotsAnimationArgs.marvy_dots_animation_color;
                    // settings.colorTwo = dotsAnimationArgs.marvy_dots_animation_color_two;
                    settings.size = dotsAnimationArgs.marvy_dots_animation_size;
                    settings.spacing = dotsAnimationArgs.marvy_dots_animation_spacing;
                   
                    if(Object.keys(dotsAnimationArgs).length !== 0){
                        
                        if(dotsAnimationArgs.__globals__ && dotsAnimationArgs.__globals__.marvy_dots_animation_background_color && dotsAnimationArgs.__globals__.marvy_dots_animation_background_color !== ""){
                            var bgColor_id = dotsAnimationArgs.__globals__.marvy_dots_animation_background_color.split('=')[1];
                            var bgColor_arr = global_color.find(element => element._id  === bgColor_id);
                            settings.bgColor = bgColor_arr.color; 
                        }
                        else{
                            settings.bgColor = dotsAnimationArgs.marvy_dots_animation_background_color;
                        }
                        if(dotsAnimationArgs.__globals__ && dotsAnimationArgs.__globals__.marvy_dots_animation_color && dotsAnimationArgs.__globals__.marvy_dots_animation_color !== ""){
                            var colorOne_id = dotsAnimationArgs.__globals__.marvy_dots_animation_color.split('=')[1];
                            var colorOne_arr = global_color.find(element => element._id  === colorOne_id);
                            settings.colorOne = colorOne_arr.color; 
                        }
                        else{
                            settings.colorOne = dotsAnimationArgs.marvy_dots_animation_color;
                        }
                        if(dotsAnimationArgs.__globals__ && dotsAnimationArgs.__globals__.marvy_dots_animation_color_two && dotsAnimationArgs.__globals__.marvy_dots_animation_color_two !== ""){
                            var colorTwo_id = dotsAnimationArgs.__globals__.marvy_dots_animation_color_two.split('=')[1];
                            var colorTwo_arr = global_color.find(element => element._id  === colorTwo_id);
                            settings.colorTwo = colorTwo_arr.color; 
                        }
                        else{
                            settings.colorTwo = dotsAnimationArgs.marvy_dots_animation_color_two;
                        }                      
                    } 
                });

            } else {
                settings.switch = $scope.data("marvy_enable_dots_animation");
                settings.bgColor = $scope.data("marvy_dots_animation_background_color");
                settings.colorOne = $scope.data("marvy_dots_animation_color");
                settings.colorTwo = $scope.data("marvy_dots_animation_color_two");
                settings.size = $scope.data("marvy_dots_animation_size");
                settings.spacing = $scope.data("marvy_dots_animation_spacing");
            }

            if (settings.switch) {
                dotsAnimation(target, settings, sectionId);
            }
        }
    };

    function dotsAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-dots-section-" + sectionId);
        if (checkElement.length >= 0) {

            var dots_div = document.createElement('div');
            dots_div.classList.add("marvy-dots-section-" + sectionId);

            document.querySelector(target).appendChild(dots_div);
            document.querySelector(target).classList.add("marvy-custom-dots-animation-section-" + sectionId);

            // Set Z-index for section container
            var dotsZindex = document.querySelector('.marvy-custom-dots-animation-section-'+sectionId+' .elementor-container , .marvy-custom-dots-animation-section-'+sectionId+'>*');
            dotsZindex.style.zIndex = '99';

            // Set min height
            var dotsMinHeight = document.querySelector(".elementor-element-"+sectionId);
            dotsMinHeight.closest('.elementor-top-section,.e-con-boxed,.e-con-full').style.minHeight = "200px";


            var dotAnimation = VANTA.DOTS({
                el: ".marvy-dots-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 10.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                color: settings.colorOne,
                color2: settings.colorTwo,
                size: settings.size,
                spacing: settings.spacing
            });
            render(dotAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualDotsAnimation.initDots);
})( jQuery );