(function( $ ) {
    'use strict';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];
    var VisualTrunkAnimation = {
        initTrunk: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualTrunkAnimation.initTrunkWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualTrunkAnimation.initTrunkWidget);
        },
        initTrunkWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var trunkAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        trunkAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                trunkAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = trunkAnimationArgs.marvy_enable_trunk_animation;
                    // settings.color = trunkAnimationArgs.marvy_trunk_animation_color;
                    // settings.bgColor = trunkAnimationArgs.marvy_trunk_animation_background_color;
                    settings.spacing = trunkAnimationArgs.marvy_trunk_animation_spacing;
                    settings.chaos = trunkAnimationArgs.marvy_trunk_animation_chaos;
                    if(Object.keys(trunkAnimationArgs).length !== 0){
                                            
                        if(trunkAnimationArgs.__globals__ && trunkAnimationArgs.__globals__.marvy_trunk_animation_background_color && trunkAnimationArgs.__globals__.marvy_trunk_animation_background_color !== ""){
                            var bgColor_id = trunkAnimationArgs.__globals__.marvy_trunk_animation_background_color.split('=')[1];
                            var bgColor_arr = global_color.find(element => element._id  === bgColor_id);
                            settings.bgColor = bgColor_arr.color; 
                        }
                        else{
                            settings.bgColor = trunkAnimationArgs.marvy_trunk_animation_background_color;
                        }
                        if(trunkAnimationArgs.__globals__ && trunkAnimationArgs.__globals__.marvy_trunk_animation_color && trunkAnimationArgs.__globals__.marvy_trunk_animation_color !== ""){
                            var color_id = trunkAnimationArgs.__globals__.marvy_trunk_animation_color.split('=')[1];
                            var color_arr = global_color.find(element => element._id  === color_id);
                            settings.color = color_arr.color; 
                        }
                        else{
                            settings.color = trunkAnimationArgs.marvy_trunk_animation_color;
                        }
                                            
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_trunk_animation");
                settings.color = $scope.data("marvy_trunk_animation_color");
                settings.bgColor = $scope.data("marvy_trunk_animation_background_color");
                settings.spacing = $scope.data("marvy_trunk_animation_spacing");
                settings.chaos = $scope.data("marvy_trunk_animation_chaos");
            }

            if (settings.switch) {
                trunkAnimation(target, settings, sectionId);
            }
        }
    };

    function trunkAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-trunk-section-" + sectionId);
        if (checkElement.length >= 0) {

            var trunk_div = document.createElement('div');
            trunk_div.classList.add("marvy-trunk-section-" + sectionId);

            document.querySelector(target).appendChild(trunk_div);
            document.querySelector(target).classList.add("marvy-custom-trunk-animation-section-" + sectionId);

            // Set Z-index for section container
            var trunkZindex = document.querySelector('.marvy-custom-trunk-animation-section-'+sectionId+' .elementor-container , .marvy-custom-trunk-animation-section-'+sectionId+'>*');
            trunkZindex.style.zIndex = '99';

            // Set min height
            var trunkMinHeight = document.querySelector(".elementor-element-"+sectionId);
            trunkMinHeight.closest('.elementor-top-section,.e-con-boxed,.e-con-full').style.minHeight = "200px";

            var trunkAnimation = VANTA.TRUNK({
                el: ".marvy-trunk-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 200.00,
                scale: 1.00,
                scaleMobile: 1.00,
                color: settings.color,
                backgroundColor: settings.bgColor,
                spacing: settings.spacing,
                chaos: settings.chaos
            });
            render(trunkAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualTrunkAnimation.initTrunk);
})( jQuery );