(function ($) {
    'use strict';
    var marvyParticlesWaveJsWorker = marvyScript.pluginsUrl + 'assets/js/custom/marvy.particlesWave.custom.js';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];

    var VisualParticlesWaveAnimation = {
        initParticlesWave: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualParticlesWaveAnimation.initParticlesWaveWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualParticlesWaveAnimation.initParticlesWaveWidget);
        },
        initParticlesWaveWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var particlesWaveAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        particlesWaveAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                particlesWaveAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    if (particlesWaveAnimationArgs.marvy_enable_particles_wave_animation) {
                        settings.switch = particlesWaveAnimationArgs.marvy_enable_particles_wave_animation;
                        settings.particle_count = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_count;
                        settings.partical_size = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_size;
                        settings.speed = particlesWaveAnimationArgs.marvy_particles_wave_animation_animation_speed;
                        settings.color = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_color;
                        settings.default_background = particlesWaveAnimationArgs.marvy_enable_particles_wave_animation_default_background;
                        
                        if(Object.keys(particlesWaveAnimationArgs).length !== 0){
                                            
                            if(particlesWaveAnimationArgs.__globals__ && particlesWaveAnimationArgs.__globals__.marvy_particles_wave_animation_particle_color && particlesWaveAnimationArgs.__globals__.marvy_particles_wave_animation_particle_color !== ""){
                                var color_id = particlesWaveAnimationArgs.__globals__.marvy_particles_wave_animation_particle_color.split('=')[1];
                                var color_arr = global_color.find(element => element._id  === color_id);
                                settings.color = color_arr.color; 
                            }
                            else{
                                settings.color = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_color; 
                            }
                                                
                        }
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_particles_wave_animation");
                settings.particle_count = $scope.data("marvy_particles_wave_animation_particle_count");
                settings.partical_size = $scope.data("marvy_particles_wave_animation_particle_size");
                settings.speed = $scope.data("marvy_particles_wave_animation_animation_speed");
                settings.color = $scope.data("marvy_particles_wave_animation_particle_color");
                settings.default_background = $scope.data("marvy_enable_particles_wave_animation_default_background");
            }
            if (settings.switch) {
                particlesWaveAnimation(target, settings, sectionId);
            }else {
                document.querySelector(target).classList.remove("marvy-custom-particles-wave-animation");
                document.querySelector(target).classList.remove("with-default-background");
            }
        }
    };

    function particlesWaveAnimation(target, settings, sectionId) {
        var checkElement = document.getElementsByClassName("marvy-particles-wave-section-" + sectionId);
        if (checkElement.length >= 0 && settings) {
            document.querySelector(target).classList.add("marvy-custom-particles-wave-animation-section-" + sectionId);
            document.querySelector(target).classList.add("marvy-custom-particles-wave-animation");
            document.querySelector(target).classList.add("with-default-background");
            if(settings.default_background != 'yes'){
                document.querySelector(target).classList.remove("with-default-background");
            }
            var particles_wave_div = document.createElement('canvas');
            particles_wave_div.setAttribute('id', 'marvy-particle-wave-canvas-' + sectionId);
            particles_wave_div.classList.add("marvy-particles-wave-section-" + sectionId);
            particles_wave_div.classList.add("marvy-particles-wave");
            document.querySelector(target).appendChild(particles_wave_div);

            // Set Z-index for section container
            var particlesWaveZindex = document.querySelector('.marvy-custom-particles-wave-animation-section-' + sectionId + ' .elementor-container , .marvy-custom-particles-wave-animation-section-' + sectionId + '>*');
            particlesWaveZindex.style.zIndex = '99';
            particlesWaveZindex.style.width = '100%';

            settings.speed = settings.speed * 100;

            startAnimation('marvy-particle-wave-canvas-' + sectionId, settings.particle_count, settings.partical_size, settings.speed,settings.color);
            resizeCanvas(sectionId);
        }
        return true;
    }

    // modified version of random-normal
    function normalPool(o) {
        var r = 0;
        do {
            var a = Math.round(normal({mean: o.mean, dev: o.dev}));
            if (a < o.pool.length && a >= 0) return o.pool[a];
            r++
        } while (r < 100)
    }

    function randomNormal(o) {
        if (o = Object.assign({
            mean: 0,
            dev: 1,
            pool: []
        }, o), Array.isArray(o.pool) && o.pool.length > 0) return normalPool(o);
        var r, a, n, e, l = o.mean, t = o.dev;
        do {
            r = (a = 2 * Math.random() - 1) * a + (n = 2 * Math.random() - 1) * n
        } while (r >= 1);
        return e = a * Math.sqrt(-2 * Math.log(r) / r), t * e + l
    }

    function rand(low, high) {
        return Math.random() * (high - low) + low;
    }

    function createParticle( particleSize, speed, color) {
        var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(color);
        let color_r = parseInt(result[1], 16);
        let color_g = parseInt(result[2], 16);
        let color_b = parseInt(result[3], 16);
        const colour = {
            r: color_r,
            g: color_g,
            b: color_b,
            a: rand(0, 1),
        };
        return {
            x: -2,
            y: -2,
            diameter: Math.max(0, randomNormal({mean: particleSize, dev: particleSize / 2})),
            duration: randomNormal({mean: speed, dev: speed * 0.1}),
            amplitude: randomNormal({mean: 16, dev: 2}),
            offsetY: randomNormal({mean: 0, dev: 10}),
            arc: Math.PI * 2,
            startTime: performance.now() - rand(0, speed),
            colour: `rgba(${colour.r}, ${colour.g}, ${colour.b}, ${colour.a})`,
        }
    }

    function moveParticle(particle, time) {
        const progress = ((time - particle.startTime) % particle.duration) / particle.duration;
        return {
            ...particle,
            x: progress,
            y: ((Math.sin(progress * particle.arc) * particle.amplitude) + particle.offsetY),
        };
    }

    function drawParticle(coanvasId, particle, ctx) {
        if (ctx) {
            const vh = ctx.canvas.height / 100;

            ctx.fillStyle = particle.colour;
            ctx.beginPath();
            ctx.ellipse(
                particle.x * ctx.canvas.width,
                particle.y * vh + (ctx.canvas.height / 2),
                particle.diameter * vh,
                particle.diameter * vh,
                0,
                0,
                2 * Math.PI
            );
            ctx.fill();
        }
    }

    function draw(time, coanvasId, canvas, ctx, particles) {
        // Move particles
        if (ctx && canvas) {
            particles.map((p, index) => particles[index] = moveParticle(p, time));

            // Clear the canvas
            ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);

            // Draw the particles
            particles.map((p) => drawParticle(coanvasId, p, ctx));

            // Schedule next frame
            requestAnimationFrame((time) => draw(time, coanvasId, canvas, ctx, particles));
        }
    }

    function initializeCanvas(coanvasId) {
        let canvas = document.getElementById(coanvasId);
        canvas.width = canvas.offsetWidth * window.devicePixelRatio;
        canvas.height = canvas.offsetHeight * window.devicePixelRatio;
        let ctx = canvas.getContext("2d");

        window.addEventListener('resize', () => {
            canvas.width = canvas.offsetWidth * window.devicePixelRatio;
            canvas.height = canvas.offsetHeight * window.devicePixelRatio;
            ctx = canvas.getContext("2d");
        })

        return [canvas, ctx];
    }

    function startAnimation(coanvasId, particleCount, particleSize, speed, color) {
        const [canvas, ctx] = initializeCanvas(coanvasId);
        let particles = [];
        // Create a bunch of particles
        for (let i = 0; i < particleCount; i++) {
            particles.push(createParticle(particleSize, speed, color));
        }
        ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
        requestAnimationFrame((time) => draw(time, coanvasId, canvas, ctx, particles));
    };

    function resizeCanvas(id){
        var canvas = document.getElementById('marvy-particle-wave-canvas-'+id);
        if (canvas) {
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
        }
    }

    $(window).on('resize', function(){
        resizeCanvas();
    });
    $(window).on('elementor/frontend/init', VisualParticlesWaveAnimation.initParticlesWave);
})(jQuery);
