(function( $ ) {
    'use strict';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];
    var VisualBirdsAnimation = {
        initBirds: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualBirdsAnimation.initBirdsWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualBirdsAnimation.initBirdsWidget);
        },
        initBirdsWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var birdsAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        birdsAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                birdsAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }                   
                    settings.switch = birdsAnimationArgs.marvy_enable_birds_animation;
                    // settings.bgColor = birdsAnimationArgs.marvy_birds_animation_background_color;
                    settings.bgOpacity = birdsAnimationArgs.marvy_birds_animation_background_opacity;
                    settings.wingsMode = birdsAnimationArgs.marvy_birds_animation_wings_mode;
                    // settings.wingsColor = birdsAnimationArgs.marvy_birds_animation_wings_color;
                    // settings.wingsColorTwo = birdsAnimationArgs.marvy_birds_animation_wings_color_two;
                    settings.birdQuantity = birdsAnimationArgs.marvy_birds_animation_quantity;
                    settings.BirdSize = birdsAnimationArgs.marvy_birds_animation_bird_size;
                    settings.wingSpan = birdsAnimationArgs.marvy_birds_animation_wing_span;
                    settings.wingSpeedLimit = birdsAnimationArgs.marvy_birds_animation_speed_limit;
                    settings.birdSeparation = birdsAnimationArgs.marvy_birds_animation_separation;
                    settings.birdAlignment = birdsAnimationArgs.marvy_birds_animation_alignment;
                    settings.birdCohesion = birdsAnimationArgs.marvy_birds_animation_cohesion;

                    if(Object.keys(birdsAnimationArgs).length !== 0){
                        
                        if(birdsAnimationArgs.__globals__ && birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color && birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color !== ""){
                            var wingsColor_id = birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color.split('=')[1];
                            var wingsColor_arr = global_color.find(element => element._id  === wingsColor_id);
                            settings.wingsColor = wingsColor_arr.color; 
                        }
                        else{
                            settings.wingsColor = birdsAnimationArgs.marvy_birds_animation_wings_color;
                        }
                        if(birdsAnimationArgs.__globals__ && birdsAnimationArgs.__globals__.marvy_birds_animation_background_color && birdsAnimationArgs.__globals__.marvy_birds_animation_background_color !== ""){
                            var bgColor_id = birdsAnimationArgs.__globals__.marvy_birds_animation_background_color.split('=')[1];
                            var bgColor_arr = global_color.find(element => element._id  === bgColor_id);
                            settings.bgColor = bgColor_arr.color; 
                        }
                        else{
                            settings.bgColor = birdsAnimationArgs.marvy_birds_animation_background_color;
                        }
                        if(birdsAnimationArgs.__globals__ && birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color_two && birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color_two !== ""){
                            var wingsColorTwo_id = birdsAnimationArgs.__globals__.marvy_birds_animation_wings_color_two.split('=')[1];
                            var wingsColorTwo_arr = global_color.find(element => element._id  === wingsColorTwo_id);
                            settings.wingsColorTwo = wingsColorTwo_arr.color; 
                        }
                        else{
                            settings.wingsColorTwo = birdsAnimationArgs.marvy_birds_animation_wings_color_two;
                        }                      
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_birds_animation");
                settings.bgColor = $scope.data("marvy_birds_animation_background_color");
                settings.bgOpacity = $scope.data("marvy_birds_animation_background_opacity");
                settings.wingsMode = $scope.data("marvy_birds_animation_wings_mode");
                settings.wingsColor = $scope.data("marvy_birds_animation_wings_color");
                settings.wingsColorTwo = $scope.data("marvy_birds_animation_wings_color_two");
                settings.birdQuantity = $scope.data("marvy_birds_animation_quantity");
                settings.BirdSize = $scope.data("marvy_birds_animation_bird_size");
                settings.wingSpan = $scope.data("marvy_birds_animation_wing_span");
                settings.wingSpeedLimit = $scope.data("marvy_birds_animation_speed_limit");
                settings.birdSeparation = $scope.data("marvy_birds_animation_separation");
                settings.birdAlignment = $scope.data("marvy_birds_animation_alignment");
                settings.birdCohesion = $scope.data("marvy_birds_animation_cohesion");
            }

            if (settings.switch) {
                birdsAnimation(target, settings, sectionId);
            }
        }
    };

    function birdsAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-birds-section-" + sectionId);
        if (checkElement.length >= 0) {

            var birds_div = document.createElement('div');
            birds_div.classList.add("marvy-birds-section-" + sectionId);

            document.querySelector(target).appendChild(birds_div);
            document.querySelector(target).classList.add("marvy-custom-birds-animation-section-" + sectionId);

            // Set Z-index for section container
            var birdsZindex = document.querySelector('.marvy-custom-birds-animation-section-'+sectionId+' .elementor-container , .marvy-custom-birds-animation-section-'+sectionId+'>*');
            birdsZindex.style.zIndex = '99';

            var birdsAnimation = VANTA.BIRDS({
                el: ".marvy-birds-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 100.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                backgroundAlpha: settings.bgOpacity,
                colorMode: settings.wingsMode,
                color1: settings.wingsColor,
                color2: settings.wingsColorTwo,
                quantity: settings.birdQuantity,
                birdSize: settings.BirdSize,
                wingSpan: settings.wingSpan,
                speedLimit: settings.wingSpeedLimit,
                separation: settings.birdSeparation,
                alignment: settings.birdSeparation,
                cohesion: settings.birdCohesion
            });
            render(birdsAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualBirdsAnimation.initBirds);
})( jQuery );