<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://iqonic.design/
 * @since             1.0.0
 * @package           Marvy_Animation_Addons
 *
 * @wordpress-plugin
 * Plugin Name:       Marvy - Ultimate Elementor Animation addons 
 * Plugin URI:        https://iqonicthemes.com
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Iqonic Design
 * Author URI:        https://iqonic.design/
 * Text Domain:       marvy-animation-addons
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'MARVY_ANIMATION_ADDONS_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-marvy-animation-addons-activator.php
 */
function marvy_animation_addons_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-marvy-animation-addons-activator.php';
	Marvy_Animation_Addons_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-marvy-animation-addons-deactivator.php
 */
function marvy_animation_addons_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-marvy-animation-addons-deactivator.php';
	Marvy_Animation_Addons_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'marvy_animation_addons_activate' );
register_deactivation_hook( __FILE__, 'marvy_animation_addons_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-marvy-animation-addons.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function marvy_animation_addons_run() {

	$plugin = new Marvy_Animation_Addons();
	$plugin->run();

}
marvy_animation_addons_run();
