<?php

if( !defined( 'ABSPATH' ) ) exit;

use Elementor\Controls_Manager;

class Marvy_Fancy_Rotate {

  public function __construct(){
    add_action('elementor/frontend/section/before_render', array($this, 'before_render'), 1);
    add_action('elementor/element/section/section_layout/after_section_end',array($this,'register_controls'), 1 );
  }

  public function register_controls($element)
  {
    $element->start_controls_section('marvy_banner_animation_section',
      [
        'label' => __('<div style="float: right"><img src="'.plugin_dir_url(__DIR__).'images/logo.png" height="15px" width="15px" style="flot:left;" alt=""></div> Fancy Rotate Animation', 'marvy-lang'),
        'tab' => Controls_Manager::TAB_LAYOUT
      ]
    );

    $element->add_control('marvy_enable_banner_animation',
      [
        'label' => esc_html__('Enable Fancy Rotate Animation', 'marvy-lang'),
        'type' => Controls_Manager::SWITCHER,
      ]
    );

    $element->add_control('marvy_enable_banner_animation_circle',
      [
        'label' => esc_html__('Show Circle', 'marvy-lang'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'marvy_enable_banner_animation' => 'yes',
        ]
      ]
    );

    $element->add_control('marvy_enable_banner_animation_particle',
      [
        'label' => esc_html__('Show Particle', 'marvy-lang'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'marvy_enable_banner_animation' => 'yes',
        ]
      ]
    );

    $element->add_control(
      'marvy_banner_animation_first_color',
      [
        'label' => esc_html__('First Particle Color', 'marvy-lang'),
        'type' => Controls_Manager::COLOR,
        'default' => '#ec542f',
        'condition' => [
          'marvy_enable_banner_animation' => 'yes',
          'marvy_enable_banner_animation_particle' => 'yes',
        ]
      ]
    );

    $element->add_control(
      'marvy_banner_animation_second_color',
      [
        'label' => esc_html__('Second Particle Color', 'marvy-lang'),
        'type' => Controls_Manager::COLOR,
        'default' => '#ffffff',
        'condition' => [
          'marvy_enable_banner_animation' => 'yes',
          'marvy_enable_banner_animation_particle' => 'yes',
        ]
      ]
    );

    $element->end_controls_section();

  }

  public function before_render($element) {
    $settings = $element->get_settings();
      if ($settings['marvy_enable_banner_animation'] === 'yes') {
          $element->add_render_attribute(
              '_wrapper',
              [
                  'data-marvy_enable_banner_animation' => 'true',
                  'data-marvy_enable_banner_animation_circle' => $settings['marvy_enable_banner_animation_circle'],
                  'data-marvy_enable_banner_animation_particle' => $settings['marvy_enable_banner_animation_particle'],
                  'data-marvy_banner_animation_first_color' => $settings['marvy_banner_animation_first_color'],
                  'data-marvy_banner_animation_second_color' => $settings['marvy_banner_animation_second_color'],
              ]
          );
      } else {
          $element->add_render_attribute('_wrapper', 'data-marvy_enable_banner_animation', 'false');
      }

  }
}