/*
Plugin Name: Marvy - Ultimate Elementor Animation addons
Author    :   Iqonic Design
Version   :   1.0.0
Author URI:   https://iqonic.design/
*/

/*----------------------------------------------
Index Of Script
------------------------------------------------
1 Fancy Rotate
2 Drop
3 Flying Objects
4 Ripple
*/

/*----------------------------- Fancy Rotate --------------------------*/
(function( $ ) {
	'use strict';
	var previousBanner = {};
	var styleBanner = document.createElement('style');
	var sheetBanner = document.head.appendChild(styleBanner).sheet;
	var innerImageUrl = marvyScript.pluginsUrl + 'images/circle_inner.png';
	var outerImageUrl = marvyScript.pluginsUrl + 'images/circle_outer.png';

	var MarvyBannerAnimation = {
		initBanner: function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/section', MarvyBannerAnimation.initBannerWidget);
		},
		initBannerWidget: function ($scope) {
			var sectionId = $scope.data('id');
			var target = '.elementor-element-'+ sectionId;
			var settings = {};
			if (window.isEditMode || window.elementorFrontend.isEditMode()) {
				var editorElements = null;
				var bannerAnimationArgs = {};

				if (!window.elementor.hasOwnProperty('elements')) {
					return false;
				}

				editorElements = window.elementor.elements;

				if (!editorElements.models) {
					return false;
				}

				$.each(editorElements.models, function (i, el) {
					if (sectionId === el.id) {
						bannerAnimationArgs = el.attributes.settings.attributes;
					} else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
						$.each(el.attributes.elements.models, function (i, col) {
							$.each(col.attributes.elements.models, function (i, subSec) {
								bannerAnimationArgs = subSec.attributes.settings.attributes;
							});
						});
					}
					settings.switch = bannerAnimationArgs.marvy_enable_banner_animation;
					settings.circle = bannerAnimationArgs.marvy_enable_banner_animation_circle;
					settings.particle = bannerAnimationArgs.marvy_enable_banner_animation_particle;
					settings.firstColor = bannerAnimationArgs.marvy_banner_animation_first_color;
					settings.secondColor = bannerAnimationArgs.marvy_banner_animation_second_color;
				});
			} else {
				settings.switch = $scope.data('marvy_enable_banner_animation');
				settings.circle = $scope.data('marvy_enable_banner_animation_circle');
				settings.particle = $scope.data('marvy_enable_banner_animation_particle');
				settings.firstColor = $scope.data('marvy_banner_animation_first_color');
				settings.secondColor = $scope.data('marvy_banner_animation_second_color');
			}

			if (settings.switch) {
				var sectionKey = 'banner-'+sectionId;
				if (!previousBanner.hasOwnProperty(sectionKey)){
					previousBanner[sectionKey] = settings;
				}

				var result = bannerAnimation(target, settings, sectionId, sectionKey);
				if (result){
					previousBanner[sectionKey] = settings;
				}
			} else {
				previousBanner = {};
				if (sheetBanner.cssRules.length !== 0){
					for (var j = sheetBanner.cssRules.length - 1; j >= 0; j--) {
						if(sheetBanner.cssRules[j].selectorText.includes(sectionId) ) {
							sheetBanner.deleteRule(j);
						}
					}
				}
			}
		}
	};

	$( window ).on('elementor/frontend/init', MarvyBannerAnimation.initBanner);

	function addRule(selector, css) {
		var propText = typeof css === "string" ? css : Object.keys(css).map(function (p) {
			return p + ":" + (p === "content" ? "'" + css[p] + "'" : css[p]);
		}).join(";");
		sheetBanner.insertRule(selector + "{" + propText + "}", sheetBanner.cssRules.length);
	}

	function bannerAnimation(target,settings,sectionId, sectionKey) {

		var checkElement = document.getElementsByClassName("marvy-banner-section-"+sectionId);

		if (checkElement.length >= 0 ) {
			var banner_div = document.createElement('div');

			banner_div.classList.add("marvy-banner-section-"+sectionId);
			document.querySelector(target).appendChild(banner_div);

			document.querySelector(target).classList.add('marvy-custom-banner-animation-section-'+sectionId);
			var bannerZindex = document.querySelector('.marvy-custom-banner-animation-section-'+sectionId+' .elementor-container');
			bannerZindex.style.zIndex = '99';

			var bannerMinHeight = document.querySelector(".elementor-element-"+sectionId);
			bannerMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

			var first_div_el = document.createElement('div');
			var second_div_el = document.createElement('div');

			if (settings.particle === 'yes') {
				first_div_el.classList.add("marvy-particles-first-"+sectionId);
				first_div_el.setAttribute("id","marvy-particleCanvas-First-"+sectionId);
				second_div_el.classList.add("marvy-particles-second-"+sectionId);
				second_div_el.setAttribute("id","marvy-particleCanvas-Second-"+sectionId);

				document.querySelector(".marvy-banner-section-"+sectionId).appendChild(first_div_el);
				document.querySelector(".marvy-banner-section-"+sectionId).appendChild(second_div_el);

				particlesJS("marvy-particleCanvas-First-"+sectionId,
					{
					"particles": {
						"number": {
							"value": 100,
							"density": {
								"enable": true,
								"value_area": 800
							}
						},
						"color": {
							"value": settings.firstColor
						},
						"shape": {
							"type": "circle",
							"stroke": {
								"width": 0,
								"color": settings.firstColor
							},
							"polygon": {
								"nb_sides": 3
							},
							"image": {
								"src": "img/github.svg",
								"width": 100,
								"height": 100
							}
						},
						"opacity": {
							"value": 0.5,
							"random": false,
							"anim": {
								"enable": true,
								"speed": 1,
								"opacity_min": 0.1,
								"sync": false
							}
						},
						"size": {
							"value": 20,
							"random": true,
							"anim": {
								"enable": false,
								"speed": 10,
								"size_min": 0.1,
								"sync": false
							}
						},
						"line_linked": {
							"enable": false,
							"distance": 150,
							"color": "#ffffff",
							"opacity": 0.4,
							"width": 1
						},
						"move": {
							"enable": true,
							"speed": 2,
							"direction": "none",
							"random": true,
							"straight": false,
							"out_mode": "bounce",
							"bounce": false,
							"attract": {
								"enable": false,
								"rotateX": 394.57382081613633,
								"rotateY": 157.82952832645452
							}
						}
					},
					"interactivity": {
						"detect_on": "canvas",
						"events": {
							"onhover": {
								"enable": true,
								"mode": "grab"
							},
							"onclick": {
								"enable": false,
								"mode": "push"
							},
							"resize": true
						},
						"modes": {
							"grab": {
								"distance": 200,
								"line_linked": {
									"opacity": 0.2
								}
							},
							"bubble": {
								"distance": 1500,
								"size": 40,
								"duration": 7.272727272727273,
								"opacity": 0.3676323676323676,
								"speed": 3
							},
							"repulse": {
								"distance": 50,
								"duration": 0.4
							},
							"push": {
								"particles_nb": 4
							},
							"remove": {
								"particles_nb": 2
							}
						}
					},
					"retina_detect": true
				});
				particlesJS("marvy-particleCanvas-Second-"+sectionId,
					{
					"particles": {
						"number": {
							"value": 100,
							"density": {
								"enable": true,
								"value_area": 800
							}
						},
						"color": {
							"value": settings.secondColor
						},
						"shape": {
							"type": "circle",
							"stroke": {
								"width": 0,
								"color": settings.secondColor
							},
							"polygon": {
								"nb_sides": 3
							},
							"image": {
								"src": "img/github.svg",
								"width": 100,
								"height": 100
							}
						},
						"opacity": {
							"value": 0.5,
							"random": true,
							"anim": {
								"enable": false,
								"speed": 0.2,
								"opacity_min": 0,
								"sync": false
							}
						},
						"size": {
							"value": 15,
							"random": true,
							"anim": {
								"enable": true,
								"speed": 10,
								"size_min": 0.1,
								"sync": false
							}
						},
						"line_linked": {
							"enable": false,
							"distance": 150,
							"color": "#ffffff",
							"opacity": 0.4,
							"width": 1
						},
						"move": {
							"enable": true,
							"speed": 2,
							"direction": "none",
							"random": true,
							"straight": false,
							"out_mode": "bounce",
							"bounce": false,
							"attract": {
								"enable": true,
								"rotateX": 3945.7382081613637,
								"rotateY": 157.82952832645452
							}
						}
					},
					"interactivity": {
						"detect_on": "canvas",
						"events": {
							"onhover": {
								"enable": false,
								"mode": "grab"
							},
							"onclick": {
								"enable": false,
								"mode": "push"
							},
							"resize": true
						},
						"modes": {
							"grab": {
								"distance": 200,
								"line_linked": {
									"opacity": 0.2
								}
							},
							"bubble": {
								"distance": 1500,
								"size": 40,
								"duration": 7.272727272727273,
								"opacity": 0.3676323676323676,
								"speed": 3
							},
							"repulse": {
								"distance": 50,
								"duration": 0.4
							},
							"push": {
								"particles_nb": 4
							},
							"remove": {
								"particles_nb": 2
							}
						}
					},
					"retina_detect": true
				});
			}
			var appendBanner = true;

			if (JSON.stringify(previousBanner[sectionKey]) !== JSON.stringify(settings)){
				appendBanner = false;
				for (var j = sheetBanner.cssRules.length - 1; j >= 0; j--) {
					if(sheetBanner.cssRules[j].selectorText.includes(sectionId) ) {
						sheetBanner.deleteRule(j);
					}
					if (j === 0){
						appendBanner = true;
						previousBanner[sectionKey] = settings;
					}
				}
			}
			while (!appendBanner){}

			addRule(".marvy-banner-section-"+sectionId+"", {
				overflow: "hidden !important"
			});

			if (settings.circle === 'yes') {
				addRule(".marvy-banner-section-" + sectionId + ":before", {
					"background-image": 'url(' + innerImageUrl + ')',
					content: " "
				});

				addRule(".marvy-banner-section-" + sectionId + ":after", {
					"background-image": 'url(' + outerImageUrl + ')',
					content: " "
				});
			}

		}
		return true;
	}

})( jQuery );

/*-----------------------------  Drop ---------------------------------*/
(function( $ ) {
	'use strict';
	var previousColorDrop = {};
	var styleColorDrop = document.createElement('style');
	var sheetColorDrop = document.head.appendChild(styleColorDrop).sheet;
	var MarvyColorDropAnimation = {
		initColorDrop: function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/section', MarvyColorDropAnimation.initColorDropWidget);
		},
		initColorDropWidget: function ($scope) {
			var sectionId = $scope.data('id');
			var target = '.elementor-element-'+ sectionId;
			var settings = {};
			if (window.isEditMode || window.elementorFrontend.isEditMode()) {

				var colorDropEditorElements = null;
				var colorDropAnimationArgs = {};
				if (!window.elementor.hasOwnProperty('elements')) {
					return false;
				}
				colorDropEditorElements = window.elementor.elements;
				if (!colorDropEditorElements.models) {
					return false;
				}

				$.each(colorDropEditorElements.models, function (i, el) {
					if (sectionId === el.id) {
						colorDropAnimationArgs = el.attributes.settings.attributes;
					} else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
						$.each(el.attributes.elements.models, function (i, col) {
							$.each(col.attributes.elements.models, function (i, subSec) {
								colorDropAnimationArgs = subSec.attributes.settings.attributes;
							});
						});
					}

					settings.switch = colorDropAnimationArgs.marvy_enable_color_drop_animation;
					settings.types = colorDropAnimationArgs.marvy_color_drop_animation_types;
					settings.firstColor = colorDropAnimationArgs.marvy_color_drop_animation_line_color;
					settings.secondColor = colorDropAnimationArgs.marvy_color_drop_animation_line_color_second;
					settings.dotColor = colorDropAnimationArgs.marvy_color_drop_animation_drop_dot_color;
					settings.dotSize = colorDropAnimationArgs.marvy_color_drop_animation_drop_dot_size;
					settings.speed = colorDropAnimationArgs.marvy_color_drop_animation_drop_speed;
				});
			}  else {
				settings.switch = $scope.data('marvy_enable_color_drop_animation');
				settings.types = $scope.data('marvy_color_drop_animation_types');
				settings.firstColor = $scope.data('marvy_color_drop_animation_line_color');
				settings.secondColor = $scope.data('marvy_color_drop_animation_line_color_second');
				settings.dotColor = $scope.data('marvy_color_drop_animation_drop_dot_color');
				settings.dotSize = $scope.data('marvy_color_drop_animation_drop_dot_size');
				settings.speed = $scope.data('marvy_color_drop_animation_drop_speed');
			}
			if (settings.switch) {
				var sectionKey = 'colorDrop-'+sectionId;
				if (!previousColorDrop.hasOwnProperty(sectionKey)){
					previousColorDrop[sectionKey] = settings;
				}
				var result = colorDropAnimation(target, settings, sectionId, sectionKey);
				if (result){
					previousColorDrop[sectionKey] = settings;
				}
			}else{
				previousColorDrop = {};
				if (sheetColorDrop.cssRules.length !== 0){
					for (var j = sheetColorDrop.cssRules.length - 1; j >= 0; j--) {
						if(sheetColorDrop.cssRules[j].selectorText.includes(sectionId) ){
							sheetColorDrop.deleteRule(j);
						}
					}
				}
			}
		}
	};

	$( window ).on('elementor/frontend/init', MarvyColorDropAnimation.initColorDrop);

	function addRule(selector, css, i) {
		var propText = typeof css === "string" ? css : Object.keys(css).map(function (p) {
			return p + ":" + (p === "content" ? "'" + css[p] + "'" : css[p]);
		}).join(";");
		sheetColorDrop.insertRule(selector + "{" + propText + "}", i);
	}
	function colorDropAnimation(target,settings,sectionId,sectionKey) {
		var checkElement = document.getElementsByClassName("marvy-color-drop-section-"+sectionId);
		if (checkElement.length <= 0 ) {
			var min = 1,j;
			var total = 150;
			var height = '';
			var dotSize = '';
			var time = 11 - settings.speed;
			var percent = 0.69444;
			if (settings.types === 'onlyDot') {
				height = 0;
				dotSize = settings.dotSize;
			} else if (settings.types === 'candleShape') {
				height = 50;
				dotSize = 0.3;
			} else if (settings.types === 'onlyLine') {
				height = 300;
				dotSize = 0;
			} else {
				height = 300;
				dotSize = settings.dotSize;
			}

			var i=0;
			var color_drop_div_el = document.createElement('div');
			color_drop_div_el.classList.add("marvy-color-drop-section-"+sectionId);
			document.querySelector(target).appendChild(color_drop_div_el);
			document.querySelector(target).classList.add('marvy-custom-color-drop-section-'+sectionId);

			var zIndex = document.querySelector('.marvy-custom-color-drop-section-'+sectionId+' .elementor-container');
			zIndex.style.zIndex = '99';

			var colorDropMinHeight = document.querySelector(".elementor-element-"+sectionId);
			colorDropMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

			var appendColeDropRule = true;
			if (JSON.stringify(previousColorDrop[sectionKey]) !== JSON.stringify(settings)){
				appendColeDropRule = false;
				for (j = sheetColorDrop.cssRules.length - 1; j >= 0; j--) {
					if(sheetColorDrop.cssRules[j].selectorText.includes(sectionId) ){
						sheetColorDrop.deleteRule(j);
					}
					if (j === 0){
						appendColeDropRule = true;
						previousColorDrop[sectionKey] = settings;
					}
				}
			}
			while(i <= total){
				var child_color_drop_div_el = document.createElement('div');
				child_color_drop_div_el.classList.add("marvy-color-drop-line-"+sectionId);
				document.querySelector(".marvy-color-drop-section-"+sectionId).appendChild(child_color_drop_div_el);


				if(appendColeDropRule) {
					addRule(".marvy-color-drop-line-" + sectionId + ":nth-child(" + i + ")", {
						left: ((i - 1) * percent) + '%',
						"background-image": 'linear-gradient(to bottom,' + settings.secondColor + ',' + settings.firstColor + ')',
						"animation-delay": (Math.random() * (total - min) + min) * (time / total) * -1 + 's'
					});

					addRule(".marvy-color-drop-line-" + sectionId + ":nth-child(" + i + ")" + ":after", {
						background: settings.dotColor
					});
					i++;
				}
			}
			if(appendColeDropRule) {
				addRule(".marvy-color-drop-line-"+sectionId+":after", {
					width: dotSize + 'vw',
					height: dotSize + 'vw',
					"border-radius": '50%',
					left: 50 + '%',
					bottom: (dotSize * -1) / 2 + 'vw',
					"margin-left": (dotSize * -1) / 2 + 'vw'
				});

				addRule(".marvy-color-drop-line-"+sectionId, {
					position: "relative",
					height: height +'px',
					width: percent+'%',
					'margin-top': '-'+height+'px',
					animation: 'drop ' + time +'s infinite ease-in'
				});
			}
		}
	}
})( jQuery );

/*----------------------------- Flying Objects ------------------------*/
(function( $ ) {
	'use strict';

	var MarvyPureAnimation = {
		initPure: function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/section', MarvyPureAnimation.initRipplesWidget);
		},
		initRipplesWidget: function ($scope) {
			var sectionId = $scope.data('id');
			var target = '.elementor-element-'+ sectionId;
			var settings = {};

			if (window.isEditMode || window.elementorFrontend.isEditMode()) {
				var editorElements = null;
				var pureAnimationArgs = {};
				if (!window.elementor.hasOwnProperty('elements')) {
					return false;
				}

				editorElements = window.elementor.elements;
				if (!editorElements.models) {
					return false;
				}

				$.each(editorElements.models, function (i, el) {
					if (sectionId === el.id) {
						pureAnimationArgs = el.attributes.settings.attributes;
					} else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
						$.each(el.attributes.elements.models, function (i, col) {
							$.each(col.attributes.elements.models, function (i, subSec) {
								pureAnimationArgs = subSec.attributes.settings.attributes;
							});
						});
					}
					settings.switch = pureAnimationArgs.marvy_enable_pure_animation;
					settings.shape = pureAnimationArgs.marvy_pure_animation_shape;
					settings.shapeColor = pureAnimationArgs.marvy_pure_animation_shape_color;
				});

			}  else {
				settings.switch = $scope.data("marvy_enable_pure_animation");
				settings.shape = $scope.data("marvy_pure_animation_shape");
				settings.shapeColor = $scope.data("marvy_pure_animation_shape_color");
			}
			if (settings.switch) {
				pureAnimation(target, settings, sectionId);
			}
		}
	};

	$( window ).on('elementor/frontend/init', MarvyPureAnimation.initPure);

	function pureAnimation(target,settings,sectionId) {
		var checkElement = document.getElementsByClassName("marvy-pure-animation-shape-"+sectionId);
		if (checkElement.length <= 0 ) {
			var i;
			var pure_ul_el = document.createElement('ul');
			pure_ul_el.classList.add("marvy-pure-animation-shape-"+sectionId);

			document.querySelector(target).appendChild(pure_ul_el);
			document.querySelector(target).classList.add('marvy-custom-pure-animation-section-'+sectionId);

			var zIndex = document.querySelector('.marvy-custom-pure-animation-section-'+sectionId+' .elementor-container');
			zIndex.style.zIndex = '99';

			var pureMinHeight = document.querySelector(".elementor-element-"+sectionId);
			pureMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

			for(i=1; i <= 15; i++) {
				var pure_li_el = document.createElement('li');
				document.querySelector('.marvy-pure-animation-shape-'+sectionId).appendChild(pure_li_el);
			}

			var pureShapeColor = document.querySelectorAll('.marvy-pure-animation-shape-'+sectionId+' li');
			var purePercentage = '5px' ;

			if (settings.shape === 'circle' ) {
				purePercentage = '50%';
			} else {
				purePercentage = '5px';
			}

			for (i = 0; i < pureShapeColor.length; i++) {
				pureShapeColor[i].style.backgroundColor = settings.shapeColor;
				pureShapeColor[i].style.borderRadius = purePercentage;
			}
		}
	}
})( jQuery );

/*-----------------------------  Ripple --------------------------------*/
(function( $ ) {
	'use strict';
	var previousRipple = {};
	var styleRipple = document.createElement('style');
	var sheetRipple = document.head.appendChild(styleRipple).sheet;
	var i, j, hw_gap, left, right, top, bottom, eleft, eright, etop, ebottom;
	var VisualRipplesAnimation = {
		initRipples: function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualRipplesAnimation.initRipplesWidget);
		},
		initRipplesWidget: function ($scope) {
			var sectionId = $scope.data('id');
			var target = '.elementor-element-' + sectionId;
			var settings = {};
			if (window.isEditMode || window.elementorFrontend.isEditMode()) {
				var editorElements = null;
				var rippleAnimationArgs = {};

				if (!window.elementor.hasOwnProperty('elements')) {
					return false;
				}

				editorElements = window.elementor.elements;

				if (!editorElements.models) {
					return false;
				}

				$.each(editorElements.models, function (i, el) {
					if (sectionId === el.id) {
						rippleAnimationArgs = el.attributes.settings.attributes;
					} else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
						$.each(el.attributes.elements.models, function (i, col) {
							$.each(col.attributes.elements.models, function (i, subSec) {
								rippleAnimationArgs = subSec.attributes.settings.attributes;
							});
						});
					}
					settings.switch = rippleAnimationArgs.marvy_enable_ripples_animation;
					settings.color = rippleAnimationArgs.marvy_ripples_animation_circle_color;
					settings.gap = rippleAnimationArgs.marvy_ripples_animation_circle_gap;
					settings.position = rippleAnimationArgs.marvy_ripples_animation_circle_position;
				});

			} else {
				settings.switch = $scope.data("marvy_enable_ripples_animation");
				settings.color = $scope.data("marvy_ripples_animation_circle_color");
				settings.position = $scope.data("marvy_ripples_animation_circle_position");
			}

			if (settings.switch) {
				var sectionKey = 'ripple-'+sectionId;
				if (!previousRipple.hasOwnProperty(sectionKey)){
					previousRipple[sectionKey] = settings;
				}

				var result = rippleAnimation(target, settings, sectionId, sectionKey);
				if (result){

					previousRipple[sectionKey] = settings;
				}
			} else {
				previousRipple = {};
				if (sheetRipple.cssRules.length !== 0){
					for (var j = sheetRipple.cssRules.length - 1; j >= 0; j--) {
						if(sheetRipple.cssRules[j].selectorText.includes(sectionId) ){
							sheetRipple.deleteRule(j);
						}
					}
				}
			}
		}
	};

	function addRule(selector, css, i) {
		var propText = typeof css === "string" ? css : Object.keys(css).map(function (p) {
			return p + ":" + (p === "content" ? "'" + css[p] + "'" : css[p]);
		}).join(";");
		sheetRipple.insertRule(selector + "{" + propText + "}", i);
	}

	function rippleAnimation(target,settings,sectionId, sectionKey) {
		var checkElement = document.getElementsByClassName("marvy-ripples-section-" + sectionId);
		if (checkElement.length >= 0) {

			var ripple_div = document.createElement('div');
			var delay_duration = 0.3;
			ripple_div.classList.add("marvy-ripples-section-" + sectionId);
			document.querySelector(target).appendChild(ripple_div);
			document.querySelector(target).classList.add("marvy-custom-ripples-animation-section-" + sectionId);

			// Set Z-index for section container
			var ripplesZindex = document.querySelector('.marvy-custom-ripples-animation-section-'+sectionId+' .elementor-container');
			ripplesZindex.style.zIndex = '99';

			// Set min height
			var ripplesMinHeight = document.querySelector(".elementor-element-"+sectionId);
			ripplesMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

			hw_gap = 300;
			left = right = top = bottom = eleft = eright = etop = ebottom = 'unset';

			if (settings.position === 'left') {
				left = 0; top = 350;  eleft = etop = 1;
			} else if (settings.position === 'top') {
				top = 0; left = 750; eleft = etop = 1;
			} else if (settings.position === 'right') {
				right = 0; top = 350; eright = etop = 1;
			} else if (settings.position === 'bottom') {
				bottom=0; left = 750; eleft = ebottom = 1;
			} else if (settings.position === 'topLeft') {
				top=left=0;eleft = etop = 1;
			} else if (settings.position === 'topRight') {
				eright = etop = 1;top=right=0;
			} else if (settings.position === 'bottomRight') {
				eright = ebottom = 1;right=bottom =0;
			} else if (settings.position === 'bottomLeft') {
				eleft = ebottom = 1; left=bottom =0;
			}

			i = 0;
			var appendRule = true;
			while (i <= 4){
				var child_div_el = document.createElement('div');
				child_div_el.classList.add("marvy-ripples-circle-" + sectionId + '-' + i);
				document.querySelector(".marvy-ripples-section-" + sectionId).appendChild(child_div_el);

				if (JSON.stringify(previousRipple[sectionKey]) !== JSON.stringify(settings)){
					appendRule = false;
					for (j = sheetRipple.cssRules.length-1; j >= 0; j--) {
						if(sheetRipple.cssRules[j].selectorText.includes(sectionId) ){
							sheetRipple.deleteRule(j);
						}
						if (j === 0){
							appendRule = true;
							previousRipple[sectionKey] = settings;
						}
					}
				}

				if(appendRule){
					addRule(".marvy-ripples-circle-" + sectionId + '-' + i, {
						width: (hw_gap * (i+1)) + 'px',
						height: (hw_gap * (i+1)) + 'px',
						left: left - (150 * (i+1) * eleft) + 'px',
						top: top - (150 * (i+1) * etop) + 'px',
						bottom: bottom - (150 * (i+1) * ebottom) + 'px',
						right: right - (150 * (i+1) * eright) + 'px',
						"animation-delay": (delay_duration * (i+1)) + 's',
						background: settings.color,
						"z-index": 1
					},i);
					i++;
				}
			}
		}
		return true;
	}

	$( window ).on('elementor/frontend/init', VisualRipplesAnimation.initRipples);
})( jQuery );
