(function( $ ) {
    'use strict';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];
    var VisualNetAnimation = {
        initNet: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualNetAnimation.initNetWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualNetAnimation.initNetWidget);
        },
        initNetWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var netAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        netAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                netAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }                   
                    settings.switch = netAnimationArgs.marvy_enable_net_animation;
                    // settings.bgColor = netAnimationArgs.marvy_net_animation_background_color;
                    // settings.color = netAnimationArgs.marvy_net_animation_color;
                    settings.points = netAnimationArgs.marvy_net_animation_points;
                    settings.maxDistance = netAnimationArgs.marvy_net_animation_max_distance;
                    settings.spacing = netAnimationArgs.marvy_net_animation_spacing;
                    settings.showDots = netAnimationArgs.marvy_net_animation_show_dots;
                    
                    if(Object.keys(netAnimationArgs).length !== 0){
                                            
                        if(netAnimationArgs.__globals__ && netAnimationArgs.__globals__.marvy_net_animation_background_color && netAnimationArgs.__globals__.marvy_net_animation_background_color !== ""){
                            var bgColor_id = netAnimationArgs.__globals__.marvy_net_animation_background_color.split('=')[1];
                            var bgColor_arr = global_color.find(element => element._id  === bgColor_id);
                            settings.bgColor = bgColor_arr.color; 
                        }
                        else{
                            settings.bgColor = netAnimationArgs.marvy_net_animation_background_color; 
                        }
                        if(netAnimationArgs.__globals__ && netAnimationArgs.__globals__.marvy_net_animation_color && netAnimationArgs.__globals__.marvy_net_animation_color !== ""){
                            var color_id = netAnimationArgs.__globals__.marvy_net_animation_color.split('=')[1];
                            var color_arr = global_color.find(element => element._id  === color_id);
                            settings.color = color_arr.color; 
                        }
                        else{
                            settings.color = netAnimationArgs.marvy_net_animation_color; 
                        }                      
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_net_animation");
                settings.bgColor = $scope.data("marvy_net_animation_background_color");
                settings.color = $scope.data("marvy_net_animation_color");
                settings.points = $scope.data("marvy_net_animation_points");
                settings.maxDistance = $scope.data("marvy_net_animation_max_distance");
                settings.spacing = $scope.data("marvy_net_animation_spacing");
                settings.showDots = $scope.data("marvy_net_animation_show_dots");
            }

            if (settings.switch) {
                netAnimation(target, settings, sectionId);
            }
        }
    };

    function netAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-net-section-" + sectionId);
        if (checkElement.length >= 0) {

            var net_div = document.createElement('div');
            net_div.classList.add("marvy-net-section-" + sectionId);

            document.querySelector(target).appendChild(net_div);
            document.querySelector(target).classList.add("marvy-custom-net-animation-section-" + sectionId);

            // Set Z-index for section container
            var netZindex = document.querySelector('.marvy-custom-net-animation-section-'+sectionId+' .elementor-container , .marvy-custom-net-animation-section-'+sectionId+'>*');
            netZindex.style.zIndex = '99';

            // Set min height
            var netMinHeight = document.querySelector(".elementor-element-"+sectionId);
            netMinHeight.closest('.elementor-top-section,.e-con-boxed,.e-con-full').style.minHeight = "100px";

            var netAnimation = VANTA.NET({
                el: ".marvy-net-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 100.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                color: settings.color,
                points: settings.points,
                maxDistance: settings.maxDistance,
                spacing: settings.spacing,
                showDots: settings.showDots
            });
            render(netAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualNetAnimation.initNet);
})( jQuery );