(function( $ ) {
    'use strict';
    var global_color = marvyScript.color.length != 0 ? [ ...marvyScript.color.custom_colors ,...marvyScript.color.system_colors ] : [];
    var VisualGlobeAnimation = {
        initGlobe: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualGlobeAnimation.initGlobeWidget);
            elementorFrontend.hooks.addAction('frontend/element_ready/container', VisualGlobeAnimation.initGlobeWidget);
        },
        initGlobeWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var globeAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        globeAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                globeAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }                   
                    settings.switch = globeAnimationArgs.marvy_enable_globe_animation;
                    // settings.bgColor = globeAnimationArgs.marvy_globe_animation_background_color;
                    // settings.colorOne = globeAnimationArgs.marvy_globe_animation_color;
                    // settings.colorTwo = globeAnimationArgs.marvy_globe_animation_color_two;
                    settings.size = globeAnimationArgs.marvy_globe_animation_size;
                
                    if(Object.keys(globeAnimationArgs).length !== 0){
                        
                        if(globeAnimationArgs.__globals__ && globeAnimationArgs.__globals__.marvy_globe_animation_background_color && globeAnimationArgs.__globals__.marvy_globe_animation_background_color !== ""){
                            var bgColor_id = globeAnimationArgs.__globals__.marvy_globe_animation_background_color.split('=')[1];
                            var bgColor_arr = global_color.find(element => element._id  === bgColor_id);
                            settings.bgColor = bgColor_arr.color; 
                        }
                        else{
                            settings.bgColor = globeAnimationArgs.marvy_globe_animation_background_color; 
                        }
                        if(globeAnimationArgs.__globals__ && globeAnimationArgs.__globals__.marvy_globe_animation_color && globeAnimationArgs.__globals__.marvy_globe_animation_color !== ""){
                            var colorOne_id = globeAnimationArgs.__globals__.marvy_globe_animation_color.split('=')[1];
                            var colorOne_arr = global_color.find(element => element._id  === colorOne_id);
                            settings.colorOne = colorOne_arr.color; 
                        }
                        else{
                            settings.colorOne = globeAnimationArgs.marvy_globe_animation_color; 
                        }
                        if(globeAnimationArgs.__globals__ && globeAnimationArgs.__globals__.marvy_globe_animation_color_two && globeAnimationArgs.__globals__.marvy_globe_animation_color_two !== ""){
                            var colorTwo_id = globeAnimationArgs.__globals__.marvy_globe_animation_color_two.split('=')[1];
                            var colorTwo_arr = global_color.find(element => element._id  === colorTwo_id);
                            settings.colorTwo = colorTwo_arr.color; 
                        }
                        else{
                            settings.colorTwo = globeAnimationArgs.marvy_globe_animation_color_two;
                        }

                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_globe_animation");
                settings.bgColor = $scope.data("marvy_globe_animation_background_color");
                settings.colorOne = $scope.data("marvy_globe_animation_color");
                settings.colorTwo = $scope.data("marvy_globe_animation_color_two");
                settings.size = $scope.data("marvy_globe_animation_size");
            }

            if (settings.switch) {
                globeAnimation(target, settings, sectionId);
            }
        }
    };

    function globeAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-globe-section-" + sectionId);
        if (checkElement.length >= 0) {

            var globe_div = document.createElement('div');
            globe_div.classList.add("marvy-globe-section-" + sectionId);

            document.querySelector(target).appendChild(globe_div);
            document.querySelector(target).classList.add("marvy-custom-globe-animation-section-" + sectionId);

            // Set Z-index for section container
            var globeZindex = document.querySelector('.marvy-custom-globe-animation-section-'+sectionId+' .elementor-container , .marvy-custom-globe-animation-section-'+sectionId+'>*');
            globeZindex.style.zIndex = '99';

            // Set min height
            var globeMinHeight = document.querySelector(".elementor-element-"+sectionId);
            globeMinHeight.closest('.elementor-top-section,.e-con-boxed,.e-con-full').style.minHeight = "200px";

            var globeAnimation = VANTA.GLOBE({
                el: ".marvy-globe-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 200.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                color: settings.colorOne,
                color2: settings.colorTwo,
                size: settings.size
            });
            render(globeAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualGlobeAnimation.initGlobe);
})( jQuery );