<?php
if ( !defined( 'WPINC' ) ) { die; }

/**
 * Class Gspbcal
 *
 * @package RH Link
 */

class Gspbcal {
	
	/**
	 * Main version of the plugin
	 */
	public $version;
	public $options;
	
	/**
	 * Output second WP filter for cloaking & rewriting Remote URL
	 */
	private $filter_name = 'rh_post_offer_url_filter';

	/**
	 * Class constructor. Includes essential files and initializes the class attributes.
	 */
	public function __construct( $version = '1.0.0' ) {
		
		$this->version = $version;
		$this->options = $this->load_options();
		$this->load_dependencies();
		
		$rewrite = new Gspbcal_Rewrite( $version, $this->options );
		$rewrite->add_actions();
		$rewrite_options = $rewrite->load_options();
		
		if( $rewrite_options['ractive'] == 'yes' ){
			$rewrite->activate();
		}

		// Import / Export activate
		$ie =  new Gspbcal_ImportExport( $version, $this->options );
		$ie->add_actions();

		add_action( 'admin_init', array( $this, 'register_settings' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_script' ) );
	}
	
	/**
	 * Loads subClasses to the parent Class
	 */
	private function load_dependencies() {
		require_once 'class-gspbcal-rewrite.php';
		require_once 'class-gspbcal-import-export.php';
	}
	
	/**
	 * Gets global variable 'filter_name' for subClasses
	 */
	public function get_filter_name() {
		return $this->filter_name;
	}

	/**
	 * Default plugin options
	 */
	public function default_options() {
		return array(
		);
	}

	/**
	 * Loads and update plugin options
	 */
	public function load_options() {
		$gspbcal_options = get_option( 'gspbcal_options' );
		if( isset( $gspbcal_options['ractive'] ) && isset( $gspbcal_options['rewrite_fields'] ) ){
			$rewrite_options = array( 'ractive' => $gspbcal_options['ractive'], 'rewrite_fields' => $gspbcal_options['rewrite_fields'] );
			update_option( 'gspbcal_rewrites', $rewrite_options );
		}
		$options = array_merge( $this->default_options(), get_option( 'gspbcal_options', array() ) );
		update_option( 'gspbcal_options', $options );
		return $options;
	}


	/**
	 * Creates Settings page of the plugin with form
	 */
	public function build_options_page() {
		?>
		<div class="wrap" id="gspbcal_options">
			<h2><?php _e( 'RH Link Pro Settings', 'gspbcal' ); ?></h2>
			<form method="post" action="options.php">
				<?php
				//wp_nonce_field( 'update-gspbcal-options' );
				settings_fields( 'gspbcal-options' );
				do_settings_sections( 'gspbcal-options' );
				submit_button();
				?>
			</form>
		</div>
		<?php
	}

	/**
	 * Registers Settings page for the plugin and validate them
	 */
	public function register_settings() {
		register_setting( 'gspbcal-options', 'gspbcal_options', array( $this, 'validate' ) );
		register_setting( 'gspbcal-rewrites', 'gspbcal_rewrites', array( $this, 'validate' ) );
	}

	/**
	 * Validates settings fields before saving
	 */
	public function validate( $input ) {			
		if ( !isset( $input ) || empty( $input ) ) 
			return $input;
		
		$new_input = $new_value = array();
		
		foreach( $input as $key => $value ) {
			if( $key == 'ractive' ){
				$new_input['ractive'] = $value;
			}
			if( $key == 'roles_rewrite' && is_array( $value ) ){
				$new_input['roles_rewrite'] = $value;
			}
			if( $key == 'rewrite_fields' && is_array( $value )  ) {
				for( $i = 0; $i <= count( $value ); $i++){
					if( empty( $value[$i]['checkdomain'] ) ) {
						continue;
					} else {
						$new_value[] = $value[$i];
					}
				}
				$new_input['rewrite_fields'] = $new_value; 
			}
		}
		return $new_input;
	}
	
	/**
	 * Creates an associative array of roles in which each element has role slug as the key and role name as value e.g. 'administrator' => 'Administrator'
	 */
	public function get_roles(){
		global $wp_roles;
		$roles = $wp_roles->roles;
		$roles_arr = array();
		foreach ($roles as $key => $role) {
			$roles_arr[$key] = $role['name'];
		}
		return $roles_arr;
	}
	
	/**
	 * Registers and Enqueues admin JS script for Settings page
	 */
	public function enqueue_admin_script( $page ) {
		if(strpos($page, 'gspbcal')) {
			wp_enqueue_style( 'gspbcal_admin_style', GREENSHIFTSEO_DIR_URL . 'includes/rewrite-links/assets/css/gspbcal-admin.css', array(), $this->version, 'all' );
			wp_enqueue_script( 'gspbcal_admin_script', GREENSHIFTSEO_DIR_URL . 'includes/rewrite-links/assets/js/gspbcal-admin.js', array('jquery'), $this->version, true );
			
			$translation_array = array( 
				'ajax_url' => admin_url( 'admin-ajax.php', 'relative' ),
				'nonce' => wp_create_nonce('ajaxed-nonce'),
				'loader' => esc_html__('loading...', 'gspbcal'),
				'importNotValid' => esc_html__('Error: Enter the JSON in valid format', 'gspbcal'),
				'importSuccess' => esc_html__('Import succeed, option page will be refreshed..', 'gspbcal'),
				'importErrorData' => esc_html__('Error: Imported data is incorrect', 'gspbcal'),
				'exportErrorData' => esc_html__('Error: Export failed. Try again.', 'gspbcal'),
			);
			wp_localize_script( 'gspbcal_admin_script', 'gspbcal_admin_script', $translation_array );
			
			$json_roles_arr = json_encode( $this->get_roles() );
			wp_add_inline_script( 'gspbcal_admin_script', '/* <![CDATA[ */var rolesArray = '.$json_roles_arr.';/* ]]> */', 'before' );
		}
	}
}
