(function($){
	if($('.gspbcal-group-inputs').length == 1){
		var inputKey = $('.gspbcal-group-input').length;
		$("#gspbcal_add_fields").on('click', function(e) {
			var groupedRow = '<tr class="gspbcal-group-input"><td><input type="text" value="" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][checkdomain]" /></td><td><input type="text" value="" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][afftag]" /></td><td><input type="text" value="" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][affstring]" /></td><td><input type="number" value="100" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][random]" min="0" max="100" step="10" />%</td><td><input type="radio" value="yes" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][aff_move]" />&nbsp;Yes&nbsp;&nbsp;<input type="radio" value="no" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][aff_move]" checked="checked" />&nbsp;No</td></tr><tr class="gspbcal-group-roles"><td colspan="5">';
			$.each( rolesArray, function( role, roleName ) {
				groupedRow += '<label for="gspbcal_rewrites[rewrite_fields]['+inputKey+'][roles_rewrite]['+role+']">'+roleName+'</label>:&nbsp;<input type="hidden" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][roles_rewrite]['+role+']" value="0" /><input type="checkbox" name="gspbcal_rewrites[rewrite_fields]['+inputKey+'][roles_rewrite]['+role+']" value="1" />&nbsp;';
			});
			groupedRow += '</td></tr>';
			$(".gspbcal-group-inputs").append(groupedRow);
			inputKey++;
			e.preventDefault();
		});
		
		$('#domains_list').on('change', function() {
			var checkdomains = $('.gspbcal-group-inputs .checkdomain');
			var checkdomain = this.value;
			if(checkdomain == ''){
				$('tr.gspbcal-group-input').show();
				$('tr.gspbcal-group-roles').show();				
			}else{
				$(checkdomains).each(function(indx, element){
					if(checkdomain != this.value){
						$(element).parents('tr.gspbcal-group-input').hide();
						$(element).parents('tr.gspbcal-group-input').next().hide();
					}else{
						$(element).parents('tr.gspbcal-group-input').show();
						$(element).parents('tr.gspbcal-group-input').next().show();
					}
				});				
			}
		});
		
		$('#afftags_list').on('change', function() {
			var afftags = $('.gspbcal-group-inputs .afftag');
			var afftag = this.value;
			if(afftag == ''){
				$('tr.gspbcal-group-input').show();
				$('tr.gspbcal-group-roles').show();				
			}else{
				$(afftags).each(function(indx, element){
					if(afftag != this.value){
						$(element).parents('tr.gspbcal-group-input').hide();
						$(element).parents('tr.gspbcal-group-input').next().hide();
					}else{
						$(element).parents('tr.gspbcal-group-input').show();
						$(element).parents('tr.gspbcal-group-input').next().show();
					}
				});				
			}
		});
	}

	$('#gspbcal-import-submit').on( 'click', function(e){
		e.preventDefault();
		var exportVal = $('#gspbcal-import-field').val();
		if( exportVal.length > 2 && isJSON(exportVal) ){
			$.ajax({
				type: 'POST',
				url: gspbcal_admin_script.ajax_url,
				dataType: 'json',
				data: {
					'action' : 'gspbcal_import',
					'nonce' : gspbcal_admin_script.nonce,
					'data' : JSON.parse($('#gspbcal-import-field').val())
				},
				success: function(response) {
					if (response.success) {
						$('#gspbcal-import-note').text(gspbcal_admin_script.importSuccess);
						setTimeout( function() {
							location.reload();
						}, 2000 );
					} else {
						$('#gspbcal-import-note').text(gspbcal_admin_script.importErrorData);
					}
				},
				error: function(xhr, str) {
					alert('Error: ' + xhr.responseCode);
				}
			});
		} else {
			$('#gspbcal-import-note').text(gspbcal_admin_script.importNotValid);
		}
	});

	$('#gspbcal-export-submit').on( 'click', function(e){
		e.preventDefault();
		$.ajax({
			type: 'POST',
			url: gspbcal_admin_script.ajax_url,
			data: {
				'action': 'gspbcal_export',
			 	'nonce' : gspbcal_admin_script.nonce,
			},
			success: function(response) {
				if (response.success) {
					$('#gspbcal-export-field').text(response.data);
				} else {
					$('#gspbcal-export-note').text(gspbcal_admin_script.exportErrorData);
				}
				
			},
			error: function(xhr, str) {
				alert('Error: ' + xhr.responseCode);
			}
		});
	});

})(jQuery);

function isJSON( str ) {
    try {
        return ( JSON.parse(str) && !!str );
    } catch ( e ) {
        return false;
    }
}
