<?php


namespace greenshiftseo\Blocks;
defined('ABSPATH') OR exit;


class Slider{

	public function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type(__DIR__, array(
			'render_callback' => array( $this, 'render_block' ),
			'attributes'      => $this->attributes
		)
		);
	}

	public $attributes = array(
		'id' => array(
			'type'    => 'string',
			'default' => null,
		),
		'inlineCssStyles' => array(
			'type'    => 'string',
			'default' => '',
		),
		'animation' => array(
			'type' => 'object',
			'default' => array(),
		),
		"backgroundColor" => array(
			"type" => "string",
			"default" => "#e1e1e1"
		),
		"arrowColor" => array(
			"type" => "string",
			"default" => "#ffffff"
		),
		"thumbColor" => array(
			"type" => "string",
			"default" => ""
		),
		"backgroundGradient" => array(
			"type" => "string",
			"default" => ""
		),
		"slides" => array(
			"type" => "array",
			"default" => array(
				array(
					"image" => array(
						"id" => 0,
						"url" => "https://via.placeholder.com/700x400/DDDDDD/FFFFFF?text=Photo",
						"width" => "",
						"height" => "",
						"alt" => "",
						"caption" => ""
					)
				)
			)
		),

	);

	public function render_block( $settings = array(), $inner_content = '' ) {
		extract( $settings);
		$html       = '';

		if ( empty( $slides ) ) {
			return;
		}

		$arrowbg = (!empty($backgroundColor)) ? 'background-color:'.$backgroundColor.';' : '';
		$arrowgrad = (!empty($backgroundGradient)) ? 'background-image:'.$backgroundGradient.';' : '';
		$arrowcolor = (!empty($arrowColor)) ? 'fill:'.$arrowColor.';' : '';
		$thumbcolor = (!empty($thumbColor)) ? ' style:"--active-slide:'.$thumbColor.';"' : '';

		$arrowstyle= ($arrowcolor || $arrowbg || $arrowgrad) ? 'style='.$arrowbg.$arrowgrad.$arrowcolor.'' : '';

		$blockId = 'gspb_id-' . esc_attr($id);
		$blockClassName = 'gspb-simpleslider '.$blockId.' '.(!empty($className) ? $className : '').' ';

		$html .= '<div class="'.$blockClassName.'gspb-slider jsgss-hook__slider mb25 width-100p"'.$thumbcolor.' '.gspb_AnimationRenderProps($animation).'>';
		$html .= ' <div class="gspb-slider__wrapper">';
		$html .= '	<div class="gspb-slider__inner">';
		foreach ( $slides as $slide ) {
			$url    = $slide['image']['url'];
			$alt    = $slide['image']['alt'];
			$caption = (!empty($slide['image']['caption'])) ? $slide['image']['caption'] : '';
			$width  = $slide['image']['width'];
			$height = $slide['image']['height'];
			if ( empty( $url ) ) {
				$url = plugin_dir_url( __DIR__ ) . '/assets/icons/noimage-placeholder.png';
			}
			$html .= '<div class="gspb-slider-item gssimglightbox">';
			if($caption){
				$html .= '<span class="gspb-slider-caption">'.$caption.'</span>';
			}
			$html .= '  <img src="' . esc_attr( $url ) . '" alt="' . esc_attr( $alt ) . '"';
			$html .= '       width="' . esc_attr( $width ) . '" height="' . esc_attr( $height ) . '"/>';
			$html .= '</div>';
		}
		$html .= '</div>';
		$html .= '<div class="gspb-slider-controls">';
		$html .= '<div class="gspb-slider-arrow gspb-slider-arrow--prev" '.$arrowstyle.'><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="451.847px" height="451.847px" viewBox="0 0 451.847 451.847"><g><path d="M97.141,225.92c0-8.095,3.091-16.192,9.259-22.366L300.689,9.27c12.359-12.359,32.397-12.359,44.751,0 c12.354,12.354,12.354,32.388,0,44.748L173.525,225.92l171.903,171.909c12.354,12.354,12.354,32.391,0,44.744 c-12.354,12.365-32.386,12.365-44.745,0l-194.29-194.281C100.226,242.115,97.141,234.018,97.141,225.92z"/></g></svg></div>';
		$html .= '<div class="gspb-slider-arrow gspb-slider-arrow--next" '.$arrowstyle.'><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="451.846px" height="451.847px" viewBox="0 0 451.846 451.847"><g><path d="M345.441,248.292L151.154,442.573c-12.359,12.365-32.397,12.365-44.75,0c-12.354-12.354-12.354-32.391,0-44.744
		L278.318,225.92L106.409,54.017c-12.354-12.359-12.354-32.394,0-44.748c12.354-12.359,32.391-12.359,44.75,0l194.287,194.284
		c6.177,6.18,9.262,14.271,9.262,22.366C354.708,234.018,351.617,242.115,345.441,248.292z"/></g></svg></div>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '	<div class="gspb-slider-thumbs gssscrollthin">';
		$html .= '		<div class="gspb-slider-thumbs__row">';
		foreach ( $slides as $key => $slide ) {
			$url    = $slide['image']['url'];
			$alt    = $slide['image']['alt'];
			$width  = $slide['image']['width'];
			$height = $slide['image']['height'];
			if ( empty( $url ) ) {
				$url = plugin_dir_url( __DIR__ ) . '/assets/icons/noimage-placeholder.png';
			}
			$html .= '<div class="gspb-slider-thumbs-item" data-slide ="' . $key . '">';
			$html .= '	<img src="' . esc_attr( $url ) . '" alt="' . esc_attr( $alt ) . '"';
			$html .= '       width="' . esc_attr( $width ) . '" height="' . esc_attr( $height ) . '" />';
			$html .= '</div>';
		}
		$html .= '		</div>';
		$html .= '	</div>';
		$html .= '</div>';

		return $html;


	}

}

new Slider;