<?php


namespace greenshiftseo\Blocks;
defined('ABSPATH') OR exit;


class PopupButton{

	public function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type(__DIR__,array(
			'attributes'      => $this->attributes
		));
	}

	protected $attributes = array(
		'id' => array(
			'type'    => 'string',
			'default' => null,
		),
		'inlineCssStyles' => array(
			'type'    => 'string',
			'default' => '',
		),
		'animation' => array(
			'type' => 'object',
			'default' => array(),
		),
		'max_width'      => array(
			'type'    => 'number',
			'default' => 500,
		),
		'btn_text'     => array(
			'type'    => 'string',
			'default' => 'Show popup',
		),
		'textalign'     => array(
			'type'    => 'string',
			'default' => 'left',
		),
	);

}

new PopupButton;