<?php


namespace greenshiftseo\Blocks;
defined('ABSPATH') OR exit;


class HowtoItem{

	public function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type(__DIR__, array(
			'attributes'      => $this->attributes,
			'render_callback' => array( $this, 'render_block' ),
		));
	}

	protected $attributes = array(
		'seoschema'  => array(
			'type'    => 'boolean',
			'default' => true,
		),
		'title'      => array(
			'type'    => 'string',
			'default' => '',
		),
	);

	public function render_block($settings = array(), $content=''){

		extract($settings);
		$schemastep = ($seoschema) ? ' itemprop="step" itemscope itemtype="https://schema.org/HowToStep"' : '';
		$schemahow = ($seoschema) ? ' itemprop="itemListElement" itemscope itemtype="https://schema.org/HowToDirection"' : '';
		$schemaname = ($seoschema) ? ' itemprop="name"' : '';
		$schematext = ($seoschema) ? ' itemprop="text"' : '';

		$out = '';
			$uniqueid = 'gspb-howid'.\uniqid();
			$out .='<div class="gspb-howtoitem__step"'.$schemastep.'>';
				if($seoschema){
					if(!empty($content)){
						preg_match( '@src="([^"]+)"@' , $content, $match );
						$src = array_pop($match);
						if($src){
							$out .='<meta itemprop="image" content="'.esc_url($src).'" />';
						}
					}
					$out .='<meta itemprop="url" content="'.get_the_permalink().'#'.$uniqueid.'step" />';
				}
				$out .='<div class="gspb-howtoitem__title">';
					$out .= '<div class="gspb-howtoitem__heading"'.$schemaname.'>';
						$out .= $title;
					$out .='</div>';
				$out .='</div>';

				$out .= '<div class="gspb-howtoitem__content" '.$schemahow.'>';
					$out .= '<div class="gspb-howtoitem__text"'.$schematext.'>'. $content.'</div>';
				$out .='</div>';
			$out .='</div>';
		

		return $out;
	}
}

new HowtoItem;