function gspbSimpleInitTabs(elem){
    "use strict";
    //addEventListener on mouse click

    document.addEventListener('DOMContentLoaded', function() {
        var tabsobj = document.getElementsByClassName('gspb-tabs');

        var tabsbuttons = document.getElementsByClassName('gspb-t-btn');
        for (let i = 0; i < tabsbuttons.length; i++) {
            tabsbuttons[i].addEventListener('click', function (e) {
                let targetnode = e.currentTarget;
                if(!targetnode.classList.contains('active')){
                    let tabnode = targetnode.closest(elem);
                    let btns = tabnode.querySelectorAll('.gspb-t-btn');
                    let panels = tabnode.querySelectorAll('.t-panel');
                    findActivetabElementAndRemoveIt(btns);
                    findActivetabElementAndRemoveIt(panels);
         
                    targetnode.classList.add('active');  
                    var nodes = Array.prototype.slice.call( targetnode.parentNode.children );   
                    let index = nodes.indexOf( targetnode);         
                    var panel = panels[index];
                    panel.classList.add('active');
                    
                    
                }
            });
        }

    });

}
 
//if option true remove active class from added element
function findActivetabElementAndRemoveIt(nodeList){
    "use strict";
    Array.prototype.forEach.call(nodeList, function (e) {
        e.classList.remove('active');
    });
}

gspbSimpleInitTabs('.gspb-tabs');