const gssfiltersortBtns = document.querySelectorAll('.gss_filtersort_btn:not(.active)');
gssfiltersortBtns.forEach(item => {
    item.addEventListener('click', function (ev) {
        let item = ev.target;
        let containerid = item.dataset.containerid;
        let activecontainer = document.getElementById(containerid);
        let sorttype = item.dataset.sorttype;
        let offset = item.dataset.offset;
        let filterPanel = activecontainer.parentElement.querySelector('.gss_filter_panel');
        let choosenTax = filterPanel.querySelector('.gss_tax_dropdown .gss_choosed_tax');
        let tax;
        if (choosenTax !== null && choosenTax.innerHTML != '') {
            tax = choosenTax.getAttribute('data-taxdata');
           
        }
        let filterargs = activecontainer.dataset.filterargs;
        let innerargs = activecontainer.dataset.innerargs;
        let template = activecontainer.dataset.template;

        item.closest('ul').classList.add('activeul'); 
        item.classList.add('gss_loadingbefore');         
        activecontainer.classList.add('sortingloading');

        const request = new XMLHttpRequest();
        request.open('POST', gssscriptvars.ajax_url, true);
        request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
        request.responseType = 'json';
        request.onload = function () {
            if (this.status >= 200 && this.status < 400) {
                let responseobj = this.response.data;
                activecontainer.innerHTML = '';
                activecontainer.insertAdjacentHTML('beforeend',responseobj);

                item.closest('.gss_filter_panel').querySelectorAll('span').forEach(function(itemfilter) {
                    itemfilter.classList.remove('active');
                });
                  
                item.classList.remove('gss_loadingbefore');
                item.classList.add('active');               
                activecontainer.classList.remove('sortingloading'); 
                item.closest('ul').classList.remove('activeul'); 
                if(item.closest('ul').classList.contains('gss_tax_dropdown')){
                    var taxDropdown = item.closest('.gss_tax_dropdown');
                    taxDropdown.querySelector('.gss_choosed_tax').innerHTML = item.innerHTML;
                    taxDropdown.querySelector('.gss_choosed_tax').style.display = "block";
                    taxDropdown.querySelector('.gss_choosed_tax').setAttribute('data-taxdata', item.getAttribute('data-sorttype'));
                    taxDropdown.querySelector('.gss_tax_placeholder').style.display = "none";
                    filterPanel.querySelector('.gss_filter_ul li:first-child span').classList.add('active');
                } 
    
            } else {
                // Response error
            }
        };
        request.onerror = function() {
            // Connection error
        };
        request.send('action=gss_filterpost&security=' + gssscriptvars.filternonce + '&sorttype=' + sorttype + '&filterargs='+filterargs +'&template=' + template + '&tax='+tax+'&containerid='+containerid+'&offset='+offset+'&innerargs='+innerargs);
    }, false);
});

const gsstaxsortBtns = document.querySelectorAll('.gss_tax_dropdown .label');
gsstaxsortBtns.forEach(item => {
    item.addEventListener('click', function (ev) {
        ev.stopPropagation();
        ev.preventDefault();
        ev.target.closest('.gss_tax_dropdown').classList.toggle('active');
    });
});

const gssfiltersortActives = document.querySelectorAll('.gss_filter_ul .gss_filtersort_btn.active');
gssfiltersortActives.forEach(item => {
    item.addEventListener('click', function (ev) {
        ev.preventDefault();
        ev.target.closest('.gss_filter_panel').querySelectorAll('ul.gss_filter_ul span').classList.toggle('showfiltermobile');
    });
});