<?php
/**
 * Commissions Breakdown Table
 *
 * Markup for the [edd_commission_breakdown_table] shortcode.
 *
 * @see       eddc_commission_breakdown_table_shortcode()
 *
 * @package   edd-commissions
 * @copyright Copyright (c) 2021, Sandhills Development, LLC
 * @license   GPL2+
 * @since     3.5
 *
 * @var \EDD_Commissions\Reports\MonthlyBreakdown $breakdown
 * @var int[]                                     $available_years
 * @var array                                     $atts Shortcode attributes.
 */

?>
<div class="eddc-monthly-breakdown-table">
	<div class="eddc-monthly-breakdown-table-header">
		<h2><?php printf( esc_html__( 'Commissions in %d', 'eddc' ), esc_html( $breakdown->year ) ); ?></h2>

		<?php if ( count( $available_years ) > 1 ) : ?>
			<form class="eddc-monthly-breakdown-year-filter" method="GET">
				<label for="eddc-monthly-breakdown-year">
					<?php esc_html_e( 'Select a year:', 'eddc' ); ?>
				</label>
				<select id="eddc-monthly-breakdown-year" name="eddc_year">
					<?php foreach ( $available_years as $year ): ?>
						<option value="<?php echo esc_attr( $year ); ?>"<?php selected( $year, $breakdown->year ); ?>>
							<?php echo esc_html( $year ); ?>
						</option>
					<?php endforeach; ?>
				</select>

				<button type="submit" class="button"><?php esc_html_e( 'Change Year', 'eddc' ); ?></button>
			</form>
		<?php endif; ?>
	</div>

	<?php
	if ( ! empty( $atts['description'] ) ) {
		echo wpautop( wp_kses_post( $atts['description'] ) );
	}
	?>

	<table>
		<thead>
		<tr>
			<th><?php esc_html_e( 'Month', 'eddc' ); ?></th>
			<th><?php esc_html_e( 'Commissions Earned', 'eddc' ); ?></th>
			<th><?php esc_html_e( 'Commissions Paid', 'eddc' ); ?></th>
			<th><?php esc_html_e( 'Refunded / Revoked', 'eddc' ); ?></th>
		</tr>
		</thead>
		<tbody>
		<?php foreach ( $breakdown->report_data as $month_number => $data ): ?>
			<tr>
				<td><?php echo esc_html( edd_month_num_to_name( $month_number, true ) ); ?></td>

				<?php foreach ( array( 'total', 'paid', 'revoked' ) as $key ) : ?>
					<td>
						<?php
						$earnings = isset( $data[ $key . '_earnings' ] ) ? $data[ $key . '_earnings' ] : 0;
						$count    = isset( $data[ $key . '_count' ] ) ? $data[ $key . '_count' ] : 0;

						printf(
							'%s (%d)',
							esc_html( edd_currency_filter( edd_format_amount( $earnings ) ) ),
							esc_html( $count )
						);
						?>
					</td>
				<?php endforeach; ?>
			</tr>
		<?php endforeach; ?>
		</tbody>
		<tfoot>
		<tr>
			<th scope="row"><?php esc_html_e( 'Total', 'eddc' ); ?></th>

			<?php foreach ( array( 'total', 'paid', 'revoked' ) as $key ) : ?>
				<td>
					<?php
					try {
						$total_earnings = $breakdown->get_total( $key . '_earnings' );
					} catch ( \Exception $e ) {
						$total_earnings = 0;
					}
					try {
						$total_count = $breakdown->get_total( $key . '_count' );
					} catch ( \Exception $e ) {
						$total_count = 0;
					}

					printf(
						'%s (%d)',
						esc_html( edd_currency_filter( edd_format_amount( $total_earnings ) ) ),
						esc_html( $total_count )
					);
					?>
				</td>
			<?php endforeach; ?>
		</tr>
		</tfoot>
	</table>
</div>
