<?php
/**
 * Installation Functions
 *
 * @package   edd-commissions
 * @copyright Copyright (c) 2021, Easy Digital Downloads
 * @license   GPL2+
 * @since     3.5
 */

/**
 * Process install/upgrades
 *
 * @since       3.4.0
 * @return      void
 */
function edd_commissions_install() {

	global $wpdb;

	$db = new EDDC_DB;
	@$db->create_table();

	$meta_db = new EDDC_Meta_DB;
	@$meta_db->create_table();

	$version = get_option( 'eddc_version' );

	if ( empty( $version ) ) {
		if ( ! function_exists( 'edd_set_upgrade_complete' ) ) {
			require_once trailingslashit( EDD_PLUGIN_DIR ) . 'includes/admin/upgrades/upgrade-functions.php';
		}

		$results         = $wpdb->get_row( "SELECT count(ID) as has_commissions FROM $wpdb->posts WHERE post_type = 'edd_commission' LIMIT 0, 1" );
		$has_commissions = ! empty( $results->has_commissions ) ? true : false;

		if ( ! $has_commissions ) {
			edd_set_upgrade_complete( 'migrate_commissions' );
			edd_set_upgrade_complete( 'remove_legacy_commissions' );
			edd_set_upgrade_complete( 'commissions_342_rate_column' );
		}
	}

	update_option( 'eddc_version', EDD_COMMISSIONS_VERSION );
}
